/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.j_spaces.jdbc.driver.ClobWriter;
import com.j_spaces.jdbc.driver.ObjectWithUID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;

public class Clob
extends ObjectWithUID
implements java.sql.Clob,
Comparable {
    public String clob = null;
    public transient Connection conn;

    public Clob(String string, Connection connection) throws SQLException {
        if (string == null) {
            throw new SQLException("Clob cannot hold null data", "GSP", -134);
        }
        this.clob = string;
        this.conn = connection;
    }

    public Clob(String string) {
        this.clob = string;
    }

    public String getClobData() {
        return this.clob;
    }

    public long length() throws SQLException {
        return this.clob.length();
    }

    public void truncate(long l2) throws SQLException {
        throw new SQLException("Command not supported!", "GSP", -132);
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            byte[] byArray = this.clob.getBytes("ASCII");
            return new ByteArrayInputStream(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Can't convert clob to ASCII, unsupported encoding", "GSP", -135);
        }
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        throw new SQLException("Command  not supported!", "GSP", -132);
    }

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.clob);
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        return new ClobWriter(this, (int)l2);
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return this.setCharacterStream(0L);
    }

    public String getSubString(long l2, int n2) throws SQLException {
        int n3 = (int)l2 - 1;
        if (n3 < 0 || n2 < 1 || n3 + n2 > this.clob.length()) {
            throw new SQLException("Substring out of clob's bounds", "GSP", -136);
        }
        return this.clob.substring(n3, n3 + n2);
    }

    public int setString(long l2, String string) throws SQLException {
        throw new SQLException("Command not supported!", "GSP", -132);
    }

    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        throw new SQLException("Command not supported!", "GSP", -132);
    }

    public long position(String string, long l2) throws SQLException {
        for (int i2 = (int)l2 - 1; i2 < this.clob.length(); ++i2) {
            if (!this.clob.regionMatches(i2, string, 0, string.length())) continue;
            return i2;
        }
        return -1L;
    }

    public long position(java.sql.Clob clob, long l2) throws SQLException {
        Clob clob2 = (Clob)clob;
        return this.position(clob2.clob, l2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Clob)) {
            return false;
        }
        Clob clob = (Clob)object;
        return clob.clob.equals(this.clob);
    }

    public int hashCode() {
        return this.clob.hashCode();
    }

    public int compareTo(Object object) throws ClassCastException {
        if (object instanceof Clob) {
            return this.clob.compareTo(((Clob)object).clob);
        }
        return -1;
    }

    public String toString() {
        return "CLOB[" + this.clob + "]";
    }

    public void setConnection(Connection connection) {
        this.conn = connection;
    }
}

