/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.LostConnectionException;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import net.jini.core.lookup.ServiceID;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;

public class JSpaceProxyWrapper
implements Remote,
Serializable {
    private static final long serialVersionUID = 1L;
    private Object proxyObject;
    private MarshalledObject proxy;
    private String proxyName;
    private String proxyPresentName;
    private boolean isLoginProcessed;
    private int spaceState = 1;
    public boolean isContainerConfigUpdated;
    private ServiceID _serviceID;

    public JSpaceProxyWrapper() {
    }

    public JSpaceProxyWrapper(Object object) {
        this.proxyObject = object;
        try {
            Object object2 = this.proxy();
            if (object2 instanceof IJSpaceContainer) {
                String string;
                String string2 = ((IJSpaceContainerAdmin)object2).getConfig().containerHostName;
                this.proxyName = string = ((IJSpaceContainer)object2).getName();
                this.proxyPresentName = JSpaceUtilities.createContainerPresentName(string2, string);
                Uuid uuid = ((ReferentUuid)object2).getReferentUuid();
                this._serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
            } else if (object2 instanceof IJSpace) {
                this.proxyPresentName = this.proxyName = ((IJSpace)object2).getName();
                Uuid uuid = ((ReferentUuid)object2).getReferentUuid();
                this._serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
            }
        }
        catch (RemoteException remoteException) {
            this.proxyPresentName = this.proxyName = "stale";
            throw new LostConnectionException(remoteException);
        }
    }

    public static JSpaceProxyWrapper createProxyWrapper(Object object) {
        try {
            JSpaceProxyWrapper jSpaceProxyWrapper = new JSpaceProxyWrapper();
            jSpaceProxyWrapper.proxy = new MarshalledObject<Object>(object);
            return jSpaceProxyWrapper;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    public Object proxy() {
        try {
            if (this.proxyObject == null) {
                this.proxyObject = this.proxy.get();
            }
            return this.proxyObject;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public String toString() {
        return this.proxyPresentName;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public int hashCode() {
        this.proxy();
        return this.proxyObject.hashCode();
    }

    public boolean equals(Object object) {
        this.proxy();
        return ReferentUuids.compare(this.proxyObject, object);
    }

    public int getState() {
        return this.spaceState;
    }

    public void setState(int n2) {
        this.spaceState = n2;
    }

    public boolean isLoginProcessed() {
        return this.isLoginProcessed;
    }

    public void setLoginProcessed(boolean bl2) {
        this.isLoginProcessed = bl2;
    }

    public ServiceID getServiceID() {
        return this._serviceID;
    }
}

