/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.j_spaces.core.client.SpaceURL;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jini.core.event.EventRegistration;
import net.sf.retrotranslator.runtime.java.lang._Integer;

public class SpaceCopyStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final short RECOVERY_TYPE = 1;
    public static final short COPY_TYPE = 2;
    private short _operationType = (short)2;
    private int _totalCopyObj;
    private int _totalDiscardedObjByFilter;
    private String _sourceMember;
    private final String _targetMember;
    private SpaceURL _sourceMemberUrl;
    private Exception _causeEx;
    private final HashMap _writeEntries;
    private final HashMap _notifyTempl;
    private transient HashSet _notifyTemplRegistration;
    private final HashMap _dublicateUID;
    private static final String TO_STRING_COPY = "Copy";
    private static final String TO_STRING_COPIED = "copied";
    private static final String TO_STRING_RECOVERY = "Recovery";
    private static final String TO_STRING_RECOVERED = "recovered";
    public static final String NULL_TEMPLATE = "NULL_NOTIFY_TEMPLATE";

    public SpaceCopyStatus(short s2, String string) {
        this._operationType = s2;
        this._targetMember = string;
        this._writeEntries = new HashMap();
        this._notifyTempl = new HashMap();
        this._dublicateUID = new HashMap();
        this._notifyTemplRegistration = new HashSet();
    }

    public int getTotalCopyObj() {
        return this._totalCopyObj;
    }

    public String getSourceMemberName() {
        return this._sourceMember;
    }

    public String getTargetMemberName() {
        return this._targetMember;
    }

    public SpaceURL getSourceMemberURL() {
        return this._sourceMemberUrl;
    }

    public Exception getCauseException() {
        return this._causeEx;
    }

    public int getTotalBlockedEntriesByFilter() {
        return this._totalDiscardedObjByFilter;
    }

    public Map getTotalCopiedEntries() {
        return this._writeEntries;
    }

    public Map getTotalCopiedNotifyTemplates() {
        return this._notifyTempl;
    }

    public Map getTotalDuplicateEntries() {
        return this._dublicateUID;
    }

    public void setOperationType(short s2) {
        this._operationType = s2;
    }

    public void setSourceMember(String string, SpaceURL spaceURL) {
        this._sourceMember = string;
        this._sourceMemberUrl = spaceURL;
    }

    public void setTotalBlockedEntriesByFilter(int n2) {
        this._totalDiscardedObjByFilter = n2;
    }

    public void addWriteEntry(String string) {
        this.increaseCount(string, this._writeEntries);
    }

    public void addNotifyTemplate(String string) {
        string = string == null ? NULL_TEMPLATE : string;
        this.increaseCount(string, this._notifyTempl);
    }

    public void addNotifyTemplate(String string, EventRegistration eventRegistration) {
        this.addNotifyTemplate(string);
        this._notifyTemplRegistration.add(eventRegistration);
    }

    public void addDublicateUID(String string, String string2) {
        this._dublicateUID.put(string2, string);
    }

    private void increaseCount(String string, HashMap hashMap) {
        int n2 = 0;
        Integer n3 = (Integer)hashMap.get(string);
        if (n3 != null) {
            n2 = n3;
        }
        hashMap.put(string, _Integer.valueOf(++n2));
        ++this._totalCopyObj;
    }

    public void setCauseException(Exception exception) {
        this._causeEx = exception;
    }

    public String toString() {
        Iterator iterator;
        Set set;
        String string = this._operationType == 2 ? TO_STRING_COPY : TO_STRING_RECOVERY;
        String string2 = this._operationType == 2 ? TO_STRING_COPIED : TO_STRING_RECOVERED;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._causeEx != null) {
            stringBuffer.append("\n" + string + " operation failed. Reason: " + this._causeEx.toString());
            return stringBuffer.toString();
        }
        stringBuffer.append("\n\n" + (this._operationType == 2 ? "Copied" : "Recovered") + " from [" + this._sourceMember + " : " + this._sourceMemberUrl + "] \n\t to [" + this._targetMember + "] space.\n");
        stringBuffer.append("\nEntries " + string2 + " :");
        Set set2 = this.getTotalCopiedEntries().entrySet();
        int n2 = 0;
        Object object = set2.iterator();
        while (object.hasNext()) {
            set = object.next();
            iterator = (String)set.getKey();
            int n3 = (Integer)set.getValue();
            stringBuffer.append("\n  " + (String)((Object)iterator) + " (" + n3 + ")");
            n2 += n3;
        }
        stringBuffer.append("\n  TOTAL #" + n2 + " " + string2 + ".\n");
        stringBuffer.append("\nNotify-templates " + string2 + ":");
        n2 = 0;
        object = this.getTotalCopiedNotifyTemplates().entrySet();
        set = object.iterator();
        while (set.hasNext()) {
            iterator = (Map.Entry)set.next();
            String string3 = (String)iterator.getKey();
            int n4 = (Integer)iterator.getValue();
            stringBuffer.append("\n  " + string3 + " (" + n4 + ")");
            n2 += n4;
        }
        stringBuffer.append("\n  TOTAL #" + n2 + " " + string2 + ".\n");
        set = this.getTotalDuplicateEntries().entrySet();
        if (set != null) {
            stringBuffer.append("\nAlready exists UID's:");
            n2 = 0;
            iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string4 = (String)entry.getKey();
                String string5 = (String)entry.getValue();
                stringBuffer.append("\n  " + string5 + " : " + string4);
            }
            stringBuffer.append("\n  TOTAL #" + set.size() + " duplicate UIDs.\n");
        }
        stringBuffer.append("\n-----\nTOTAL " + string2 + " objects: #" + this._totalCopyObj);
        stringBuffer.append("\nTOTAL discarded objects by Replication-Input-Filter: #" + this._totalDiscardedObjByFilter);
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    public HashSet getNotifyTemplRegistration() {
        return this._notifyTemplRegistration;
    }
}

