/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SecurityContext
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String _username;
    private String _password;
    private boolean _isEncrypted;
    private String _permissions;
    private Object _implementorContext;
    public static final char PERMISSION_READ = 'R';
    public static final char PERMISSION_WRITE = 'W';
    public static final char PERMISSION_ADMIN = 'A';
    public static final String ANONYMOUS_USER = "ANONYMOUS";

    public SecurityContext() {
        this(ANONYMOUS_USER, ANONYMOUS_USER);
    }

    public SecurityContext(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("User name shouldn't be null");
        }
        if (string2 == null) {
            throw new NullPointerException("Password shouldn't be null");
        }
        this.setUsername(string);
        this.setPassword(string2);
    }

    public void disableAllOperations() {
        this.setPermissions("");
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.getUsername() != null) {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this.getUsername());
            if (this._password != null) {
                objectOutput.writeBoolean(true);
                objectOutput.writeUTF(this._password);
            } else {
                objectOutput.writeBoolean(false);
            }
        } else {
            objectOutput.writeBoolean(false);
        }
        if (this._permissions != null) {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this._permissions);
        } else {
            objectOutput.writeBoolean(false);
        }
        if (this._implementorContext != null) {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(this._implementorContext);
        } else {
            objectOutput.writeBoolean(false);
        }
        objectOutput.writeBoolean(this._isEncrypted);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (objectInput.readBoolean()) {
            this._username = objectInput.readUTF();
            if (objectInput.readBoolean()) {
                this._password = objectInput.readUTF();
            }
        }
        if (objectInput.readBoolean()) {
            this._permissions = objectInput.readUTF();
        }
        if (objectInput.readBoolean()) {
            this._implementorContext = objectInput.readObject();
        }
        this._isEncrypted = objectInput.readBoolean();
    }

    public void setUsername(String string) {
        this._username = string;
    }

    public String getUsername() {
        return this._username;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public String getPassword() {
        return this._password;
    }

    public void setEncrypted(boolean bl2) {
        this._isEncrypted = bl2;
    }

    public boolean isEncrypted() {
        return this._isEncrypted;
    }

    public void setPermissions(String string) {
        this._permissions = string;
    }

    public String getPermissions() {
        return this._permissions;
    }

    public void setImplementorContext(Object object) {
        this._implementorContext = object;
    }

    public Object getImplementorContext() {
        return this._implementorContext;
    }
}

