/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.layout;

import com.borland.jbcl.layout.PaneConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PaneNode
implements Serializable {
    public transient Component childComponent;
    public String name;
    public PaneNode childNodeA;
    public PaneNode childNodeB;
    public Rectangle location = new Rectangle();
    public float widthDivide;
    public float heightDivide;
    public int xOffset;
    public int yOffset;
    public boolean horizontal;
    public boolean reverse = false;

    public PaneNode(String string, Component component, String string2) {
        this.childComponent = component;
        this.name = string;
        this.widthDivide = 1.0f;
        this.heightDivide = 0.5f;
        this.horizontal = string2.equals("Top") || string2.equals("Bottom");
        this.reverse = string2.equals("Top") || string2.equals("Left");
    }

    public PaneNode(PaneNode paneNode, PaneNode paneNode2, String string, float f2) {
        this.childNodeA = paneNode;
        this.childNodeB = paneNode2;
        if (string.equals("Top") || string.equals("Bottom")) {
            this.widthDivide = 1.0f;
            this.heightDivide = f2;
            this.horizontal = true;
        } else {
            this.widthDivide = f2;
            this.heightDivide = 1.0f;
            this.horizontal = false;
        }
        this.reverse = string.equals("Top") || string.equals("Left");
    }

    public void dump() {
    }

    public void setConstraints(Component component, PaneConstraints paneConstraints) {
        if (this.childComponent != null) {
            return;
        }
        this.reverse = paneConstraints.position.equals("Top") || paneConstraints.position.equals("Left");
        if (paneConstraints.position.equals("Bottom")) {
            this.heightDivide = 1.0f - paneConstraints.proportion;
            this.widthDivide = 1.0f;
            this.horizontal = true;
        } else if (paneConstraints.position.equals("Top")) {
            this.heightDivide = 1.0f - paneConstraints.proportion;
            this.widthDivide = 1.0f;
            this.horizontal = true;
        } else if (paneConstraints.position.equals("Right")) {
            this.widthDivide = 1.0f - paneConstraints.proportion;
            this.heightDivide = 1.0f;
            this.horizontal = false;
        } else if (paneConstraints.position.equals("Left")) {
            this.widthDivide = 1.0f - paneConstraints.proportion;
            this.heightDivide = 1.0f;
            this.horizontal = false;
        }
    }

    public void addChild(String string, Component component, String string2, float f2) {
        if (this.childComponent != null) {
            this.childNodeA = new PaneNode(this.name, this.childComponent, "Root");
            this.childComponent = null;
            this.name = null;
            this.childNodeB = new PaneNode(string, component, "Root");
            if ((f2 = 1.0f - f2) > 1.0f || f2 < 0.0f) {
                f2 = 0.5f;
            }
            if (string2 == null) {
                string2 = this.horizontal ? "Right" : "Bottom";
            } else if (string2.equals("Right") || string2.equals("Bottom")) {
                this.reverse = false;
            } else {
                this.reverse = true;
                if (!(string2.equals("Left") || string2.equals("Top") || string2.equals("Root"))) {
                    f2 = 0.5f;
                }
            }
            if (string2.equals("Left") || string2.equals("Right")) {
                this.widthDivide = f2;
                this.heightDivide = 1.0f;
                this.horizontal = false;
            } else {
                this.widthDivide = 1.0f;
                this.heightDivide = f2;
                this.horizontal = true;
            }
        } else {
            string2 = this.horizontal ? "Right" : "Bottom";
            this.childNodeB.addChild(string, component, string2, f2);
        }
    }

    public boolean addChildSplit(String string, String string2, String string3, Component component, float f2) {
        if (this.childComponent != null) {
            if (this.name != null) {
                if (this.name.equals(string2)) {
                    this.addChild(string, component, string3, f2);
                    return true;
                }
                return false;
            }
        } else {
            if (!this.childNodeA.addChildSplit(string, string2, string3, component, f2)) {
                return this.childNodeB.addChildSplit(string, string2, string3, component, f2);
            }
            return true;
        }
        return false;
    }

    public Dimension getPreferredSize(int n2) {
        Dimension dimension = null;
        try {
            if (this.childComponent != null) {
                Dimension dimension2 = dimension = this.childComponent.getPreferredSize();
                return dimension2;
            }
            Dimension dimension3 = this.childNodeA.getPreferredSize(n2);
            Dimension dimension4 = this.childNodeB.getPreferredSize(n2);
            float f2 = this.widthDivide;
            if (!this.horizontal) {
                if ((double)f2 >= 0.999) {
                    dimension = dimension3;
                }
                dimension = (double)f2 == 0.0 ? dimension4 : new Dimension((int)Math.max((double)((float)dimension3.width / f2), (double)dimension4.width / (1.0 - (double)f2)), Math.max(dimension3.height, dimension4.height));
                dimension.width += n2 + n2 + 1;
            } else {
                f2 = this.heightDivide;
                dimension = (double)f2 >= 0.999 ? dimension3 : ((double)f2 == 0.0 ? dimension4 : new Dimension(Math.max(dimension3.width, dimension4.width), (int)Math.max((double)((float)dimension3.height / f2), (double)dimension4.height / (1.0 - (double)f2))));
                dimension.height += n2 + n2 + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dimension;
    }

    public String getNodeAComponent() {
        if (this.childComponent != null) {
            return this.name;
        }
        return this.childNodeA.getNodeAComponent();
    }

    public PaneNode getImmediateParent(Component component) {
        if (this.childComponent != null) {
            if (this.childComponent == component) {
                return this;
            }
            return null;
        }
        if (this.childNodeA.childComponent == component) {
            return this;
        }
        if (this.childNodeB.childComponent == component) {
            return this;
        }
        PaneNode paneNode = this.childNodeA.getImmediateParent(component);
        if (paneNode != null) {
            return paneNode;
        }
        return this.childNodeB.getImmediateParent(component);
    }

    public void getComponents(Point point, String[] stringArray, boolean bl2) {
        if (this.childComponent == null) {
            if (bl2) {
                stringArray[point.x] = this.childNodeA.getNodeAComponent();
                ++point.x;
            }
            stringArray[point.x] = this.childNodeB.getNodeAComponent();
            ++point.x;
            this.childNodeA.getComponents(point, stringArray, false);
            this.childNodeB.getComponents(point, stringArray, false);
        }
    }

    public PaneNode getParentNode(Component component, PaneNode paneNode) {
        if (this.childComponent != null) {
            if (this.childComponent == component) {
                return this;
            }
            return null;
        }
        if (this.childNodeA.childComponent == component) {
            if (paneNode != null) {
                return paneNode;
            }
            return this.childNodeA;
        }
        if (this.childNodeB.childComponent == component) {
            return this;
        }
        PaneNode paneNode2 = this.childNodeA.getParentNode(component, paneNode);
        if (paneNode2 != null) {
            return paneNode2;
        }
        return this.childNodeB.getParentNode(component, this);
    }

    public PaneNode removeChild(Component component) {
        PaneNode paneNode = null;
        if (this.childNodeA.childComponent == component) {
            paneNode = this.childNodeA;
            paneNode.widthDivide = this.widthDivide;
            paneNode.heightDivide = this.heightDivide;
            paneNode.reverse = this.reverse;
            paneNode.horizontal = this.horizontal;
            this.absorbChildNode(this.childNodeB);
            paneNode.childNodeA = this;
            paneNode.childNodeB = null;
        } else if (this.childNodeB.childComponent == component) {
            paneNode = this.childNodeB;
            paneNode.widthDivide = this.widthDivide;
            paneNode.heightDivide = this.heightDivide;
            paneNode.reverse = this.reverse;
            paneNode.horizontal = this.horizontal;
            this.absorbChildNode(this.childNodeA);
            paneNode.childNodeA = null;
            paneNode.childNodeB = this;
        }
        return paneNode;
    }

    public Rectangle getDividerRect(int n2) {
        if (this.childComponent == null) {
            if (this.heightDivide == 1.0f) {
                if (this.reverse) {
                    return new Rectangle(this.childNodeB.location.x + this.childNodeB.location.width, this.childNodeB.location.y, n2, this.childNodeB.location.height);
                }
                return new Rectangle(this.childNodeA.location.x + this.childNodeA.location.width, this.childNodeA.location.y, n2, this.childNodeA.location.height);
            }
            if (this.reverse) {
                return new Rectangle(this.childNodeB.location.x, this.childNodeB.location.y + this.childNodeB.location.height, this.childNodeB.location.width, n2);
            }
            return new Rectangle(this.childNodeA.location.x, this.childNodeA.location.y + this.childNodeA.location.height, this.childNodeA.location.width, n2);
        }
        return new Rectangle(this.location.x - n2, this.yOffset + this.location.y - n2, this.location.width + n2, n2);
    }

    public void drag(int n2, int n3) {
        boolean bl2 = true;
        if (this.childComponent == null) {
            if (this.heightDivide == 1.0f) {
                this.widthDivide = (float)(n2 - this.location.x) / (float)this.location.width;
                if (this.reverse) {
                    this.widthDivide = 1.0f - this.widthDivide;
                }
                if (this.widthDivide < 0.0f) {
                    this.widthDivide = 0.0f;
                    bl2 = false;
                } else if (this.widthDivide >= 1.0f) {
                    this.widthDivide = 0.999f;
                    bl2 = false;
                }
            } else {
                if (this.reverse) {
                    this.heightDivide = 1.0f - this.heightDivide;
                }
                this.heightDivide = (float)(n3 - this.location.y) / (float)this.location.height;
                if (this.reverse) {
                    this.heightDivide = 1.0f - this.heightDivide;
                }
                if (this.heightDivide < 0.0f) {
                    bl2 = false;
                    this.heightDivide = 0.0f;
                } else if (this.heightDivide >= 1.0f) {
                    bl2 = false;
                    this.heightDivide = 0.999f;
                }
            }
        }
    }

    public PaneNode hitTest(int n2, int n3, int n4) {
        if (this.location != null && this.childComponent == null) {
            int n5 = this.heightDivide == 1.0f ? n2 - (this.location.x + this.xOffset) : n3 - (this.location.y + this.yOffset);
            if (Math.abs(n5) <= n4) {
                return this;
            }
            if (n5 < 0 ^ this.reverse) {
                return this.childNodeA.hitTest(n2, n3, n4);
            }
            return this.childNodeB.hitTest(n2, n3, n4);
        }
        return null;
    }

    public void assertLocation(Rectangle rectangle, int n2) {
        this.location.x = rectangle.x;
        this.location.y = rectangle.y;
        this.location.width = rectangle.width;
        this.location.height = rectangle.height;
        if (this.childComponent != null) {
            if (!this.childComponent.getBounds().equals(this.location)) {
                this.childComponent.setBounds(this.location.x, this.location.y, this.location.width, this.location.height);
                if (this.childComponent instanceof Container) {
                    ((Container)this.childComponent).doLayout();
                }
            }
        } else {
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            this.calculateLocations(this.location, rectangle2, rectangle3, n2);
            this.childNodeA.assertLocation(rectangle2, n2);
            this.childNodeB.assertLocation(rectangle3, n2);
        }
    }

    public void absorbChildNode(PaneNode paneNode) {
        if (paneNode.childComponent != null) {
            this.childComponent = paneNode.childComponent;
            this.name = paneNode.name;
        } else {
            this.childComponent = null;
            this.childNodeA = paneNode.childNodeA;
            this.childNodeB = paneNode.childNodeB;
            this.widthDivide = paneNode.widthDivide;
            this.heightDivide = paneNode.heightDivide;
            this.reverse = paneNode.reverse;
            this.horizontal = paneNode.horizontal;
        }
    }

    public void calculateLocations(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n2) {
        float f2;
        n2 += n2;
        if (this.heightDivide == 1.0f) {
            f2 = this.widthDivide;
            if (this.reverse) {
                f2 = 1.0f - f2;
            }
            this.xOffset = (int)((float)(rectangle.width - n2) * f2);
            rectangle2.x = rectangle.x;
            rectangle2.y = rectangle.y;
            rectangle2.width = this.xOffset;
            rectangle2.height = rectangle.height;
            rectangle3.x = rectangle.x + this.xOffset + n2;
            rectangle3.y = rectangle.y;
            rectangle3.width = rectangle.width - this.xOffset - n2;
            rectangle3.height = rectangle.height;
        } else {
            f2 = this.heightDivide;
            if (this.reverse) {
                f2 = 1.0f - f2;
            }
            this.yOffset = (int)((float)(rectangle.height - n2) * f2);
            rectangle2.x = rectangle.x;
            rectangle2.y = rectangle.y;
            rectangle2.width = rectangle.width;
            rectangle2.height = this.yOffset;
            rectangle3.x = rectangle.x;
            rectangle3.y = rectangle.y + this.yOffset + n2;
            rectangle3.width = rectangle.width;
            rectangle3.height = rectangle.height - this.yOffset - n2;
        }
        if (this.reverse) {
            Rectangle rectangle4 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            rectangle2.x = rectangle3.x;
            rectangle2.y = rectangle3.y;
            rectangle2.width = rectangle3.width;
            rectangle2.height = rectangle3.height;
            rectangle3.x = rectangle4.x;
            rectangle3.y = rectangle4.y;
            rectangle3.width = rectangle4.width;
            rectangle3.height = rectangle4.height;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.childComponent instanceof Serializable ? this.childComponent : null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof Component) {
            this.childComponent = (Component)object;
        }
    }
}

