/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.AbstractExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ThreadPoolExecutor
extends AbstractExecutorService {
    private final AtomicInteger ctl = new AtomicInteger(ThreadPoolExecutor.ctlOf(Integer.MIN_VALUE, 0));
    private static final int COUNT_BITS = 30;
    private static final int CAPACITY = 0x3FFFFFFF;
    private static final int RUNNING = Integer.MIN_VALUE;
    private static final int SHUTDOWN = -1073741824;
    private static final int STOP = 0;
    private static final int TERMINATED = 0x40000000;
    private final BlockingQueue workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final HashSet workers = new HashSet();
    private final Condition termination = this.mainLock.newCondition();
    private int largestPoolSize;
    private long completedTaskCount;
    private volatile ThreadFactory threadFactory;
    private volatile RejectedExecutionHandler handler;
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private static final boolean ONLY_ONE = true;

    private static int runStateOf(int c) {
        return c & 0xC0000000;
    }

    private static int workerCountOf(int c) {
        return c & 0x3FFFFFFF;
    }

    private static int ctlOf(int r, int w) {
        return r | w;
    }

    private void advanceRunState(int targetState) {
        int c;
        while (ThreadPoolExecutor.runStateOf(c = this.ctl.get()) < targetState && !this.ctl.compareAndSet(c, ThreadPoolExecutor.ctlOf(targetState, ThreadPoolExecutor.workerCountOf(c)))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryTerminate() {
        int c;
        do {
            int rs;
            if ((rs = ThreadPoolExecutor.runStateOf(c = this.ctl.get())) < -1073741824 || rs == 0x40000000 || rs == -1073741824 && !this.workQueue.isEmpty()) {
                return;
            }
            if (ThreadPoolExecutor.workerCountOf(c) == 0) continue;
            this.interruptIdleWorkers(true);
            return;
        } while (!this.ctl.compareAndSet(c, ThreadPoolExecutor.ctlOf(0x40000000, 0)));
        this.mainLock.lock();
        try {
            this.termination.signalAll();
        }
        finally {
            this.mainLock.unlock();
        }
        this.terminated();
    }

    private void decrementWorkerCount() {
        int c;
        while (!this.ctl.compareAndSet(c = this.ctl.get(), ThreadPoolExecutor.ctlOf(ThreadPoolExecutor.runStateOf(c), ThreadPoolExecutor.workerCountOf(c) - 1))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdownAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(shutdownPerm);
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                Iterator itr = this.workers.iterator();
                while (itr.hasNext()) {
                    Worker w = (Worker)itr.next();
                    security.checkAccess(w.thread);
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptWorkers() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                try {
                    w.thread.interrupt();
                }
                catch (SecurityException ignore) {}
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptIdleWorkers(boolean onlyOne) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            Iterator it = this.workers.iterator();
            while (it.hasNext()) {
                Worker w = (Worker)it.next();
                Thread t = w.thread;
                if (!t.isInterrupted() && w.tryLock()) {
                    try {
                        t.interrupt();
                    }
                    catch (SecurityException ignore) {
                    }
                    finally {
                        w.unlock();
                    }
                }
                if (!onlyOne) continue;
                break;
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    private void interruptIdleWorkers() {
        this.interruptIdleWorkers(false);
    }

    private void clearInterruptsForTaskRun() {
        if (ThreadPoolExecutor.runStateOf(this.ctl.get()) < 0 && Thread.interrupted() && ThreadPoolExecutor.runStateOf(this.ctl.get()) >= 0) {
            Thread.currentThread().interrupt();
        }
    }

    final void reject(Runnable command) {
        this.handler.rejectedExecution(command, this);
    }

    void onShutdown() {
    }

    final boolean isRunningOrShutdown(boolean shutdownOK) {
        int rs = ThreadPoolExecutor.runStateOf(this.ctl.get());
        return rs == Integer.MIN_VALUE || rs == -1073741824 && shutdownOK;
    }

    private List drainQueue() {
        BlockingQueue q = this.workQueue;
        ArrayList<Runnable> taskList = new ArrayList<Runnable>();
        q.drainTo(taskList);
        if (!q.isEmpty()) {
            Runnable[] arr = q.toArray(new Runnable[0]);
            for (int i = 0; i < arr.length; ++i) {
                Runnable r = arr[i];
                if (!q.remove(r)) continue;
                taskList.add(r);
            }
        }
        return taskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addWorker(Runnable firstTask, boolean core) {
        int wc;
        int rs;
        int c;
        do {
            if ((rs = ThreadPoolExecutor.runStateOf(c = this.ctl.get())) == -1073741824) {
                if (this.workQueue.isEmpty()) {
                    return false;
                }
                c = this.ctl.get();
            }
            wc = ThreadPoolExecutor.workerCountOf(c);
            if (rs <= -1073741824 && wc < 0x3FFFFFFF && wc < (core ? this.corePoolSize : this.maximumPoolSize)) continue;
            return false;
        } while (!this.ctl.compareAndSet(c, ThreadPoolExecutor.ctlOf(rs, wc + 1)));
        Worker w = new Worker(firstTask);
        Thread t = w.thread;
        if (t == null) {
            this.decrementWorkerCount();
            this.tryTerminate();
            return false;
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.workers.add(w);
            int s = this.workers.size();
            if (s > this.largestPoolSize) {
                this.largestPoolSize = s;
            }
        }
        finally {
            mainLock.unlock();
        }
        t.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorkerExit(Worker w, boolean completedAbruptly) {
        if (completedAbruptly) {
            this.decrementWorkerCount();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.completedTaskCount += w.completedTasks;
            this.workers.remove(w);
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
        if (!completedAbruptly) {
            int c;
            int min;
            int n = min = this.allowCoreThreadTimeOut ? 0 : this.corePoolSize;
            if (min == 0 && !this.workQueue.isEmpty()) {
                min = 1;
            }
            if (ThreadPoolExecutor.workerCountOf(c = this.ctl.get()) >= min || ThreadPoolExecutor.runStateOf(c) >= 0) {
                return;
            }
        }
        this.addWorker(null, false);
    }

    private Runnable getTask() {
        boolean empty = false;
        while (true) {
            boolean timed;
            int c;
            int rs;
            if ((rs = ThreadPoolExecutor.runStateOf(c = this.ctl.get())) == -1073741824 || empty) {
                empty = this.workQueue.isEmpty();
                c = this.ctl.get();
                if (ThreadPoolExecutor.runStateOf(c) != rs) continue;
            }
            int wc = ThreadPoolExecutor.workerCountOf(c);
            boolean bl = timed = this.allowCoreThreadTimeOut || wc > this.corePoolSize;
            if (wc > this.maximumPoolSize || rs > -1073741824 || empty && (timed || rs == -1073741824)) {
                if (!this.ctl.compareAndSet(c, ThreadPoolExecutor.ctlOf(rs, wc - 1))) continue;
                return null;
            }
            try {
                Runnable r;
                Runnable runnable = r = timed ? (Runnable)this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS) : (Runnable)this.workQueue.take();
                if (r != null) {
                    return r;
                }
                empty = true;
            }
            catch (InterruptedException retry) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runWorker(Worker w) {
        Runnable task = w.firstTask;
        w.firstTask = null;
        boolean completedAbruptly = true;
        try {
            while (task != null || (task = this.getTask()) != null) {
                w.lock();
                this.clearInterruptsForTaskRun();
                try {
                    this.beforeExecute(w.thread, task);
                    Throwable thrown = null;
                    try {
                        task.run();
                    }
                    catch (RuntimeException x) {
                        thrown = x;
                        throw x;
                    }
                    catch (Error x) {
                        thrown = x;
                        throw x;
                    }
                    catch (Throwable x) {
                        thrown = x;
                        throw new Error(x);
                    }
                    finally {
                        this.afterExecute(task, thrown);
                    }
                }
                finally {
                    task = null;
                    ++w.completedTasks;
                    w.unlock();
                }
            }
            completedAbruptly = false;
        }
        finally {
            this.processWorkerExit(w, completedAbruptly);
        }
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (workQueue == null || threadFactory == null || handler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        this.handler = handler;
    }

    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        int c = this.ctl.get();
        if (ThreadPoolExecutor.workerCountOf(c) < this.corePoolSize) {
            if (this.addWorker(command, true)) {
                return;
            }
            c = this.ctl.get();
        }
        if (ThreadPoolExecutor.runStateOf(c) == Integer.MIN_VALUE && this.workQueue.offer(command)) {
            int recheck = this.ctl.get();
            if (ThreadPoolExecutor.runStateOf(recheck) >= 0 && this.remove(command)) {
                this.reject(command);
            } else if (ThreadPoolExecutor.workerCountOf(recheck) == 0) {
                this.addWorker(null, false);
            }
        } else if (!this.addWorker(command, false)) {
            this.reject(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(-1073741824);
            this.interruptIdleWorkers();
            this.onShutdown();
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List shutdownNow() {
        List tasks;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0);
            this.interruptWorkers();
            tasks = this.drainQueue();
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
        return tasks;
    }

    public boolean isShutdown() {
        return ThreadPoolExecutor.runStateOf(this.ctl.get()) != Integer.MIN_VALUE;
    }

    public boolean isTerminating() {
        int rs = ThreadPoolExecutor.runStateOf(this.ctl.get());
        return rs == -1073741824 || rs == 0;
    }

    public boolean isTerminated() {
        return ThreadPoolExecutor.runStateOf(this.ctl.get()) == 0x40000000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        long deadline = Utils.nanoTime() + nanos;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (ThreadPoolExecutor.runStateOf(this.ctl.get()) == 0x40000000) {
                boolean bl = true;
                return bl;
            }
            while (nanos > 0L) {
                this.termination.await(nanos, TimeUnit.NANOSECONDS);
                if (ThreadPoolExecutor.runStateOf(this.ctl.get()) == 0x40000000) {
                    boolean bl = true;
                    return bl;
                }
                nanos = deadline - Utils.nanoTime();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            mainLock.unlock();
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public void setCorePoolSize(int corePoolSize) {
        block3: {
            int delta;
            block2: {
                if (corePoolSize < 0) {
                    throw new IllegalArgumentException();
                }
                delta = corePoolSize - this.corePoolSize;
                this.corePoolSize = corePoolSize;
                if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) <= corePoolSize) break block2;
                this.interruptIdleWorkers();
                break block3;
            }
            if (delta <= 0) break block3;
            int k = Math.min(delta, this.workQueue.size());
            while (k-- > 0 && this.addWorker(null, true) && !this.workQueue.isEmpty()) {
            }
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return ThreadPoolExecutor.workerCountOf(this.ctl.get()) < this.corePoolSize && this.addWorker(null, true);
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addWorker(null, true)) {
            ++n;
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean value) {
        if (value && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        if (value != this.allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = value;
            if (value) {
                this.interruptIdleWorkers();
            }
        }
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize = maximumPoolSize;
        if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) > maximumPoolSize) {
            this.interruptIdleWorkers();
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        if (time == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        long keepAliveTime = unit.toNanos(time);
        long delta = keepAliveTime - this.keepAliveTime;
        this.keepAliveTime = keepAliveTime;
        if (delta < 0L) {
            this.interruptIdleWorkers();
        }
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public BlockingQueue getQueue() {
        return this.workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Runnable task) {
        boolean removed;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            removed = this.workQueue.remove(task);
        }
        finally {
            mainLock.unlock();
        }
        if (removed) {
            this.tryTerminate();
        }
        return removed;
    }

    public void purge() {
        BlockingQueue q = this.workQueue;
        try {
            Iterator it = q.iterator();
            while (it.hasNext()) {
                Runnable r = (Runnable)it.next();
                if (!(r instanceof Future) || !((Future)((Object)r)).isCancelled()) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException fallThrough) {
            Object[] arr = q.toArray();
            for (int i = 0; i < arr.length; ++i) {
                Object r = arr[i];
                if (!(r instanceof Future) || !((Future)r).isCancelled()) continue;
                q.remove(r);
            }
        }
        this.tryTerminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = this.workers.size();
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = 0;
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                if (!w.isLocked()) continue;
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLargestPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = this.largestPoolSize;
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                n += w.completedTasks;
                if (!w.isLocked()) continue;
                ++n;
            }
            long l = n + (long)this.workQueue.size();
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                n += w.completedTasks;
            }
            long l = n;
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    protected void afterExecute(Runnable r, Throwable t) {
    }

    protected void terminated() {
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException();
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                r.run();
            }
        }
    }

    private final class Worker
    extends ReentrantLock
    implements Runnable {
        final Thread thread;
        Runnable firstTask;
        volatile long completedTasks;

        Worker(Runnable firstTask) {
            this.firstTask = firstTask;
            this.thread = ThreadPoolExecutor.this.getThreadFactory().newThread(this);
        }

        public void run() {
            ThreadPoolExecutor.this.runWorker(this);
        }
    }
}

