/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.resourceloader;

import com.google.clearsilver.jsilver.exceptions.JSilverTemplateNotFoundException;
import com.google.clearsilver.jsilver.resourceloader.BufferedResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class FileSystemResourceLoader
extends BufferedResourceLoader {
    private final File rootDir;

    public FileSystemResourceLoader(File rootDir) {
        this.rootDir = rootDir;
    }

    public FileSystemResourceLoader(String rootDir) {
        this(new File(rootDir));
    }

    public Reader open(String name) throws IOException {
        File file = new File(this.rootDir, name);
        if (file.exists() && !file.isDirectory() && file.canRead()) {
            return this.buffer(new InputStreamReader((InputStream)new FileInputStream(file), this.getCharacterSet()));
        }
        return null;
    }

    public Reader openOrFail(String name) throws JSilverTemplateNotFoundException, IOException {
        Reader reader = this.open(name);
        if (reader == null) {
            throw new JSilverTemplateNotFoundException("No file '" + name + "' inside directory '" + this.rootDir + "'");
        }
        return reader;
    }

    public Object getResourceVersionId(String filename) {
        File file = new File(this.rootDir, filename);
        if (file.exists() && !file.isDirectory() && file.canRead()) {
            String fullPath;
            try {
                fullPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                fullPath = file.getAbsolutePath();
            }
            return String.format("%s@%s", fullPath, file.lastModified());
        }
        return null;
    }
}

