/*
 * Decompiled with CFR 0.152.
 */
package DTDDoc;

import DTDDoc.CommentParser;
import DTDDoc.DefinitionsMap;
import DTDDoc.Logger;
import DTDDoc.Tools;
import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttlist;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDComment;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEntity;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDParser;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExtendedDTD {
    private Logger log;
    private boolean getAroundNetBeanComments;
    private DefinitionsMap definitionsMap;
    private File systemPath;
    private DTD dtd;
    private String title = null;
    private String doctype = null;
    private DTDElement rootElement = null;
    private String encoding = null;
    private Map parents = null;
    private static final String ROOT_TAG = "@root";
    private static final String TITLE_TAG = "@title";
    private static final String DOCTYPE_TAG = "@doctype";
    private final Map attributesListMap;

    public String getEncoding() {
        return this.encoding;
    }

    public String getEffectiveEncoding() {
        return this.encoding == null ? "UTF-8" : this.encoding;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public List getItems() {
        return this.dtd.items;
    }

    public Map getElements() {
        return this.dtd.elements;
    }

    public Collection getElementsCollection() {
        return this.dtd.elements.values();
    }

    public DTDElement getElementByName(String name) {
        Object o = this.getElements().get(name);
        if (o == null) {
            this.log.warn("Invalid name or the element doesn't exist (" + name + ").");
        }
        return (DTDElement)o;
    }

    public DTDElement getElementByName(DTDName name) {
        return this.getElementByName(name.getValue());
    }

    public Map getEntities() {
        return this.dtd.entities;
    }

    public DTDElement getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(DTDElement element) {
        this.rootElement = element;
    }

    public File getSystemPath() {
        return this.systemPath;
    }

    public boolean isExternal(DTDElement element) {
        String elementPath = this.definitionsMap.getLocation(element);
        return !elementPath.equals(this.getSystemPath().getPath());
    }

    public boolean isExternal(DTDAttlist attList) {
        return this.isExternal(this.getElementByName(attList.getName()));
    }

    public String getElementOrigin(DTDElement element) {
        String elementPath = this.definitionsMap.getLocation(element);
        if (elementPath == null) {
            this.log.warn("Requesting info about a non existing element: " + element.name);
        }
        return elementPath;
    }

    public ExtendedDTD(File dtdFilePath, Logger log, boolean getAroundNetBeanComments) throws IOException {
        this.log = log;
        this.getAroundNetBeanComments = getAroundNetBeanComments;
        this.systemPath = dtdFilePath;
        if (!this.getSystemPath().canRead()) {
            throw new IOException("Can't read " + this.getSystemPath() + ". Be prepared to get tons of errors !");
        }
        DTDParser dtdParser = new DTDParser(this.getSystemPath());
        this.dtd = dtdParser.parse(true);
        this.encoding = dtdParser.getDTDEncoding();
        this.definitionsMap = this.locateElements(this.getSystemPath().getPath(), this.dtd);
        this.findDeclaredRootElement();
        this.attributesListMap = ExtendedDTD.makeAttributesListsMap(this.dtd.items);
        this.parents = ExtendedDTD.findParents(this.dtd);
    }

    private DefinitionsMap locateElements(String filePath, DTD dtd) throws IOException {
        if (dtd == null) {
            File f = new File(filePath);
            try {
                DTDParser dtdParser = new DTDParser(f);
                dtd = dtdParser.parse(true);
            }
            catch (Exception ex) {
                this.log.warn("locateElements():can't read " + filePath);
                return null;
            }
        }
        DefinitionsMap defMap = new DefinitionsMap();
        Iterator items = dtd.entities.values().iterator();
        while (items.hasNext()) {
            DTDEntity entity = (DTDEntity)items.next();
            String nextFile = null;
            if (entity.getExternalID() != null) {
                nextFile = entity.getExternalID().getSystem();
            }
            if (nextFile == null || nextFile.startsWith("http:") || nextFile.startsWith("file:")) continue;
            nextFile = filePath.substring(0, filePath.lastIndexOf(File.separatorChar) + 1) + nextFile;
            defMap.merge(this.locateElements(nextFile, null));
        }
        items = dtd.elements.values().iterator();
        while (items.hasNext()) {
            DTDElement element = (DTDElement)items.next();
            defMap.add(element, filePath);
        }
        return defMap;
    }

    private String findRootTagValue() {
        String rootName = null;
        Iterator elements = this.getItems().iterator();
        while (elements.hasNext()) {
            Object obj = elements.next();
            if (obj instanceof DTDComment) {
                String t;
                DTDComment comment = (DTDComment)obj;
                CommentParser cp = new CommentParser(comment, this.log, this.getAroundNetBeanComments);
                String rn = cp.getUniqueTagValue(ROOT_TAG);
                if (rn != null) {
                    DTDElement rnElmt = this.getElementByName(rn);
                    if (rnElmt != null && !this.isExternal(rnElmt)) {
                        rootName = rn;
                    } else {
                        this.log.warn("The root element you specified with \"@root " + rn + "\" doesn't exist in the DTD !");
                    }
                }
                if ((t = cp.getUniqueTagValue(TITLE_TAG)) != null) {
                    this.title = t;
                }
                if ((t = cp.getUniqueTagValue(DOCTYPE_TAG)) == null) continue;
                this.doctype = t;
                continue;
            }
            if (!(obj instanceof DTDElement) && !(obj instanceof DTDEntity)) continue;
            break;
        }
        if (this.title == null) {
            this.title = Tools.getFilename(this.systemPath.getName());
        }
        return rootName;
    }

    private void findDeclaredRootElement() {
        String rootName = this.findRootTagValue();
        if (rootName != null) {
            DTDElement rootNameElement = this.getElementByName(rootName);
            if (rootNameElement != null) {
                this.setRootElement(rootNameElement);
            } else {
                this.log.warn("The provided root element (@root " + rootName + ") is nowhere to be found in the DTD!");
            }
        }
    }

    public static String getUniqueId(DTDAttlist attList, DTDAttribute attribute) {
        return attList.name + '_' + attribute.getName();
    }

    public static String getUniqueId(DTDElement element, DTDAttribute attribute) {
        return element.name + '_' + attribute.getName();
    }

    public static String getUniqueId(DTDElement element) {
        return element.getName();
    }

    public DTDAttlist locateAttributesList(DTDAttribute attribute) {
        return (DTDAttlist)this.attributesListMap.get(attribute);
    }

    private static Map makeAttributesListsMap(List dtdItems) {
        HashMap hash = new HashMap();
        Iterator iter = dtdItems.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (!(item instanceof DTDAttlist)) continue;
            DTDAttlist attList = (DTDAttlist)item;
            Iterator iter2 = attList.attributes.iterator();
            while (iter2.hasNext()) {
                hash.put(iter2.next(), attList);
            }
        }
        return hash;
    }

    private static Map findParents(DTD dtd) {
        HashMap<String, HashSet<DTDElement>> parents = new HashMap<String, HashSet<DTDElement>>();
        Iterator i = dtd.elements.values().iterator();
        while (i.hasNext()) {
            Set children;
            DTDElement element = (DTDElement)i.next();
            String k = element.getName();
            if (!parents.containsKey(k)) {
                parents.put(k, null);
            }
            if ((children = ExtendedDTD.collectDeclaredChildren(element)) == null) continue;
            Iterator j = children.iterator();
            while (j.hasNext()) {
                Object o = j.next();
                if (!(o instanceof DTDName)) continue;
                String cName = ((DTDName)o).getValue();
                if (element.getName().equals(cName)) continue;
                HashSet<DTDElement> parentElements = (HashSet<DTDElement>)parents.get(cName);
                if (parentElements == null) {
                    parentElements = new HashSet<DTDElement>();
                }
                parentElements.add(element);
                parents.put(cName, parentElements);
            }
        }
        return parents;
    }

    public Set getParents(String sonName) {
        return (Set)this.parents.get(sonName);
    }

    public boolean isRoot(DTDElement element) {
        Set parents = this.getParents(element.getName());
        return parents == null || parents.size() == 0;
    }

    public static Set collectDeclaredChildren(DTDElement element) {
        return ExtendedDTD.collectDeclaredChildrenHelper(element.getContent());
    }

    private static Set collectDeclaredChildrenHelper(DTDItem item) {
        if (item instanceof DTDContainer) {
            Iterator items = ((DTDContainer)item).getItemsVec().iterator();
            HashSet children = null;
            while (items.hasNext()) {
                Set s = ExtendedDTD.collectDeclaredChildrenHelper((DTDItem)items.next());
                if (s == null) continue;
                if (children == null) {
                    children = new HashSet();
                }
                children.addAll(s);
            }
            return children;
        }
        if (item instanceof DTDName) {
            return Collections.singleton(item);
        }
        return null;
    }
}

