/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;

public class SHA
extends MessageDigestSpi
implements Cloneable {
    private int version = 1;
    private static final int SHA_LENGTH = 20;
    private int[] W = new int[80];
    private long count = 0L;
    private final int countmax = 64;
    private final int countmask = 63;
    private int AA;
    private int BB;
    private int CC;
    private int DD;
    private int EE;
    private final int round1_kt = 1518500249;
    private final int round2_kt = 1859775393;
    private final int round3_kt = -1894007588;
    private final int round4_kt = -899497514;

    private SHA(SHA sHA) {
        this();
        this.version = sHA.version;
        System.arraycopy(sHA.W, 0, this.W, 0, this.W.length);
        this.count = sHA.count;
        this.AA = sHA.AA;
        this.BB = sHA.BB;
        this.CC = sHA.CC;
        this.DD = sHA.DD;
        this.EE = sHA.EE;
    }

    SHA(int n2) {
        this();
        this.version = n2;
    }

    public SHA() {
        this.init();
    }

    protected int engineGetDigestLength() {
        return 20;
    }

    public void engineUpdate(byte by2) {
        this.engineUpdate((int)by2);
    }

    private void engineUpdate(int n2) {
        int n3 = ((int)this.count & 0x3F) >>> 2;
        int n4 = (~((int)this.count) & 3) << 3;
        this.W[n3] = this.W[n3] & ~(255 << n4) | (n2 & 0xFF) << n4;
        if (((int)this.count & 0x3F) == 63) {
            this.computeBlock();
        }
        ++this.count;
    }

    /*
     * Unable to fully structure code
     */
    public void engineUpdate(byte[] var1_1, int var2_2, int var3_3) {
        if (var2_2 >= 0 && var3_3 >= 0 && var2_2 + var3_3 <= var1_1.length) ** GOTO lbl6
        throw new ArrayIndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            this.engineUpdate(var1_1[var2_2]);
            ++var2_2;
            --var3_3;
lbl6:
            // 2 sources

            ** while (var3_3 > 0 && ((int)this.count & 3) != 0)
        }
lbl7:
        // 2 sources

        while (var3_3 >= 4) {
            var4_4 = ((int)this.count & 63) >> 2;
            this.W[var4_4] = (var1_1[var2_2] & 255) << 24 | (var1_1[var2_2 + 1] & 255) << 16 | (var1_1[var2_2 + 2] & 255) << 8 | var1_1[var2_2 + 3] & 255;
            this.count += 4L;
            if (((int)this.count & 63) == 0) {
                this.computeBlock();
            }
            var3_3 -= 4;
            var2_2 += 4;
        }
        while (var3_3 > 0) {
            this.engineUpdate(var1_1[var2_2]);
            --var3_3;
            ++var2_2;
        }
    }

    public void init() {
        this.AA = 1732584193;
        this.BB = -271733879;
        this.CC = -1732584194;
        this.DD = 271733878;
        this.EE = -1009589776;
        int n2 = 0;
        while (n2 < 80) {
            this.W[n2] = 0;
            ++n2;
        }
        this.count = 0L;
    }

    public void engineReset() {
        this.init();
    }

    public byte[] engineDigest() {
        byte[] byArray = new byte[20];
        try {
            int n2 = this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            throw new InternalError("");
        }
        return byArray;
    }

    public int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        if (n3 < 20) {
            throw new DigestException("partial digests not returned");
        }
        if (byArray.length - n2 < 20) {
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        long l2 = this.count << 3;
        this.engineUpdate(128);
        while ((int)(this.count & 0x3FL) != 56) {
            this.engineUpdate(0);
        }
        this.W[14] = (int)(l2 >>> 32);
        this.W[15] = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
        this.count += 8L;
        this.computeBlock();
        byArray[n2 + 0] = (byte)(this.AA >>> 24);
        byArray[n2 + 1] = (byte)(this.AA >>> 16);
        byArray[n2 + 2] = (byte)(this.AA >>> 8);
        byArray[n2 + 3] = (byte)(this.AA >>> 0);
        byArray[n2 + 4] = (byte)(this.BB >>> 24);
        byArray[n2 + 5] = (byte)(this.BB >>> 16);
        byArray[n2 + 6] = (byte)(this.BB >>> 8);
        byArray[n2 + 7] = (byte)(this.BB >>> 0);
        byArray[n2 + 8] = (byte)(this.CC >>> 24);
        byArray[n2 + 9] = (byte)(this.CC >>> 16);
        byArray[n2 + 10] = (byte)(this.CC >>> 8);
        byArray[n2 + 11] = (byte)(this.CC >>> 0);
        byArray[n2 + 12] = (byte)(this.DD >>> 24);
        byArray[n2 + 13] = (byte)(this.DD >>> 16);
        byArray[n2 + 14] = (byte)(this.DD >>> 8);
        byArray[n2 + 15] = (byte)(this.DD >>> 0);
        byArray[n2 + 16] = (byte)(this.EE >>> 24);
        byArray[n2 + 17] = (byte)(this.EE >>> 16);
        byArray[n2 + 18] = (byte)(this.EE >>> 8);
        byArray[n2 + 19] = (byte)(this.EE >>> 0);
        this.engineReset();
        return 20;
    }

    private void computeBlock() {
        int n2;
        int n3 = 16;
        while (n3 <= 79) {
            if (this.version == 0) {
                this.W[n3] = this.W[n3 - 3] ^ this.W[n3 - 8] ^ this.W[n3 - 14] ^ this.W[n3 - 16];
            } else {
                n2 = this.W[n3 - 3] ^ this.W[n3 - 8] ^ this.W[n3 - 14] ^ this.W[n3 - 16];
                this.W[n3] = n2 << 1 | n2 >>> 31;
            }
            ++n3;
        }
        int n4 = this.AA;
        int n5 = this.BB;
        int n6 = this.CC;
        int n7 = this.DD;
        int n8 = this.EE;
        int n9 = 0;
        while (n9 < 20) {
            n2 = (n4 << 5 | n4 >>> 27) + (n5 & n6 | ~n5 & n7) + n8 + this.W[n9] + 1518500249;
            n8 = n7;
            n7 = n6;
            n6 = n5 << 30 | n5 >>> 2;
            n5 = n4;
            n4 = n2;
            ++n9;
        }
        int n10 = 20;
        while (n10 < 40) {
            n2 = (n4 << 5 | n4 >>> 27) + (n5 ^ n6 ^ n7) + n8 + this.W[n10] + 1859775393;
            n8 = n7;
            n7 = n6;
            n6 = n5 << 30 | n5 >>> 2;
            n5 = n4;
            n4 = n2;
            ++n10;
        }
        int n11 = 40;
        while (n11 < 60) {
            n2 = (n4 << 5 | n4 >>> 27) + (n5 & n6 | n5 & n7 | n6 & n7) + n8 + this.W[n11] + -1894007588;
            n8 = n7;
            n7 = n6;
            n6 = n5 << 30 | n5 >>> 2;
            n5 = n4;
            n4 = n2;
            ++n11;
        }
        int n12 = 60;
        while (n12 < 80) {
            n2 = (n4 << 5 | n4 >>> 27) + (n5 ^ n6 ^ n7) + n8 + this.W[n12] + -899497514;
            n8 = n7;
            n7 = n6;
            n6 = n5 << 30 | n5 >>> 2;
            n5 = n4;
            n4 = n2;
            ++n12;
        }
        this.AA += n4;
        this.BB += n5;
        this.CC += n6;
        this.DD += n7;
        this.EE += n8;
    }

    public Object clone() {
        SHA sHA = null;
        try {
            sHA = (SHA)super.clone();
            sHA.W = new int[80];
            System.arraycopy(this.W, 0, sHA.W, 0, this.W.length);
            return sHA;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return sHA;
        }
    }
}

