/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.util.NoSuchElementException;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;

public class SQLTokenizer
extends StringTokenizer {
    private static final String DEFAULTS = "\t\r\n ";
    private static final String OPS = "'\"+-*/=<>!()%@,.;";
    private String marker = null;

    public SQLTokenizer(String string) {
        super(string, DEFAULTS, false, false);
        this.setQuotesEnabled(true);
    }

    public String nextForwardToken() {
        int n2;
        String string;
        int n3;
        block14: {
            this.skipForwardDelimiters();
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            n3 = this.currentPosition;
            this.lastQuoteIdx = -1;
            while (this.currentPosition < this.maxPosition && !this.isDelimiterAtIndex(this.currentPosition)) {
                ++this.currentPosition;
            }
            string = null;
            try {
                boolean bl2;
                n2 = this.str.charAt(n3);
                boolean bl3 = this.delimiters.indexOf(n2) >= 0;
                boolean bl4 = bl2 = OPS.indexOf(n2) >= 0;
                if (n3 == this.currentPosition && !bl3) {
                    string = this.checkOps(n3);
                    if (string == null) {
                        if (bl2) {
                            ++this.currentPosition;
                        }
                        return Character.toString((char)n2);
                    }
                    if (this.retTokens) {
                        ++this.currentPosition;
                        return Character.toString((char)n2);
                    }
                    break block14;
                }
                if (this.currentPosition >= this.maxPosition) {
                    string = this.str.substring(n3);
                    break block14;
                }
                if (!bl3) {
                    string = this.str.substring(n3, this.currentPosition);
                    break block14;
                }
                ++this.currentPosition;
                return "";
            }
            catch (RuntimeException runtimeException) {
                BasicUtilities.HandleException(runtimeException);
                return null;
            }
        }
        if (string.startsWith("--") && this.marker == null) {
            if (this.hasMoreForwardTokens()) {
                this.marker = "--";
                string = string.concat(this.nextToken("\r\n"));
                this.delimiters = DEFAULTS;
                this.marker = null;
            }
            this.tokenIndex = n3;
            return string;
        }
        if (string.startsWith("/*") && this.marker == null) {
            string = string.concat(Character.toString(this.getLastDelimiter()));
            n2 = this.str.indexOf("*/", this.currentPosition);
            if (n2 >= 0) {
                this.tokenIndex = n3;
                this.currentPosition = n2 + 2;
                return this.str.substring(this.tokenIndex, this.currentPosition);
            }
            this.tokenIndex = n3;
            this.currentPosition = this.str.length() - 1;
            return this.str.substring(this.tokenIndex, this.currentPosition);
        }
        return string;
    }

    public synchronized void reset() {
        super.reset();
        this.delimiters = DEFAULTS;
        this.marker = null;
    }

    public boolean isDelimiterAtIndex(int n2) {
        if (n2 >= 0 && n2 < this.str.length()) {
            boolean bl2;
            boolean bl3 = this.isQuoteIdentiferAtIndex(n2);
            boolean bl4 = this.delimiters.indexOf(this.str.charAt(n2)) >= 0;
            boolean bl5 = bl2 = OPS.indexOf(this.str.charAt(n2)) >= 0;
            if (bl3) {
                return false;
            }
            if (this.marker != null) {
                bl2 = false;
            }
            return bl4 || bl2;
        }
        return false;
    }

    public char peek(int n2) {
        try {
            return this.str.charAt(n2 + 1);
        }
        catch (Throwable throwable) {
            return '\u0000';
        }
    }

    public String checkOps(int n2) {
        char c2 = this.str.charAt(n2);
        char c3 = this.peek(n2);
        if (OPS.indexOf(c2) >= 0) {
            switch (c2) {
                case '@': {
                    if (c3 != '@') break;
                    this.currentPosition += 2;
                    return "@@";
                }
                case '<': {
                    switch (c3) {
                        case '=': 
                        case '>': {
                            this.currentPosition += 2;
                            return Character.toString(c2).concat(Character.toString(c3));
                        }
                    }
                    break;
                }
                case '>': {
                    if (c3 != '=') break;
                    this.currentPosition += 2;
                    return ">=";
                }
                case '!': {
                    if (c3 == '=') {
                        this.currentPosition += 2;
                        return "!=";
                    }
                }
                case '&': {
                    if (c3 != '>' && c3 != '<' && c3 != '&') break;
                    this.currentPosition += 2;
                    return "&" + c3;
                }
                case '/': {
                    if (c3 != '*') break;
                    this.currentPosition += 2;
                    return "/*";
                }
                case '*': {
                    if (c3 != '/') break;
                    this.currentPosition += 2;
                    return "*/";
                }
                case '-': {
                    if (c3 != c2) break;
                    this.currentPosition += 2;
                    return "--";
                }
            }
            ++this.currentPosition;
            return Character.toString(c2);
        }
        return null;
    }
}

