/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import com.ibm.bsf.BSFManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintStream;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.ScriptTreeModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.ITabbedPane;
import org.isqlviewer.swing.JConsole;
import org.isqlviewer.swing.SimpleTextEditor;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.ui.SQLWorkBench;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public class ScriptManager
extends JFrame {
    public static final String BEAN_ID_DATABASE_CONNECTION = "isql_db";
    public static final String BEAN_ID_iSQL_CONFIG = "isql_config";
    public static final String BEAN_ID_iSQL_UTILITES = "isql_util";
    public static final String BEAN_ID_RESULT_RENDERER = "isql_renderer";
    public static final String BEAN_ID_CONSOLE_OUT = "out";
    public static final String BEAN_ID_CONSOLE_ERR = "err";
    private static final ThreadGroup SCRIPT_GROUP = new ThreadGroup("isql-scripts");
    private static ScriptManager instance = null;
    private BSFManager scriptManager = new BSFManager();
    private SystemConfig sysConfig = SystemConfig.getInstance();
    private boolean beVerbose = this.sysConfig.getPreferences().getBoolean("scripting.debug-enabled");
    private ScriptTreeModel mdlScripts = new ScriptTreeModel(new ScriptFileFilter(null));
    private JTree treScripts = new JTree(this.mdlScripts);
    private JSplitPane sppTreeEditorView = new JSplitPane(1);
    private JSplitPane sppRoot = new JSplitPane(0);
    private ActionHandler actionHandler = new ActionHandler(null);
    private JToolBar editorToolbar = ActionToolBar.createNullInstance();
    private ITabbedPane fileContainer = new ITabbedPane(1, 5);
    private JConsole console = new JConsole(BasicUtilities.getString("Script_Console_Ready"));
    private JButton btnExecute = new JButton(BasicUtilities.loadToolbarIconResource("Play"));
    private JButton btnSave = new JButton(BasicUtilities.loadToolbarIconResource("Save"));
    private JButton btnSaveAs = new JButton(BasicUtilities.loadToolbarIconResource("SaveAs"));
    private JButton btnOpen = new JButton(BasicUtilities.loadToolbarIconResource("Open"));
    private JButton btnNew = new JButton(BasicUtilities.loadToolbarIconResource("New"));
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));
    private PrintStream dbg = new PrintStream(this.console.createFilteredStream(JConsole.CATEGORY_SCRIPT_DEBUG), true);
    private PrintStream out = new PrintStream(this.console.createFilteredStream("system"), true);
    private PrintStream err = new PrintStream(this.console.createFilteredStream("err"), true);
    static /* synthetic */ Class class$org$isqlviewer$util$BasicUtilities;

    public static int showDialog(JFrame jFrame, DatabaseConnection databaseConnection, SQLWorkBench sQLWorkBench) {
        if (instance == null) {
            try {
                instance = new ScriptManager(databaseConnection, sQLWorkBench);
                instance.pack();
                instance.setSize(640, 480);
                instance.setLocationRelativeTo(jFrame);
                instance.show();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "", true);
                instance = null;
                return -1;
            }
        } else {
            instance.toFront();
        }
        return 0;
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        int n2 = windowEvent.getID();
        switch (n2) {
            case 202: {
                instance = null;
                break;
            }
            case 201: {
                this.sysConfig.getIPCService().unSubscribeAll(this.actionHandler);
                break;
            }
            case 200: {
                this.sppRoot.setDividerLocation(0.8);
                this.sppTreeEditorView.setDividerLocation(this.treScripts.getPreferredSize().width + this.sppTreeEditorView.getDividerSize());
            }
        }
        super.processWindowEvent(windowEvent);
    }

    public ScriptManager(DatabaseConnection databaseConnection, SQLWorkBench sQLWorkBench) {
        Class<?> clazz;
        this.setDefaultCloseOperation(2);
        this.setTitle(BasicUtilities.getString("Script_Manager_Title"));
        this.scriptManager.setDebugStream(this.dbg);
        this.console.configure(this.sysConfig.getPreferences());
        this.sysConfig.getIPCService().subscribe(this.actionHandler, "isql-service-change");
        this.scriptManager.setClassLoader(this.sysConfig.getRuntimeClassLoader());
        if (this.beVerbose) {
            this.out.println(BasicUtilities.getString("Script_Bean_Register", BEAN_ID_iSQL_CONFIG));
        }
        this.scriptManager.registerBean(BEAN_ID_iSQL_CONFIG, (Object)this.sysConfig);
        if (this.beVerbose) {
            this.out.println(BasicUtilities.getString("Script_Bean_Register", BEAN_ID_CONSOLE_OUT));
        }
        this.scriptManager.registerBean(BEAN_ID_CONSOLE_OUT, (Object)this.out);
        if (this.beVerbose) {
            this.out.println(BasicUtilities.getString("Script_Bean_Register", BEAN_ID_CONSOLE_ERR));
        }
        this.scriptManager.registerBean(BEAN_ID_CONSOLE_ERR, (Object)this.err);
        if (this.beVerbose) {
            this.out.println(BasicUtilities.getString("Script_Bean_Register", BEAN_ID_RESULT_RENDERER));
        }
        ResultSetViewer resultSetViewer = sQLWorkBench.createResultSetDelegate();
        this.scriptManager.registerBean(BEAN_ID_RESULT_RENDERER, (Object)resultSetViewer);
        if (this.beVerbose) {
            this.out.println(BasicUtilities.getString("Script_Bean_Register", BEAN_ID_iSQL_UTILITES));
        }
        if ((clazz = class$org$isqlviewer$util$BasicUtilities) == null) {
            clazz = class$org$isqlviewer$util$BasicUtilities = new BasicUtilities[0].getClass().getComponentType();
        }
        this.scriptManager.registerBean(BEAN_ID_iSQL_UTILITES, (Object)clazz);
        if (databaseConnection != null) {
            if (this.beVerbose) {
                this.out.println(BasicUtilities.getString("Script_Bean_Register", BEAN_ID_DATABASE_CONNECTION));
            }
            this.scriptManager.registerBean(BEAN_ID_DATABASE_CONNECTION, (Object)databaseConnection);
        } else if (this.beVerbose) {
            this.err.println(BasicUtilities.getString("Script_DB_Warning", BEAN_ID_DATABASE_CONNECTION));
        }
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initUI() {
        JToolBar jToolBar = new JToolBar(0);
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        BasicUtilities.lockComponentToPerferredSize(this.btnOK);
        this.btnOK.setToolTipText(BasicUtilities.getString("Close_This_Dialog"));
        this.btnExecute.setToolTipText(BasicUtilities.getString("Script_Exec_Tip"));
        this.btnSave.setToolTipText(BasicUtilities.getString("Script_Save_Tip"));
        this.btnSaveAs.setToolTipText(BasicUtilities.getString("Script_SaveAs_Tip"));
        this.btnNew.setToolTipText(BasicUtilities.getString("Script_New_Tip"));
        this.btnOK.addActionListener(this.actionHandler);
        this.btnNew.addActionListener(this.actionHandler);
        this.btnExecute.addActionListener(this.actionHandler);
        this.btnSave.addActionListener(this.actionHandler);
        this.btnSaveAs.addActionListener(this.actionHandler);
        this.btnOpen.addActionListener(this.actionHandler);
        this.btnNew.setName("New");
        this.btnExecute.setName("Play");
        this.btnSave.setName("Save");
        this.btnSaveAs.setName("SaveAS");
        this.btnOpen.setName("Open");
        this.btnExecute.setMnemonic('X');
        this.btnSave.setMnemonic('S');
        this.btnSaveAs.setMnemonic('A');
        this.btnNew.setMnemonic('N');
        this.editorToolbar.setOrientation(0);
        this.editorToolbar.setFloatable(false);
        this.editorToolbar.add(this.btnOpen);
        this.editorToolbar.add(this.btnNew);
        this.editorToolbar.add(this.btnSave);
        this.editorToolbar.add(this.btnSaveAs);
        this.editorToolbar.addSeparator();
        this.editorToolbar.add(this.btnExecute);
        jToolBar.setFloatable(false);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(this.btnOK);
        jToolBar.add(Box.createHorizontalStrut(12));
        WizardPanel wizardPanel = new WizardPanel();
        wizardPanel.add((Component)this.sppRoot, "root");
        wizardPanel.showCard(this.sppRoot);
        this.sppRoot.setTopComponent(this.sppTreeEditorView);
        this.treScripts.setCellRenderer(new ScriptRenderer());
        this.treScripts.addMouseListener(this.actionHandler);
        this.treScripts.setEditable(true);
        this.treScripts.setRootVisible(false);
        this.sppTreeEditorView.setLeftComponent(new JScrollPane(this.treScripts));
        this.sppTreeEditorView.setRightComponent(this.fileContainer);
        this.sppRoot.setBottomComponent(new JScrollPane(this.console));
        this.getContentPane().add((Component)this.editorToolbar, "North");
        this.getContentPane().add((Component)wizardPanel, "Center");
        this.getContentPane().add((Component)jToolBar, "South");
    }

    private Component createEditor(File file) {
        return new SimpleTextEditor(file, this.getLangforFile(file));
    }

    private Icon getIconforFile(File file) {
        Icon icon = BasicUtilities.loadIconResource("Script16");
        try {
            BSFManager.getLangFromFilename((String)file.getName());
        }
        catch (Exception exception) {
            icon = BasicUtilities.loadIconResource("BadScript16");
        }
        return icon;
    }

    private String getLangforFile(File file) {
        String string = null;
        try {
            string = BSFManager.getLangFromFilename((String)file.getName());
        }
        catch (Exception exception) {
            string = "null";
        }
        return string;
    }

    public static class 1 {
    }

    private class ScriptRunner
    implements Runnable {
        private File script = null;

        public ScriptRunner(File file) {
            this.script = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String[] stringArray;
            long l2 = System.currentTimeMillis();
            try {
                stringArray = new FileInputStream(this.script);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)this.script.length());
                BasicUtilities.copyStream((InputStream)stringArray, byteArrayOutputStream);
                stringArray.close();
                String string = new String(byteArrayOutputStream.toByteArray());
                String string2 = BSFManager.getLangFromFilename((String)this.script.getName());
                String[] stringArray2 = new String[]{this.script.getName(), string2};
                ScriptManager.this.out.println(BasicUtilities.getString("Script_Exec_Start", stringArray2));
                ScriptManager.this.scriptManager.exec(string2, this.script.getName(), 0, 0, (Object)string);
            }
            catch (Throwable throwable) {
                try {
                    BasicUtilities.HandleException(throwable, BasicUtilities.getString("Srcipt_Exec_Error", this.script.getName()), true, ScriptManager.this.err);
                }
                catch (Throwable throwable2) {
                    String[] stringArray3 = new String[]{this.script.getName(), Long.toString(System.currentTimeMillis() - l2)};
                    ScriptManager.this.out.println(BasicUtilities.getString("Script_Exec_Finished", stringArray3));
                    throw throwable2;
                }
                String[] stringArray4 = new String[]{this.script.getName(), Long.toString(System.currentTimeMillis() - l2)};
                ScriptManager.this.out.println(BasicUtilities.getString("Script_Exec_Finished", stringArray4));
            }
            stringArray = new String[]{this.script.getName(), Long.toString(System.currentTimeMillis() - l2)};
            ScriptManager.this.out.println(BasicUtilities.getString("Script_Exec_Finished", stringArray));
        }
    }

    private class ScriptFileFilter
    implements FileFilter {
        private ScriptFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isFile()) {
                UserPreferences userPreferences = ScriptManager.this.sysConfig.getPreferences();
                if (userPreferences.getBoolean("scripting.filefilter-enabled")) {
                    try {
                        BSFManager.getLangFromFilename((String)file.getName());
                        return true;
                    }
                    catch (Throwable throwable) {
                        return false;
                    }
                }
                return true;
            }
            return true;
        }

        public /* synthetic */ ScriptFileFilter(1 var2_2) {
            this();
        }
    }

    private class ActionHandler
    extends MouseAdapter
    implements ActionListener,
    IPCListener {
        private ActionHandler() {
        }

        public void receiveMessage(Object object, String string, Object object2) {
            if (string != null && string.equals("isql-service-change")) {
                DatabaseConnection databaseConnection = (DatabaseConnection)object2;
                if (databaseConnection != null) {
                    if (ScriptManager.this.beVerbose) {
                        ScriptManager.this.out.println(BasicUtilities.getString("Script_Bean_Register", ScriptManager.BEAN_ID_DATABASE_CONNECTION));
                    }
                    ScriptManager.this.scriptManager.registerBean(ScriptManager.BEAN_ID_DATABASE_CONNECTION, (Object)databaseConnection);
                } else {
                    if (ScriptManager.this.beVerbose) {
                        ScriptManager.this.err.println(BasicUtilities.getString("Script_DB_Warning", ScriptManager.BEAN_ID_DATABASE_CONNECTION));
                    }
                    try {
                        ScriptManager.this.scriptManager.unregisterBean(ScriptManager.BEAN_ID_DATABASE_CONNECTION);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ScriptManager.this.btnOK) {
                ScriptManager.this.dispatchEvent(new WindowEvent(ScriptManager.this, 201));
            } else if (object == ScriptManager.this.btnSave) {
                this.saveSelected();
            } else if (object == ScriptManager.this.btnSaveAs) {
                this.saveSelectedAs();
            } else if (object == ScriptManager.this.btnExecute) {
                this.execSelected();
            } else if (object == ScriptManager.this.btnNew) {
                this.createNew();
            } else if (object == ScriptManager.this.btnOpen) {
                File file = BasicUtilities.getSystemFile(ScriptManager.this, 0);
                if (file == null) {
                    return;
                }
                this.openFile(file);
            }
        }

        public void removeSelected() {
        }

        public void createNew() {
        }

        public File getSelectedScript() {
            TreePath treePath;
            Object object;
            File file = null;
            if (!ScriptManager.this.fileContainer.isEmpty()) {
                SimpleTextEditor simpleTextEditor = (SimpleTextEditor)ScriptManager.this.fileContainer.getSelectedComponent();
                if (simpleTextEditor.isModified()) {
                    this.saveSelected();
                }
                file = new File(ScriptManager.this.fileContainer.getSelectedToolTip());
            } else if (ScriptManager.this.treScripts.getSelectionPath() != null && (object = (treePath = ScriptManager.this.treScripts.getSelectionPath()).getLastPathComponent()) instanceof File) {
                file = (File)object;
                file = file.isFile() ? file : null;
            }
            return file;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object;
            if (mouseEvent.getClickCount() == 2 && (object = ScriptManager.this.treScripts.getSelectionPath().getLastPathComponent()) instanceof File) {
                File file = (File)object;
                this.openFile(file);
            }
        }

        public void openFile(File file) {
            if (file.isFile()) {
                try {
                    Icon icon = ScriptManager.this.getIconforFile(file);
                    int n2 = -1;
                    for (int i2 = 0; i2 < ScriptManager.this.fileContainer.getTabCount(); ++i2) {
                        if (!ScriptManager.this.fileContainer.getToolTipTextAt(i2).equals(file.getAbsolutePath())) continue;
                        n2 = i2;
                        break;
                    }
                    if (n2 != -1) {
                        ScriptManager.this.fileContainer.setSelectedIndex(n2);
                    } else {
                        String string = file.getName();
                        int n3 = string.lastIndexOf(46);
                        if (n3 >= 0) {
                            string = string.substring(0, n3);
                        }
                        Component component = ScriptManager.this.createEditor(file);
                        ScriptManager.this.fileContainer.addTab(string, icon, component, file.getAbsolutePath());
                        ScriptManager.this.fileContainer.setSelectedIndex(ScriptManager.this.fileContainer.getTabCount() - 1);
                        component.requestFocus();
                    }
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, BasicUtilities.getString("Script_Read_Error", file.getName()), false);
                }
            }
        }

        public void execSelected() {
            File file = this.getSelectedScript();
            if (file != null) {
                ScriptRunner scriptRunner = new ScriptRunner(file);
                Thread thread = new Thread(SCRIPT_GROUP, scriptRunner, file.getName());
                thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveSelected() {
            try {
                File file = new File(ScriptManager.this.fileContainer.getSelectedToolTip());
                FileWriter fileWriter = new FileWriter(file);
                SimpleTextEditor simpleTextEditor = (SimpleTextEditor)ScriptManager.this.fileContainer.getSelectedComponent();
                fileWriter.write(simpleTextEditor.getText());
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, BasicUtilities.getString("Could_Not_Save_File", ScriptManager.this.fileContainer.getSelectedToolTip()), true, ScriptManager.this.err);
            }
            finally {
                ScriptManager.this.out.println(BasicUtilities.getString("Script_Save", ScriptManager.this.fileContainer.getSelectedToolTip()));
            }
        }

        public void saveSelectedAs() {
        }

        public /* synthetic */ ActionHandler(1 var2_2) {
            this();
        }
    }

    private static class ScriptRenderer
    extends DefaultTreeCellRenderer {
        public ScriptRenderer() {
            this.setLeafIcon(BasicUtilities.loadIconResource("Script16"));
            this.setOpenIcon(BasicUtilities.loadIconResource("LeafOpen16"));
            this.setClosedIcon(BasicUtilities.loadIconResource("LeafClose16"));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
            if (object instanceof File) {
                File file = (File)object;
                this.setText(file.getName());
                this.setToolTipText(file.getAbsolutePath());
                if (file.isFile()) {
                    try {
                        BSFManager.getLangFromFilename((String)file.getName());
                    }
                    catch (Exception exception) {
                        this.setIcon(BasicUtilities.loadIconResource("BadScript16"));
                    }
                }
            }
            return this;
        }
    }
}

