/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.model.AbstractTreeModel;
import org.isqlviewer.swing.PropertyPageCellRenderer;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.ui.BatchWizard;
import org.isqlviewer.ui.prefs.AdvancedPropertyPage;
import org.isqlviewer.ui.prefs.GeneralPropertyPage;
import org.isqlviewer.ui.prefs.I18NPropertyPage;
import org.isqlviewer.ui.prefs.ScriptManagerPropertyPage;
import org.isqlviewer.ui.prefs.ServiceManagerPropertyPage;
import org.isqlviewer.ui.prefs.WorkbenchPropertyPage;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.PropertyPage;
import org.isqlviewer.util.StringUtilities;

public final class PreferencesEditor
extends JDialog
implements ActionListener {
    public static final int UI_PAGE = -1;
    public static final int FONT_PAGE = -1;
    public static final int SM_PAGE = -1;
    public static final int GENERAL_PAGE = 0;
    public static final int WORKBENCH_PAGE = 1;
    public static final int ADVANCED_PAGE = 2;
    public static final int SERVICE_PAGE = 3;
    public static final int EDITOR_PAGE = 4;
    public static final int SCRIPT_PAGE = 5;
    public static final int I18N_PAGE = 6;
    private final PropertyPage[] ppages = new PropertyPage[7];
    private PropertyTreeModel configTree = null;
    private JTree configView = null;
    private JScrollPane propertyView = new JScrollPane();
    private JSplitPane rootView = new JSplitPane(1, true);
    private JPanel SouthPanel = new JPanel(new FlowLayout());
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));
    private JButton btnApply = new JButton(BasicUtilities.getString("Apply"));
    private JButton btnCANCEL = new JButton(BasicUtilities.getString("Cancel"));

    private PreferencesEditor(JDialog jDialog) {
        super(jDialog, BasicUtilities.getString("iSQLPrefrences_Title"), true);
        try {
            this.loadPages();
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "PreferencesEditor(Frame)");
        }
    }

    private PreferencesEditor(JFrame jFrame) {
        super(jFrame, BasicUtilities.getString("iSQLPrefrences_Title"), true);
        try {
            this.loadPages();
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "PreferencesEditor(Frame)");
        }
    }

    private void loadPages() {
        this.ppages[0] = new GeneralPropertyPage();
        this.ppages[1] = new WorkbenchPropertyPage();
        this.ppages[2] = new AdvancedPropertyPage(this);
        this.ppages[4] = new BatchWizard.PreferencesBatch();
        this.ppages[3] = new ServiceManagerPropertyPage();
        this.ppages[5] = new ScriptManagerPropertyPage();
        this.ppages[6] = new I18NPropertyPage();
        for (int i2 = 0; i2 < this.ppages.length; ++i2) {
            PropertyPage propertyPage = this.ppages[i2];
            if (propertyPage == null) continue;
            propertyPage.loadProperties();
        }
    }

    public void resetPages() {
        for (int i2 = 0; i2 < this.ppages.length; ++i2) {
            PropertyPage propertyPage = this.ppages[i2];
            propertyPage.revertProperties();
            propertyPage.saveProperties();
        }
        this.dispose();
    }

    public void savePages() {
        for (int i2 = 0; i2 < this.ppages.length; ++i2) {
            PropertyPage propertyPage = this.ppages[i2];
            if (!propertyPage.hasChangedProperties()) continue;
            propertyPage.saveProperties();
            propertyPage.revertChangedState();
        }
        this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 200: {
                this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
                break;
            }
            case 201: {
                String string;
                Boolean bl2 = (Boolean)this.getRootPane().getClientProperty("windowModified");
                if (bl2 == null || !bl2.booleanValue()) break;
                String string2 = BasicUtilities.getString("Preference_Edit_Warning");
                int n2 = JOptionPane.showConfirmDialog(this, string2 = StringUtilities.formatBreak(80, "<html>".concat(string2), "", true), string = BasicUtilities.getString("Warning"), 0);
                if (n2 != 1) break;
                return;
            }
        }
        super.processWindowEvent(windowEvent);
    }

    private void initUI() {
        this.SouthPanel.add(Box.createHorizontalGlue());
        this.SouthPanel.add(this.btnOK);
        this.SouthPanel.add(this.btnCANCEL);
        this.SouthPanel.add(this.btnApply);
        this.SouthPanel.add(Box.createHorizontalGlue());
        this.btnOK.addActionListener(this);
        this.btnCANCEL.addActionListener(this);
        this.btnApply.addActionListener(this);
        this.configTree = new PropertyTreeModel(null);
        this.configView = new JTree(this.configTree);
        this.configView.setRootVisible(false);
        this.configView.setExpandsSelectedPaths(true);
        this.configView.setCellRenderer(new PropertyPageCellRenderer());
        this.configView.setScrollsOnExpand(true);
        this.configView.setSelectionRow(0);
        this.configView.expandRow(0);
        PropertyPageSelectionListener propertyPageSelectionListener = new PropertyPageSelectionListener(null);
        this.configView.addTreeSelectionListener(propertyPageSelectionListener);
        this.rootView.setLeftComponent(new JScrollPane(this.configView));
        this.rootView.setRightComponent(this.propertyView);
        WizardPanel wizardPanel = new WizardPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.rootView, "Center");
        jPanel.add((Component)this.SouthPanel, "South");
        wizardPanel.showCard(jPanel);
        this.setContentPane(wizardPanel);
        this.configView.setSelectionRow(0);
        propertyPageSelectionListener.valueChanged(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnOK || object == this.btnApply) {
            this.savePages();
            if (object == this.btnApply) {
                return;
            }
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public static final int showDialog(JDialog jDialog, int n2) {
        PreferencesEditor preferencesEditor = new PreferencesEditor(jDialog);
        preferencesEditor.pack();
        preferencesEditor.setSize(640, 365);
        preferencesEditor.setLocationRelativeTo(jDialog);
        preferencesEditor.configView.collapseRow(0);
        preferencesEditor.configView.setSelectionRow(n2);
        preferencesEditor.configView.expandRow(n2);
        preferencesEditor.show();
        return 0;
    }

    public static final int showDialog(JFrame jFrame) {
        PreferencesEditor preferencesEditor = new PreferencesEditor(jFrame);
        preferencesEditor.pack();
        preferencesEditor.setSize(640, 365);
        preferencesEditor.setLocationRelativeTo(jFrame);
        preferencesEditor.show();
        return 0;
    }

    public static class 1 {
    }

    private class PropertyTreeModel
    extends AbstractTreeModel {
        private final Object ROOT = new Object();
        private final TreeModelEvent EVENT_RELOAD = new TreeModelEvent((Object)this, new Object[]{this.ROOT}, null, null);

        private PropertyTreeModel() {
        }

        public void reload() {
            this.fireTreeStructureChanged(this.EVENT_RELOAD);
        }

        public Object getChild(Object object, int n2) {
            if (object == this.getRoot()) {
                return PreferencesEditor.this.ppages[n2];
            }
            if (object instanceof PropertyPage) {
                return ((PropertyPage)object).getChildren()[n2];
            }
            return "";
        }

        public int getChildCount(Object object) {
            if (object == this.getRoot()) {
                return PreferencesEditor.this.ppages.length;
            }
            if (object instanceof PropertyPage) {
                return ((PropertyPage)object).getChildren().length;
            }
            return 0;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object == this.getRoot()) {
                for (int i2 = 0; i2 < PreferencesEditor.this.ppages.length; ++i2) {
                    if (!PreferencesEditor.this.ppages[i2].getPropertyPageName().equals(object2)) continue;
                    return i2;
                }
                return -1;
            }
            if (object instanceof PropertyPage) {
                PropertyPage[] propertyPageArray = ((PropertyPage)object).getChildren();
                String string = ((PropertyPage)object2).getPropertyPageName();
                for (int i3 = 0; i3 < propertyPageArray.length; ++i3) {
                    if (!propertyPageArray[i3].getPropertyPageName().equals(string)) continue;
                    return i3;
                }
                return -1;
            }
            return 0;
        }

        public Object getRoot() {
            return this.ROOT;
        }

        public boolean isLeaf(Object object) {
            return this.getChildCount(object) == 0;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public /* synthetic */ PropertyTreeModel(1 var2_2) {
            this();
        }
    }

    private class PropertyPageSelectionListener
    implements TreeSelectionListener {
        private PropertyPageSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            try {
                PropertyPage propertyPage = (PropertyPage)PreferencesEditor.this.configView.getSelectionPath().getLastPathComponent();
                PreferencesEditor.this.setTitle(BasicUtilities.getString("iSQLPrefrences_Title", propertyPage.getPropertyPageName()));
                PreferencesEditor.this.propertyView.setViewportView(propertyPage.getPageComponent());
                SwingUtilities.updateComponentTreeUI(PreferencesEditor.this.propertyView);
                int n2 = ((PreferencesEditor)PreferencesEditor.this).configView.getPreferredSize().width + 2 * PreferencesEditor.this.rootView.getDividerSize() + 2;
                if (PreferencesEditor.this.rootView.getDividerLocation() < n2) {
                    PreferencesEditor.this.rootView.setDividerLocation(n2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public /* synthetic */ PropertyPageSelectionListener(1 var2_2) {
            this();
        }
    }
}

