/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public final class SimpleTextEditor
extends JComponent {
    private JEditorPane editor = new JEditorPane("text/plain", "");
    private JLabel lblSrc = new JLabel("");
    private JLabel lblInfo = new JLabel("");
    private JLabel lblCaret = new JLabel("");
    private JPanel statusBar = new JPanel(new GridBagLayout());
    private File file = null;
    private NumberFormat caretFormat = NumberFormat.getIntegerInstance();
    private TextActionHandler textActionHandler = new TextActionHandler(null);
    public boolean isModified = false;
    private UndoManager undo = new UndoManager();

    public SimpleTextEditor(File file, String string) {
        this.initUI();
        this.setFile(file);
        this.setXtraInfo(string);
        this.caretFormat.setMinimumIntegerDigits(3);
    }

    public void requestFocus() {
        this.editor.requestFocus();
    }

    public void reload() {
        try {
            this.editor.setPage(this.file.toURL());
            this.editor.getDocument().addDocumentListener(this.textActionHandler);
            this.editor.getDocument().addUndoableEditListener(this.textActionHandler);
            this.editor.setEditable(this.file.canRead());
            this.editor.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isModified = false;
    }

    public void finalize() {
        BasicUtilities.unlocalizeTextComponent(this.editor, this.undo);
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        Border border = BorderFactory.createLineBorder(this.lblSrc.getForeground());
        this.lblSrc.setBorder(border);
        this.lblInfo.setBorder(border);
        this.lblCaret.setBorder(border);
        Insets insets = new Insets(1, 1, 1, 1);
        this.lblCaret.setHorizontalAlignment(0);
        this.statusBar.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 1, 1));
        this.statusBar.add((Component)this.lblSrc, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 1, 1));
        this.statusBar.add((Component)this.lblInfo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 1, 1));
        this.statusBar.add((Component)this.lblCaret, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 1, 1));
        JScrollPane jScrollPane = new JScrollPane(this.editor);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.statusBar, "South");
        this.statusBar.revalidate();
        this.editor.addCaretListener(this.textActionHandler);
        BasicUtilities.localizeTextComponent(this.editor, this.undo);
    }

    public void setXtraInfo(String string) {
        this.lblInfo.setText(" " + string + " ");
    }

    public String getXtraInfo() {
        return this.lblInfo.getText().trim();
    }

    public String getText() {
        return this.editor.getText();
    }

    public void setFile(File file) {
        this.file = file;
        this.lblSrc.setText(" ".concat(file.getName().concat(" ")));
        this.reload();
    }

    public File getFile() {
        return this.file;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public static class 1 {
    }

    private class TextActionHandler
    implements CaretListener,
    UndoableEditListener,
    DocumentListener {
        private UserPreferences prefs = SystemConfig.getInstance().getPreferences();

        private TextActionHandler() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (!SimpleTextEditor.this.isModified) {
                SimpleTextEditor.this.isModified = true;
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (!SimpleTextEditor.this.isModified) {
                SimpleTextEditor.this.isModified = true;
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (!SimpleTextEditor.this.isModified) {
                SimpleTextEditor.this.isModified = true;
            }
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (undoableEditEvent == null || undoableEditEvent.getEdit() == null) {
                return;
            }
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            String string = undoableEdit.getPresentationName();
            if (string != null && undoableEdit.canUndo()) {
                if (string.indexOf("style") < 0) {
                    SimpleTextEditor.this.undo.addEdit(undoableEditEvent.getEdit());
                } else {
                    undoableEdit.die();
                }
            } else {
                undoableEdit.die();
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            Object object = caretEvent == null ? SimpleTextEditor.this.editor : caretEvent.getSource();
            int n2 = caretEvent == null ? SimpleTextEditor.this.editor.getCaretPosition() : caretEvent.getDot();
            try {
                if (object instanceof JTextComponent) {
                    int n3 = 0;
                    int n4 = 0;
                    JTextComponent jTextComponent = (JTextComponent)object;
                    n3 = BasicUtilities.getCaretRow(n2, jTextComponent) + 1;
                    n4 = BasicUtilities.getCaretCol(n2, jTextComponent) + 1;
                    String string = SimpleTextEditor.this.caretFormat.format(n3).concat(" : ").concat(SimpleTextEditor.this.caretFormat.format(n4));
                    if (this.prefs.getBoolean("editor.caretoffset-enabled")) {
                        string = string.concat(", ").concat(SimpleTextEditor.this.caretFormat.format(n2 + 1));
                    }
                    SimpleTextEditor.this.lblCaret.setText(" ".concat(string).concat(" "));
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
        }

        public /* synthetic */ TextActionHandler(1 var2_2) {
            this();
        }
    }
}

