/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.AbstractTreeModel;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.UserPreferences;

public class ScriptTreeModel
extends AbstractTreeModel {
    private final Object ROOT_NODE = new Object();
    private SystemConfig sysConfig = SystemConfig.getInstance();
    public EventListenerList listenerList = new EventListenerList();
    public Vector rootPaths = new Vector();
    public FileFilter fileFilter = null;

    public ScriptTreeModel() {
        this(null);
    }

    public ScriptTreeModel(FileFilter fileFilter) {
        this.setScriptFilter(fileFilter);
        UserPreferences userPreferences = this.sysConfig.getPreferences();
        String string = userPreferences.get("scripting.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            if (!file.isDirectory()) continue;
            this.rootPaths.add(file);
        }
    }

    public void setScriptFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.reload();
    }

    public Object getRoot() {
        return this.ROOT_NODE;
    }

    public int getChildCount(Object object) {
        if (object == this.ROOT_NODE) {
            return this.rootPaths.size();
        }
        if (object instanceof File) {
            File[] fileArray = null;
            File file = (File)object;
            fileArray = this.fileFilter == null ? file.listFiles() : file.listFiles(this.fileFilter);
            return fileArray.length;
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        if (object == this.ROOT_NODE) {
            return false;
        }
        if (object instanceof File) {
            return !((File)object).isDirectory();
        }
        return true;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == this.ROOT_NODE) {
            return this.rootPaths.indexOf(object2);
        }
        if (object instanceof File) {
            File[] fileArray = null;
            File file = (File)object;
            fileArray = this.fileFilter == null ? file.listFiles() : file.listFiles(this.fileFilter);
            return Arrays.asList(fileArray).indexOf(object2);
        }
        return -1;
    }

    public Object getChild(Object object, int n2) {
        if (object == this.ROOT_NODE) {
            return this.rootPaths.get(n2);
        }
        if (object instanceof File) {
            File[] fileArray = null;
            File file = (File)object;
            fileArray = this.fileFilter == null ? file.listFiles() : file.listFiles(this.fileFilter);
            return fileArray[n2];
        }
        return null;
    }
}

