/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.action;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.isqlviewer.core.action.DefaultActionManager;
import org.isqlviewer.util.BasicUtilities;

public class CoreAction
extends AbstractAction {
    public static final String ICON_NAME = "ICON_NAME";
    public static DefaultActionManager manager;

    public static final void setActionManager(DefaultActionManager defaultActionManager) {
        manager = defaultActionManager;
    }

    public CoreAction(String string, int n2, ResourceBundle resourceBundle) {
        this.putValue("Name", string);
        try {
            this.putValue(ICON_NAME, resourceBundle.getString(string + "_Icon"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.putValue("Default", resourceBundle.getString(string + "_Text"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.putValue("ShortDescription", resourceBundle.getString(string + "_S_Desc"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.putValue("LongDescription", resourceBundle.getString(string + "_L_Desc"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.putValue("MnemonicKey", new Integer(resourceBundle.getString(string + "_Mnemonic")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            KeyStroke keyStroke = BasicUtilities.getLocalKeyStroke(resourceBundle, string + "_Accel");
            if (keyStroke != null) {
                this.putValue("AcceleratorKey", keyStroke);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.putValue("ActionCommandKey", Integer.toString(n2));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (manager == null) {
            return;
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(this.getValue("ActionCommandKey").toString());
        }
        catch (Exception exception) {
            return;
        }
        manager.forwardAction(new ActionEvent(actionEvent.getSource(), n2, actionEvent.getActionCommand(), actionEvent.getModifiers()));
    }
}

