/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentList;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.PersistentIterator;
import org.garret.perst.PersistentResource;
import org.garret.perst.Storage;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.SubList;

class PersistentListImpl
extends PersistentResource
implements IPersistentList {
    int nElems;
    ListPage root;
    transient int modCount;
    static final int nLeafPageItems = 1020;
    static final int nIntermediatePageItems = 509;

    public Object get(int n2) {
        if (n2 < 0 || n2 >= this.nElems) {
            throw new IndexOutOfBoundsException("index=" + n2 + ", size=" + this.nElems);
        }
        return this.root.get(n2);
    }

    IPersistent getPosition(TreePosition treePosition, int n2) {
        if (n2 < 0 || n2 >= this.nElems) {
            throw new IndexOutOfBoundsException("index=" + n2 + ", size=" + this.nElems);
        }
        if (treePosition.page != null && n2 >= treePosition.index && n2 < treePosition.index + treePosition.page.nItems) {
            return treePosition.page.items.get(n2 - treePosition.index);
        }
        treePosition.index = n2;
        return this.root.getPosition(treePosition, n2);
    }

    IPersistent getRawPosition(TreePosition treePosition, int n2) {
        if (n2 < 0 || n2 >= this.nElems) {
            throw new IndexOutOfBoundsException("index=" + n2 + ", size=" + this.nElems);
        }
        if (treePosition.page != null && n2 >= treePosition.index && n2 < treePosition.index + treePosition.page.nItems) {
            return treePosition.page.items.getRaw(n2 - treePosition.index);
        }
        treePosition.index = n2;
        return this.root.getRawPosition(treePosition, n2);
    }

    public Object set(int n2, Object object) {
        if (n2 < 0 || n2 >= this.nElems) {
            throw new IndexOutOfBoundsException("index=" + n2 + ", size=" + this.nElems);
        }
        return this.root.set(n2, object);
    }

    public Object[] toArray() {
        int n2 = this.nElems;
        Object[] objectArray = new Object[n2];
        ListIterator listIterator = this.listIterator(0);
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = listIterator.next();
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n2 = this.nElems;
        if (objectArray.length < n2) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        }
        ListIterator listIterator = this.listIterator(0);
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = listIterator.next();
        }
        return objectArray;
    }

    public boolean isEmpty() {
        return this.nElems == 0;
    }

    public int size() {
        return this.nElems;
    }

    public boolean contains(Object object) {
        Iterator iterator = this.iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean add(Object object) {
        this.add(this.nElems, object);
        return true;
    }

    public void add(int n2, Object object) {
        if (n2 < 0 || n2 > this.nElems) {
            throw new IndexOutOfBoundsException("index=" + n2 + ", size=" + this.nElems);
        }
        IPersistent iPersistent = (IPersistent)object;
        ListPage listPage = this.root.add(n2, iPersistent);
        if (listPage != null) {
            ListIntermediatePage listIntermediatePage = new ListIntermediatePage(this.getStorage());
            listIntermediatePage.setItem(0, listPage);
            listIntermediatePage.items.set(1, this.root);
            listIntermediatePage.nChildren[1] = Integer.MAX_VALUE;
            listIntermediatePage.nItems = 2;
            this.root = listIntermediatePage;
        }
        ++this.nElems;
        ++this.modCount;
        this.modify();
    }

    public Object remove(int n2) {
        if (n2 < 0 || n2 >= this.nElems) {
            throw new IndexOutOfBoundsException("index=" + n2 + ", size=" + this.nElems);
        }
        IPersistent iPersistent = this.root.remove(n2);
        if (this.root.nItems == 1 && this.root instanceof ListIntermediatePage) {
            ListPage listPage = (ListPage)this.root.items.get(0);
            this.root.deallocate();
            this.root = listPage;
        }
        --this.nElems;
        ++this.modCount;
        this.modify();
        return iPersistent;
    }

    public void clear() {
        ++this.modCount;
        this.root.prune();
        this.root = new ListPage(this.getStorage());
        this.nElems = 0;
        this.modify();
    }

    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator();
        if (object == null) {
            while (listIterator.hasNext()) {
                if (listIterator.next() != null) continue;
                return listIterator.previousIndex();
            }
        } else {
            while (listIterator.hasNext()) {
                if (!object.equals(listIterator.next())) continue;
                return listIterator.previousIndex();
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        ListIterator listIterator = this.listIterator(this.size());
        if (object == null) {
            while (listIterator.hasPrevious()) {
                if (listIterator.previous() != null) continue;
                return listIterator.nextIndex();
            }
        } else {
            while (listIterator.hasPrevious()) {
                if (!object.equals(listIterator.previous())) continue;
                return listIterator.nextIndex();
            }
        }
        return -1;
    }

    public boolean addAll(int n2, Collection collection) {
        boolean bl2 = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(n2++, iterator.next());
            bl2 = true;
        }
        return bl2;
    }

    public Iterator iterator() {
        return new Itr();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n2) {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
        return new ListItr(n2);
    }

    public List subList(int n2, int n3) {
        return new SubList(this, n2, n3);
    }

    protected void removeRange(int n2, int n3) {
        while (n2 < n3) {
            this.remove(n2);
            --n3;
        }
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl2 |= this.add(iterator.next());
        }
        return bl2;
    }

    public boolean retainAll(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (collection.contains(e2)) continue;
            arrayList.add(e2);
        }
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.remove(arrayList.get(i2));
        }
        return n2 != 0;
    }

    public boolean removeAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl2 |= this.remove(iterator.next());
        }
        return bl2;
    }

    public boolean remove(Object object) {
        Iterator iterator = this.iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(clazz, this.iterator(), string);
    }

    PersistentListImpl() {
    }

    PersistentListImpl(Storage storage) {
        super(storage);
        this.root = new ListPage(storage);
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int n2) {
            this.cursor = n2;
        }

        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            this.checkForComodification();
            try {
                int n2 = this.cursor - 1;
                IPersistent iPersistent = PersistentListImpl.this.getPosition(this, n2);
                this.lastRet = this.cursor = n2;
                return iPersistent;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object object) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                PersistentListImpl.this.set(this.lastRet, object);
                this.expectedModCount = PersistentListImpl.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object object) {
            this.checkForComodification();
            try {
                PersistentListImpl.this.add(this.cursor++, object);
                this.lastRet = -1;
                this.page = null;
                this.expectedModCount = PersistentListImpl.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    extends TreePosition
    implements PersistentIterator,
    Iterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = PersistentListImpl.this.modCount;
        }

        public boolean hasNext() {
            return this.cursor != PersistentListImpl.this.size();
        }

        public int nextOid() {
            this.checkForComodification();
            try {
                int n2 = PersistentListImpl.this.getRawPosition(this, this.cursor).getOid();
                this.lastRet = this.cursor++;
                return n2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public Object next() {
            this.checkForComodification();
            try {
                IPersistent iPersistent = PersistentListImpl.this.getPosition(this, this.cursor);
                this.lastRet = this.cursor++;
                return iPersistent;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                PersistentListImpl.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.page = null;
                this.lastRet = -1;
                this.expectedModCount = PersistentListImpl.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (PersistentListImpl.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    static class ListIntermediatePage
    extends ListPage {
        int[] nChildren;

        IPersistent getPosition(TreePosition treePosition, int n2) {
            int n3 = 0;
            while (n2 >= this.nChildren[n3]) {
                n2 -= this.nChildren[n3];
                ++n3;
            }
            return ((ListPage)this.items.get(n3)).getPosition(treePosition, n2);
        }

        IPersistent getRawPosition(TreePosition treePosition, int n2) {
            int n3 = 0;
            while (n2 >= this.nChildren[n3]) {
                n2 -= this.nChildren[n3];
                ++n3;
            }
            return ((ListPage)this.items.get(n3)).getRawPosition(treePosition, n2);
        }

        Object get(int n2) {
            int n3 = 0;
            while (n2 >= this.nChildren[n3]) {
                n2 -= this.nChildren[n3];
                ++n3;
            }
            return ((ListPage)this.items.get(n3)).get(n2);
        }

        Object set(int n2, Object object) {
            int n3 = 0;
            while (n2 >= this.nChildren[n3]) {
                n2 -= this.nChildren[n3];
                ++n3;
            }
            return ((ListPage)this.items.get(n3)).set(n2, object);
        }

        ListPage add(int n2, IPersistent iPersistent) {
            int n3 = 0;
            while (n2 >= this.nChildren[n3]) {
                n2 -= this.nChildren[n3];
                ++n3;
            }
            ListPage listPage = (ListPage)this.items.get(n3);
            ListPage listPage2 = listPage.add(n2, iPersistent);
            if (listPage2 != null) {
                this.countChildren(n3, listPage);
                listPage2 = super.add(n3, listPage2);
            } else {
                this.modify();
                if (this.nChildren[n3] != Integer.MAX_VALUE) {
                    int n4 = n3;
                    this.nChildren[n4] = this.nChildren[n4] + 1;
                }
            }
            return listPage2;
        }

        IPersistent remove(int n2) {
            int n3 = 0;
            while (n2 >= this.nChildren[n3]) {
                n2 -= this.nChildren[n3];
                ++n3;
            }
            ListPage listPage = (ListPage)this.items.get(n3);
            IPersistent iPersistent = listPage.remove(n2);
            this.modify();
            if (listPage.underflow()) {
                this.handlePageUnderflow(listPage, n3);
            } else if (this.nChildren[n3] != Integer.MAX_VALUE) {
                int n4 = n3;
                this.nChildren[n4] = this.nChildren[n4] - 1;
            }
            return iPersistent;
        }

        void countChildren(int n2, ListPage listPage) {
            if (this.nChildren[n2] != Integer.MAX_VALUE) {
                this.nChildren[n2] = listPage.size();
            }
        }

        void prune() {
            for (int i2 = 0; i2 < this.nItems; ++i2) {
                ((ListPage)this.items.get(i2)).prune();
            }
            this.deallocate();
        }

        void handlePageUnderflow(ListPage listPage, int n2) {
            int n3 = listPage.nItems;
            int n4 = listPage.getMaxItems();
            if (n2 + 1 < this.nItems) {
                ListPage listPage2 = (ListPage)this.items.get(n2 + 1);
                int n5 = listPage2.nItems;
                Assert.that(n5 >= n3);
                if (n3 + n5 > n4) {
                    int n6 = n5 - (n3 + n5 >> 1);
                    listPage2.modify();
                    listPage.copy(n3, listPage2, 0, n6);
                    listPage2.copy(0, listPage2, n6, n5 - n6);
                    listPage2.clear(n5 - n6, n6);
                    listPage2.nItems -= n6;
                    listPage.nItems += n6;
                    this.nChildren[n2] = listPage.size();
                    this.countChildren(n2 + 1, listPage2);
                } else {
                    listPage.copy(n3, listPage2, 0, n5);
                    listPage.nItems += n5;
                    --this.nItems;
                    this.nChildren[n2] = this.nChildren[n2 + 1];
                    this.copy(n2 + 1, this, n2 + 2, this.nItems - n2 - 1);
                    this.countChildren(n2, listPage);
                    this.items.set(this.nItems, null);
                    listPage2.deallocate();
                }
            } else {
                ListPage listPage3 = (ListPage)this.items.get(n2 - 1);
                int n7 = listPage3.nItems;
                Assert.that(n7 >= n3);
                listPage3.modify();
                if (n3 + n7 > n4) {
                    int n8 = n7 - (n3 + n7 >> 1);
                    listPage.copy(n8, listPage, 0, n3);
                    listPage.copy(0, listPage3, n7 - n8, n8);
                    listPage3.clear(n7 - n8, n8);
                    listPage3.nItems -= n8;
                    listPage.nItems += n8;
                    this.nChildren[n2 - 1] = listPage3.size();
                    this.countChildren(n2, listPage);
                } else {
                    listPage3.copy(n7, listPage, 0, n3);
                    listPage3.nItems += n3;
                    --this.nItems;
                    this.nChildren[n2 - 1] = this.nChildren[n2];
                    this.countChildren(n2 - 1, listPage3);
                    this.items.set(n2, null);
                    listPage.deallocate();
                }
            }
        }

        void copy(int n2, ListPage listPage, int n3, int n4) {
            super.copy(n2, listPage, n3, n4);
            System.arraycopy(((ListIntermediatePage)listPage).nChildren, n3, this.nChildren, n2, n4);
        }

        int getMaxItems() {
            return 509;
        }

        void setItem(int n2, IPersistent iPersistent) {
            super.setItem(n2, iPersistent);
            this.nChildren[n2] = ((ListPage)iPersistent).size();
        }

        int size() {
            if (this.nChildren[this.nItems - 1] == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            int n2 = 0;
            for (int i2 = 0; i2 < this.nItems; ++i2) {
                n2 += this.nChildren[i2];
            }
            return n2;
        }

        ListPage clonePage() {
            return new ListIntermediatePage(this.getStorage());
        }

        ListIntermediatePage() {
        }

        ListIntermediatePage(Storage storage) {
            super(storage);
            this.nChildren = new int[509];
        }
    }

    static class ListPage
    extends Persistent {
        int nItems;
        Link items;

        Object get(int n2) {
            return this.items.get(n2);
        }

        IPersistent getPosition(TreePosition treePosition, int n2) {
            treePosition.page = this;
            treePosition.index -= n2;
            return this.items.get(n2);
        }

        IPersistent getRawPosition(TreePosition treePosition, int n2) {
            treePosition.page = this;
            treePosition.index -= n2;
            return this.items.getRaw(n2);
        }

        Object set(int n2, Object object) {
            IPersistent iPersistent = this.items.get(n2);
            this.items.set(n2, (IPersistent)object);
            return iPersistent;
        }

        void clear(int n2, int n3) {
            while (--n3 >= 0) {
                this.items.set(n2++, null);
            }
        }

        void prune() {
            this.deallocate();
        }

        void copy(int n2, ListPage listPage, int n3, int n4) {
            System.arraycopy(listPage.items.toRawArray(), n3, this.items.toRawArray(), n2, n4);
        }

        int getMaxItems() {
            return 1020;
        }

        void setItem(int n2, IPersistent iPersistent) {
            this.items.set(n2, iPersistent);
        }

        int size() {
            return this.nItems;
        }

        ListPage clonePage() {
            return new ListPage(this.getStorage());
        }

        ListPage() {
        }

        ListPage(Storage storage) {
            super(storage);
            int n2 = this.getMaxItems();
            this.items = storage.createLink(n2);
            this.items.setSize(n2);
        }

        IPersistent remove(int n2) {
            IPersistent iPersistent = this.items.get(n2);
            --this.nItems;
            this.copy(n2, this, n2 + 1, this.nItems - n2);
            this.items.set(this.nItems, null);
            this.modify();
            return iPersistent;
        }

        boolean underflow() {
            return this.nItems < this.getMaxItems() / 2;
        }

        ListPage add(int n2, IPersistent iPersistent) {
            int n3 = this.getMaxItems();
            this.modify();
            if (this.nItems < n3) {
                this.copy(n2 + 1, this, n2, this.nItems - n2);
                this.setItem(n2, iPersistent);
                ++this.nItems;
                return null;
            }
            ListPage listPage = this.clonePage();
            int n4 = n3 / 2;
            if (n2 < n4) {
                listPage.copy(0, this, 0, n2);
                listPage.copy(n2 + 1, this, n2, n4 - n2 - 1);
                this.copy(0, this, n4 - 1, n3 - n4 + 1);
                listPage.setItem(n2, iPersistent);
            } else {
                listPage.copy(0, this, 0, n4);
                this.copy(0, this, n4, n2 - n4);
                this.copy(n2 - n4 + 1, this, n2, n3 - n2);
                this.setItem(n2 - n4, iPersistent);
            }
            this.clear(n3 - n4 + 1, n4 - 1);
            this.nItems = n3 - n4 + 1;
            listPage.nItems = n4;
            return listPage;
        }
    }

    static class TreePosition {
        ListPage page;
        int index;

        TreePosition() {
        }
    }
}

