/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.Arrays;
import org.garret.perst.Assert;
import org.garret.perst.IFile;
import org.garret.perst.impl.LRU;
import org.garret.perst.impl.ObjectHeader;
import org.garret.perst.impl.Page;

class PagePool {
    LRU lru;
    Page freePages;
    Page[] hashTable;
    int poolSize;
    boolean autoExtended;
    IFile file;
    long lruLimit;
    int nDirtyPages;
    Page[] dirtyPages;
    boolean flushing;
    static final int INFINITE_POOL_INITIAL_SIZE = 8;

    PagePool(int n2, long l2) {
        if (n2 == 0) {
            this.autoExtended = true;
            n2 = 8;
        }
        this.poolSize = n2;
        this.lruLimit = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Page find(long l2, int n2) {
        Page page;
        int n3 = (int)(l2 >>> 12);
        int n4 = n3 % this.poolSize;
        PagePool pagePool = this;
        synchronized (pagePool) {
            page = this.hashTable[n4];
            while (page != null) {
                if (page.offs == l2) {
                    if (page.accessCount++ != 0) break;
                    page.unlink();
                    break;
                }
                page = page.collisionChain;
            }
            if (page == null) {
                Object object;
                int n5;
                page = this.freePages;
                if (page != null) {
                    this.freePages = (Page)page.next;
                } else if (this.autoExtended) {
                    if (n3 >= this.poolSize) {
                        n5 = n3 >= this.poolSize * 2 ? n3 + 1 : this.poolSize * 2;
                        object = new Page[n5];
                        System.arraycopy(this.hashTable, 0, object, 0, this.hashTable.length);
                        this.hashTable = object;
                        this.poolSize = n5;
                    }
                    page = new Page();
                    n4 = n3;
                } else {
                    Assert.that("unfixed page available", this.lru.prev != this.lru);
                    page = (Page)this.lru.prev;
                    page.unlink();
                    Page page2 = page;
                    synchronized (page2) {
                        if ((page.state & 1) != 0) {
                            page.state = 0;
                            this.file.write(page.offs, page.data);
                            if (!this.flushing) {
                                this.dirtyPages[page.writeQueueIndex] = this.dirtyPages[--this.nDirtyPages];
                                this.dirtyPages[page.writeQueueIndex].writeQueueIndex = page.writeQueueIndex;
                            }
                        }
                    }
                    n5 = (int)(page.offs >> 12) % this.poolSize;
                    object = this.hashTable[n5];
                    Object object2 = null;
                    while (object != page) {
                        object2 = object;
                        object = object.collisionChain;
                    }
                    if (object2 == null) {
                        this.hashTable[n5] = page.collisionChain;
                    } else {
                        object2.collisionChain = page.collisionChain;
                    }
                }
                page.accessCount = 1;
                page.offs = l2;
                page.state = 2;
                page.collisionChain = this.hashTable[n4];
                this.hashTable[n4] = page;
            }
            if ((page.state & 1) == 0 && (n2 & 1) != 0) {
                Assert.that(!this.flushing);
                if (this.nDirtyPages >= this.dirtyPages.length) {
                    Page[] pageArray = new Page[this.nDirtyPages * 2];
                    System.arraycopy(this.dirtyPages, 0, pageArray, 0, this.dirtyPages.length);
                    this.dirtyPages = pageArray;
                }
                this.dirtyPages[this.nDirtyPages] = page;
                page.writeQueueIndex = this.nDirtyPages++;
                page.state |= 1;
            }
            if ((page.state & 2) != 0) {
                if (this.file.read(page.offs, page.data) < 4096) {
                    for (int i2 = 0; i2 < 4096; ++i2) {
                        page.data[i2] = 0;
                    }
                }
                page.state &= 0xFFFFFFFD;
            }
        }
        return page;
    }

    final synchronized void copy(long l2, long l3, long l4) {
        long l5;
        int n2 = (int)l2 & 0xFFF;
        int n3 = (int)l3 & 0xFFF;
        Page page = this.find(l2 -= (long)n2, 1);
        Page page2 = this.find(l3 -= (long)n3, 0);
        do {
            if (n2 == 4096) {
                this.unfix(page);
                page = this.find(l2 += 4096L, 1);
                n2 = 0;
            }
            if (n3 == 4096) {
                this.unfix(page2);
                page2 = this.find(l3 += 4096L, 0);
                n3 = 0;
            }
            if ((l5 = l4) > (long)(4096 - n3)) {
                l5 = 4096 - n3;
            }
            if (l5 > (long)(4096 - n2)) {
                l5 = 4096 - n2;
            }
            System.arraycopy(page2.data, n3, page.data, n2, (int)l5);
            n3 = (int)((long)n3 + l5);
            n2 = (int)((long)n2 + l5);
        } while ((l4 -= l5) != 0L);
        this.unfix(page);
        this.unfix(page2);
    }

    final void write(long l2, byte[] byArray) {
        Assert.that((l2 & 0xFFFL) == 0L);
        Assert.that((byArray.length & 0xFFF) == 0);
        int n2 = 0;
        while (n2 < byArray.length) {
            Page page = this.find(l2, 1);
            byte[] byArray2 = page.data;
            for (int i2 = 0; i2 < 4096; ++i2) {
                byArray2[i2] = byArray[n2++];
            }
            this.unfix(page);
            l2 += 4096L;
        }
    }

    final void open(IFile iFile) {
        this.file = iFile;
        this.reset();
    }

    final void reset() {
        this.lru = new LRU();
        this.freePages = null;
        this.hashTable = new Page[this.poolSize];
        this.dirtyPages = new Page[this.poolSize];
        this.nDirtyPages = 0;
        if (!this.autoExtended) {
            int n2 = this.poolSize;
            while (--n2 >= 0) {
                Page page = new Page();
                page.next = this.freePages;
                this.freePages = page;
            }
        }
    }

    final void clear() {
        Assert.that(this.nDirtyPages == 0);
        this.reset();
    }

    final synchronized void close() {
        this.file.close();
        this.hashTable = null;
        this.dirtyPages = null;
        this.lru = null;
        this.freePages = null;
    }

    final synchronized void unfix(Page page) {
        Assert.that(page.accessCount > 0);
        if (--page.accessCount == 0) {
            if (page.offs <= this.lruLimit) {
                this.lru.link(page);
            } else {
                this.lru.prev.link(page);
            }
        }
    }

    final synchronized void modify(Page page) {
        Assert.that(page.accessCount > 0);
        if ((page.state & 1) == 0) {
            Assert.that(!this.flushing);
            page.state |= 1;
            if (this.nDirtyPages >= this.dirtyPages.length) {
                Page[] pageArray = new Page[this.nDirtyPages * 2];
                System.arraycopy(this.dirtyPages, 0, pageArray, 0, this.dirtyPages.length);
                this.dirtyPages = pageArray;
            }
            this.dirtyPages[this.nDirtyPages] = page;
            page.writeQueueIndex = this.nDirtyPages++;
        }
    }

    final Page getPage(long l2) {
        return this.find(l2, 0);
    }

    final Page putPage(long l2) {
        return this.find(l2, 1);
    }

    final byte[] get(long l2) {
        Assert.that(l2 != 0L);
        int n2 = (int)l2 & 0xFFF;
        Page page = this.find(l2 - (long)n2, 0);
        int n3 = ObjectHeader.getSize(page.data, n2);
        Assert.that(n3 >= 8);
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n3 > 4096 - n2) {
            System.arraycopy(page.data, n2, byArray, n4, 4096 - n2);
            this.unfix(page);
            n3 -= 4096 - n2;
            n4 += 4096 - n2;
            page = this.find(l2 += (long)(4096 - n2), 0);
            n2 = 0;
        }
        System.arraycopy(page.data, n2, byArray, n4, n3);
        this.unfix(page);
        return byArray;
    }

    final void put(long l2, byte[] byArray) {
        this.put(l2, byArray, byArray.length);
    }

    final void put(long l2, byte[] byArray, int n2) {
        int n3 = (int)l2 & 0xFFF;
        Page page = this.find(l2 - (long)n3, 1);
        int n4 = 0;
        while (n2 > 4096 - n3) {
            System.arraycopy(byArray, n4, page.data, n3, 4096 - n3);
            this.unfix(page);
            n2 -= 4096 - n3;
            n4 += 4096 - n3;
            page = this.find(l2 += (long)(4096 - n3), 1);
            n3 = 0;
        }
        System.arraycopy(byArray, n4, page.data, n3, n2);
        this.unfix(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        PagePool pagePool = this;
        synchronized (pagePool) {
            this.flushing = true;
            Arrays.sort(this.dirtyPages, 0, this.nDirtyPages);
        }
        for (int i2 = 0; i2 < this.nDirtyPages; ++i2) {
            Page page;
            Page page2 = page = this.dirtyPages[i2];
            synchronized (page2) {
                if ((page.state & 1) != 0) {
                    this.file.write(page.offs, page.data);
                    page.state &= 0xFFFFFFFE;
                }
                continue;
            }
        }
        this.file.sync();
        this.nDirtyPages = 0;
        this.flushing = false;
    }
}

