/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.garret.perst.IPersistent;
import org.garret.perst.Link;
import org.garret.perst.PersistentIterator;
import org.garret.perst.impl.PersistentStub;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.StorageImpl;

public class LinkImpl
implements Link {
    IPersistent[] arr;
    int used;
    transient IPersistent owner;

    private final void modify() {
        if (this.owner != null) {
            this.owner.modify();
        }
    }

    public int size() {
        return this.used;
    }

    public IPersistent get(int n2) {
        if (n2 < 0 || n2 >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        return this.loadElem(n2);
    }

    public IPersistent getRaw(int n2) {
        if (n2 < 0 || n2 >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        return this.arr[n2];
    }

    public void pin() {
        int n2 = this.used;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.arr[i2] = this.loadElem(i2);
        }
    }

    public void unpin() {
        int n2 = this.used;
        for (int i2 = 0; i2 < n2; ++i2) {
            IPersistent iPersistent = this.arr[i2];
            if (iPersistent == null || iPersistent.isRaw() || !iPersistent.isPersistent()) continue;
            this.arr[i2] = new PersistentStub(iPersistent.getStorage(), iPersistent.getOid());
        }
    }

    public void set(int n2, IPersistent iPersistent) {
        if (n2 < 0 || n2 >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        this.arr[n2] = iPersistent;
        this.modify();
    }

    public void remove(int n2) {
        if (n2 < 0 || n2 >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        --this.used;
        System.arraycopy(this.arr, n2 + 1, this.arr, n2, this.used - n2);
        this.arr[this.used] = null;
        this.modify();
    }

    public void setSize(int n2) {
        if (n2 < this.used) {
            int n3 = this.used;
            while (--n3 >= n2) {
                this.arr[n3] = null;
            }
        } else {
            this.reserveSpace(n2 - this.used);
        }
        this.used = n2;
        this.modify();
    }

    void reserveSpace(int n2) {
        if (this.used + n2 > this.arr.length) {
            IPersistent[] iPersistentArray = new IPersistent[this.used + n2 > this.arr.length * 2 ? this.used + n2 : this.arr.length * 2];
            System.arraycopy(this.arr, 0, iPersistentArray, 0, this.used);
            this.arr = iPersistentArray;
        }
        this.modify();
    }

    public void insert(int n2, IPersistent iPersistent) {
        if (n2 < 0 || n2 > this.used) {
            throw new IndexOutOfBoundsException();
        }
        this.reserveSpace(1);
        System.arraycopy(this.arr, n2, this.arr, n2 + 1, this.used - n2);
        this.arr[n2] = iPersistent;
        ++this.used;
    }

    public void add(IPersistent iPersistent) {
        this.reserveSpace(1);
        this.arr[this.used++] = iPersistent;
    }

    public void addAll(IPersistent[] iPersistentArray) {
        this.addAll(iPersistentArray, 0, iPersistentArray.length);
    }

    public void addAll(IPersistent[] iPersistentArray, int n2, int n3) {
        this.reserveSpace(n3);
        System.arraycopy(iPersistentArray, n2, this.arr, this.used, n3);
        this.used += n3;
    }

    public void addAll(Link link) {
        int n2 = link.size();
        this.reserveSpace(n2);
        int n3 = 0;
        int n4 = this.used;
        while (n3 < n2) {
            this.arr[n4] = link.getRaw(n3);
            ++n3;
            ++n4;
        }
        this.used += n2;
    }

    public IPersistent[] toArray() {
        IPersistent[] iPersistentArray = new IPersistent[this.used];
        int n2 = this.used;
        while (--n2 >= 0) {
            iPersistentArray[n2] = this.loadElem(n2);
        }
        return iPersistentArray;
    }

    public IPersistent[] toRawArray() {
        return this.arr;
    }

    public IPersistent[] toArray(IPersistent[] iPersistentArray) {
        if (iPersistentArray.length < this.used) {
            iPersistentArray = (IPersistent[])Array.newInstance(iPersistentArray.getClass().getComponentType(), this.used);
        }
        int n2 = this.used;
        while (--n2 >= 0) {
            iPersistentArray[n2] = this.loadElem(n2);
        }
        if (iPersistentArray.length > this.used) {
            iPersistentArray[this.used] = null;
        }
        return iPersistentArray;
    }

    public boolean contains(IPersistent iPersistent) {
        int n2 = this.used;
        while (--n2 >= 0) {
            if (!this.loadElem(n2).equals(iPersistent)) continue;
            return true;
        }
        return false;
    }

    public boolean containsObject(IPersistent iPersistent) {
        return this.indexOf(iPersistent) >= 0;
    }

    public int indexOf(IPersistent iPersistent) {
        int n2;
        if (iPersistent != null && (n2 = iPersistent.getOid()) != 0) {
            int n3 = this.used;
            while (--n3 >= 0) {
                IPersistent iPersistent2 = this.arr[n3];
                if (iPersistent2 == null || iPersistent2.getOid() != n2) continue;
                return n3;
            }
        } else {
            int n4 = this.used;
            while (--n4 >= 0) {
                if (this.arr[n4] != iPersistent) continue;
                return n4;
            }
        }
        return -1;
    }

    public boolean containsElement(int n2, IPersistent iPersistent) {
        IPersistent iPersistent2 = this.arr[n2];
        return iPersistent2 == iPersistent || iPersistent2 != null && iPersistent2.getOid() != 0 && iPersistent2.getOid() == iPersistent.getOid();
    }

    public void clear() {
        int n2 = this.used;
        while (--n2 >= 0) {
            this.arr[n2] = null;
        }
        this.used = 0;
        this.modify();
    }

    public Iterator iterator() {
        return new LinkIterator(this);
    }

    private final IPersistent loadElem(int n2) {
        IPersistent iPersistent = this.arr[n2];
        if (iPersistent != null && iPersistent.isRaw()) {
            iPersistent = ((StorageImpl)iPersistent.getStorage()).lookupObject(iPersistent.getOid(), null);
        }
        return iPersistent;
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(null);
        return queryImpl.select(clazz, this.iterator(), string);
    }

    LinkImpl() {
    }

    LinkImpl(int n2) {
        this.arr = new IPersistent[n2];
    }

    LinkImpl(IPersistent[] iPersistentArray, IPersistent iPersistent) {
        this.arr = iPersistentArray;
        this.owner = iPersistent;
        this.used = iPersistentArray.length;
    }

    static class LinkIterator
    implements PersistentIterator {
        private Link link;
        private int i;

        LinkIterator(Link link) {
            this.link = link;
        }

        public boolean hasNext() {
            return this.i < this.link.size();
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.link.get(this.i++);
        }

        public int nextOid() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.link.getRaw(this.i++).getOid();
        }

        public void remove() {
            this.link.remove(this.i);
        }
    }
}

