/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import org.garret.perst.Blob;
import org.garret.perst.PersistentResource;
import org.garret.perst.RandomAccessInputStream;
import org.garret.perst.RandomAccessOutputStream;
import org.garret.perst.Storage;

public class BlobImpl
extends PersistentResource
implements Blob {
    int size;
    BlobImpl next;
    byte[] body;
    transient int used;
    static final int headerSize = 20;

    void discard(int n2) {
        if (--this.used == 0 && (n2 & 1) == 0) {
            this.invalidate();
            this.next = null;
        }
    }

    public boolean recursiveLoading() {
        return false;
    }

    public RandomAccessInputStream getInputStream() {
        return this.getInputStream(0);
    }

    public RandomAccessInputStream getInputStream(int n2) {
        return new BlobInputStream(this, n2);
    }

    public RandomAccessOutputStream getOutputStream() {
        return this.getOutputStream(8);
    }

    public RandomAccessOutputStream getOutputStream(boolean bl2) {
        return this.getOutputStream(bl2 ? 8 : 12);
    }

    public RandomAccessOutputStream getOutputStream(long l2, boolean bl2) {
        RandomAccessOutputStream randomAccessOutputStream = this.getOutputStream(bl2);
        randomAccessOutputStream.setPosition(l2);
        return randomAccessOutputStream;
    }

    public RandomAccessOutputStream getOutputStream(int n2) {
        return new BlobOutputStream(this, n2);
    }

    public void deallocate() {
        this.load();
        if (this.size > 0) {
            BlobImpl blobImpl = this.next;
            while (blobImpl != null) {
                blobImpl.load();
                BlobImpl blobImpl2 = blobImpl.next;
                blobImpl.deallocate();
                blobImpl = blobImpl2;
            }
        }
        super.deallocate();
    }

    BlobImpl(Storage storage, int n2) {
        super(storage);
        this.body = new byte[n2];
    }

    BlobImpl() {
    }

    static class BlobOutputStream
    extends RandomAccessOutputStream {
        protected BlobImpl first;
        protected BlobImpl curr;
        protected int pos;
        protected int blobOffs;
        protected int flags;
        protected boolean modified;

        public void write(int n2) {
            byte[] byArray = new byte[]{(byte)n2};
            this.write(byArray, 0, 1);
        }

        public void write(byte[] byArray, int n2, int n3) {
            while (n3 > 0) {
                if (this.blobOffs == this.curr.body.length) {
                    BlobImpl blobImpl = this.curr;
                    if (blobImpl.next == null) {
                        BlobImpl blobImpl2;
                        int n4 = this.curr.body.length;
                        if ((this.flags & 2) != 0 && n4 << 1 > n4) {
                            n4 = (n4 + 20 << 1) - 20;
                        }
                        this.curr = blobImpl.next = (blobImpl2 = new BlobImpl(this.curr.getStorage(), n4));
                        this.modified = true;
                    } else {
                        this.curr = blobImpl.next;
                        this.curr.load();
                    }
                    ++this.curr.used;
                    if (blobImpl != this.first) {
                        if (this.modified) {
                            blobImpl.store();
                        }
                        blobImpl.discard(this.flags);
                    }
                    this.blobOffs = 0;
                }
                int n5 = n3 > this.curr.body.length - this.blobOffs ? this.curr.body.length - this.blobOffs : n3;
                System.arraycopy(byArray, n2, this.curr.body, this.blobOffs, n5);
                this.modified = true;
                this.blobOffs += n5;
                n2 += n5;
                n3 -= n5;
                this.pos += n5;
            }
            if (this.pos > this.first.size) {
                this.first.size = this.pos;
            }
        }

        public void close() {
            if ((this.flags & 4) != 0 && this.blobOffs < this.curr.body.length && this.curr.next == null) {
                byte[] byArray = new byte[this.blobOffs];
                System.arraycopy(this.curr.body, 0, byArray, 0, this.blobOffs);
                this.curr.body = byArray;
            }
            this.curr.store();
            this.curr.discard(this.flags);
            if (this.curr != this.first) {
                this.first.store();
                this.first.discard(this.flags);
            }
            this.curr = null;
            this.first = null;
        }

        public long setPosition(long l2) {
            if (l2 < (long)this.pos) {
                if (l2 >= (long)(this.pos - this.blobOffs)) {
                    this.blobOffs = (int)((long)this.blobOffs - ((long)this.pos - l2));
                    this.pos = (int)l2;
                    return this.pos;
                }
                if (this.first != this.curr) {
                    if (this.modified) {
                        this.curr.store();
                        this.modified = false;
                    }
                    this.curr.discard(this.flags);
                    this.curr = this.first;
                }
                this.pos = 0;
                this.blobOffs = 0;
            }
            this.skip(l2 - (long)this.pos);
            return this.pos;
        }

        public long getPosition() {
            return this.pos;
        }

        public long size() {
            return this.first.size;
        }

        public long skip(long l2) {
            int n2 = this.first.size - this.pos;
            if (l2 > (long)n2) {
                l2 = n2;
            }
            int n3 = (int)l2;
            while (n3 > 0) {
                if (this.blobOffs == this.curr.body.length) {
                    BlobImpl blobImpl = this.curr;
                    this.curr = blobImpl.next;
                    this.curr.load();
                    ++this.curr.used;
                    if (blobImpl != this.first) {
                        if (this.modified) {
                            blobImpl.store();
                            this.modified = false;
                        }
                        blobImpl.discard(this.flags);
                    }
                    this.blobOffs = 0;
                }
                int n4 = n3 > this.curr.body.length - this.blobOffs ? this.curr.body.length - this.blobOffs : n3;
                this.pos += n4;
                n3 -= n4;
                this.blobOffs += n4;
            }
            return l2;
        }

        BlobOutputStream(BlobImpl blobImpl, int n2) {
            this.flags = n2;
            this.first = blobImpl;
            blobImpl.load();
            ++blobImpl.used;
            this.curr = blobImpl;
        }
    }

    static class BlobInputStream
    extends RandomAccessInputStream {
        protected BlobImpl curr;
        protected BlobImpl first;
        protected int pos;
        protected int blobOffs;
        protected int flags;

        public int read() {
            byte[] byArray = new byte[1];
            return this.read(byArray, 0, 1) == 1 ? byArray[0] & 0xFF : -1;
        }

        public int read(byte[] byArray, int n2, int n3) {
            if (this.pos >= this.first.size) {
                return -1;
            }
            int n4 = this.first.size - this.pos;
            if (n3 > n4) {
                n3 = n4;
            }
            int n5 = n3;
            while (n3 > 0) {
                if (this.blobOffs == this.curr.body.length) {
                    BlobImpl blobImpl = this.curr;
                    this.curr = blobImpl.next;
                    this.curr.load();
                    ++this.curr.used;
                    if (blobImpl != this.first) {
                        blobImpl.discard(this.flags);
                    }
                    this.blobOffs = 0;
                }
                int n6 = n3 > this.curr.body.length - this.blobOffs ? this.curr.body.length - this.blobOffs : n3;
                System.arraycopy(this.curr.body, this.blobOffs, byArray, n2, n6);
                this.blobOffs += n6;
                n2 += n6;
                n3 -= n6;
                this.pos += n6;
            }
            return n5;
        }

        public long setPosition(long l2) {
            if (l2 < (long)this.pos) {
                if (l2 >= (long)(this.pos - this.blobOffs)) {
                    this.blobOffs = (int)((long)this.blobOffs - ((long)this.pos - l2));
                    this.pos = (int)l2;
                    return this.pos;
                }
                if (this.first != this.curr) {
                    this.curr.discard(this.flags);
                    this.curr = this.first;
                }
                this.pos = 0;
                this.blobOffs = 0;
            }
            this.skip(l2 - (long)this.pos);
            return this.pos;
        }

        public long getPosition() {
            return this.pos;
        }

        public long size() {
            return this.first.size;
        }

        public long skip(long l2) {
            int n2 = this.first.size - this.pos;
            if (l2 > (long)n2) {
                l2 = n2;
            }
            int n3 = (int)l2;
            while (n3 > 0) {
                if (this.blobOffs == this.curr.body.length) {
                    BlobImpl blobImpl = this.curr;
                    this.curr = blobImpl.next;
                    this.curr.load();
                    ++this.curr.used;
                    if (blobImpl != this.first) {
                        blobImpl.discard(this.flags);
                    }
                    this.blobOffs = 0;
                }
                int n4 = n3 > this.curr.body.length - this.blobOffs ? this.curr.body.length - this.blobOffs : n3;
                this.pos += n4;
                n3 -= n4;
                this.blobOffs += n4;
            }
            return l2;
        }

        public int available() {
            return this.first.size - this.pos;
        }

        public void close() {
            this.curr.discard(this.flags);
            if (this.first != this.curr) {
                this.first.discard(this.flags);
            }
            this.first = null;
            this.curr = null;
        }

        protected BlobInputStream(BlobImpl blobImpl, int n2) {
            this.flags = n2;
            this.first = blobImpl;
            blobImpl.load();
            this.curr = blobImpl;
            ++blobImpl.used;
        }
    }
}

