/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.util.Date;
import org.garret.perst.Assert;
import org.garret.perst.AssertionFailed;
import org.garret.perst.Link;
import org.garret.perst.PersistentResource;
import org.garret.perst.Storage;
import org.garret.perst.VersionHistory;

public class Version
extends PersistentResource
implements Cloneable {
    private Link successors;
    private Link predecessors;
    private String[] labels;
    private Date date;
    private String id;
    VersionHistory history;

    public synchronized VersionHistory getVersionHistory() {
        return this.history;
    }

    public synchronized Version[] getPredecessors() {
        return (Version[])this.predecessors.toArray(new Version[this.predecessors.size()]);
    }

    public synchronized Version[] getSuccessors() {
        return (Version[])this.successors.toArray(new Version[this.successors.size()]);
    }

    public boolean isCheckedIn() {
        return this.id != null;
    }

    public boolean isCheckedOut() {
        return this.id == null;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Version newVersion() {
        try {
            Version version = (Version)this.clone();
            version.predecessors = this.getStorage().createLink(1);
            version.predecessors.add(this);
            version.successors = this.getStorage().createLink(1);
            version.labels = new String[0];
            version.id = null;
            version.oid = 0;
            version.state = 0;
            return version;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionFailed("Clone not supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkin() {
        VersionHistory versionHistory = this.history;
        synchronized (versionHistory) {
            Assert.that(this.isCheckedOut());
            for (int i2 = 0; i2 < this.predecessors.size(); ++i2) {
                Version version;
                Version version2 = version = (Version)this.predecessors.get(i2);
                synchronized (version2) {
                    if (i2 == 0) {
                        this.id = version.constructId();
                    }
                    version.successors.add(this);
                    continue;
                }
            }
            this.date = new Date();
            this.history.versions.add(this);
            this.history.current = this;
            this.modify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPredecessor(Version version) {
        Version version2 = version;
        synchronized (version2) {
            Version version3 = this;
            synchronized (version3) {
                this.predecessors.add(version);
                if (this.isCheckedIn()) {
                    version.successors.add(this);
                }
            }
        }
    }

    public Date getDate() {
        return this.date;
    }

    public synchronized String[] getLabels() {
        return this.labels;
    }

    public synchronized void addLabel(String string) {
        String[] stringArray = new String[this.labels.length + 1];
        System.arraycopy(this.labels, 0, stringArray, 0, this.labels.length);
        stringArray[stringArray.length - 1] = string;
        this.labels = stringArray;
        this.modify();
    }

    public synchronized boolean hasLabel(String string) {
        for (int i2 = 0; i2 < this.labels.length; ++i2) {
            if (!this.labels[i2].equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    protected Version(Storage storage) {
        super(storage);
        this.successors = storage.createLink(1);
        this.predecessors = storage.createLink(1);
        this.labels = new String[0];
        this.date = new Date();
        this.id = "1";
    }

    private Version() {
    }

    private String constructId() {
        String string;
        int n2 = this.id.lastIndexOf(46);
        int n3 = Integer.parseInt(this.id.substring(n2 + 1));
        String string2 = string = n2 < 0 ? Integer.toString(n3 + 1) : this.id.substring(0, n2) + Integer.toString(n3 + 1);
        if (this.successors.size() != 0) {
            string = string + (46 + this.successors.size()) + ".1";
        }
        return string;
    }
}

