/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester;

import java.util.HashMap;
import java.util.logging.Level;
import org.apache.commons.gs.beanutils.BeanUtils;
import org.apache.commons.gs.beanutils.PropertyUtils;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.Rule;
import org.xml.sax.Attributes;

public class SetPropertiesRule
extends Rule {
    private String[] attributeNames;
    private String[] propertyNames;
    private boolean ignoreMissingProperty = true;

    public SetPropertiesRule(Digester digester) {
        this();
    }

    public SetPropertiesRule() {
    }

    public SetPropertiesRule(String string, String string2) {
        this.attributeNames = new String[1];
        this.attributeNames[0] = string;
        this.propertyNames = new String[1];
        this.propertyNames[0] = string2;
    }

    public SetPropertiesRule(String[] stringArray, String[] stringArray2) {
        int n2;
        this.attributeNames = new String[stringArray.length];
        int n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.attributeNames[n2] = stringArray[n2];
        }
        this.propertyNames = new String[stringArray2.length];
        n3 = stringArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.propertyNames[n2] = stringArray2[n2];
        }
    }

    public void begin(Attributes attributes) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        if (this.attributeNames != null) {
            n2 = this.attributeNames.length;
        }
        int n3 = 0;
        if (this.propertyNames != null) {
            n3 = this.propertyNames.length;
        }
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            Object object;
            boolean bl2;
            String string = attributes.getLocalName(i2);
            if ("".equals(string)) {
                string = attributes.getQName(i2);
            }
            String string2 = attributes.getValue(i2);
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!string.equals(this.attributeNames[i3])) continue;
                if (i3 < n3) {
                    string = this.propertyNames[i3];
                    break;
                }
                string = null;
                break;
            }
            if (this.digester.log.isLoggable(Level.FINE)) {
                this.digester.log.fine("[SetPropertiesRule]{" + this.digester.match + "} Setting property '" + string + "' to '" + string2 + "'");
            }
            if (!this.ignoreMissingProperty && string != null && !(bl2 = PropertyUtils.isWriteable(object = this.digester.peek(), string))) {
                throw new NoSuchMethodException("Property " + string + " can't be set");
            }
            if (string == null) continue;
            hashMap.put(string, string2);
        }
        Object object = this.digester.peek();
        if (this.digester.log.isLoggable(Level.FINE)) {
            if (object != null) {
                this.digester.log.fine("[SetPropertiesRule]{" + this.digester.match + "} Set " + object.getClass().getName() + " properties");
            } else {
                this.digester.log.fine("[SetPropertiesRule]{" + this.digester.match + "} Set NULL properties");
            }
        }
        BeanUtils.populate(object, hashMap);
    }

    public void addAlias(String string, String string2) {
        if (this.attributeNames == null) {
            this.attributeNames = new String[1];
            this.attributeNames[0] = string;
            this.propertyNames = new String[1];
            this.propertyNames[0] = string2;
        } else {
            int n2 = this.attributeNames.length;
            String[] stringArray = new String[n2 + 1];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = this.attributeNames[i2];
            }
            stringArray[n2] = string;
            String[] stringArray2 = new String[n2 + 1];
            for (int i3 = 0; i3 < n2 && i3 < this.propertyNames.length; ++i3) {
                stringArray2[i3] = this.propertyNames[i3];
            }
            stringArray2[n2] = string2;
            this.propertyNames = stringArray2;
            this.attributeNames = stringArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SetPropertiesRule[");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean isIgnoreMissingProperty() {
        return this.ignoreMissingProperty;
    }

    public void setIgnoreMissingProperty(boolean bl2) {
        this.ignoreMissingProperty = bl2;
    }
}

