/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.gs.digester.Rule;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NodeCreateRule
extends Rule {
    private DocumentBuilder documentBuilder = null;
    private int nodeType = 1;

    public NodeCreateRule() throws ParserConfigurationException {
        this(1);
    }

    public NodeCreateRule(DocumentBuilder documentBuilder) {
        this(1, documentBuilder);
    }

    public NodeCreateRule(int n2) throws ParserConfigurationException {
        this(n2, DocumentBuilderFactory.newInstance().newDocumentBuilder());
    }

    public NodeCreateRule(int n2, DocumentBuilder documentBuilder) {
        if (n2 != 11 && n2 != 1) {
            throw new IllegalArgumentException("Can only create nodes of type DocumentFragment and Element");
        }
        this.nodeType = n2;
        this.documentBuilder = documentBuilder;
    }

    public void begin(String string, String string2, Attributes attributes) throws Exception {
        Document document = this.documentBuilder.newDocument();
        NodeBuilder nodeBuilder = null;
        if (this.nodeType == 1) {
            Element element = null;
            if (this.getDigester().getNamespaceAware()) {
                element = document.createElementNS(string, string2);
                for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                    element.setAttributeNS(attributes.getURI(i2), attributes.getLocalName(i2), attributes.getValue(i2));
                }
            } else {
                element = document.createElement(string2);
                for (int i3 = 0; i3 < attributes.getLength(); ++i3) {
                    element.setAttribute(attributes.getQName(i3), attributes.getValue(i3));
                }
            }
            nodeBuilder = new NodeBuilder(document, element);
        } else {
            nodeBuilder = new NodeBuilder(document, document.createDocumentFragment());
        }
        this.getDigester().setCustomContentHandler(nodeBuilder);
    }

    public void end() throws Exception {
        Object object = this.digester.pop();
    }

    private class NodeBuilder
    extends DefaultHandler {
        public ContentHandler oldContentHandler = null;
        public int depth = 0;
        public Document doc = null;
        public Node root = null;
        public Node top = null;

        public NodeBuilder(Document document, Node node) throws ParserConfigurationException, SAXException {
            this.doc = document;
            this.root = node;
            this.top = node;
            this.oldContentHandler = NodeCreateRule.this.digester.getCustomContentHandler();
        }

        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            try {
                String string = new String(cArray, n2, n3);
                if (string.trim().length() > 0) {
                    this.top.appendChild(this.doc.createTextNode(string));
                }
            }
            catch (DOMException dOMException) {
                throw new SAXException(dOMException.getMessage());
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            try {
                if (this.depth == 0) {
                    NodeCreateRule.this.getDigester().setCustomContentHandler(this.oldContentHandler);
                    NodeCreateRule.this.getDigester().push(this.root);
                    NodeCreateRule.this.getDigester().endElement(string, string2, string3);
                }
                this.top = this.top.getParentNode();
                --this.depth;
            }
            catch (DOMException dOMException) {
                throw new SAXException(dOMException.getMessage());
            }
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            try {
                this.top.appendChild(this.doc.createProcessingInstruction(string, string2));
            }
            catch (DOMException dOMException) {
                throw new SAXException(dOMException.getMessage());
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                Node node = this.top;
                this.top = string2 == null || string2.length() == 0 ? this.doc.createElement(string3) : this.doc.createElementNS(string, string2);
                for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                    Attr attr = null;
                    if (attributes.getLocalName(i2) == null || attributes.getLocalName(i2).length() == 0) {
                        attr = this.doc.createAttribute(attributes.getQName(i2));
                        attr.setNodeValue(attributes.getValue(i2));
                        ((Element)this.top).setAttributeNode(attr);
                        continue;
                    }
                    attr = this.doc.createAttributeNS(attributes.getURI(i2), attributes.getLocalName(i2));
                    attr.setNodeValue(attributes.getValue(i2));
                    ((Element)this.top).setAttributeNodeNS(attr);
                }
                node.appendChild(this.top);
                ++this.depth;
            }
            catch (DOMException dOMException) {
                throw new SAXException(dOMException.getMessage());
            }
        }
    }
}

