/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils.converters;

import org.apache.commons.gs.beanutils.ConversionException;
import org.apache.commons.gs.beanutils.Converter;

public final class BooleanConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public BooleanConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public BooleanConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (object instanceof Boolean) {
            return object;
        }
        try {
            String string = object.toString();
            if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("1")) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("0")) {
                return Boolean.FALSE;
            }
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(string);
        }
        catch (ClassCastException classCastException) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(classCastException);
        }
    }
}

