/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.gs.beanutils.ConversionException;
import org.apache.commons.gs.beanutils.DynaBean;
import org.apache.commons.gs.beanutils.DynaClass;
import org.apache.commons.gs.beanutils.DynaProperty;
import org.apache.commons.gs.beanutils.LazyDynaClass;
import org.apache.commons.gs.beanutils.MutableDynaClass;

public class LazyDynaBean
implements DynaBean,
Serializable {
    private static Logger logger;
    public static final BigInteger BigInteger_ZERO;
    public static final BigDecimal BigDecimal_ZERO;
    public static final Character Character_SPACE;
    public static final Byte Byte_ZERO;
    public static final Short Short_ZERO;
    public static final Integer Integer_ZERO;
    public static final Long Long_ZERO;
    public static final Float Float_ZERO;
    public static final Double Double_ZERO;
    public Map values = this.newMap();
    public MutableDynaClass dynaClass;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$commons$gs$beanutils$LazyDynaBean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$org$apache$commons$gs$beanutils$DynaBean;
    static /* synthetic */ Class class$java$util$Date;

    public LazyDynaBean() {
        this(new LazyDynaClass());
    }

    public LazyDynaBean(String string) {
        this(new LazyDynaClass(string));
    }

    public LazyDynaBean(DynaClass dynaClass) {
        this.dynaClass = dynaClass instanceof MutableDynaClass ? (MutableDynaClass)dynaClass : new LazyDynaClass(dynaClass.getName(), dynaClass.getDynaProperties());
    }

    public Map getMap() {
        return this.values;
    }

    public int size(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object v2 = this.values.get(string);
        if (v2 == null) {
            return 0;
        }
        if (v2 instanceof Map) {
            return ((Map)v2).size();
        }
        if (v2 instanceof List) {
            return ((List)v2).size();
        }
        if (v2.getClass().isArray()) {
            return Array.getLength(v2);
        }
        return 0;
    }

    public boolean contains(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object v2 = this.values.get(string);
        if (v2 == null) {
            return false;
        }
        if (v2 instanceof Map) {
            return ((Map)v2).containsKey(string2);
        }
        return false;
    }

    public Object get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object object = this.values.get(string);
        if (object != null) {
            return object;
        }
        if (!this.isDynaProperty(string)) {
            return null;
        }
        object = this.createProperty(string, this.dynaClass.getDynaProperty(string).getType());
        if (object != null) {
            this.set(string, object);
        }
        return object;
    }

    public Object get(String string, int n2) {
        if (!this.isDynaProperty(string)) {
            this.set(string, this.defaultIndexedProperty(string));
        }
        Object object = this.get(string);
        if (!this.dynaClass.getDynaProperty(string).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n2 + "]' " + this.dynaClass.getDynaProperty(string).getName());
        }
        if ((object = this.growIndexedProperty(string, object, n2)).getClass().isArray()) {
            return Array.get(object, n2);
        }
        if (object instanceof List) {
            return ((List)object).get(n2);
        }
        throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n2 + "]' " + object.getClass().getName());
    }

    public Object get(String string, String string2) {
        if (!this.isDynaProperty(string)) {
            this.set(string, this.defaultMappedProperty(string));
        }
        Object object = this.get(string);
        if (!this.dynaClass.getDynaProperty(string).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")' " + this.dynaClass.getDynaProperty(string).getType().getName());
        }
        if (object instanceof Map) {
            return ((Map)object).get(string2);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'" + object.getClass().getName());
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public void remove(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object v2 = this.values.get(string);
        if (v2 == null) {
            return;
        }
        if (!(v2 instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'" + v2.getClass().getName());
        }
        ((Map)v2).remove(string2);
    }

    public void set(String string, Object object) {
        if (!this.isDynaProperty(string)) {
            if (this.dynaClass.isRestricted()) {
                throw new IllegalArgumentException("Invalid property name '" + string + "' (DynaClass is restricted)");
            }
            if (object == null) {
                this.dynaClass.add(string);
            } else {
                this.dynaClass.add(string, object.getClass());
            }
        }
        DynaProperty dynaProperty = this.dynaClass.getDynaProperty(string);
        if (object == null) {
            if (dynaProperty.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + string + "'");
            }
        } else if (!this.isAssignable(dynaProperty.getType(), object.getClass())) {
            throw new ConversionException("Cannot assign value of type '" + object.getClass().getName() + "' to property '" + string + "' of type '" + dynaProperty.getType().getName() + "'");
        }
        this.values.put(string, object);
    }

    public void set(String string, int n2, Object object) {
        if (!this.isDynaProperty(string)) {
            this.set(string, this.defaultIndexedProperty(string));
        }
        Object object2 = this.get(string);
        if (!this.dynaClass.getDynaProperty(string).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n2 + "]'" + this.dynaClass.getDynaProperty(string).getType().getName());
        }
        if ((object2 = this.growIndexedProperty(string, object2, n2)).getClass().isArray()) {
            Array.set(object2, n2, object);
        } else if (object2 instanceof List) {
            ((List)object2).set(n2, object);
        } else {
            throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n2 + "]' " + object2.getClass().getName());
        }
    }

    public void set(String string, String string2, Object object) {
        if (!this.isDynaProperty(string)) {
            this.set(string, this.defaultMappedProperty(string));
        }
        Object object2 = this.get(string);
        if (!this.dynaClass.getDynaProperty(string).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'" + this.dynaClass.getDynaProperty(string).getType().getName());
        }
        ((Map)object2).put(string2, object);
    }

    public Object growIndexedProperty(String string, Object object, int n2) {
        int n3;
        if (object instanceof List) {
            List list = (List)object;
            while (n2 >= list.size()) {
                list.add(null);
            }
        }
        if (object.getClass().isArray() && n2 >= (n3 = Array.getLength(object))) {
            Class<?> clazz = object.getClass().getComponentType();
            Object object2 = Array.newInstance(clazz, n2 + 1);
            System.arraycopy(object, 0, object2, 0, n3);
            object = object2;
            this.set(string, object);
            int n4 = Array.getLength(object);
            for (int i2 = n3; i2 < n4; ++i2) {
                Array.set(object, i2, this.createProperty(string + "[" + i2 + "]", clazz));
            }
        }
        return object;
    }

    public Object createProperty(String string, Class clazz) {
        block12: {
            block11: {
                if (clazz.isArray()) break block11;
                Class<?> clazz2 = class$java$util$List;
                if (clazz2 == null) {
                    clazz2 = class$java$util$List = new List[0].getClass().getComponentType();
                }
                if (!clazz2.isAssignableFrom(clazz)) break block12;
            }
            return this.createIndexedProperty(string, clazz);
        }
        Class<?> clazz3 = class$java$util$Map;
        if (clazz3 == null) {
            clazz3 = class$java$util$Map = new Map[0].getClass().getComponentType();
        }
        if (clazz3.isAssignableFrom(clazz)) {
            return this.createMappedProperty(string, clazz);
        }
        Class<?> clazz4 = class$org$apache$commons$gs$beanutils$DynaBean;
        if (clazz4 == null) {
            clazz4 = class$org$apache$commons$gs$beanutils$DynaBean = new DynaBean[0].getClass().getComponentType();
        }
        if (clazz4.isAssignableFrom(clazz)) {
            return this.createDynaBeanProperty(string, clazz);
        }
        if (clazz.isPrimitive()) {
            return this.createPrimitiveProperty(string, clazz);
        }
        Class<?> clazz5 = class$java$lang$Number;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Number = new Number[0].getClass().getComponentType();
        }
        if (clazz5.isAssignableFrom(clazz)) {
            return this.createNumberProperty(string, clazz);
        }
        return this.createOtherProperty(string, clazz);
    }

    public Object createIndexedProperty(String string, Class clazz) {
        Object object = null;
        if (clazz == null) {
            object = this.defaultIndexedProperty(string);
        } else if (clazz.isArray()) {
            object = Array.newInstance(clazz.getComponentType(), 0);
        } else {
            Class<?> clazz2 = class$java$util$List;
            if (clazz2 == null) {
                clazz2 = class$java$util$List = new List[0].getClass().getComponentType();
            }
            if (clazz2.isAssignableFrom(clazz)) {
                if (clazz.isInterface()) {
                    object = this.defaultIndexedProperty(string);
                } else {
                    try {
                        object = clazz.newInstance();
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Error instantiating indexed property of type '" + clazz.getName() + "' for '" + string + "' " + exception);
                    }
                }
            } else {
                throw new IllegalArgumentException("Non-indexed property of type '" + clazz.getName() + "' for '" + string + "'");
            }
        }
        return object;
    }

    public Object createMappedProperty(String string, Class clazz) {
        Map map = null;
        if (clazz == null) {
            map = this.defaultMappedProperty(string);
        } else if (clazz.isInterface()) {
            map = this.defaultMappedProperty(string);
        } else {
            Class<?> clazz2 = class$java$util$Map;
            if (clazz2 == null) {
                clazz2 = class$java$util$Map = new Map[0].getClass().getComponentType();
            }
            if (clazz2.isAssignableFrom(clazz)) {
                try {
                    map = clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Error instantiating mapped property of type '" + clazz.getName() + "' for '" + string + "' " + exception);
                }
            } else {
                throw new IllegalArgumentException("Non-mapped property of type '" + clazz.getName() + "' for '" + string + "'");
            }
        }
        return map;
    }

    public Object createDynaBeanProperty(String string, Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Error instantiating DynaBean property of type '" + clazz.getName() + "' for '" + string + "' " + exception);
            }
            return null;
        }
    }

    public Object createPrimitiveProperty(String string, Class clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Integer.TYPE) {
            return Integer_ZERO;
        }
        if (clazz == Long.TYPE) {
            return Long_ZERO;
        }
        if (clazz == Double.TYPE) {
            return Double_ZERO;
        }
        if (clazz == Float.TYPE) {
            return Float_ZERO;
        }
        if (clazz == Byte.TYPE) {
            return Byte_ZERO;
        }
        if (clazz == Short.TYPE) {
            return Short_ZERO;
        }
        if (clazz == Character.TYPE) {
            return Character_SPACE;
        }
        return null;
    }

    public Object createNumberProperty(String string, Class clazz) {
        return null;
    }

    public Object createOtherProperty(String string, Class clazz) {
        block11: {
            block10: {
                Class<?> clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
                }
                if (clazz == clazz2) break block10;
                Class<?> clazz3 = class$java$lang$Boolean;
                if (clazz3 == null) {
                    clazz3 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
                }
                if (clazz == clazz3) break block10;
                Class<?> clazz4 = class$java$lang$Character;
                if (clazz4 == null) {
                    clazz4 = class$java$lang$Character = new Character[0].getClass().getComponentType();
                }
                if (clazz == clazz4) break block10;
                Class<?> clazz5 = class$java$util$Date;
                if (clazz5 == null) {
                    clazz5 = class$java$util$Date = new Date[0].getClass().getComponentType();
                }
                if (!clazz5.isAssignableFrom(clazz)) break block11;
            }
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Error instantiating property of type '" + clazz.getName() + "' for '" + string + "' " + exception);
            }
            return null;
        }
    }

    public Object defaultIndexedProperty(String string) {
        return new ArrayList();
    }

    public Map defaultMappedProperty(String string) {
        return new HashMap();
    }

    public boolean isDynaProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        if (this.dynaClass instanceof LazyDynaClass) {
            return ((LazyDynaClass)this.dynaClass).isDynaProperty(string);
        }
        return this.dynaClass.getDynaProperty(string) != null;
    }

    public boolean isAssignable(Class clazz, Class clazz2) {
        block19: {
            block11: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            if (clazz.isAssignableFrom(clazz2)) break block11;
                                            if (clazz != Boolean.TYPE) break block12;
                                            Class<?> clazz3 = class$java$lang$Boolean;
                                            if (clazz3 == null) {
                                                clazz3 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
                                            }
                                            if (clazz2 == clazz3) break block11;
                                        }
                                        if (clazz != Byte.TYPE) break block13;
                                        Class<?> clazz4 = class$java$lang$Byte;
                                        if (clazz4 == null) {
                                            clazz4 = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
                                        }
                                        if (clazz2 == clazz4) break block11;
                                    }
                                    if (clazz != Character.TYPE) break block14;
                                    Class<?> clazz5 = class$java$lang$Character;
                                    if (clazz5 == null) {
                                        clazz5 = class$java$lang$Character = new Character[0].getClass().getComponentType();
                                    }
                                    if (clazz2 == clazz5) break block11;
                                }
                                if (clazz != Double.TYPE) break block15;
                                Class<?> clazz6 = class$java$lang$Double;
                                if (clazz6 == null) {
                                    clazz6 = class$java$lang$Double = new Double[0].getClass().getComponentType();
                                }
                                if (clazz2 == clazz6) break block11;
                            }
                            if (clazz != Float.TYPE) break block16;
                            Class<?> clazz7 = class$java$lang$Float;
                            if (clazz7 == null) {
                                clazz7 = class$java$lang$Float = new Float[0].getClass().getComponentType();
                            }
                            if (clazz2 == clazz7) break block11;
                        }
                        if (clazz != Integer.TYPE) break block17;
                        Class<?> clazz8 = class$java$lang$Integer;
                        if (clazz8 == null) {
                            clazz8 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
                        }
                        if (clazz2 == clazz8) break block11;
                    }
                    if (clazz != Long.TYPE) break block18;
                    Class<?> clazz9 = class$java$lang$Long;
                    if (clazz9 == null) {
                        clazz9 = class$java$lang$Long = new Long[0].getClass().getComponentType();
                    }
                    if (clazz2 == clazz9) break block11;
                }
                if (clazz != Short.TYPE) break block19;
                Class<?> clazz10 = class$java$lang$Short;
                if (clazz10 == null) {
                    clazz10 = class$java$lang$Short = new Short[0].getClass().getComponentType();
                }
                if (clazz2 != clazz10) break block19;
            }
            return true;
        }
        return false;
    }

    public Map newMap() {
        return new HashMap();
    }

    static {
        Class<?> clazz = class$org$apache$commons$gs$beanutils$LazyDynaBean;
        if (clazz == null) {
            clazz = class$org$apache$commons$gs$beanutils$LazyDynaBean = new LazyDynaBean[0].getClass().getComponentType();
        }
        logger = Logger.getLogger(clazz.getName());
        BigInteger_ZERO = new BigInteger("0");
        BigDecimal_ZERO = new BigDecimal("0");
        Character_SPACE = new Character(' ');
        Byte_ZERO = new Byte(0);
        Short_ZERO = new Short(0);
        Integer_ZERO = new Integer(0);
        Long_ZERO = new Long(0L);
        Float_ZERO = new Float(0.0f);
        Double_ZERO = new Double(0.0);
    }
}

