/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.List;
import java.util.Map;

public class DynaProperty
implements Serializable {
    private static final int BOOLEAN_TYPE = 1;
    private static final int BYTE_TYPE = 2;
    private static final int CHAR_TYPE = 3;
    private static final int DOUBLE_TYPE = 4;
    private static final int FLOAT_TYPE = 5;
    private static final int INT_TYPE = 6;
    private static final int LONG_TYPE = 7;
    private static final int SHORT_TYPE = 8;
    public String name;
    public transient Class type;
    public transient Class contentType;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Object;

    public DynaProperty(String string) {
        Class<?> clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        this(string, clazz);
    }

    public DynaProperty(String string, Class clazz) {
        this.name = null;
        this.type = null;
        this.name = string;
        this.type = clazz;
    }

    public DynaProperty(String string, Class clazz, Class clazz2) {
        this.name = null;
        this.type = null;
        this.name = string;
        this.type = clazz;
        this.contentType = clazz2;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public Class getContentType() {
        return this.contentType;
    }

    public boolean isIndexed() {
        if (this.type == null) {
            return false;
        }
        if (this.type.isArray()) {
            return true;
        }
        Class<?> clazz = class$java$util$List;
        if (clazz == null) {
            clazz = class$java$util$List = new List[0].getClass().getComponentType();
        }
        return clazz.isAssignableFrom(this.type);
    }

    public boolean isMapped() {
        if (this.type == null) {
            return false;
        }
        Class<?> clazz = class$java$util$Map;
        if (clazz == null) {
            clazz = class$java$util$Map = new Map[0].getClass().getComponentType();
        }
        return clazz.isAssignableFrom(this.type);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("DynaProperty[name=");
        stringBuffer.append(this.name);
        stringBuffer.append(",type=");
        stringBuffer.append(this.type);
        if (this.isMapped() || this.isIndexed()) {
            stringBuffer.append(" <").append(this.contentType).append(">");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.writeAnyClass(this.type, objectOutputStream);
        if (this.isMapped() || this.isIndexed()) {
            this.writeAnyClass(this.contentType, objectOutputStream);
        }
        objectOutputStream.defaultWriteObject();
    }

    private void writeAnyClass(Class clazz, ObjectOutputStream objectOutputStream) throws IOException {
        int n2 = 0;
        if (Boolean.TYPE.equals(clazz)) {
            n2 = 1;
        } else if (Byte.TYPE.equals(clazz)) {
            n2 = 2;
        } else if (Character.TYPE.equals(clazz)) {
            n2 = 3;
        } else if (Double.TYPE.equals(clazz)) {
            n2 = 4;
        } else if (Float.TYPE.equals(clazz)) {
            n2 = 5;
        } else if (Integer.TYPE.equals(clazz)) {
            n2 = 6;
        } else if (Long.TYPE.equals(clazz)) {
            n2 = 7;
        } else if (Short.TYPE.equals(clazz)) {
            n2 = 8;
        }
        if (n2 == 0) {
            objectOutputStream.writeBoolean(false);
            objectOutputStream.writeObject(clazz);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeInt(n2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.type = this.readAnyClass(objectInputStream);
        if (this.isMapped() || this.isIndexed()) {
            this.contentType = this.readAnyClass(objectInputStream);
        }
        objectInputStream.defaultReadObject();
    }

    private Class readAnyClass(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream.readBoolean()) {
            switch (objectInputStream.readInt()) {
                case 1: {
                    return Boolean.TYPE;
                }
                case 2: {
                    return Byte.TYPE;
                }
                case 3: {
                    return Character.TYPE;
                }
                case 4: {
                    return Double.TYPE;
                }
                case 5: {
                    return Float.TYPE;
                }
                case 6: {
                    return Integer.TYPE;
                }
                case 7: {
                    return Long.TYPE;
                }
                case 8: {
                    return Short.TYPE;
                }
            }
            throw new StreamCorruptedException("Invalid primitive type. Check version of beanutils used to serialize is compatible.");
        }
        return (Class)objectInputStream.readObject();
    }
}

