/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils;

import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.gs.beanutils.BeanUtilsBean;
import org.apache.commons.gs.beanutils.ConvertUtils;
import org.apache.commons.gs.beanutils.Converter;
import org.apache.commons.gs.beanutils.converters.BigDecimalConverter;
import org.apache.commons.gs.beanutils.converters.BigIntegerConverter;
import org.apache.commons.gs.beanutils.converters.BooleanArrayConverter;
import org.apache.commons.gs.beanutils.converters.BooleanConverter;
import org.apache.commons.gs.beanutils.converters.ByteArrayConverter;
import org.apache.commons.gs.beanutils.converters.ByteConverter;
import org.apache.commons.gs.beanutils.converters.CharacterArrayConverter;
import org.apache.commons.gs.beanutils.converters.CharacterConverter;
import org.apache.commons.gs.beanutils.converters.ClassConverter;
import org.apache.commons.gs.beanutils.converters.DoubleArrayConverter;
import org.apache.commons.gs.beanutils.converters.DoubleConverter;
import org.apache.commons.gs.beanutils.converters.FileConverter;
import org.apache.commons.gs.beanutils.converters.FloatArrayConverter;
import org.apache.commons.gs.beanutils.converters.FloatConverter;
import org.apache.commons.gs.beanutils.converters.IntegerArrayConverter;
import org.apache.commons.gs.beanutils.converters.IntegerConverter;
import org.apache.commons.gs.beanutils.converters.LongArrayConverter;
import org.apache.commons.gs.beanutils.converters.LongConverter;
import org.apache.commons.gs.beanutils.converters.ShortArrayConverter;
import org.apache.commons.gs.beanutils.converters.ShortConverter;
import org.apache.commons.gs.beanutils.converters.SqlDateConverter;
import org.apache.commons.gs.beanutils.converters.SqlTimeConverter;
import org.apache.commons.gs.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.gs.beanutils.converters.StringArrayConverter;
import org.apache.commons.gs.beanutils.converters.StringConverter;
import org.apache.commons.gs.beanutils.converters.URLConverter;
import org.apache.commons.gs.collections.FastHashMap;

public class ConvertUtilsBean {
    private FastHashMap converters = new FastHashMap();
    private Logger log;
    private Boolean defaultBoolean;
    private Byte defaultByte;
    private Character defaultCharacter;
    private Double defaultDouble;
    private Float defaultFloat;
    private Integer defaultInteger;
    private Long defaultLong;
    private static Short defaultShort = new Short(0);
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$apache$commons$gs$beanutils$ConvertUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public static ConvertUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getConvertUtils();
    }

    public ConvertUtilsBean() {
        Class<?> clazz = class$org$apache$commons$gs$beanutils$ConvertUtils;
        if (clazz == null) {
            clazz = class$org$apache$commons$gs$beanutils$ConvertUtils = new ConvertUtils[0].getClass().getComponentType();
        }
        this.log = Logger.getLogger(clazz.getName());
        this.defaultBoolean = Boolean.FALSE;
        this.defaultByte = new Byte(0);
        this.defaultCharacter = new Character(' ');
        this.defaultDouble = new Double(0.0);
        this.defaultFloat = new Float(0.0f);
        this.defaultInteger = new Integer(0);
        this.defaultLong = new Long(0L);
        this.converters.setFast(false);
        this.deregister();
        this.converters.setFast(true);
    }

    public boolean getDefaultBoolean() {
        return this.defaultBoolean;
    }

    public void setDefaultBoolean(boolean bl2) {
        this.defaultBoolean = new Boolean(bl2);
        this.register(new BooleanConverter(this.defaultBoolean), Boolean.TYPE);
        BooleanConverter booleanConverter = new BooleanConverter(this.defaultBoolean);
        Class<?> clazz = class$java$lang$Boolean;
        if (clazz == null) {
            clazz = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
        }
        this.register(booleanConverter, clazz);
    }

    public byte getDefaultByte() {
        return this.defaultByte;
    }

    public void setDefaultByte(byte by2) {
        this.defaultByte = new Byte(by2);
        this.register(new ByteConverter(this.defaultByte), Byte.TYPE);
        ByteConverter byteConverter = new ByteConverter(this.defaultByte);
        Class<?> clazz = class$java$lang$Byte;
        if (clazz == null) {
            clazz = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
        }
        this.register(byteConverter, clazz);
    }

    public char getDefaultCharacter() {
        return this.defaultCharacter.charValue();
    }

    public void setDefaultCharacter(char c2) {
        this.defaultCharacter = new Character(c2);
        this.register(new CharacterConverter(this.defaultCharacter), Character.TYPE);
        CharacterConverter characterConverter = new CharacterConverter(this.defaultCharacter);
        Class<?> clazz = class$java$lang$Character;
        if (clazz == null) {
            clazz = class$java$lang$Character = new Character[0].getClass().getComponentType();
        }
        this.register(characterConverter, clazz);
    }

    public double getDefaultDouble() {
        return this.defaultDouble;
    }

    public void setDefaultDouble(double d2) {
        this.defaultDouble = new Double(d2);
        this.register(new DoubleConverter(this.defaultDouble), Double.TYPE);
        DoubleConverter doubleConverter = new DoubleConverter(this.defaultDouble);
        Class<?> clazz = class$java$lang$Double;
        if (clazz == null) {
            clazz = class$java$lang$Double = new Double[0].getClass().getComponentType();
        }
        this.register(doubleConverter, clazz);
    }

    public float getDefaultFloat() {
        return this.defaultFloat.floatValue();
    }

    public void setDefaultFloat(float f2) {
        this.defaultFloat = new Float(f2);
        this.register(new FloatConverter(this.defaultFloat), Float.TYPE);
        FloatConverter floatConverter = new FloatConverter(this.defaultFloat);
        Class<?> clazz = class$java$lang$Float;
        if (clazz == null) {
            clazz = class$java$lang$Float = new Float[0].getClass().getComponentType();
        }
        this.register(floatConverter, clazz);
    }

    public int getDefaultInteger() {
        return this.defaultInteger;
    }

    public void setDefaultInteger(int n2) {
        this.defaultInteger = new Integer(n2);
        this.register(new IntegerConverter(this.defaultInteger), Integer.TYPE);
        IntegerConverter integerConverter = new IntegerConverter(this.defaultInteger);
        Class<?> clazz = class$java$lang$Integer;
        if (clazz == null) {
            clazz = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
        }
        this.register(integerConverter, clazz);
    }

    public long getDefaultLong() {
        return this.defaultLong;
    }

    public void setDefaultLong(long l2) {
        this.defaultLong = new Long(l2);
        this.register(new LongConverter(this.defaultLong), Long.TYPE);
        LongConverter longConverter = new LongConverter(this.defaultLong);
        Class<?> clazz = class$java$lang$Long;
        if (clazz == null) {
            clazz = class$java$lang$Long = new Long[0].getClass().getComponentType();
        }
        this.register(longConverter, clazz);
    }

    public short getDefaultShort() {
        return defaultShort;
    }

    public void setDefaultShort(short s2) {
        defaultShort = new Short(s2);
        this.register(new ShortConverter(defaultShort), Short.TYPE);
        ShortConverter shortConverter = new ShortConverter(defaultShort);
        Class<?> clazz = class$java$lang$Short;
        if (clazz == null) {
            clazz = class$java$lang$Short = new Short[0].getClass().getComponentType();
        }
        this.register(shortConverter, clazz);
    }

    public String convert(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            if (Array.getLength(object) < 1) {
                return null;
            }
            if ((object = Array.get(object, 0)) == null) {
                return null;
            }
            Class<?> clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            Converter converter = this.lookup(clazz);
            Class<?> clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            return (String)converter.convert(clazz2, object);
        }
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        Converter converter = this.lookup(clazz);
        Class<?> clazz3 = class$java$lang$String;
        if (clazz3 == null) {
            clazz3 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        return (String)converter.convert(clazz3, object);
    }

    public Object convert(String string, Class clazz) {
        Converter converter;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Convert string '" + string + "' to class '" + clazz.getName() + "'");
        }
        if ((converter = this.lookup(clazz)) == null) {
            Class<?> clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            converter = this.lookup(clazz2);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("  Using converter " + converter);
        }
        return converter.convert(clazz, string);
    }

    public Object convert(String[] stringArray, Class clazz) {
        Converter converter;
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Convert String[" + stringArray.length + "] to class '" + clazz2.getName() + "[]'");
        }
        if ((converter = this.lookup(clazz2)) == null) {
            Class<?> clazz3 = class$java$lang$String;
            if (clazz3 == null) {
                clazz3 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            converter = this.lookup(clazz3);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("  Using converter " + converter);
        }
        Object object = Array.newInstance(clazz2, stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Array.set(object, i2, converter.convert(clazz2, stringArray[i2]));
        }
        return object;
    }

    public void deregister() {
        boolean[] blArray = new boolean[]{};
        byte[] byArray = new byte[]{};
        char[] cArray = new char[]{};
        double[] dArray = new double[]{};
        float[] fArray = new float[]{};
        int[] nArray = new int[]{};
        long[] lArray = new long[]{};
        short[] sArray = new short[]{};
        String[] stringArray = new String[]{};
        this.converters.clear();
        Class<?> clazz = class$java$math$BigDecimal;
        if (clazz == null) {
            clazz = class$java$math$BigDecimal = new BigDecimal[0].getClass().getComponentType();
        }
        this.register(clazz, new BigDecimalConverter());
        Class<?> clazz2 = class$java$math$BigInteger;
        if (clazz2 == null) {
            clazz2 = class$java$math$BigInteger = new BigInteger[0].getClass().getComponentType();
        }
        this.register(clazz2, new BigIntegerConverter());
        this.register(Boolean.TYPE, new BooleanConverter(this.defaultBoolean));
        Class<?> clazz3 = class$java$lang$Boolean;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
        }
        this.register(clazz3, new BooleanConverter(this.defaultBoolean));
        this.register(blArray.getClass(), new BooleanArrayConverter(blArray));
        this.register(Byte.TYPE, new ByteConverter(this.defaultByte));
        Class<?> clazz4 = class$java$lang$Byte;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
        }
        this.register(clazz4, new ByteConverter(this.defaultByte));
        this.register(byArray.getClass(), new ByteArrayConverter(byArray));
        this.register(Character.TYPE, new CharacterConverter(this.defaultCharacter));
        Class<?> clazz5 = class$java$lang$Character;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Character = new Character[0].getClass().getComponentType();
        }
        this.register(clazz5, new CharacterConverter(this.defaultCharacter));
        this.register(cArray.getClass(), new CharacterArrayConverter(cArray));
        Class<?> clazz6 = class$java$lang$Class;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Class = new Class[0].getClass().getComponentType();
        }
        this.register(clazz6, new ClassConverter());
        this.register(Double.TYPE, new DoubleConverter(this.defaultDouble));
        Class<?> clazz7 = class$java$lang$Double;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Double = new Double[0].getClass().getComponentType();
        }
        this.register(clazz7, new DoubleConverter(this.defaultDouble));
        this.register(dArray.getClass(), new DoubleArrayConverter(dArray));
        this.register(Float.TYPE, new FloatConverter(this.defaultFloat));
        Class<?> clazz8 = class$java$lang$Float;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Float = new Float[0].getClass().getComponentType();
        }
        this.register(clazz8, new FloatConverter(this.defaultFloat));
        this.register(fArray.getClass(), new FloatArrayConverter(fArray));
        this.register(Integer.TYPE, new IntegerConverter(this.defaultInteger));
        Class<?> clazz9 = class$java$lang$Integer;
        if (clazz9 == null) {
            clazz9 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
        }
        this.register(clazz9, new IntegerConverter(this.defaultInteger));
        this.register(nArray.getClass(), new IntegerArrayConverter(nArray));
        this.register(Long.TYPE, new LongConverter(this.defaultLong));
        Class<?> clazz10 = class$java$lang$Long;
        if (clazz10 == null) {
            clazz10 = class$java$lang$Long = new Long[0].getClass().getComponentType();
        }
        this.register(clazz10, new LongConverter(this.defaultLong));
        this.register(lArray.getClass(), new LongArrayConverter(lArray));
        this.register(Short.TYPE, new ShortConverter(defaultShort));
        Class<?> clazz11 = class$java$lang$Short;
        if (clazz11 == null) {
            clazz11 = class$java$lang$Short = new Short[0].getClass().getComponentType();
        }
        this.register(clazz11, new ShortConverter(defaultShort));
        this.register(sArray.getClass(), new ShortArrayConverter(sArray));
        Class<?> clazz12 = class$java$lang$String;
        if (clazz12 == null) {
            clazz12 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        this.register(clazz12, new StringConverter());
        this.register(stringArray.getClass(), new StringArrayConverter(stringArray));
        Class<?> clazz13 = class$java$sql$Date;
        if (clazz13 == null) {
            clazz13 = class$java$sql$Date = new Date[0].getClass().getComponentType();
        }
        this.register(clazz13, new SqlDateConverter());
        Class<?> clazz14 = class$java$sql$Time;
        if (clazz14 == null) {
            clazz14 = class$java$sql$Time = new Time[0].getClass().getComponentType();
        }
        this.register(clazz14, new SqlTimeConverter());
        Class<?> clazz15 = class$java$sql$Timestamp;
        if (clazz15 == null) {
            clazz15 = class$java$sql$Timestamp = new Timestamp[0].getClass().getComponentType();
        }
        this.register(clazz15, new SqlTimestampConverter());
        Class<?> clazz16 = class$java$io$File;
        if (clazz16 == null) {
            clazz16 = class$java$io$File = new File[0].getClass().getComponentType();
        }
        this.register(clazz16, new FileConverter());
        Class<?> clazz17 = class$java$net$URL;
        if (clazz17 == null) {
            clazz17 = class$java$net$URL = new URL[0].getClass().getComponentType();
        }
        this.register(clazz17, new URLConverter());
    }

    private void register(Class clazz, Converter converter) {
        this.register(converter, clazz);
    }

    public void deregister(Class clazz) {
        this.converters.remove(clazz);
    }

    public Converter lookup(Class clazz) {
        return (Converter)this.converters.get(clazz);
    }

    public void register(Converter converter, Class clazz) {
        this.converters.put(clazz, converter);
    }
}

