/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.util;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class UUID_
implements Serializable,
Comparable {
    private static final long serialVersionUID = 4759128571957838954L;
    private static final SecureRandom randomGenerator = new SecureRandom();
    private long mostSignificantBits;
    private long leastSignificantBits;

    public UUID_(long mostSigBits, long leastSigBits) {
        this.mostSignificantBits = mostSigBits;
        this.leastSignificantBits = leastSigBits;
    }

    public static UUID_ randomUUID() {
        byte[] bytes = new byte[16];
        randomGenerator.nextBytes(bytes);
        return UUID_.newInstance(bytes, 4);
    }

    public static UUID_ nameUUIDFromBytes(byte[] name) {
        try {
            return UUID_.newInstance(MessageDigest.getInstance("MD5").digest(name), 3);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new InternalError(e2.getMessage());
        }
    }

    public static UUID_ fromString(String name) {
        String[] values = name.split("-");
        if (values.length != 5) {
            throw new IllegalArgumentException(name);
        }
        try {
            return new UUID_(Long.parseLong(values[0], 16) << 32 | Long.parseLong(values[1], 16) << 16 | Long.parseLong(values[2], 16), Long.parseLong(values[3], 16) << 48 | Long.parseLong(values[4], 16));
        }
        catch (NumberFormatException e2) {
            throw new IllegalStateException(name);
        }
    }

    public long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    public long getLeastSignificantBits() {
        return this.leastSignificantBits;
    }

    public int version() {
        return (int)(this.mostSignificantBits >>> 12) & 0xF;
    }

    public int variant() {
        if (this.leastSignificantBits >>> 63 == 0L) {
            return 0;
        }
        if (this.leastSignificantBits >>> 62 == 2L) {
            return 2;
        }
        return (int)(this.leastSignificantBits >>> 61);
    }

    public long timestamp() {
        this.assertVersion1();
        return (this.mostSignificantBits & 0xFFFL) << 48 | (this.mostSignificantBits & 0xFFFF0000L) << 16 | this.mostSignificantBits >>> 32;
    }

    public int clockSequence() {
        this.assertVersion1();
        return (int)(this.leastSignificantBits >>> 48) & 0x3FFF;
    }

    public long node() {
        this.assertVersion1();
        return this.leastSignificantBits & 0xFFFFFFFFFFFFL;
    }

    public String toString() {
        return UUID_.hex(this.mostSignificantBits >> 32, 8) + '-' + UUID_.hex(this.mostSignificantBits >> 16, 4) + '-' + UUID_.hex(this.mostSignificantBits, 4) + '-' + UUID_.hex(this.leastSignificantBits >> 48, 4) + '-' + UUID_.hex(this.leastSignificantBits, 12);
    }

    public int hashCode() {
        return (int)(this.mostSignificantBits >> 32 ^ this.mostSignificantBits ^ this.leastSignificantBits >> 32 ^ this.leastSignificantBits);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UUID_) {
            UUID_ val = (UUID_)obj;
            return this.mostSignificantBits == val.mostSignificantBits && this.leastSignificantBits == val.leastSignificantBits;
        }
        return false;
    }

    public int compareTo(UUID_ val) {
        if (this.mostSignificantBits > val.mostSignificantBits) {
            return 1;
        }
        if (this.mostSignificantBits < val.mostSignificantBits) {
            return -1;
        }
        if (this.leastSignificantBits > val.leastSignificantBits) {
            return 1;
        }
        if (this.leastSignificantBits < val.leastSignificantBits) {
            return -1;
        }
        return 0;
    }

    private static UUID_ newInstance(byte[] bytes, int version) {
        return new UUID_(UUID_.getLong(bytes, 0) & 0xFFFFFFFFFFFF0FFFL | (long)(version << 12), UUID_.getLong(bytes, 8) & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE);
    }

    private static long getLong(byte[] bytes, int offset) {
        long result = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            result = result << 8 | (long)(bytes[i2 + offset] & 0xFF);
        }
        return result;
    }

    private static String hex(long value, int length) {
        String s2 = Long.toHexString(1L << (length << 2) | value);
        return s2.substring(s2.length() - length);
    }

    private void assertVersion1() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a version 1 UUID");
        }
    }

    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((UUID_)x0);
    }
}

