/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.ViewFileDialog;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceConfigAdvancedPanel;
import com.j_spaces.tools.spacebrowser.SpaceConfigException;
import com.j_spaces.tools.spacebrowser.SpaceConfigPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SpaceConfigStandardPanel
extends JPanel {
    public SpaceConfigPanel m_owner;
    public SpaceBrowser m_spaceBrowser;
    public boolean m_isCreateMode;
    public JPanel panNorth = new JPanel();
    public JPanel panPersistence = new JPanel();
    public JPanel panCluster = new JPanel();
    public JButton butEditClusterConfigURL = new JButton();
    public JLabel labSAClass = new JLabel();
    public JLabel labSAURL = new JLabel();
    public JLabel labClusterConfigURL = new JLabel();
    public JComboBox cmboxSAClass = new JComboBox();
    public JComboBox cmboxSAUrl = new JComboBox();
    public JComboBox cmboxClusterConfigURL = new JComboBox();
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");

    public SpaceConfigStandardPanel(SpaceConfigPanel spaceConfigPanel, SpaceBrowser spaceBrowser, boolean bl2) {
        this.m_owner = spaceConfigPanel;
        this.m_spaceBrowser = spaceBrowser;
        this.m_isCreateMode = bl2;
        try {
            this.jbInit();
            this.init();
            this.setFirstEnableComponentsMode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.butEditClusterConfigURL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((String)SpaceConfigStandardPanel.this.cmboxClusterConfigURL.getEditor().getItem()).trim();
                if (string.length() == 0 || string.equals("none") || !string.endsWith(".xml")) {
                    File file = SpaceConfigStandardPanel.this.m_spaceBrowser.chooseFile();
                    if (file != null) {
                        SpaceConfigStandardPanel.this.cmboxClusterConfigURL.getEditor().setItem(file.getPath().replace('\\', '/'));
                    }
                } else {
                    try {
                        ViewFileDialog viewFileDialog = new ViewFileDialog(SpaceConfigStandardPanel.this.m_spaceBrowser, string);
                        viewFileDialog.show();
                    }
                    catch (Exception exception) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, exception.toString(), exception);
                        }
                        JOptionPane.showConfirmDialog(SpaceConfigStandardPanel.this.m_spaceBrowser, exception.getClass().getName() + " " + exception.getMessage(), "Can't read the file", -1, 0, SpaceConfigStandardPanel.this.m_spaceBrowser.EXCEPTION_ICON);
                    }
                }
            }
        });
        Font font = new JTextField().getFont();
        this.cmboxSAClass.setFont(font);
        this.cmboxSAUrl.setFont(font);
        this.cmboxClusterConfigURL.setFont(font);
    }

    public void cleanup() {
        JSpaceUtilities.cleanAWTContainer(this);
        this.setFirstEnableComponentsMode();
    }

    public void setPersistenceEnabled(boolean bl2) {
        JSpaceUtilities.setAWTComponentsStatus(this.panPersistence, bl2);
        this.cmboxSAClass.setEnabled(this.m_isCreateMode && bl2);
        this.cmboxSAUrl.setEnabled(this.m_isCreateMode && bl2);
    }

    public void setClusterEnabled(boolean bl2) {
        JSpaceUtilities.setAWTComponentsStatus(this.panCluster, bl2);
    }

    public void setModelForSAComboxBoxes(ComboBoxModel comboBoxModel, ComboBoxModel comboBoxModel2) {
        this.cmboxSAClass.setModel(comboBoxModel);
        this.cmboxSAUrl.setModel(comboBoxModel2);
    }

    public void updateSettings(SpaceConfig spaceConfig, boolean bl2) {
        this.setPersistenceEnabled(spaceConfig.isPersistent() ? !bl2 : false);
        Object object = null;
        object = spaceConfig.getStorageAdapterClass() != null ? spaceConfig.getStorageAdapterClass() : (this.cmboxSAClass.getModel().getSize() > 0 ? this.cmboxSAClass.getSelectedItem() : "");
        this.cmboxSAClass.getEditor().setItem(object);
        object = spaceConfig.getStorageAdapterURL() != null ? spaceConfig.getStorageAdapterURL() : (this.cmboxSAUrl.getModel().getSize() > 0 ? this.cmboxSAUrl.getSelectedItem() : "");
        this.cmboxSAUrl.getEditor().setItem(object);
        if (((DefaultComboBoxModel)this.cmboxSAUrl.getModel()).getIndexOf(object) < 0) {
            this.cmboxSAUrl.addItem(object);
        }
        this.cmboxSAUrl.setSelectedItem(object);
        this.cmboxClusterConfigURL.getEditor().setItem(spaceConfig.getClusterConfigURL());
        this.setClusterEnabled(spaceConfig.isClustered());
    }

    public void updateConfig(SpaceConfig spaceConfig) throws SpaceConfigException {
        String string;
        if (this.m_owner.chboxPersistent.isSelected()) {
            string = (String)this.cmboxSAClass.getEditor().getItem();
            String string2 = (String)this.cmboxSAUrl.getEditor().getItem();
            if (string == null || string.trim().length() == 0) {
                throw new SpaceConfigException("Please define storage adapter class and url value.");
            }
            spaceConfig.setStorageAdapterClass(string);
            if (string2 != null && string2.trim().length() != 0) {
                spaceConfig.setStorageAdapterURL(string2);
            } else {
                throw new SpaceConfigException("Please define storage adapter class and url value.");
            }
        }
        if (this.m_owner.chboxClustered.isSelected()) {
            string = ((String)this.cmboxClusterConfigURL.getEditor().getItem()).trim();
            if (string.length() == 0 && string.equals("none")) {
                throw new SpaceConfigException("Please define cluster configuration file name.");
            }
            spaceConfig.setClusterConfigURL(string);
            spaceConfig.setClustered(true);
        }
    }

    private void setFirstEnableComponentsMode() {
        JSpaceUtilities.setAWTComponentsStatus(this.panPersistence, false);
        JSpaceUtilities.setAWTComponentsStatus(this.panCluster, false);
    }

    public void copySettingsTo(SpaceConfigAdvancedPanel spaceConfigAdvancedPanel) {
        if (this.m_isCreateMode) {
            this.m_owner.updateComboBoxModel(this.cmboxSAClass);
            this.m_owner.updateComboBoxModel(this.cmboxSAUrl);
        }
        spaceConfigAdvancedPanel.cmboxClusterConfigURL.getEditor().setItem(this.cmboxClusterConfigURL.getEditor().getItem());
        this.m_owner.updateComboBoxModel(this.cmboxClusterConfigURL);
    }

    private void jbInit() throws Exception {
        this.labSAClass.setText("Storage Adapter Class:");
        this.labSAURL.setText("Storage Adapter URL:");
        this.cmboxSAClass.setEditable(true);
        this.cmboxSAUrl.setEditable(true);
        this.butEditClusterConfigURL.setText("...");
        this.labClusterConfigURL.setText("Cluster Config URL:");
        this.cmboxClusterConfigURL.setEditable(true);
        this.panNorth.setLayout(new GridBagLayout());
        this.panNorth.add((Component)this.panPersistence, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panNorth.add((Component)this.panCluster, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panPersistence.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Persistent Options"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panPersistence.setLayout(new GridBagLayout());
        this.panPersistence.add((Component)this.labSAClass, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 5), 0, 0));
        this.panPersistence.add((Component)this.cmboxSAClass, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, -3));
        this.panPersistence.add((Component)this.labSAURL, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panPersistence.add((Component)this.cmboxSAUrl, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, -3));
        this.panCluster.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Cluster Options"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panCluster.setLayout(new GridBagLayout());
        this.panCluster.add((Component)this.cmboxClusterConfigURL, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, -3));
        this.panCluster.add((Component)this.labClusterConfigURL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 1, 0));
        this.panCluster.add((Component)this.butEditClusterConfigURL, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 0), -9, -4));
        this.setLayout(new BorderLayout());
        this.add((Component)this.panNorth, "North");
    }
}

