/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.view.ColumnSortListener;
import com.j_spaces.tools.cluster.view.MembersLegend;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class MembersTable
extends JPanel {
    private MembersTableModel m_tableModel;
    private JTable m_table;
    private JPopupMenu popupMenu;
    private JMenuItem copyMemberURLItem;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public MembersTable() {
        block2: {
            try {
                this.m_tableModel = new MembersTableModel();
                this.m_tableModel.addColumn("Name");
                this.m_tableModel.addColumn("URL");
                this.m_table = new JTable(this.m_tableModel){

                    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n2, int n3) {
                        Component component = super.prepareRenderer(tableCellRenderer, n2, n3);
                        if (component instanceof JComponent) {
                            JComponent jComponent = (JComponent)component;
                            jComponent.setToolTipText((String)this.getValueAt(n2, n3));
                        }
                        return component;
                    }
                };
                JTableHeader jTableHeader = this.m_table.getTableHeader();
                jTableHeader.addMouseListener(new ColumnSortListener());
                jTableHeader.setFont(new Font("Tahoma", 1, 12));
                this.m_table.setAutoCreateColumnsFromModel(false);
                this.m_table.setSelectionMode(0);
                this.m_table.setShowHorizontalLines(false);
                this.m_table.setAutoResizeMode(4);
                this.m_table.setAutoscrolls(true);
                this.m_table.getColumnModel().getColumn(0).setCellRenderer(new CustomTableCellRenderer());
                this.handleTablePopupEventsAndMenu();
                this.setBorder(new TitledBorder("Members"));
                this.setLayout(new BorderLayout());
                this.add((Component)new JScrollPane(this.m_table), "Center");
                this.setPreferredSize(new Dimension(100, 150));
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public void setMembers(ClusterMemberInfo[] clusterMemberInfoArray) {
        this.m_tableModel.setMembers(clusterMemberInfoArray);
    }

    private void handleTablePopupEventsAndMenu() {
        this.createPopupMenu();
        this.m_table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int n2 = MembersTable.this.m_table.getSelectedRow();
                    if (_logger.isLoggable(Level.INFO)) {
                        _logger.info(" sel row2=" + n2);
                    }
                    int n3 = mouseEvent.getX();
                    int n4 = mouseEvent.getY();
                    int n5 = MembersTable.this.m_table.getRowHeight();
                    int n6 = MembersTable.this.m_table.getSelectedRow();
                    int n7 = (n4 - n6 * MembersTable.this.m_table.getRowMargin()) / n5;
                    if (n2 != n7) {
                        MembersTable.this.m_table.setRowSelectionInterval(n7, n7);
                    }
                    MembersTable.this.popupMenu.show(mouseEvent.getComponent(), n3, n4);
                }
            }
        });
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.copyMemberURLItem = new JMenuItem("Copy URL");
        this.popupMenu.add(this.copyMemberURLItem);
        this.copyMemberURLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = MembersTable.this.m_table.getValueAt(MembersTable.this.m_table.getSelectedRow(), 1).toString();
                StringSelection stringSelection = new StringSelection(string);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            }
        });
    }

    public class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            ClusterMemberInfo clusterMemberInfo = MembersTable.this.m_tableModel.getClusterMember(n2);
            boolean bl4 = false;
            if (clusterMemberInfo != null) {
                bl4 = clusterMemberInfo.isMirror();
            }
            this.setForeground(MembersLegend.getColor(ServiceManagerImpl.getMemberStatus(object.toString(), bl4)));
            return this;
        }
    }

    public class MembersTableModel
    extends DefaultTableModel {
        private ClusterMemberInfo[] _members = new ClusterMemberInfo[0];

        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        public void clear() {
            int n2 = this._members.length;
            if (n2 > 0) {
                this._members = new ClusterMemberInfo[0];
                this.fireTableRowsDeleted(0, n2);
            }
        }

        public void setMembers(ClusterMemberInfo[] clusterMemberInfoArray) {
            this.clear();
            this._members = clusterMemberInfoArray;
        }

        public Object getValueAt(int n2, int n3) {
            if (n2 < this._members.length && n2 >= 0) {
                ClusterMemberInfo clusterMemberInfo = this._members[n2];
                if (n3 == 0) {
                    return clusterMemberInfo.memberName;
                }
                if (n3 == 1) {
                    return clusterMemberInfo.memberURL.getURL();
                }
            }
            return null;
        }

        public Class getColumnClass(int n2) {
            Object object = this.getValueAt(0, n2);
            if (object != null) {
                return object.getClass();
            }
            return null;
        }

        public int getRowCount() {
            return this._members == null ? 0 : this._members.length;
        }

        public ClusterMemberInfo getClusterMember(int n2) {
            if (this._members.length > n2 && n2 >= 0) {
                return this._members[n2];
            }
            return null;
        }
    }
}

