/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.tools.cluster.view.GroupPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class MembersLegend
extends JPanel {
    public static final String MEMBER_UNREACHABLE = "Unreachable";
    public static final String MEMBER_ALIVE = "Alive";
    public static final String MEMBER_SOURCE = "Source";
    public static final String MEMBER_TARGET = "Target";
    public static final String MEMBER_MIRROR_ALIVE = "MirrorAlive";
    public static final String MEMBER_MIRROR_UNREACHABLE = "MirrorUnreachable";
    public static final String REPLICATION_STATUS_ACTIVE = "Active";
    public static final String REPLICATION_STATUS_DISCONNECTED = "Disconnected";
    public static final String REPLICATION_STATUS_DISABLED = "Disabled";
    public static final String BACKGROUND_COLOR = "Background";
    public static Hashtable dataHash = new Hashtable();
    public static Object[][] data = new Object[][]{{null, "5"}, {"Member:", null}, {"Unreachable", Color.gray}, {"Alive", Color.green}, {"Source", Color.white}, {"Target", Color.black}, {null, "5"}, {"Replication:", null}, {"Active", Color.green}, {"Disconnected", Color.red}, {"Disabled", Color.white}, {null, "10"}, {"Background", SystemColor.control}, {"MirrorAlive", Color.yellow}, {"MirrorUnreachable", new Color(0, 153, 153)}};
    private GroupPanel owner;

    public MembersLegend(GroupPanel groupPanel) {
        this.owner = groupPanel;
        this.setBorder(new TitledBorder("Legend"));
        this.setLayout(new GridBagLayout());
        int n2 = 0;
        int n3 = 0;
        int n4 = 17;
        int n5 = 0;
        Insets insets = null;
        Font font = new Font("Tahoma", 0, 10);
        Font font2 = new Font("Tahoma", 1, 10);
        Border border = BorderFactory.createLineBorder(Color.black);
        for (int i2 = 0; i2 < data.length; ++i2) {
            String string = (String)data[i2][0];
            Color color = null;
            if (string == null) {
                int n6 = Integer.parseInt((String)data[i2][1]);
                string = "";
                insets = new Insets(n6, 2, n6, 2);
            } else {
                insets = new Insets(2, 2, 2, 2);
                color = (Color)data[i2][1];
            }
            JLabel jLabel = new JLabel();
            jLabel.setFont(color == null ? font2 : font);
            jLabel.setText(string);
            this.add((Component)jLabel, new GridBagConstraints(n2++, n3, 1, 1, 1.0, 0.0, n4, n5, insets, 0, 0));
            if (color != null) {
                dataHash.put(string, color);
                this.add((Component)new JLabel("-"), new GridBagConstraints(n2++, n3, 1, 1, 1.0, 0.0, n4, n5, insets, 0, 0));
                JPanel jPanel = new JPanel();
                jPanel.setBackground(color);
                jPanel.setBorder(border);
                jPanel.setToolTipText("Set custom color");
                jPanel.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        MembersLegend.this.setCustomColor(mouseEvent);
                    }
                });
                jPanel.setName(string);
                this.add((Component)jPanel, new GridBagConstraints(n2, n3, 1, 1, 0.0, 0.0, n4, n5, insets, 0, 0));
            }
            n2 = 0;
            ++n3;
        }
    }

    public static Color getColor(String string) {
        return (Color)dataHash.get(string);
    }

    public static Color getColor(int n2) {
        Color color = null;
        switch (n2) {
            case 0: {
                color = MembersLegend.getColor(REPLICATION_STATUS_ACTIVE);
                break;
            }
            case 2: {
                MembersLegend.getColor(REPLICATION_STATUS_DISABLED);
                break;
            }
            case 1: {
                color = MembersLegend.getColor(REPLICATION_STATUS_DISCONNECTED);
            }
        }
        return color;
    }

    private void setCustomColor(MouseEvent mouseEvent) {
        JPanel jPanel = (JPanel)mouseEvent.getSource();
        Color color = JColorChooser.showDialog(jPanel, "Set color for <" + jPanel.getName() + ">", jPanel.getBackground());
        if (color != null) {
            jPanel.setBackground(color);
            dataHash.put(jPanel.getName(), color);
            ((JComponent)((Object)this.owner.getGraphPanel())).repaint();
        }
    }

    public void repaint() {
        super.repaint();
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component component = this.getComponent(i2);
            if (component == null || !(component instanceof JPanel) || !dataHash.containsKey(component.getName())) continue;
            component.setBackground((Color)dataHash.get(component.getName()));
        }
    }
}

