/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.DescEventListener;
import com.j_spaces.tools.cluster.ListItemAlreadyExistsException;
import com.j_spaces.tools.cluster.NewCluster;
import com.j_spaces.tools.cluster.NewMember;
import com.j_spaces.tools.cluster.ResourcesInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class CreateMembers
extends JPanel {
    public JPanel optionPanel = new JPanel();
    public JPanel memButtonPanel = new JPanel();
    public JPanel memListPanel = new JPanel();
    public JPanel paramPanel = new JPanel();
    public DefaultTableModel paramModel = new DefaultTableModel();
    public JTable paramTable = new JTable(this.paramModel);
    public JLabel paramLabel = new JLabel();
    public JLabel memNameLabel = new JLabel();
    public JLabel memUrlLabel = new JLabel();
    public JButton addButton = new JButton();
    public JButton removeButton = new JButton();
    public JButton editButton = new JButton();
    public DefaultListModel memModel = new DefaultListModel();
    public DefaultListModel memUrlModel = new DefaultListModel();
    public JListExt memList = new JListExt(this.memModel, null);
    public JListExt memUrlList = new JListExt(this.memUrlModel, null);
    public Vector emptyTable = new Vector();
    public MemberListActionListener m_memListActionListener = new MemberListActionListener(null);
    public NewMember m_newMemberDialog;
    public NewCluster m_newCluster;

    public CreateMembers(NewCluster newCluster) {
        this.m_newCluster = newCluster;
        this.jbInit();
    }

    public void jbInit() {
        this.m_newMemberDialog = new NewMember(this);
        this.memListPanel.setLayout(new BorderLayout());
        this.paramPanel.setLayout(new BorderLayout());
        this.memList.setSelectionMode(0);
        this.paramLabel.setBorder(BorderFactory.createEmptyBorder(3, 2, 0, 0));
        this.addButton.setRequestFocusEnabled(false);
        this.removeButton.setRequestFocusEnabled(false);
        this.editButton.setRequestFocusEnabled(false);
        this.setLayout(new BorderLayout());
        this.optionPanel.setLayout(new BorderLayout());
        this.memNameLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.add((Component)this.optionPanel, "Center");
        this.optionPanel.add((Component)this.memButtonPanel, "South");
        this.memButtonPanel.add((Component)this.addButton, null);
        this.memButtonPanel.add((Component)this.editButton, null);
        this.memButtonPanel.add((Component)this.removeButton, null);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.memUrlLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.memList.setVisibleRowCount(6);
        this.memUrlList.setVisibleRowCount(6);
        this.memUrlList.setEnabled(false);
        this.memUrlList.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.memUrlList.setSelectionMode(0);
        jPanel.add((Component)this.memUrlLabel, "North");
        jPanel.add((Component)new JScrollPane(this.memUrlList), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.memListPanel, "West");
        jPanel2.add((Component)jPanel, "East");
        String[] stringArray = ResourcesInfo.createMembers.getLabels();
        this.optionPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), stringArray[0]));
        this.memNameLabel.setText(stringArray[1]);
        this.memUrlLabel.setText(stringArray[2]);
        this.paramLabel.setText(stringArray[3]);
        String[] stringArray2 = ResourcesInfo.createMembers.getButtons();
        this.addButton.setText(stringArray2[0]);
        this.editButton.setText(stringArray2[1]);
        this.removeButton.setText(stringArray2[2]);
        String[] stringArray3 = ResourcesInfo.createMembers.getToolTips();
        JLabel jLabel = this.m_newCluster.stepDescLabel;
        this.memList.addMouseListener(new DescEventListener(jLabel, stringArray3[0]));
        this.addButton.addMouseListener(new DescEventListener(jLabel, stringArray3[1]));
        this.editButton.addMouseListener(new DescEventListener(jLabel, stringArray3[2]));
        this.removeButton.addMouseListener(new DescEventListener(jLabel, stringArray3[3]));
        this.paramTable.addMouseListener(new DescEventListener(jLabel, stringArray3[4]));
        this.paramModel.addColumn("Param Name");
        this.paramModel.addColumn("Param Value");
        this.paramTable.setEnabled(false);
        JSplitPane jSplitPane = new JSplitPane(1, this.memListPanel, jPanel);
        jPanel2.add((Component)jSplitPane, null);
        jPanel.setPreferredSize(new Dimension(200, 130));
        this.memListPanel.setPreferredSize(new Dimension(205, 130));
        this.memListPanel.add((Component)new JScrollPane(this.memList), "Center");
        this.paramPanel.add((Component)new JScrollPane(this.paramTable), "Center");
        this.memListPanel.add((Component)this.memNameLabel, "North");
        this.optionPanel.add((Component)jPanel2, "North");
        this.optionPanel.add((Component)this.paramPanel, "Center");
        this.paramPanel.add((Component)this.paramLabel, "North");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateMembers.this.m_newMemberDialog.showDialog();
            }
        });
        this.memList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n2 = CreateMembers.this.memList.locationToIndex(mouseEvent.getPoint());
                    if (n2 == -1) {
                        return;
                    }
                    CreateMembers.this.editMember();
                }
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateMembers.this.editMember();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = CreateMembers.this.memList.getAnchorSelectionIndex();
                CreateMembers.this.memList.remove(n2);
                CreateMembers.this.memUrlList.remove(n2);
            }
        });
        this.memList.addListSelectionListener(this.m_memListActionListener);
    }

    public void setMemberInfo(boolean bl2, String string, SpaceURL spaceURL, Vector vector) throws ListItemAlreadyExistsException {
        ClusterMemberInfo clusterMemberInfo = new ClusterMemberInfo(string, spaceURL, this.m_newCluster.getClusterName(), null, vector.size() > 0 ? vector : null, null);
        if (bl2) {
            int n2 = this.memList.getSelectedIndex();
            this.memModel.set(n2, clusterMemberInfo);
            this.memUrlModel.set(n2, spaceURL.getURL());
        } else if (!this.memList.containsMember(string) && !this.memUrlList.containsMemberUrl(spaceURL.getURL())) {
            this.memList.addItem(clusterMemberInfo);
            this.memUrlList.addItem(spaceURL.getURL());
        }
        if (vector.size() > 0) {
            this.paramModel.setDataVector(vector, ClusterMemberInfo.paramColNames);
        }
    }

    public void addMemberInfo(ClusterMemberInfo clusterMemberInfo) throws ListItemAlreadyExistsException {
        if (!this.memList.containsMember(clusterMemberInfo.memberName) && !this.memUrlList.containsMemberUrl(clusterMemberInfo.memberURL.getURL())) {
            this.memList.addItem(clusterMemberInfo);
            this.memUrlList.addItem(clusterMemberInfo.memberURL.getURL());
        }
        if (clusterMemberInfo.paramData.size() > 0) {
            this.paramModel.setDataVector(clusterMemberInfo.paramData, ClusterMemberInfo.paramColNames);
        }
    }

    public void clearAllMemberInfo() {
        this.memList.removeListSelectionListener(this.m_memListActionListener);
        this.memModel.clear();
        this.memUrlModel.clear();
        this.m_newMemberDialog.memCombo.removeAllItems();
        this.m_newMemberDialog.urlCombo.removeAllItems();
        this.paramModel.setDataVector(new Vector(), ClusterMemberInfo.paramColNames);
        this.memList.addListSelectionListener(this.m_memListActionListener);
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void editMember() {
        ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)this.memList.getSelectedValue();
        this.m_newMemberDialog.showEditData(clusterMemberInfo.memberName, clusterMemberInfo.memberURL.getURL(), clusterMemberInfo.paramData);
    }

    public DefaultListModel getMemberListModel() {
        return this.memModel;
    }

    public ClusterMemberInfo[] getMembers() {
        Object[] objectArray = new ClusterMemberInfo[this.memModel.size()];
        this.memModel.copyInto(objectArray);
        return objectArray;
    }

    private class JListExt
    extends JList {
        private JListExt(DefaultListModel defaultListModel) {
            super(defaultListModel);
        }

        public void addItem(Object object) throws ListItemAlreadyExistsException {
            DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
            defaultListModel.addElement(object);
            int n2 = defaultListModel.getSize();
            this.setSelectedIndex(n2 - 1);
            this.ensureIndexIsVisible(n2 - 1);
            CreateMembers.this.removeButton.setEnabled(true);
            CreateMembers.this.editButton.setEnabled(true);
        }

        public boolean contains(Object object, String string) throws ListItemAlreadyExistsException {
            DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
            for (int i2 = 0; i2 < defaultListModel.getSize(); ++i2) {
                Object object2 = defaultListModel.get(i2);
                if (object2 instanceof ClusterMemberInfo) {
                    object2 = ((ClusterMemberInfo)object2).memberName;
                }
                if (!object2.equals(object)) continue;
                throw new ListItemAlreadyExistsException(string);
            }
            return false;
        }

        public boolean containsMember(Object object) throws ListItemAlreadyExistsException {
            return this.contains(object, "This Member: " + object + " already exists.");
        }

        public boolean containsMemberUrl(Object object) throws ListItemAlreadyExistsException {
            return this.contains(object, "This URL: " + object + " already in use by other member.Define other URL.");
        }

        public void remove(int n2) {
            DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
            defaultListModel.remove(n2);
            if (defaultListModel.size() > 0) {
                this.setSelectedIndex(n2 == 0 ? n2 : n2 - 1);
            } else {
                CreateMembers.this.paramModel.setDataVector(CreateMembers.this.emptyTable, ClusterMemberInfo.paramColNames);
                CreateMembers.this.removeButton.setEnabled(false);
                CreateMembers.this.editButton.setEnabled(false);
            }
        }

        public /* synthetic */ JListExt(DefaultListModel defaultListModel, 1 var3_3) {
            this(defaultListModel);
        }
    }

    private class MemberListActionListener
    implements ListSelectionListener {
        private MemberListActionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n2 = CreateMembers.this.memList.getAnchorSelectionIndex();
            CreateMembers.this.memUrlList.setSelectedIndex(n2);
            CreateMembers.this.memUrlList.ensureIndexIsVisible(n2);
            if (CreateMembers.this.memModel.size() - 1 < n2) {
                return;
            }
            ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)CreateMembers.this.memModel.get(n2);
            Vector vector = clusterMemberInfo.paramData != null ? clusterMemberInfo.paramData : CreateMembers.this.emptyTable;
            CreateMembers.this.paramModel.setDataVector(vector, ClusterMemberInfo.paramColNames);
        }

        public /* synthetic */ MemberListActionListener(1 var2_2) {
            this();
        }
    }
}

