/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.jms.GSConnectionImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.GSTemporaryTopicImpl;
import com.j_spaces.jms.GSTopicImpl;
import com.j_spaces.jms.GSTopicPublisherImpl;
import com.j_spaces.jms.GSTopicSubscriberImpl;
import com.j_spaces.jms.JMSDurableSubDataEntry;
import com.j_spaces.jms.utils.GSJMSAdmin;
import com.j_spaces.jms.utils.StringsUtils;
import com.j_spaces.kernel.JSpaceUtilities;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public class GSTopicSessionImpl
extends GSSessionImpl
implements TopicSession {
    private HashSet e = new HashSet();
    private static Logger f = Logger.getLogger("com.gigaspaces.jms");

    public GSTopicSessionImpl(GSConnectionImpl gSConnectionImpl, boolean bl2, int n2, Transaction transaction) throws JMSException {
        super(gSConnectionImpl, bl2, n2, transaction);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.createSubscriber(topic, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl2) throws JMSException {
        GSTopicSubscriberImpl gSTopicSubscriberImpl;
        GSTopicSessionImpl gSTopicSessionImpl = this;
        synchronized (gSTopicSessionImpl) {
            this.ensureOpen();
            String string2 = "";
            if (topic != null) {
                string2 = topic.getTopicName();
            }
            if (this.getConn() != null) {
                String string3 = this.getConn().getClientID();
                if (string3.indexOf(":") != -1) {
                    this.getConn().updateClientIDInternally(string3.substring(0, string3.indexOf(":")) + ":" + string2);
                } else {
                    this.getConn().updateClientIDInternally(string3 + ":" + string2);
                }
            }
            gSTopicSubscriberImpl = new GSTopicSubscriberImpl(this, (GSTopicImpl)topic, this.d(), null, string, bl2, this.f());
            this.addSubscriber(gSTopicSubscriberImpl, null);
        }
        return gSTopicSubscriberImpl;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        return this.createDurableSubscriber(topic, string, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl2) throws JMSException {
        GSTopicSubscriberImpl gSTopicSubscriberImpl;
        GSTopicSessionImpl gSTopicSessionImpl = this;
        synchronized (gSTopicSessionImpl) {
            this.ensureOpen();
            if (topic instanceof TemporaryTopic) {
                throw new InvalidDestinationException("Attempt to create a durable subscription for a temporary topic");
            }
            if (string == null || string.trim().length() == 0) {
                throw new JMSException("Null or empty subscription");
            }
            if (this.e.contains(string)) {
                throw new JMSException("A durable subscriber already exists with the name: " + string);
            }
            String string3 = "";
            if (topic != null) {
                string3 = topic.getTopicName();
            }
            GSJMSAdmin gSJMSAdmin = this.getConn().connFacParent.getAdmin();
            Hashtable hashtable = gSJMSAdmin.getDurableSubscriberDetailsFromXML(string3, string);
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (hashtable == null) {
                string4 = this.getConn().getClientID();
                if (string4.indexOf(":") != -1) {
                    this.getConn().updateClientIDInternally(string4.substring(0, string4.indexOf(":")) + ":" + string3);
                } else {
                    this.getConn().updateClientIDInternally(string4 + ":" + string3);
                }
                string5 = this.d();
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                hashtable2.put("clientID", this.getConn().getClientID());
                hashtable2.put("connection-id", this.getConn().getCnxKey());
                hashtable2.put("session-id", this.getSessionID());
                hashtable2.put("durable-topic-name", string3);
                hashtable2.put("durable-subscription-name", string);
                if (f.isLoggable(Level.FINE)) {
                    f.fine("GSTopicSessionImpl.createDurableSubscriber(): updating jms-config.xml about newly subscribed DurableSubscriber details.");
                }
                gSJMSAdmin.addNewDurableSubscriberDetailsIntoXML(hashtable2);
            } else {
                string4 = hashtable.get("clientID").toString();
                string6 = hashtable.get("session-id").toString();
                String string7 = hashtable.get("connection-id").toString();
                this.getConn().setCnxKey(string7);
                this.getConn().updateClientIDInternally(string4);
                this.setSessionID(string6);
                String string8 = string6;
                string5 = JSpaceUtilities.replaceInString(string8, "_sess_", "_cons_", false);
                this.d();
                if (f.isLoggable(Level.FINE)) {
                    f.fine("GSTopicSessionImpl.createDurableSubscriber(): loading existing subscribed DurableSubscriber details from jms-config.xml file.");
                }
            }
            if (f.isLoggable(Level.FINE)) {
                f.fine("GSTopicSessionImpl.createDurableSubscriber(): || sessionID:" + this.getSessionID() + " || consumerID: " + string5 + " || clientID: " + string4);
            }
            this.e.add(string);
            if (!(topic instanceof GSTopicImpl) && f.isLoggable(Level.FINE)) {
                f.fine("GSTopicSessionImpl.createTopicSession(): Invalid JMS Topic of type: " + topic.getClass().getName());
            }
            gSTopicSubscriberImpl = new GSTopicSubscriberImpl(this, (GSTopicImpl)topic, string5, string, string2, bl2, this.f());
            this.addSubscriber(gSTopicSubscriberImpl, string);
        }
        return gSTopicSubscriberImpl;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.ensureOpen();
        GSTemporaryTopicImpl gSTemporaryTopicImpl = new GSTemporaryTopicImpl(this.m_sessionID + ":" + this.getRandomInt(), this.m_sessionID);
        try {
            this.getConn().getConnFacParent().getAdmin().rebindToJNDI(this.getConn().getConnFacParent().getAdmin().getBondedDestPrefixName() + gSTemporaryTopicImpl.toString(), gSTemporaryTopicImpl);
        }
        catch (NamingException namingException) {
            if (f.isLoggable(Level.FINE)) {
                f.log(Level.FINE, "NamingException inside GSTopicSessionImpl.createTemporaryTopic(): " + namingException.toString(), namingException);
            }
            JMSException jMSException = new JMSException("NamingException : ");
            jMSException.setLinkedException(namingException);
            throw jMSException;
        }
        return gSTemporaryTopicImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        GSTopicPublisherImpl gSTopicPublisherImpl;
        GSTopicSessionImpl gSTopicSessionImpl = this;
        synchronized (gSTopicSessionImpl) {
            this.ensureOpen();
            String string = "";
            if (topic != null) {
                string = topic.getTopicName();
            }
            if (this.getConn() != null) {
                String string2 = this.getConn().getClientID();
                this.getConn().updateClientIDInternally(string2 + ":" + string);
            }
            gSTopicPublisherImpl = new GSTopicPublisherImpl((GSSessionImpl)this, (GSTopicImpl)topic, this.e());
            this.addPublisher(gSTopicPublisherImpl);
        }
        return gSTopicPublisherImpl;
    }

    public void addSubscriber(GSTopicSubscriberImpl gSTopicSubscriberImpl, String string) throws JMSException {
        this.addConsumer(gSTopicSubscriberImpl);
    }

    public void addPublisher(GSTopicPublisherImpl gSTopicPublisherImpl) throws JMSException {
        this.addProducer(gSTopicPublisherImpl);
    }

    public void removeSubscriber(GSTopicSubscriberImpl gSTopicSubscriberImpl) throws JMSException {
        if (!this.isClosed()) {
            this.removeConsumer(gSTopicSubscriberImpl);
            if (gSTopicSubscriberImpl.isDurableSubscriber()) {
                this.e.remove(gSTopicSubscriberImpl.getName());
            }
        }
    }

    public void removePublisher(GSTopicPublisherImpl gSTopicPublisherImpl) {
        this.removeProducer(gSTopicPublisherImpl);
    }

    private void a(String string, String string2, String string3) throws JMSException {
        try {
            JMSDurableSubDataEntry jMSDurableSubDataEntry = new JMSDurableSubDataEntry();
            jMSDurableSubDataEntry.m_durableSubscriptionName = string;
            jMSDurableSubDataEntry.m_topicName = string2;
            jMSDurableSubDataEntry.m_subscriberClientID = string3;
            JMSDurableSubDataEntry jMSDurableSubDataEntry2 = new JMSDurableSubDataEntry();
            jMSDurableSubDataEntry2.m_durableSubscriptionName = string;
            jMSDurableSubDataEntry2.m_topicName = string2;
            jMSDurableSubDataEntry2.m_isSubscribed = false;
            jMSDurableSubDataEntry2.m_isSubscriberOnline = false;
            jMSDurableSubDataEntry2.m_subscriberClientID = string3;
            Object[] objectArray = this.a.replace(jMSDurableSubDataEntry, jMSDurableSubDataEntry2, null, Long.MAX_VALUE);
        }
        catch (TransactionException transactionException) {
            if (f.isLoggable(Level.FINE)) {
                f.log(Level.FINE, "TransactionException inside GSTopicSessionImpl.unsubscribeFromTopic(): " + transactionException.toString(), transactionException);
            }
            JMSException jMSException = new JMSException("TransactionException : " + transactionException.getMessage());
            jMSException.setLinkedException(transactionException);
            throw jMSException;
        }
        catch (RemoteException remoteException) {
            if (f.isLoggable(Level.FINE)) {
                f.log(Level.FINE, "RemoteException inside GSTopicSessionImpl.unsubscribeFromTopic(): " + remoteException.toString(), remoteException);
            }
            JMSException jMSException = new JMSException("RemoteException : " + remoteException.getMessage());
            jMSException.setLinkedException(remoteException);
            throw jMSException;
        }
        catch (UnusableEntryException unusableEntryException) {
            if (unusableEntryException instanceof EntryNotInSpaceException) {
                if (f.isLoggable(Level.FINE)) {
                    f.log(Level.FINE, "GSTopicSessionImpl.unsubscribeFromTopic(): The Entry " + ((EntryNotInSpaceException)unusableEntryException).getUID() + " No Longer In Space " + unusableEntryException.getCause(), unusableEntryException);
                }
            }
            JMSException jMSException = new JMSException("UnusableEntryException : ");
            jMSException.setLinkedException(unusableEntryException);
            throw jMSException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String string) throws JMSException {
        GSTopicSessionImpl gSTopicSessionImpl = this;
        synchronized (gSTopicSessionImpl) {
            if (f.isLoggable(Level.FINE)) {
                f.fine("GSTopicSessionImpl.unsubscribe()  unsubscribe from: " + string + " || " + this.toString());
            }
            if (!StringsUtils.isEmpty(string)) {
                if (this.e.contains(string)) {
                    throw new JMSException("Cannot unsubscribe while an active TopicSubscriber still exists with the subscription name: " + string);
                }
            } else {
                throw new InvalidDestinationException("Cannot unsubscribe with a null subscription name.");
            }
            String string2 = this.getConn().getClientID();
            String string3 = string2.substring(string2.lastIndexOf(":") + 1);
            this.a(string, string3, string2);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("clientID", string2);
            hashtable.put("connection-id", this.getConn().getCnxKey());
            hashtable.put("session-id", this.getSessionID());
            hashtable.put("durable-topic-name", string3);
            hashtable.put("durable-subscription-name", string);
            this.getConn().getConnFacParent().getAdmin().unsubscribeDurableSubscriberDetailsFromXML(hashtable);
            this.e.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic createTopic(String string) throws JMSException {
        GSTopicImpl gSTopicImpl;
        GSTopicSessionImpl gSTopicSessionImpl = this;
        synchronized (gSTopicSessionImpl) {
            this.ensureOpen();
            if (StringsUtils.isEmpty(string)) {
                throw new JMSException("Invalid or null topic name specified");
            }
            gSTopicImpl = new GSTopicImpl(string);
        }
        return gSTopicImpl;
    }

    public Queue createQueue(String string) throws JMSException {
        throw new IllegalStateException("Forbidden call on a TopicSession.");
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new IllegalStateException("Forbidden call on a TopicSession.");
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        throw new IllegalStateException("Forbidden call on a TopicSession.");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new IllegalStateException("Forbidden call on a TopicSession.");
    }
}

