/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.NotifyDelegatorMultiplexer;
import com.j_spaces.jms.GSBytesMessageImpl;
import com.j_spaces.jms.GSMapMessageImpl;
import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSObjectMessageImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.GSStreamMessageImpl;
import com.j_spaces.jms.GSTextMessageImpl;
import com.j_spaces.jms.JMSAckDataEntry;
import com.j_spaces.jms.MessagePool;
import com.j_spaces.kernel.lrmi.CompressedMarshObjectConvertor;
import com.j_spaces.kernel.lrmi.MarshObject;
import com.j_spaces.kernel.time.SystemTime;
import com.j_spaces.obf.he;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import net.jini.core.entry.Entry;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.transaction.TransactionException;

public abstract class GSMessageProducerImpl
implements MessageProducer {
    private int a = 2;
    private int b = 4;
    private String c;
    private long d = 0L;
    public GSSessionImpl m_session = null;
    public Destination m_dest = null;
    public String m_destName = "TempDestName";
    private boolean e;
    private volatile boolean f = false;
    public volatile boolean m_started = false;
    private ExternalEntry g;
    private volatile boolean h = false;
    private volatile boolean i = false;
    private String j;
    private String k;
    private transient IJSpace l;
    private NotifyDelegatorMultiplexer m;
    private String n;
    private final int o = 9;
    private he p = null;
    private int q;
    private static Logger r = Logger.getLogger("com.gigaspaces.jms");
    private final ReentrantLock s = new ReentrantLock();
    private final ReentrantLock t = new ReentrantLock();
    private final ReentrantLock u = new ReentrantLock();

    public GSMessageProducerImpl(GSSessionImpl gSSessionImpl, Destination destination, String string) throws JMSException {
        this.m_session = gSSessionImpl;
        if (gSSessionImpl == null) {
            throw new IllegalArgumentException("GSMessageProducerImpl  Argument 'session' is null");
        }
        this.m_dest = destination;
        if (destination != null) {
            this.m_destName = destination.toString();
        } else {
            this.e = true;
        }
        this.j = string;
        this.l = this.m_session.getConn().getSpace();
        this.q = this.m_session.getConn().getCompressionMinSize();
        this.n = "ID:" + this.m_destName + "_" + this.m_session.getConn().getCnxKey() + this.l.getName() + "_m";
        this.k = this.m_session.getConn().getClientID();
        this.p = new he(CompressedMarshObjectConvertor.getFactory(), 0, 100);
        this.g = new ExternalEntry(this.m_destName, MessagePool.externalEntryDefValues, GSMessageImpl.m_ExtEntryFieldsNames, GSMessageImpl.m_ExtEntryFieldsTypes);
        this.g.setFifo(true);
        this.g.setNOWriteLeaseMode(true);
        this.g.setIndexIndicators(MessagePool.extEntryIndexes);
        try {
            if (r.isLoggable(Level.FINE)) {
                r.fine("GSMessageProducerImpl: creating new Ack NotifyDelegator | destName: " + destination + "  |  producerID: " + this.toString());
            }
            if (this.m_session.getAcknowledgeMode() != 1) {
                JMSAckDataEntry jMSAckDataEntry = MessagePool.getAckDataEntry();
                jMSAckDataEntry.m_producerKey = string;
                jMSAckDataEntry.m_destinationNameToBeAcked = this.m_destName;
                this.m = new NotifyDelegatorMultiplexer(this.l);
                this.m.notify(jMSAckDataEntry, null, new AckEventListener(), Long.MAX_VALUE, null, true, 1);
                MessagePool.releaseEntry(jMSAckDataEntry);
            }
        }
        catch (TransactionException transactionException) {
            JMSException jMSException = new JMSException("GSMessageProducerImpl\tTransactionException : " + transactionException.getMessage());
            jMSException.setLinkedException(transactionException);
            throw jMSException;
        }
        catch (RemoteException remoteException) {
            JMSException jMSException = new JMSException("GSMessageProducerImpl\tRemoteException : " + remoteException.getMessage());
            jMSException.setLinkedException(remoteException);
            throw jMSException;
        }
    }

    public void setDisableMessageID(boolean bl2) throws JMSException {
        this.h = bl2;
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.h;
    }

    public void setDisableMessageTimestamp(boolean bl2) throws JMSException {
        this.i = bl2;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.i;
    }

    public void setDeliveryMode(int n2) throws JMSException {
        this.a = n2;
    }

    public int getDeliveryMode() throws JMSException {
        return this.a;
    }

    public void setPriority(int n2) throws JMSException {
        if (n2 < 0 || n2 > 9) {
            throw new JMSException(n2 + " is an invalid priority value");
        }
        this.b = n2;
    }

    public int getPriority() throws JMSException {
        return this.b;
    }

    public void setTimeToLive(long l2) throws JMSException {
        if (l2 < 0L) {
            throw new JMSException(l2 + " is an invalid TimeToLive value");
        }
        this.d = l2;
    }

    public long getTimeToLive() throws JMSException {
        return this.d;
    }

    public Destination getDestination() throws JMSException {
        return this.m_dest;
    }

    private void b() {
        if (this.m != null) {
            this.m.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (r.isLoggable(Level.FINE)) {
            r.fine("GSMessageProducerImpl.close(): " + this.toString());
        }
        this.s.lock();
        try {
            this.b();
        }
        finally {
            this.m_session = null;
            this.f = true;
            this.s.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.t.lock();
        try {
            if (r.isLoggable(Level.FINE)) {
                r.fine("GSMessageProducerImpl.start()  starting MessageProducer: " + this.toString());
            }
            this.m_started = true;
        }
        finally {
            this.t.unlock();
        }
    }

    public void send(Message message) throws JMSException {
        this.send(this.m_dest, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Message message, int n2, int n3, long l2) throws JMSException {
        this.send(this.m_dest, message, n2, n3, l2);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Destination destination, Message message, int n2, int n3, long l2) throws JMSException {
        block16: {
            ExternalEntry externalEntry = null;
            try {
                if (destination == null) {
                    throw new InvalidDestinationException("Can't send message to an unidentified destination.");
                }
                if (n2 != 1 && n2 != 2) {
                    throw new JMSException("Delivery Mode of " + n2 + " is not valid" + " (should be " + 1 + " integer for a Non-Persistent delivery, or " + 2 + " integer for a Persistent delivery).");
                }
                if (0 > n3 || n3 > 9) {
                    throw new JMSException("Message Priority of " + n3 + " is not valid" + " (should be an integer between 0 and 9).");
                }
                this.m_dest = destination;
                this.m_destName = destination.toString();
                externalEntry = this.a((GSMessageImpl)message, n2, n3, l2, destination);
                long l3 = l2;
                if (l2 == 0L) {
                    l3 = Long.MAX_VALUE;
                }
                if (!this.m_session.getTransacted()) {
                    this.l.write(externalEntry, null, l3);
                    ++this.m_session.d;
                    this.g.setFieldsValues(new Object[17]);
                    this.g.m_UID = null;
                } else {
                    this.m_session.a(destination.toString(), externalEntry);
                }
            }
            catch (RemoteException remoteException) {
                if (r.isLoggable(Level.SEVERE)) {
                    r.log(Level.SEVERE, "Exception inside GSMessageProducerImpl.send(: " + remoteException.getMessage(), remoteException);
                }
                JMSException jMSException = new JMSException("RemoteException : " + remoteException.getMessage());
                jMSException.setLinkedException(remoteException);
                throw jMSException;
            }
            catch (TransactionException transactionException) {
                if (r.isLoggable(Level.FINE)) {
                    r.log(Level.FINE, "Exception inside GSMessageProducerImpl.send(: " + transactionException.getMessage(), transactionException);
                }
                JMSException jMSException = new JMSException("TransactionException : " + transactionException.getMessage());
                jMSException.setLinkedException(transactionException);
                throw jMSException;
            }
            catch (Exception exception) {
                if (exception instanceof EntryAlreadyInSpaceException) {
                    if (r.isLoggable(Level.SEVERE)) {
                        r.severe("GSMessageProducerImpl.send() EntryAlreadyInSpaceException extE.m_ClassName: " + externalEntry.m_ClassName + "  |  destination:  " + destination + "  |  extE.m_uid:  " + externalEntry.m_UID);
                    }
                }
                if (r.isLoggable(Level.FINE)) {
                    r.log(Level.FINE, "Exception inside GSMessageProducerImpl.send(): ", exception);
                }
                if (exception instanceof InterruptedException) break block16;
                if (r.isLoggable(Level.FINE)) {
                    r.log(Level.FINE, exception.toString(), exception);
                }
                JMSException jMSException = new JMSException("Exception : " + exception.getMessage());
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MessageProducer | Producer ID: ");
        stringBuffer.append(this.j);
        stringBuffer.append("  |  Session ID: ");
        if (this.m_session == null) {
            stringBuffer.append(" NULL session");
        } else {
            stringBuffer.append(this.m_session.getSessionID());
        }
        return stringBuffer.toString();
    }

    private ExternalEntry a(GSMessageImpl gSMessageImpl, int n2, int n3, long l2, Destination destination) throws JMSException, Exception {
        String string;
        long l3 = 0L;
        if (r.isLoggable(Level.FINE)) {
            l3 = SystemTime.timeMillis();
        }
        String string2 = destination.toString();
        if (this.m_session.getTransacted()) {
            this.g = new ExternalEntry(string2, MessagePool.externalEntryDefValues, GSMessageImpl.m_ExtEntryFieldsNames, GSMessageImpl.m_ExtEntryFieldsTypes);
            this.g.setFifo(true);
            this.g.setNOWriteLeaseMode(true);
            this.g.setIndexIndicators(MessagePool.extEntryIndexes);
        }
        this.g.setClassName(string2);
        if (this.e) {
            this.n = "ID:" + string2 + "_" + this.m_session.getConn().getCnxKey() + this.l.getName() + "_m";
        }
        String string3 = this.m_session.a(this.n);
        gSMessageImpl.setJMSMessageID(string3);
        gSMessageImpl.setJMSDestination(destination);
        if (gSMessageImpl instanceof GSTextMessageImpl) {
            if (gSMessageImpl.m_body_text != null) {
                int n4 = gSMessageImpl.m_body_text.length();
                int n5 = n4 * 2;
                if (n5 > this.q) {
                    if (r.isLoggable(Level.FINE)) {
                        r.fine("GSMessageProducerImpl.prepareExternalEntryFromJMSMessage() compressing the JMS message body (original message size " + n5 + " bytes) " + "compressionMinSize: " + this.q);
                    }
                    MarshObject marshObject = this.a(gSMessageImpl.m_body_text);
                    this.g.m_FieldsValues[0] = marshObject;
                } else {
                    this.g.m_FieldsValues[0] = gSMessageImpl.m_body_text;
                }
            }
            string = "Text";
        } else if (gSMessageImpl instanceof GSMapMessageImpl) {
            this.g.m_FieldsValues[0] = gSMessageImpl.m_body_map;
            string = "Map";
        } else if (gSMessageImpl instanceof GSObjectMessageImpl) {
            this.g.m_FieldsValues[0] = gSMessageImpl.m_body_object;
            string = "Object";
        } else if (gSMessageImpl instanceof GSBytesMessageImpl) {
            this.g.m_FieldsValues[0] = gSMessageImpl.getBodyAsBytes();
            string = "Bytes";
        } else if (gSMessageImpl instanceof GSStreamMessageImpl) {
            this.g.m_FieldsValues[0] = gSMessageImpl.getBodyAsBytes();
            string = "Stream";
        } else {
            string = "Simple";
        }
        this.g.m_FieldsValues[1] = destination;
        this.g.m_FieldsValues[2] = MessagePool.constIntValues[n2];
        Long l4 = new Long(SystemTime.timeMillis());
        long l5 = l4 + l2;
        gSMessageImpl.m_timeToLive = l2;
        gSMessageImpl.setJMSExpiration(l5);
        if (l2 == 0L) {
            this.g.m_FieldsValues[3] = MessagePool.defTTL;
            this.g.m_FieldsValues[12] = MessagePool.defTTL;
        } else {
            this.g.m_FieldsValues[3] = new Long(l5);
            this.g.m_FieldsValues[12] = new Long(l2);
        }
        this.g.m_FieldsValues[4] = MessagePool.constIntValues[n3];
        this.g.m_FieldsValues[5] = string3;
        if (!this.i) {
            this.g.m_FieldsValues[6] = l4;
        }
        if (!gSMessageImpl.m_isCorrelationIDStr && gSMessageImpl.m_correlationIdbytes instanceof byte[]) {
            this.g.m_FieldsValues[7] = gSMessageImpl.getJMSCorrelationIDAsBytes();
        } else if (gSMessageImpl.m_isCorrelationIDStr && gSMessageImpl.m_correlationIdStr instanceof String) {
            this.g.m_FieldsValues[7] = gSMessageImpl.getJMSCorrelationID();
        }
        Destination destination2 = gSMessageImpl.getJMSReplyTo();
        this.g.m_FieldsValues[8] = destination2 != null ? destination2 : destination;
        this.g.m_FieldsValues[9] = string;
        this.g.m_FieldsValues[11] = this.j;
        this.g.m_FieldsValues[15] = this.k;
        this.g.m_FieldsValues[13] = gSMessageImpl.getStringProperty("JMSXGroupID");
        this.g.m_FieldsValues[14] = gSMessageImpl.getObjectProperty("JMSXGroupSeq");
        HashMap hashMap = gSMessageImpl.getProperties();
        if (hashMap != null && !hashMap.isEmpty()) {
            this.g.m_FieldsValues[16] = hashMap;
        }
        if (n2 == 1) {
            this.g.makeTransient();
        } else {
            this.g.makePersistent();
        }
        if (r.isLoggable(Level.FINE)) {
            double d2 = SystemTime.timeMillis() - l3;
            r.fine("GSMessageProducerImpl.prepareExternalEntryFromJMSMessage() prepareTime : " + d2 + " | Destination: " + this.m_dest + " | extEntry TTL: " + this.g.m_TimeToLive + " | Custom Message Properties: " + gSMessageImpl.getProperties() + " | " + gSMessageImpl.toString());
        }
        return this.g;
    }

    public String getProducerID() {
        return this.j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        boolean bl2 = false;
        this.u.lock();
        try {
            bl2 = this.f;
        }
        finally {
            this.u.unlock();
        }
        return bl2;
    }

    public GSSessionImpl getSession() {
        return this.m_session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarshObject a(Object object) throws IOException {
        CompressedMarshObjectConvertor compressedMarshObjectConvertor = null;
        try {
            MarshObject marshObject;
            compressedMarshObjectConvertor = (CompressedMarshObjectConvertor)this.p.a();
            MarshObject marshObject2 = marshObject = compressedMarshObjectConvertor.getMarshObject(object);
            return marshObject2;
        }
        finally {
            if (compressedMarshObjectConvertor != null) {
                this.p.a(compressedMarshObjectConvertor);
            }
        }
    }

    public class AckEventListener
    implements RemoteEventListener {
        public void notify(RemoteEvent remoteEvent) throws UnknownEventException, RemoteException {
            block3: {
                try {
                    Entry entry = ((EntryArrivedRemoteEvent)remoteEvent).getEntry(false);
                    if (entry instanceof JMSAckDataEntry) {
                        JMSAckDataEntry jMSAckDataEntry = (JMSAckDataEntry)entry;
                        String string = jMSAckDataEntry.m_producerKey;
                        String string2 = jMSAckDataEntry.m_destinationNameToBeAcked;
                        if (string.hashCode() == GSMessageProducerImpl.this.getProducerID().hashCode() && !string2.equalsIgnoreCase(GSMessageProducerImpl.this.m_dest.toString())) break block3;
                    }
                    return;
                }
                catch (Exception exception) {
                    if (!r.isLoggable(Level.FINE)) break block3;
                    r.log(Level.FINE, "AckEventListener.notify() |   exception while processing the received message: " + exception.toString(), exception);
                }
            }
        }
    }
}

