/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.SecurityContext;
import com.j_spaces.core.SpaceSecurityException;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.LocalTransactionManager;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.jdbc.ParserManager;
import com.j_spaces.jms.GSConnectionImpl;
import com.j_spaces.jms.GSQueueConnectionImpl;
import com.j_spaces.jms.GSTopicConnectionImpl;
import com.j_spaces.jms.GSXAQueueConnectionImpl;
import com.j_spaces.jms.GSXATopicConnectionImpl;
import com.j_spaces.jms.utils.GSJMSAdmin;
import com.j_spaces.jms.utils.StringsUtils;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import net.jini.core.transaction.server.TransactionManager;

public abstract class GSConnectionFactoryImpl
implements ConnectionFactory,
XAConnectionFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    public volatile int cnxC = 0;
    public static String ID_SUFFIX;
    private GSJMSAdmin admin;
    private static TransactionManager ltm;
    private IJSpace m_space;
    private String m_spaceName;
    private ParserManager m_parserManager;
    private String m_spaceURL;
    public static final int QUEUE_CONNECTION_FAC = 1;
    public static final int TOPIC_CONNECTION_FAC = 2;
    public static final int XAQUEUE_CONNECTION_FAC = 3;
    public static final int XATOPIC_CONNECTION_FAC = 4;
    public int m_connectionFactoryType = 1;
    public boolean m_initializedServices;
    public static final String AUTH_DEF_ANONYMOUSE_NAME = "anonymous";
    public static Random random;
    private static Logger _logger;
    private Hashtable connectionsHash;

    public GSConnectionFactoryImpl(String string, int n2, IJSpace iJSpace) throws JMSException {
        this.m_spaceURL = string;
        this.m_connectionFactoryType = n2;
        this.m_space = iJSpace;
        if (null != iJSpace) {
            this.m_spaceName = iJSpace.getName();
        }
        if (this.connectionsHash == null) {
            this.connectionsHash = new Hashtable();
        }
    }

    public final String getSpaceName() {
        return this.m_spaceName;
    }

    public ParserManager getParserManager() {
        return this.m_parserManager;
    }

    private void createParserManagerInstance() {
        if (this.m_parserManager == null) {
            this.m_parserManager = ParserManager.getInstance();
        }
    }

    public final IJSpace getSpace() {
        return this.m_space;
    }

    private void findSpaceProxy() throws JMSException {
        try {
            this.m_space = (IJSpace)SpaceFinder.find(this.m_spaceURL);
            this.m_spaceName = this.m_space.getName();
            this.m_space.setNOWriteLeaseMode(true);
            this.m_space.setFifo(true);
        }
        catch (FinderException finderException) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "exception inside GSConnectionFactoryImpl.findSpaceProxy() using url: " + this.m_spaceURL + " : " + finderException.toString(), finderException);
            }
            JMSException jMSException = new JMSException("FinderException : " + finderException.getMessage());
            jMSException.setLinkedException(finderException);
            throw jMSException;
        }
        catch (SpaceSecurityException spaceSecurityException) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "exception inside GSConnectionFactoryImpl.findSpaceProxy() using url: " + this.m_spaceURL + " : " + spaceSecurityException.toString(), spaceSecurityException);
            }
            JMSSecurityException jMSSecurityException = new JMSSecurityException("SpaceSecurityException : " + spaceSecurityException.getMessage());
            jMSSecurityException.setLinkedException(spaceSecurityException);
            throw jMSSecurityException;
        }
        if (this.m_space != null && _logger.isLoggable(Level.FINE)) {
            _logger.fine("GSConnectionFactoryImpl.findSpaceProxy() space name: " + this.m_spaceName + " | spaceProxy: " + this.m_space + "\n\t| spaceProxy isSecured: " + this.m_space.isSecured() + "\t| spaceProxy isEmbedded: " + this.m_space.isEmbedded() + "\t| spaceProxy isFifo: " + this.m_space.isFifo() + "\t| spaceProxy isNOWriteLeaseMode: " + this.m_space.isNOWriteLeaseMode());
            try {
                _logger.fine("GSConnectionFactoryImpl.findSpaceProxy() space attributes: \n" + this.m_space.getContainer().getSpaceAttributes(this.m_spaceName));
            }
            catch (RemoteException remoteException) {
                _logger.log(Level.FINE, remoteException.toString(), remoteException);
            }
            catch (NoSuchNameException noSuchNameException) {
                _logger.log(Level.FINE, noSuchNameException.toString(), noSuchNameException);
            }
        }
    }

    public void setSpaceSecurityContext(String string, String string2) throws JMSSecurityException, JMSException {
        try {
            if (string.equalsIgnoreCase(AUTH_DEF_ANONYMOUSE_NAME) && string2.equalsIgnoreCase(AUTH_DEF_ANONYMOUSE_NAME)) {
                return;
            }
            if (!this.m_space.isSecured()) {
                throw new JMSSecurityException("The space < " + this.m_spaceName + " > must be defined as a Secured Space.");
            }
            this.m_space.setSecurityContext(new SecurityContext(string, string2));
        }
        catch (SpaceSecurityException spaceSecurityException) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "exception inside setSpaceSecurityContext(user,pass): " + spaceSecurityException.toString(), spaceSecurityException);
            }
            JMSSecurityException jMSSecurityException = new JMSSecurityException("SpaceSecurityException : " + spaceSecurityException.getMessage());
            jMSSecurityException.setLinkedException(spaceSecurityException);
            throw jMSSecurityException;
        }
        catch (RemoteException remoteException) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "exception inside setSpaceSecurityContext(user,pass): " + remoteException.toString(), remoteException);
            }
            JMSException jMSException = new JMSException("RemoteException : " + remoteException.getMessage());
            jMSException.setLinkedException(remoteException);
            throw jMSException;
        }
    }

    private boolean isSpaceSecured() {
        return this.m_space.isSecured();
    }

    public boolean pingSpace() {
        try {
            this.m_space.ping();
        }
        catch (RemoteException remoteException) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "GSConnectionFactoryImpl.pingSpace() | Lost connection to the m_space < " + this.m_space.getName() + " > \t\t " + remoteException.toString(), remoteException);
            }
            return false;
        }
        return true;
    }

    public void initializeConnFactoryServices(String string, GSJMSAdmin gSJMSAdmin) throws JMSException {
        if (!StringsUtils.isEmpty(string)) {
            this.m_spaceURL = string;
        }
        this.admin = gSJMSAdmin;
        this.findSpaceProxy();
        this.m_initializedServices = true;
    }

    public String getSpaceURL() {
        return this.m_spaceURL;
    }

    public Connection createConnection() throws JMSException {
        if (!this.m_initializedServices) {
            this.admin = this.getAdmin();
            if (!StringsUtils.isEmpty(this.admin.getOverwrittenConnFacSpaceURL())) {
                this.m_spaceURL = this.admin.getOverwrittenConnFacSpaceURL();
            }
            this.initializeConnFactoryServices(this.m_spaceURL, this.admin);
        }
        GSConnectionImpl gSConnectionImpl = null;
        this.createLocalTransactionManager();
        this.createParserManagerInstance();
        switch (this.m_connectionFactoryType) {
            case 1: {
                gSConnectionImpl = new GSQueueConnectionImpl(this);
                break;
            }
            case 2: {
                gSConnectionImpl = new GSTopicConnectionImpl(this);
                break;
            }
            case 3: {
                gSConnectionImpl = new GSXAQueueConnectionImpl(this);
                break;
            }
            case 4: {
                gSConnectionImpl = new GSXATopicConnectionImpl(this);
                break;
            }
            default: {
                gSConnectionImpl = new GSQueueConnectionImpl(this);
            }
        }
        String string = this.nextCnxKey();
        ((GSConnectionImpl)gSConnectionImpl).setCnxKey(string);
        ((GSConnectionImpl)gSConnectionImpl).updateClientIDInternally(string + "_" + this.m_spaceName);
        this.addConnection(gSConnectionImpl);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSConnectionFactoryImpl.createConnection() connKey: " + string);
        }
        return gSConnectionImpl;
    }

    public Connection createConnection(String string, String string2) throws JMSException {
        if (!this.m_initializedServices) {
            this.admin = this.getAdmin();
            if (!StringsUtils.isEmpty(this.admin.getOverwrittenConnFacSpaceURL())) {
                this.m_spaceURL = this.admin.getOverwrittenConnFacSpaceURL();
            }
            this.initializeConnFactoryServices(this.m_spaceURL, this.admin);
        }
        if (string == null) {
            throw new JMSSecurityException("Unauthenicated Username- Username must not be null");
        }
        if (string2 == null) {
            throw new JMSSecurityException("Unauthenicated Password- Password must not be null");
        }
        this.setSpaceSecurityContext(string, string2);
        return this.createConnection();
    }

    public XAConnection createXAConnection() throws JMSException {
        if (!this.m_initializedServices) {
            this.admin = this.getAdmin();
            if (!StringsUtils.isEmpty(this.admin.getOverwrittenConnFacSpaceURL())) {
                this.m_spaceURL = this.admin.getOverwrittenConnFacSpaceURL();
            }
            this.initializeConnFactoryServices(this.m_spaceURL, this.admin);
        }
        GSConnectionImpl gSConnectionImpl = null;
        this.createLocalTransactionManager();
        this.createParserManagerInstance();
        switch (this.m_connectionFactoryType) {
            case 3: {
                gSConnectionImpl = new GSXAQueueConnectionImpl(this);
                break;
            }
            case 4: {
                gSConnectionImpl = new GSXATopicConnectionImpl(this);
                break;
            }
            default: {
                gSConnectionImpl = new GSXAQueueConnectionImpl(this);
            }
        }
        String string = this.nextCnxKey();
        if (gSConnectionImpl instanceof GSXATopicConnectionImpl) {
            ((GSXATopicConnectionImpl)gSConnectionImpl).setCnxKey(string);
            ((GSXATopicConnectionImpl)gSConnectionImpl).updateClientIDInternally(string + "_" + this.m_spaceName);
        } else if (gSConnectionImpl instanceof GSXAQueueConnectionImpl) {
            gSConnectionImpl.setCnxKey(string);
            ((GSXAQueueConnectionImpl)gSConnectionImpl).updateClientIDInternally(string + "_" + this.m_spaceName);
        }
        this.addConnection(gSConnectionImpl);
        return gSConnectionImpl;
    }

    public XAConnection createXAConnection(String string, String string2) throws JMSException {
        if (string == null) {
            throw new JMSSecurityException("Unauthenticated Username- Username must not be null");
        }
        if (string2 == null) {
            throw new JMSSecurityException("Unauthenticated Password- Password must not be null");
        }
        this.setSpaceSecurityContext(string, string2);
        return this.createXAConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextCnxKey() {
        String string = null;
        GSConnectionFactoryImpl gSConnectionFactoryImpl = this;
        synchronized (gSConnectionFactoryImpl) {
            if (this.cnxC == Integer.MAX_VALUE) {
                this.cnxC = 0;
            }
            ++this.cnxC;
            int n2 = Math.abs(random.nextInt());
            switch (this.m_connectionFactoryType) {
                case 1: {
                    string = "qc" + this.cnxC + n2 + "_" + ID_SUFFIX;
                    break;
                }
                case 2: {
                    string = "tc" + this.cnxC + n2 + "_" + ID_SUFFIX;
                    break;
                }
                case 3: {
                    string = "xaqc" + this.cnxC + n2 + "_" + ID_SUFFIX;
                    break;
                }
                case 4: {
                    string = "xatc" + this.cnxC + n2 + "_" + ID_SUFFIX;
                }
            }
        }
        return string;
    }

    public int getCnxCounter() {
        return this.cnxC;
    }

    public GSJMSAdmin getAdmin() throws JMSException {
        if (this.admin == null) {
            this.admin = GSJMSAdmin.getInstance();
        }
        return this.admin;
    }

    public TransactionManager getLocalTransactionManager() {
        return ltm;
    }

    private void createLocalTransactionManager() throws JMSException {
        try {
            if (ltm == null) {
                ltm = LocalTransactionManager.getInstance(this.m_space);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSConnectionFactoryImpl.createLocalTransactionManager() LocalTransactionManager: " + ltm.toString() + "\t| spaceProxy: " + ((LocalTransactionManager)ltm).getProxy().toString() + "\t| spaceProxy name: " + ((LocalTransactionManager)ltm).getProxy().getName());
            }
        }
        catch (RemoteException remoteException) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.FINE, "Exception inside GSConnectionFactoryImpl.createLocalTransactionManager() : " + remoteException.toString(), remoteException);
            }
            JMSException jMSException = new JMSException("RemoteException: " + remoteException.getMessage());
            jMSException.setLinkedException(remoteException);
            throw jMSException;
        }
    }

    public Connection getConnection(String string) {
        Object v2 = this.connectionsHash.get(string);
        Connection connection = null;
        if (v2 != null) {
            connection = (Connection)v2;
        }
        return connection;
    }

    public void addConnection(Connection connection) throws JMSException {
        if (connection instanceof GSConnectionImpl) {
            this.connectionsHash.put(((GSConnectionImpl)connection).connFacParent.getSpaceURL(), connection);
        }
    }

    public void removeConnection(GSConnectionImpl gSConnectionImpl) {
        this.connectionsHash.remove(gSConnectionImpl.connFacParent.getSpaceURL());
        gSConnectionImpl = null;
    }

    public boolean isConnManaged(GSConnectionImpl gSConnectionImpl) {
        return this.connectionsHash.contains(gSConnectionImpl);
    }

    public Enumeration getManagedConnections() {
        return this.connectionsHash.elements();
    }

    public static TransactionManager getTransactionManager() {
        return ltm;
    }

    static {
        random = new Random();
        _logger = Logger.getLogger("com.gigaspaces.jms");
        InetAddress inetAddress = null;
        String string = "127.0.0.1";
        try {
            inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string = "127.0.0.1";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.insert(0, stringTokenizer.nextToken());
        }
        ID_SUFFIX = stringBuffer.toString();
    }
}

