/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.j_spaces.jdbc.driver.BlobOutputStream;
import com.j_spaces.jdbc.driver.ObjectWithUID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;

public class Blob
extends ObjectWithUID
implements java.sql.Blob,
Comparable {
    public byte[] blob;
    public transient Connection conn;

    public Blob(byte[] byArray, Connection connection) throws SQLException {
        if (byArray == null) {
            throw new SQLException("Blob cannot hold null data", "GSP", -131);
        }
        this.blob = byArray;
        this.conn = connection;
    }

    public Blob(byte[] byArray) {
        this.blob = byArray;
    }

    public long length() throws SQLException {
        return this.blob.length;
    }

    public void truncate(long l2) throws SQLException {
        throw new SQLException("Command not supported!", "GSP", -132);
    }

    public byte[] getBytes(long l2, int n2) throws SQLException {
        if (l2 < 1L || n2 < 1) {
            throw new SQLException("Both parameters should be greater than 1", "GSP", -133);
        }
        if (l2 + (long)n2 > (long)(this.blob.length + 1)) {
            n2 = this.blob.length - (int)l2 + 1;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.blob, (int)l2 - 1, byArray, 0, n2);
        return byArray;
    }

    public int setBytes(long l2, byte[] byArray) throws SQLException {
        throw new SQLException("Command not supported!", "GSP", -132);
    }

    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        throw new SQLException("Command not supported!", "GSP", -132);
    }

    public long position(byte[] byArray, long l2) throws SQLException {
        boolean bl2 = false;
        while (!bl2) {
            if ((long)byArray.length + l2 > (long)(this.blob.length + 1)) {
                return -1L;
            }
            bl2 = true;
            for (int i2 = 0; i2 <= byArray.length; ++i2) {
                if (byArray[i2] == this.blob[i2 + (int)l2 - 1]) continue;
                bl2 = false;
                break;
            }
            if (bl2) continue;
            ++l2;
        }
        return l2;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.blob);
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(0L);
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        return new BlobOutputStream(this, (int)l2);
    }

    public long position(java.sql.Blob blob, long l2) throws SQLException {
        Blob blob2 = (Blob)blob;
        return this.position(blob2.blob, l2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Blob)) {
            return false;
        }
        Blob blob = (Blob)object;
        if (blob.blob.length != this.blob.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.blob.length; ++i2) {
            if (this.blob[i2] == blob.blob[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.blob.length; ++i2) {
            n2 += this.blob[i2];
        }
        return n2;
    }

    public int compareTo(Object object) throws ClassCastException {
        return this.hashCode() - ((Blob)object).hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("BLOB[");
        for (int i2 = 0; i2 < this.blob.length; ++i2) {
            stringBuffer.append(this.blob[i2]);
            stringBuffer.append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void setConnection(Connection connection) {
        this.conn = connection;
    }
}

