/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.LocalTransactionManager;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.jdbc.QPConstants;
import com.j_spaces.jdbc.QueryHandler;
import com.j_spaces.jdbc.RequestPacket;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.SocketSession;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class QueryProcessor
implements Runnable {
    private int b;
    private int c;
    private ServerSocket d;
    public IJSpace spaceCluster;
    public IJSpace spaceRegular;
    private ExecutorService e;
    private int f;
    private HashMap g;
    private Hashtable h;
    private LocalTransactionManager i;
    public static boolean JMX_ON;
    public static boolean TRACE_EXEC_TIME;
    public static boolean AUTO_COMMIT;
    public static MBeanServer jmxServer;
    private static int j;
    private static QueryProcessor k;
    private Object l;
    public static boolean a;
    private boolean m;
    private Thread n;
    private Selector o;
    private static Logger p;

    public QueryProcessor(Properties properties, boolean bl2) {
        this.b = 64;
        this.c = 4;
        this.e = null;
        this.i = null;
        this.l = new Object();
        this.m = true;
        this.o = null;
        this.initQP(properties, bl2);
    }

    public QueryProcessor(IJSpace iJSpace, IJSpace iJSpace2, boolean bl2) {
        this(iJSpace, iJSpace2, bl2, 0);
    }

    public QueryProcessor(IJSpace iJSpace, IJSpace iJSpace2, boolean bl2, int n2) {
        block5: {
            this.b = 64;
            this.c = 4;
            this.e = null;
            this.i = null;
            this.l = new Object();
            this.m = true;
            this.o = null;
            try {
                if (n2 != 0) {
                    this.f = n2;
                }
                this.e = Executors.newFixedThreadPool((int)this.b);
                this.spaceCluster = iJSpace;
                this.spaceRegular = iJSpace2;
                IJSpace iJSpace3 = iJSpace != null ? iJSpace : iJSpace2;
                this.i = (LocalTransactionManager)LocalTransactionManager.getInstance(iJSpace3);
                this.g = new HashMap();
                this.h = new Hashtable();
                SpaceConfig spaceConfig = ((IRemoteJSpaceAdmin)iJSpace2.getAdmin()).getConfig();
                this.b = spaceConfig.getQpMaxJDBCClientConnections();
                this.c = spaceConfig.getQpMinJDBCClientConnections();
                QPConstants.SPACE_READ_LEASE = spaceConfig.getQpSpaceReadLeaseTime();
                QPConstants.SPACE_WRITE_LEASE = spaceConfig.getQpSpaceWriteLeaseTime();
                QPConstants.TRANSACTION_TIMEOUT = spaceConfig.getQpTransactionTimeout();
                QPConstants.PARSER_CASE_SENSETIVITY = spaceConfig.isQPParserCaseSensetivity();
                AUTO_COMMIT = spaceConfig.isQPAutoCommit();
                JMX_ON = spaceConfig.isQPInitJMX();
                TRACE_EXEC_TIME = spaceConfig.isQPTraceExecTime();
                j = QPConstants.JMX_PORT;
                QPConstants.DATE_FORMAT = spaceConfig.getQpDateFormat();
                QPConstants.DATETIME_FORMAT = spaceConfig.getQpDateTimeFormat();
                QPConstants.TIME_FORMAT = spaceConfig.getQpTimeFormat();
                if (!bl2) {
                    this.a();
                } else {
                    this.n = new Thread(this);
                    this.n.start();
                }
            }
            catch (Exception exception) {
                if (!p.isLoggable(Level.SEVERE)) break block5;
                p.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    public QueryProcessor(String string, boolean bl2) {
        this.b = 64;
        this.c = 4;
        this.e = null;
        this.i = null;
        this.l = new Object();
        this.m = true;
        this.o = null;
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            this.initQP(properties, bl2);
            fileInputStream.close();
        }
        catch (Exception exception) {
            if (p.isLoggable(Level.SEVERE)) {
                p.log(Level.SEVERE, "Error initiating program....Exiting.", exception);
            }
            System.exit(-1);
        }
    }

    public static QueryProcessor getQpInstance(IJSpace iJSpace, Properties properties, String string, boolean bl2) {
        if (k == null) {
            if (iJSpace != null) {
                k = new QueryProcessor(null, iJSpace, bl2);
            } else if (properties != null) {
                k = new QueryProcessor(properties, bl2);
            } else if (string != null) {
                k = new QueryProcessor(string, bl2);
            }
        }
        return k;
    }

    public void initQP(Properties properties, boolean bl2) {
        try {
            this.b = Integer.parseInt(properties.getProperty("MAX_CONNECTIONS"));
            this.c = Integer.parseInt(properties.getProperty("MIN_CONNECTIONS"));
            QPConstants.SPACE_READ_LEASE = Integer.parseInt(properties.getProperty("SPACE_READ_LEASE_TIME"));
            QPConstants.SPACE_WRITE_LEASE = Long.parseLong(properties.getProperty("SPACE_WRITE_LEASE"));
            QPConstants.TRANSACTION_TIMEOUT = Long.parseLong(properties.getProperty("TRANSACTION_TIMEOUT"));
            QPConstants.PARSER_CASE_SENSETIVITY = Boolean.valueOf(properties.getProperty("PARSER_CASE_SENSETIVITY"));
            this.f = Integer.parseInt(properties.getProperty("PORT", "2872"));
            String string = properties.getProperty("SPACE_URL");
            AUTO_COMMIT = Boolean.valueOf(properties.getProperty("AUTO_COMMIT", "true"));
            JMX_ON = Boolean.valueOf(properties.getProperty("INIT_JMX"));
            TRACE_EXEC_TIME = Boolean.valueOf(properties.getProperty("TRACE_EXEC_TIME"));
            j = Integer.parseInt(properties.getProperty("JMX_PORT", "8889"));
            QPConstants.DATE_FORMAT = properties.getProperty("QueryProcessor.date_format");
            QPConstants.DATETIME_FORMAT = properties.getProperty("QueryProcessor.datetime_format");
            QPConstants.TIME_FORMAT = properties.getProperty("QueryProcessor.time_format");
            jmxServer = JMX_ON ? this.b() : null;
            if (this.c > this.b) {
                throw new IllegalArgumentException("invalid parameters. min cannot be higher then max!");
            }
            this.e = Executors.newFixedThreadPool((int)this.b);
            this.spaceRegular = (IJSpace)SpaceFinder.find(string);
            this.i = (LocalTransactionManager)LocalTransactionManager.getInstance(this.spaceRegular);
            this.g = new HashMap();
            this.h = new Hashtable();
            if (!bl2) {
                this.a();
            } else {
                this.n = new Thread(this);
                this.n.start();
            }
        }
        catch (Exception exception) {
            if (p.isLoggable(Level.SEVERE)) {
                p.log(Level.SEVERE, "Error initiating program....Exiting.", exception);
            }
            System.exit(-1);
        }
    }

    public void run() {
        block2: {
            try {
                this.a();
            }
            catch (IOException iOException) {
                if (!p.isLoggable(Level.SEVERE)) break block2;
                p.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() throws IOException {
        ServerSocketChannel serverSocketChannel = null;
        try {
            this.o = Selector.open();
            serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.f);
            this.d = serverSocketChannel.socket();
            this.d.bind(inetSocketAddress);
            this.unblock();
            serverSocketChannel.register(this.o, 16);
            if (p.isLoggable(Level.FINE)) {
                p.fine("GigaSpaces query processor listener started!");
            }
            while (this.m && !Thread.currentThread().isInterrupted()) {
                int n2 = this.o.select(2000L);
                if (n2 <= 0) continue;
                Set<SelectionKey> set = this.o.selectedKeys();
                Iterator<SelectionKey> iterator = set.iterator();
                ByteBuffer byteBuffer = ByteBuffer.allocate(40000);
                while (iterator.hasNext()) {
                    SocketChannel socketChannel;
                    SelectionKey selectionKey = iterator.next();
                    int n3 = selectionKey.readyOps();
                    if ((n3 & 0x10) == 16) {
                        socketChannel = serverSocketChannel.accept();
                        socketChannel.configureBlocking(false);
                        socketChannel.register(this.o, 1);
                        this.g.put(socketChannel, new SocketSession(this.i));
                        iterator.remove();
                        continue;
                    }
                    if ((n3 & 1) != 1) continue;
                    socketChannel = (SocketChannel)selectionKey.channel();
                    iterator.remove();
                    SocketSession socketSession = (SocketSession)this.g.get(socketChannel);
                    if (socketSession == null) {
                        if (!p.isLoggable(Level.INFO)) continue;
                        p.info("QueryProcessor: Invalid session for " + socketChannel.socket());
                        continue;
                    }
                    RequestPacket requestPacket = null;
                    byteBuffer.clear();
                    int n4 = 0;
                    try {
                        n4 = socketChannel.read(byteBuffer);
                    }
                    catch (IOException iOException) {
                        if (p.isLoggable(Level.FINE)) {
                            p.fine("QueryProcessor: Client closed socket unexpectedly. closing channel");
                        }
                        socketChannel.close();
                        continue;
                    }
                    if (n4 > 0) {
                        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteBuffer.array()));
                        requestPacket = (RequestPacket)objectInputStream.readObject();
                        socketSession.addPacket(requestPacket);
                        SocketSession socketSession2 = socketSession;
                        synchronized (socketSession2) {
                            if (!socketSession.isCurrentlyHandled()) {
                                socketSession.setCurrentlyHandled(true);
                                this.e.execute((Runnable)new QueryHandler(socketChannel, socketSession, this.spaceCluster, this.spaceRegular, this.h));
                            }
                        }
                    }
                    if (n4 >= 0) continue;
                    if (p.isLoggable(Level.FINE)) {
                        p.fine("QueryProcessor: Closing socket");
                    }
                    this.g.remove(socketChannel);
                    socketChannel.close();
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (p.isLoggable(Level.SEVERE)) {
                p.log(Level.SEVERE, classNotFoundException.getMessage(), classNotFoundException);
            }
        }
        catch (IOException iOException) {
            if (p.isLoggable(Level.SEVERE)) {
                p.log(Level.SEVERE, "Error occurred while opening Server Socket", iOException);
            }
        }
        catch (RuntimeException runtimeException) {
            if (p.isLoggable(Level.SEVERE)) {
                p.log(Level.SEVERE, runtimeException.getMessage(), runtimeException);
            }
        }
        finally {
            if (this.d != null) {
                this.d.close();
            }
            if (this.o != null) {
                this.o.close();
            }
            if (serverSocketChannel != null) {
                serverSocketChannel.close();
            }
            if (p.isLoggable(Level.FINE)) {
                p.fine("GigaSpaces query processor listener stopped!");
            }
        }
    }

    public synchronized ResponsePacket handleEmbeddedRequest(RequestPacket requestPacket, SocketSession socketSession) {
        QueryHandler queryHandler = new QueryHandler(null, socketSession, this.spaceCluster, this.spaceRegular, this.h);
        return queryHandler.handleEmbeddedRequests(requestPacket);
    }

    public synchronized SocketSession createLocalSession() {
        return new SocketSession(this.i);
    }

    public synchronized void closeLocalSession(SocketSession socketSession) {
        socketSession.closeSession();
    }

    private MBeanServer b() throws Exception {
        MBeanServer mBeanServer = MBeanServerFactory.createMBeanServer();
        HtmlAdaptorServer htmlAdaptorServer = new HtmlAdaptorServer(j);
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("Adaptor:name=html,port=8889");
            mBeanServer.registerMBean(htmlAdaptorServer, objectName);
        }
        catch (Exception exception) {
            if (p.isLoggable(Level.SEVERE)) {
                p.log(Level.SEVERE, "\t!QueryProcessor: Could not create the HTML adaptor !", exception);
            }
            throw exception;
        }
        htmlAdaptorServer.start();
        return mBeanServer;
    }

    public ServerSocket getSocket() {
        return this.d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block() throws InterruptedException {
        Object object = this.l;
        synchronized (object) {
            if (a) {
                this.l.wait();
            }
            a = true;
        }
    }

    public void stopQp() {
        block14: {
            block13: {
                block12: {
                    this.m = false;
                    try {
                        if (this.e != null) {
                            this.e.shutdown();
                        }
                    }
                    catch (SecurityException securityException) {
                        if (!p.isLoggable(Level.SEVERE)) break block12;
                        p.log(Level.SEVERE, "security manager did not permit shutdown of this service. " + securityException.getMessage(), securityException);
                    }
                }
                if (this.n != null) {
                    try {
                        this.o.close();
                        this.n.join();
                    }
                    catch (InterruptedException interruptedException) {
                        if (p.isLoggable(Level.FINEST)) {
                            p.log(Level.FINEST, Thread.currentThread().getName() + " interrupted.", interruptedException);
                        }
                        Thread.currentThread().interrupt();
                    }
                    catch (IOException iOException) {
                        if (!p.isLoggable(Level.SEVERE)) break block13;
                        p.log(Level.SEVERE, iOException.getMessage(), iOException);
                    }
                }
            }
            if (this.d != null) {
                try {
                    this.d.close();
                }
                catch (IOException iOException) {
                    if (!p.isLoggable(Level.SEVERE)) break block14;
                    p.log(Level.SEVERE, iOException.getMessage(), iOException);
                }
            }
        }
        if (this.h != null) {
            this.h.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock() {
        Object object = this.l;
        synchronized (object) {
            this.l.notify();
            a = false;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            if (p.isLoggable(Level.INFO)) {
                p.info("Usage: QueryProcessor <property file>");
            }
            System.exit(-1);
        }
        QueryProcessor queryProcessor = new QueryProcessor(stringArray[0], false);
    }

    static {
        a = true;
        p = Logger.getLogger("com.gigaspaces.persistent");
    }
}

