/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jca;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.NotifyDelegator;
import com.j_spaces.jca.GSConnection;
import com.j_spaces.jca.GSInteractionSpec;
import com.j_spaces.jca.GSManagedConnection;
import com.j_spaces.jca.GSRecordEntry;
import java.rmi.RemoteException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public class JSInteraction
implements Interaction {
    private final GSConnection a;
    public static final String TAKE_OPERATION = "TAKE";
    public static final String NOTIFY_OPERATION = "NOTIFY";
    public static final String WRITE_OPERATION = "WRITE";
    public static final String READ_OPERATION = "READ";
    public static final String SNAPSHOT_OPERATION = "SNAPSHOT";
    public static final String CLEAR_OPERATION = "CLEAR";
    public static final String CLEAN_OPERATION = "CLEAN";
    public static final String COUNT_OPERATION = "COUNT";
    public static final String INSTANCE_COUNT_OPERATION = "INSTANCE_COUNT";
    public static final String EXCEPTIONTYPE_TX = "EXCEPTIONTYPE_TX";
    public static final String EXCEPTIONTYPE_REMOTEEXCEPTION = "EXCEPTIONTYPE_REMOTEEXCEPTION";

    public JSInteraction(GSConnection gSConnection) {
        this.a = gSConnection;
    }

    public void clearWarnings() throws ResourceException {
    }

    public ResourceWarning getWarnings() throws ResourceException {
        return null;
    }

    public String getSpaceURL() throws ResourceException {
        GSManagedConnection gSManagedConnection = this.getGSConnection().getManagedConnection();
        return gSManagedConnection.getJavaSpaceURL();
    }

    public void close() throws ResourceException {
    }

    public Record execute(InteractionSpec interactionSpec, Record record) throws ResourceException {
        if (!(interactionSpec instanceof GSInteractionSpec)) {
            throw new IllegalArgumentException("You must use a GSInteractionSpec! " + interactionSpec);
        }
        if (!(record instanceof GSRecordEntry)) {
            throw new IllegalArgumentException("You must use a GSRecordEntry! " + record);
        }
        GSInteractionSpec gSInteractionSpec = (GSInteractionSpec)interactionSpec;
        GSRecordEntry gSRecordEntry = (GSRecordEntry)record;
        if (gSInteractionSpec.getFunctionName().equals(WRITE_OPERATION)) {
            Lease lease = this.write(gSRecordEntry.getEntry(), gSRecordEntry.getTimeout());
            GSRecordEntry gSRecordEntry2 = new GSRecordEntry();
            gSRecordEntry2.setLease(lease);
            return gSRecordEntry2;
        }
        if (gSInteractionSpec.getFunctionName().equals(READ_OPERATION)) {
            Entry entry = this.read(gSRecordEntry.getEntry(), gSRecordEntry.getTimeout());
            GSRecordEntry gSRecordEntry3 = new GSRecordEntry();
            gSRecordEntry3.setEntry(entry);
            return gSRecordEntry3;
        }
        if (gSInteractionSpec.getFunctionName().equals(SNAPSHOT_OPERATION)) {
            Entry entry = this.snapshot(gSRecordEntry.getEntry());
            GSRecordEntry gSRecordEntry4 = new GSRecordEntry();
            gSRecordEntry4.setEntry(entry);
            return gSRecordEntry4;
        }
        if (gSInteractionSpec.getFunctionName().equals(NOTIFY_OPERATION)) {
            EventRegistration eventRegistration = this.notify(gSRecordEntry.getEntry(), gSRecordEntry.getListener());
            GSRecordEntry gSRecordEntry5 = new GSRecordEntry();
            gSRecordEntry5.setEventRegistration(eventRegistration);
            return gSRecordEntry5;
        }
        if (gSInteractionSpec.getFunctionName().equals(TAKE_OPERATION)) {
            Entry entry = this.take(gSRecordEntry.getEntry(), gSRecordEntry.getTimeout());
            GSRecordEntry gSRecordEntry6 = new GSRecordEntry();
            gSRecordEntry6.setEntry(entry);
            return gSRecordEntry6;
        }
        if (gSInteractionSpec.getFunctionName().equals(CLEAN_OPERATION)) {
            this.clean();
            return null;
        }
        if (gSInteractionSpec.getFunctionName().equals(COUNT_OPERATION)) {
            int n2 = this.count(gSRecordEntry.getEntry());
            GSRecordEntry gSRecordEntry7 = new GSRecordEntry();
            gSRecordEntry7.setCount(n2);
            return null;
        }
        if (gSInteractionSpec.getFunctionName().equals(CLEAR_OPERATION)) {
            this.clear(gSRecordEntry.getEntry());
            return null;
        }
        throw new IllegalArgumentException("Invalid function name: should be TAKE, WRITE, READ , NOTIFY ,  CLEAR , or CLEAN");
    }

    public boolean execute(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        throw new ResourceException("You can only use the execute method that returns a Record");
    }

    public Connection getConnection() {
        return this.a;
    }

    public Entry take(Entry entry, long l2) throws ResourceException {
        return this.take(entry, true, l2);
    }

    public Entry take(Entry entry, boolean bl2, long l2) throws ResourceException {
        GSManagedConnection gSManagedConnection = this.a.getManagedConnection();
        try {
            Transaction.Created created = null;
            if (bl2) {
                created = gSManagedConnection.getJiniTx();
            }
            IJSpace iJSpace = gSManagedConnection.getSpace();
            if (created == null) {
                return iJSpace.take(entry, null, l2);
            }
            return iJSpace.take(entry, created.transaction, l2);
        }
        catch (Exception exception) {
            throw this.handleException(exception, "take", gSManagedConnection);
        }
    }

    public Entry takeIfExists(Entry entry, long l2) throws ResourceException {
        return this.takeIfExists(entry, true, l2);
    }

    public Entry takeIfExists(Entry entry, boolean bl2, long l2) throws ResourceException {
        GSManagedConnection gSManagedConnection = this.a.getManagedConnection();
        try {
            Transaction.Created created = null;
            if (bl2) {
                created = gSManagedConnection.getJiniTx();
            }
            IJSpace iJSpace = gSManagedConnection.getSpace();
            if (created == null) {
                return iJSpace.takeIfExists(entry, null, l2);
            }
            return iJSpace.takeIfExists(entry, created.transaction, l2);
        }
        catch (Exception exception) {
            throw this.handleException(exception, "takeIfExists", gSManagedConnection);
        }
    }

    public Entry read(Entry entry, long l2) throws ResourceException {
        return this.read(entry, true, l2);
    }

    public Entry read(Entry entry, boolean bl2, long l2) throws ResourceException {
        GSManagedConnection gSManagedConnection = this.a.getManagedConnection();
        try {
            Transaction.Created created = null;
            if (bl2) {
                created = gSManagedConnection.getJiniTx();
            }
            IJSpace iJSpace = gSManagedConnection.getSpace();
            if (created == null) {
                return iJSpace.read(entry, null, l2);
            }
            return iJSpace.read(entry, created.transaction, l2);
        }
        catch (Exception exception) {
            throw this.handleException(exception, "read", gSManagedConnection);
        }
    }

    public Entry readIfExists(Entry entry, long l2) throws ResourceException {
        return this.readIfExists(entry, true, l2);
    }

    public Entry readIfExists(Entry entry, boolean bl2, long l2) throws ResourceException {
        GSManagedConnection gSManagedConnection = this.a.getManagedConnection();
        try {
            Transaction.Created created = null;
            if (bl2) {
                created = gSManagedConnection.getJiniTx();
            }
            IJSpace iJSpace = gSManagedConnection.getSpace();
            if (created == null) {
                return iJSpace.readIfExists(entry, null, l2);
            }
            return iJSpace.readIfExists(entry, created.transaction, l2);
        }
        catch (Exception exception) {
            throw this.handleException(exception, "readIfExists", gSManagedConnection);
        }
    }

    public Entry snapshot(Entry entry) throws ResourceException {
        GSManagedConnection gSManagedConnection = this.a.getManagedConnection();
        try {
            IJSpace iJSpace = gSManagedConnection.getSpace();
            return iJSpace.snapshot(entry);
        }
        catch (Exception exception) {
            throw this.handleException(exception, "snapshot", gSManagedConnection);
        }
    }

    public Lease write(Entry entry, long l2) throws ResourceException {
        return this.write(entry, true, l2);
    }

    public Lease write(Entry entry, boolean bl2, long l2) throws ResourceException {
        GSManagedConnection gSManagedConnection = this.a.getManagedConnection();
        try {
            Transaction.Created created = null;
            if (bl2) {
                created = gSManagedConnection.getJiniTx();
            }
            IJSpace iJSpace = gSManagedConnection.getSpace();
            if (created == null) {
                return iJSpace.write(entry, null, l2);
            }
            return iJSpace.write(entry, created.transaction, l2);
        }
        catch (Exception exception) {
            throw this.handleException(exception, "write", gSManagedConnection);
        }
    }

    public EventRegistration notify(Entry entry, RemoteEventListener remoteEventListener) throws ResourceException {
        GSManagedConnection gSManagedConnection = this.a.getManagedConnection();
        try {
            IJSpace iJSpace = gSManagedConnection.getSpace();
            NotifyDelegator notifyDelegator = new NotifyDelegator(iJSpace, entry, null, remoteEventListener, Long.MAX_VALUE, null, false, 1);
            return notifyDelegator.getEventRegistration();
        }
        catch (Exception exception) {
            throw this.handleException(exception, "notify", gSManagedConnection);
        }
    }

    public GSConnection getGSConnection() {
        return this.a;
    }

    public void clean() throws ResourceException {
        GSManagedConnection gSManagedConnection = this.getGSConnection().getManagedConnection();
        IJSpace iJSpace = gSManagedConnection.getSpace();
        try {
            iJSpace.clean();
        }
        catch (Exception exception) {
            throw this.handleException(exception, "clean", gSManagedConnection);
        }
    }

    public void clear(Entry entry) throws ResourceException {
        this.clear(entry, true);
    }

    public void clear(Entry entry, boolean bl2) throws ResourceException {
        GSManagedConnection gSManagedConnection = this.getGSConnection().getManagedConnection();
        IJSpace iJSpace = gSManagedConnection.getSpace();
        try {
            Transaction.Created created = null;
            if (bl2) {
                created = gSManagedConnection.getJiniTx();
            }
            if (created == null) {
                iJSpace.clear(entry, null);
            } else {
                iJSpace.clear(entry, created.transaction);
            }
        }
        catch (Exception exception) {
            throw this.handleException(exception, "clear", gSManagedConnection);
        }
    }

    public int count(Entry entry) throws ResourceException {
        return this.count(entry, true);
    }

    public int count(Entry entry, boolean bl2) throws ResourceException {
        GSManagedConnection gSManagedConnection = this.getGSConnection().getManagedConnection();
        IJSpace iJSpace = gSManagedConnection.getSpace();
        try {
            Transaction.Created created = null;
            if (bl2) {
                created = gSManagedConnection.getJiniTx();
                if (created == null) {
                    throw this.handleException(new TransactionException("Transaction cannot be NULL."), "count", gSManagedConnection);
                }
                return iJSpace.count(entry, created.transaction);
            }
            return iJSpace.count(entry, null);
        }
        catch (Exception exception) {
            throw this.handleException(exception, "count", gSManagedConnection);
        }
    }

    public IRemoteJSpaceAdmin getSpaceAdmin() throws ResourceException {
        GSManagedConnection gSManagedConnection = this.getGSConnection().getManagedConnection();
        try {
            IJSpace iJSpace = gSManagedConnection.getSpace();
            return (IRemoteJSpaceAdmin)iJSpace.getAdmin();
        }
        catch (Exception exception) {
            throw this.handleException(exception, "getAdmin", gSManagedConnection);
        }
    }

    public boolean isSecured() throws ResourceException {
        GSManagedConnection gSManagedConnection = this.getGSConnection().getManagedConnection();
        try {
            IJSpace iJSpace = gSManagedConnection.getSpace();
            return iJSpace.isSecured();
        }
        catch (Exception exception) {
            throw this.handleException(exception, "isSecured", gSManagedConnection);
        }
    }

    public ResourceException handleException(Exception exception, String string, GSManagedConnection gSManagedConnection) throws ResourceException {
        if (exception instanceof TransactionException) {
            TransactionException transactionException = (TransactionException)exception;
            return new ResourceException("TransactionException in " + string + " - " + transactionException, EXCEPTIONTYPE_TX);
        }
        if (exception instanceof RemoteException) {
            RemoteException remoteException = (RemoteException)exception;
            return new ResourceException("RemoteException in " + string + " - " + remoteException, EXCEPTIONTYPE_REMOTEEXCEPTION);
        }
        if (exception instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)exception;
            gSManagedConnection.a(runtimeException);
            return new ResourceException("RuntimeException in:" + string + " - " + runtimeException);
        }
        return new ResourceException(exception.getMessage());
    }
}

