/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.service;

import com.gigaspaces.transport.GenericExporter;
import com.gigaspaces.transport.nio.NIOConfiguration;
import com.j_spaces.core.service.Service;
import com.j_spaces.core.service.ServiceAdminImpl;
import com.j_spaces.kernel.JSpaceUtilities;
import com.sun.jini.start.LifeCycle;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.core.entry.Entry;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jrmp.JrmpExporter;
import net.jini.lookup.JoinManager;

public abstract class AbstractService
implements Service,
Remote {
    public static final long MAX_UNEXPORT_DELAY = 60000L;
    public Exporter m_serverExporter;
    public Exporter m_adminExporter;
    public LifeCycle m_lifeCycle;
    public ActivationID m_activationID;
    public ServiceAdminImpl m_adminImpl;
    public Uuid m_uuid;
    public Configuration m_configuration;
    public ArrayList m_lookupAttributes;
    private static final Logger a = Logger.getLogger("com.gigaspaces.admin");

    public AbstractService(String[] stringArray, ActivationID activationID, LifeCycle lifeCycle) throws IOException, ConfigurationException {
        block2: {
            this.m_configuration = null;
            JSpaceUtilities.setXMLImplSystemProps();
            this.m_activationID = activationID;
            this.m_lifeCycle = lifeCycle;
            try {
                this.m_configuration = ConfigurationProvider.getInstance(stringArray, this.getClass().getClassLoader());
            }
            catch (Throwable throwable) {
                if (!a.isLoggable(Level.SEVERE)) break block2;
                a.log(Level.SEVERE, "Failed to initialize Jini Configuration object: " + throwable.getClass().getName(), throwable);
            }
        }
        this.m_lookupAttributes = new ArrayList();
        this.m_adminExporter = new JrmpExporter();
        this.m_uuid = UuidFactory.generate();
    }

    public Exporter getExporter() {
        NIOConfiguration nIOConfiguration = new NIOConfiguration();
        return new GenericExporter(nIOConfiguration);
    }

    public Configuration getConfigurationProvider() {
        return this.m_configuration;
    }

    public abstract String getServiceName();

    public abstract void shutdown() throws RemoteException;

    public abstract JoinManager getJoinManager();

    public abstract String getConfigComponent();

    public synchronized Object getAdmin() {
        block3: {
            try {
                if (this.m_adminImpl == null) {
                    this.m_adminImpl = new ServiceAdminImpl(this, this.m_adminExporter);
                }
            }
            catch (Exception exception) {
                if (!a.isLoggable(Level.SEVERE)) break block3;
                a.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        return this.m_adminImpl != null ? this.m_adminImpl.getProxy() : null;
    }

    public Uuid getUuid() {
        return this.m_uuid;
    }

    public LifeCycle getLifeCycle() {
        return this.m_lifeCycle;
    }

    public ActivationID getActivationID() {
        return this.m_activationID;
    }

    public Object getConfigEntry(Configuration configuration, String string, String string2, Class clazz, Object object) throws ConfigurationException {
        try {
            return configuration.getEntry(string, string2, clazz);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            return object != null ? object : null;
        }
    }

    public void addAttribute(Entry entry) {
        if (entry == null) {
            throw new NullPointerException("attribute is null");
        }
        JoinManager joinManager = this.getJoinManager();
        if (joinManager != null) {
            joinManager.addAttributes(new Entry[]{entry}, false);
        } else {
            this.m_lookupAttributes.add(entry);
        }
    }

    public void addAttributes(Entry[] entryArray) {
        if (entryArray == null) {
            throw new NullPointerException("attributes are null");
        }
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            this.addAttribute(entryArray[i2]);
        }
    }

    public Entry[] getInitLookupAttributes() {
        return this.m_lookupAttributes.toArray(new Entry[this.m_lookupAttributes.size()]);
    }

    public void modifyLookupAttributes(Entry[] entryArray, Entry[] entryArray2) {
        if (this.getJoinManager() != null) {
            this.getJoinManager().modifyAttributes(entryArray, entryArray2, false);
        }
    }
}

