/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.lookup.entry.ContainerName;
import com.j_spaces.lookup.entry.GenericEntry;
import com.j_spaces.obf.dm;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.Name;

public class SpaceURL
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.client");
    public static final String ANY = "*";
    public static final String JINI_PROTOCOL = "jini:";
    public static final String RMI_PROTOCOL = "rmi:";
    public static final String EMBEDDED_SPACE_PROTOCOL = "java:";
    public static final HashSet AVAILABLE_PROTOCOLS = new HashSet();
    public static final String GROUPS = "groups";
    public static final String LOCATORS = "locators";
    public static final String CLUSTER_NAME = "clustername";
    public static final String CLUSTER_GROUP = "clustergroup";
    public static final String TIMEOUT = "timeout";
    public static final String FIFO_MODE = "fifo";
    public static final String DESTROY = "destroy";
    public static final String CREATE = "create";
    public static final String USE_LOCAL_CACHE = "useLocalCache";
    public static final String LOCAL_CACHE_UPDATE_MODE = "updateMode";
    public static final int UPDATE_MODE_PULL = 1;
    public static final int UPDATE_MODE_PUSH = 2;
    public static final String VERSIONED = "versioned";
    public static final String SECURITY_MANAGER = "securityManager";
    public static final String NO_WRITE_LEASE = "NOWriteLease";
    public static final String MIRROR = "mirror";
    public static final String VIEWS = "views";
    public static final String SCHEMA_NAME = "schema";
    public static final String DEFAULT_SCHEMA_NAME = "default";
    public static final String CLUSTER_SCHEMA = "cluster_schema";
    public static final String CLUSTER_TOTAL_MEMBERS = "total_members";
    public static final String CLUSTER_BACKUP_ID = "backup_id";
    public static final String CLUSTER_MEMBER_ID = "id";
    public static final String PROPERTIES_FILE_NAME = "properties";
    public static final String CUSTOM_PROPERTIES_NAME = "customproperties";
    public static final String GENERIC_LOOKUP_ATTRIBUTES = "GENERIC.LOOKUP.ATTRIBUES";
    public static final String CACHE_URL_PROP = "gs.space.url";
    public static final String PROPERTIES_SPACE_URL_ARG = "gs.space.url.arg";
    public static final String PROPERTIES_SPACE_URL_ARGLINE = "gs.space.url.arg_line";
    public static final String IGNORE_VALIDATION = "ignoreValidation";
    public static final String CONTAINER = "container";
    public static final String LOOKUP_CONTAINER_NAME = "containername";
    public static final String STATE = "state";
    public static final String LOOKUP_SERVICE_NAME = "servicename";
    public static final String LOOKUP_PERSISTENT_NAME = "persistent";
    public static final String SPACE = "space";
    public static final String HOST_NAME = "host";
    public static final String PROTOCOL_NAME = "protocol";
    public static final String URL_NAME = "url";
    public static final String MEMBER_NAME = "membername";
    public static final HashSet AVAILABLE_URL_ATTRIBUTES;
    private static StringBuffer spaceURLQueryAttribs;

    public String getProtocol() {
        return this.getProperty(PROTOCOL_NAME);
    }

    public String getMemberName() {
        return this.getProperty(MEMBER_NAME);
    }

    public static HashSet getSpaceUrlAttributes() {
        return AVAILABLE_URL_ATTRIBUTES;
    }

    public String getHost() {
        return this.getProperty(HOST_NAME).equals(ANY) ? null : this.getProperty(HOST_NAME);
    }

    public void setPropertiesPrefix(String string, String string2, String string3, String string4) {
        Object object;
        if (JSpaceUtilities.isEmpty(string) || !AVAILABLE_PROTOCOLS.contains(string)) {
            super.setProperty(PROTOCOL_NAME, JINI_PROTOCOL);
        } else {
            super.setProperty(PROTOCOL_NAME, string);
        }
        super.setProperty(HOST_NAME, string2);
        if (string.equalsIgnoreCase(JINI_PROTOCOL)) {
            object = (Hashtable)this.get(GENERIC_LOOKUP_ATTRIBUTES);
            ((Hashtable)object).clear();
        }
        this.setContainerName(string3);
        this.setSpaceName(string4);
        object = this.getProperty(PROTOCOL_NAME) + "//" + this.getProperty(HOST_NAME) + "/" + this.getContainerName() + "/" + this.getProperty(SPACE);
        String string5 = "";
        int n2 = this.getURL().indexOf(63);
        if (n2 >= 0) {
            string5 = this.getURL().substring(n2);
        }
        super.setProperty(URL_NAME, (String)object + string5);
    }

    public String getContainerName() {
        return this.getProperty(CONTAINER, ANY);
    }

    public void setContainerName(String string) {
        this.setProperty(CONTAINER, string);
        if (!string.equals(ANY)) {
            Hashtable hashtable = (Hashtable)this.get(GENERIC_LOOKUP_ATTRIBUTES);
            ContainerName containerName = (ContainerName)SpaceURLParser.a.get(LOOKUP_CONTAINER_NAME);
            hashtable.put(LOOKUP_CONTAINER_NAME, containerName.fromString(string));
        }
    }

    public void setSpaceName(String string) {
        if (!JSpaceUtilities.isEmpty(string)) {
            super.setProperty(SPACE, string);
        }
        if (!this.getProperty(PROTOCOL_NAME).equalsIgnoreCase(RMI_PROTOCOL)) {
            if (JSpaceUtilities.isEmpty(string)) {
                this.setServiceName(this.getContainerName());
            } else if (!string.equalsIgnoreCase(ANY)) {
                this.setServiceName(string);
            }
        }
    }

    public String setServiceName(String string) {
        if (!JSpaceUtilities.isEmpty(string)) {
            Hashtable hashtable = (Hashtable)this.get(GENERIC_LOOKUP_ATTRIBUTES);
            hashtable.put(LOOKUP_SERVICE_NAME, new Name(string));
        }
        return string;
    }

    public String getSpaceName() {
        return this.getProperty(SPACE);
    }

    public String getURL() {
        return this.getProperty(URL_NAME);
    }

    public String getProperty(String string) {
        return super.getProperty(string.toLowerCase());
    }

    public String getProperty(String string, String string2) {
        return super.getProperty(string.toLowerCase(), string2);
    }

    public Entry[] getLookupAttributes() {
        Hashtable hashtable = (Hashtable)this.get(GENERIC_LOOKUP_ATTRIBUTES);
        Entry[] entryArray = hashtable.values().toArray(new Entry[hashtable.size()]);
        return entryArray;
    }

    public String getClusterSchema() {
        return this.getProperty(CLUSTER_SCHEMA);
    }

    public String getSchema() {
        return this.getProperty(SCHEMA_NAME);
    }

    public void setPropertiesForSpaceProxy(IJSpace iJSpace) {
        String string;
        String string2;
        String string3 = this.getProperty(FIFO_MODE, "false");
        if (string3.equalsIgnoreCase("true")) {
            iJSpace.setFifo(true);
        }
        if ((string2 = this.getProperty(VERSIONED)) != null) {
            boolean bl2 = Boolean.valueOf(string2);
            iJSpace.setOptimisticLocking(bl2);
        }
        if ((string = this.getProperty(NO_WRITE_LEASE, "false")).equalsIgnoreCase("true")) {
            iJSpace.setNOWriteLeaseMode(true);
        }
    }

    public static String concatAttrIfNotExist(String string, String string2, String string3) {
        if (string.toLowerCase().indexOf(string2.toLowerCase() + "=") != -1) {
            return string;
        }
        int n2 = string.lastIndexOf(63);
        int n3 = string.lastIndexOf(38);
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n2 != -1 || n3 != -1) {
            stringBuffer.append('&');
        } else {
            stringBuffer.append('?');
        }
        stringBuffer.append(string2);
        if (string3 != null) {
            stringBuffer.append('=');
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object object) {
        SpaceURL spaceURL = (SpaceURL)object;
        Hashtable hashtable = this.removePropertiesValueForCalculation(this);
        Hashtable hashtable2 = this.removePropertiesValueForCalculation(spaceURL);
        try {
            if (super.equals(spaceURL)) {
                boolean bl2 = JSpaceUtilities.isStringEquals(this.getContainerName(), spaceURL.getContainerName()) && JSpaceUtilities.isStringEquals(this.getSpaceName(), spaceURL.getSpaceName()) && JSpaceUtilities.isStringEquals(this.getSchema(), spaceURL.getSchema()) && JSpaceUtilities.isStringEquals(this.getClusterSchema(), spaceURL.getClusterSchema());
                return bl2;
            }
        }
        finally {
            this.returnPropertiesValue(this, hashtable);
            this.returnPropertiesValue(spaceURL, hashtable2);
        }
        return false;
    }

    public synchronized int hashCode() {
        int n2;
        Hashtable hashtable = this.removePropertiesValueForCalculation(this);
        int n3 = n2 = super.hashCode();
        if (this.getContainerName() != null) {
            n3 ^= this.getContainerName().hashCode();
        }
        if (this.getSpaceName() != null) {
            n3 ^= this.getSpaceName().hashCode();
        }
        if (this.getSchema() != null) {
            n3 ^= this.getSchema().hashCode();
        }
        if (this.getClusterSchema() != null) {
            n3 ^= this.getClusterSchema().hashCode();
        }
        this.returnPropertiesValue(this, hashtable);
        return n3;
    }

    private Hashtable removePropertiesValueForCalculation(SpaceURL spaceURL) {
        return (Hashtable)spaceURL.remove(GENERIC_LOOKUP_ATTRIBUTES);
    }

    private void returnPropertiesValue(SpaceURL spaceURL, Hashtable hashtable) {
        spaceURL.put(GENERIC_LOOKUP_ATTRIBUTES, hashtable);
    }

    public Properties getCustomProperties() {
        return (Properties)super.get(CUSTOM_PROPERTIES_NAME);
    }

    public void setCustomProperties(Properties properties) {
        this.put(PROPERTIES_FILE_NAME, properties);
    }

    public SpaceURL setProperty(String string, String string2) {
        super.setProperty(string, string2);
        if (!string.equalsIgnoreCase(URL_NAME) && SpaceURL.getSpaceUrlAttributes().contains(string.toLowerCase())) {
            GenericEntry genericEntry;
            String string3 = SpaceURL.concatAttrIfNotExist(this.getProperty(URL_NAME), string, string2);
            Hashtable hashtable = (Hashtable)this.get(GENERIC_LOOKUP_ATTRIBUTES);
            if (hashtable != null && (genericEntry = (GenericEntry)SpaceURLParser.a.get(string.toLowerCase())) != null) {
                hashtable.put(string.toLowerCase(), genericEntry.fromString(string2));
            }
            super.setProperty(URL_NAME, string3);
        }
        return this;
    }

    public String toString() {
        if (_logger.isLoggable(Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!super.isEmpty()) {
                stringBuffer.append("\n\t space url attributes:");
            }
            Enumeration<Object> enumeration = super.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = super.get(string);
                stringBuffer.append("\n\t\t Key [ " + string + " ] Value [ " + object + " ]");
            }
            stringBuffer.append("\n");
            _logger.log(Level.FINE, stringBuffer.toString());
            return stringBuffer.toString();
        }
        return this.getProperty(URL_NAME);
    }

    public synchronized Object clone() {
        return dm.b(this);
    }

    public /* synthetic */ Object setProperty(String string, String string2) {
        return this.setProperty(string, string2);
    }

    static {
        AVAILABLE_PROTOCOLS.add(JINI_PROTOCOL);
        AVAILABLE_PROTOCOLS.add(RMI_PROTOCOL);
        AVAILABLE_PROTOCOLS.add(EMBEDDED_SPACE_PROTOCOL);
        AVAILABLE_URL_ATTRIBUTES = new HashSet();
        AVAILABLE_URL_ATTRIBUTES.add(CLUSTER_BACKUP_ID.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(CLUSTER_MEMBER_ID.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(CLUSTER_GROUP.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(CLUSTER_NAME.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(CLUSTER_SCHEMA.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(CLUSTER_TOTAL_MEMBERS.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(SCHEMA_NAME.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(GROUPS.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(FIFO_MODE.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(LOCAL_CACHE_UPDATE_MODE.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(VERSIONED.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(USE_LOCAL_CACHE.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(TIMEOUT.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(SECURITY_MANAGER.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(NO_WRITE_LEASE.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(CREATE.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(DESTROY.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(PROPERTIES_FILE_NAME.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(IGNORE_VALIDATION.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(LOCATORS.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(STATE.toLowerCase());
        AVAILABLE_URL_ATTRIBUTES.add(MIRROR.toLowerCase());
    }
}

