/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.j_spaces.core.Constants;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.tools.filters.FiltersInfo;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.retrotranslator.runtime.java.util._Arrays;

public class JSpaceAttributes
extends Properties {
    public static final long serialVersionUID = 1L;
    private JSpaceAttributes _dCacheProperties;
    private ClusterPolicy _clusterPolicy;
    private FiltersInfo[] _filtersInfo;
    private Properties _customProperties;
    public boolean m_isClustered;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.core.config");

    public JSpaceAttributes(Properties properties) {
        super(properties);
    }

    public JSpaceAttributes() {
    }

    public JSpaceAttributes(String string) {
        this.setSchemaName(string);
    }

    public JSpaceAttributes(String string, Properties properties) {
        this(string, properties, false);
    }

    public JSpaceAttributes(String string, Properties properties, boolean bl2) {
        this.setSchemaName(string);
        this.setCustomProperties(properties);
        this.setLoadOnStartup(bl2);
    }

    public JSpaceAttributes(String string, boolean bl2) {
        this.setSchemaName(string);
        this.setLoadOnStartup(bl2);
    }

    public JSpaceAttributes(String string, String string2) {
        this(string);
        this.setClusterConfigURL(string2);
        if (string2 != null) {
            this.setClustered(true);
        }
    }

    public JSpaceAttributes(String string, String string2, int n2) {
        this(string, null, string2, n2);
    }

    public JSpaceAttributes(String string, Properties properties, String string2, int n2) {
        this(string, string2);
        this.setLRMIServerPort(String.valueOf(n2));
        this.setCustomProperties(properties);
    }

    public synchronized Object setProperty(String string, String string2) {
        if (string2 != null) {
            return super.setProperty(string, string2);
        }
        return null;
    }

    public Object clone() {
        return (JSpaceAttributes)super.clone();
    }

    public boolean isSpaceDefinitionEqual(JSpaceAttributes jSpaceAttributes) {
        if (!JSpaceUtilities.isStringEquals(this.getSpaceState(), jSpaceAttributes.getSpaceState())) {
            return false;
        }
        if (this.isPrivate() != jSpaceAttributes.isPrivate()) {
            return false;
        }
        if (this.getSerializationType() != jSpaceAttributes.getSerializationType()) {
            return false;
        }
        if (!JSpaceUtilities.isStringEquals(this.getCachePolicy(), jSpaceAttributes.getCachePolicy())) {
            return false;
        }
        if (this.isPersistent() != jSpaceAttributes.isPersistent()) {
            return false;
        }
        if (!JSpaceUtilities.isStringEquals(this.getLRMIServerPort(), jSpaceAttributes.getLRMIServerPort())) {
            return false;
        }
        if (!JSpaceUtilities.isStringEquals(this.getLRMIClientPort(), jSpaceAttributes.getLRMIClientPort())) {
            return false;
        }
        if (this.isLRMIMultiplexConnection() != jSpaceAttributes.isLRMIMultiplexConnection()) {
            return false;
        }
        if (!JSpaceUtilities.isStringEquals(this.getSchemaName(), jSpaceAttributes.getSchemaName())) {
            return false;
        }
        if (!JSpaceUtilities.isStringEquals(this.getConnectionRetries(), jSpaceAttributes.getConnectionRetries())) {
            return false;
        }
        if (!JSpaceUtilities.isStringEquals(this.getNotifyRetries(), jSpaceAttributes.getNotifyRetries())) {
            return false;
        }
        if (!JSpaceUtilities.isStringEquals(this.isEngineMemoryUsageEnabled(), jSpaceAttributes.isEngineMemoryUsageEnabled())) {
            return false;
        }
        if (Boolean.valueOf(this.isEngineMemoryUsageEnabled()).booleanValue()) {
            if (!this.isFloatValuesEqual(this.getEngineMemoryUsageHighPercentageRatio(), jSpaceAttributes.getEngineMemoryUsageHighPercentageRatio())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.isEngineMemoryExplicitGSEnabled(), jSpaceAttributes.isEngineMemoryExplicitGSEnabled())) {
                return false;
            }
            if (!this.isFloatValuesEqual(this.getEngineMemoryUsageLowPercentageRatio(), jSpaceAttributes.getEngineMemoryUsageLowPercentageRatio())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getEngineMemoryUsageEvictionBatchSize(), jSpaceAttributes.getEngineMemoryUsageEvictionBatchSize())) {
                return false;
            }
            if (!this.isFloatValuesEqual(this.getEngineMemoryUsageWriteOnlyBlockPercentageRatio(), jSpaceAttributes.getEngineMemoryUsageWriteOnlyBlockPercentageRatio())) {
                return false;
            }
            if (!this.isFloatValuesEqual(this.getEngineMemoryWriteOnlyCheckPercentageRatio(), jSpaceAttributes.getEngineMemoryWriteOnlyCheckPercentageRatio())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getEngineMemoryUsageRetryCount(), jSpaceAttributes.getEngineMemoryUsageRetryCount())) {
                return false;
            }
        }
        if (!JSpaceUtilities.isStringEquals(this.getExpirationTimeInterval(), jSpaceAttributes.getExpirationTimeInterval())) {
            return false;
        }
        if (!JSpaceUtilities.isStringEquals(this.getNumberImplicitIndexes(), jSpaceAttributes.getNumberImplicitIndexes())) {
            return false;
        }
        if (!JSpaceUtilities.isStringEquals(this.getEngineMinThreads(), jSpaceAttributes.getEngineMinThreads())) {
            return false;
        }
        if (!JSpaceUtilities.isStringEquals(this.getEngineMaxThreads(), jSpaceAttributes.getEngineMaxThreads())) {
            return false;
        }
        if (this.isPersistent() && jSpaceAttributes.isPersistent()) {
            if (this.isResetOnFailure() != jSpaceAttributes.isResetOnFailure()) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getStorageAdapterClass(), jSpaceAttributes.getStorageAdapterClass())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getStorageAdapterURL(), jSpaceAttributes.getStorageAdapterURL())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getInitSAConnections(), jSpaceAttributes.getInitSAConnections())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getMaxSAConnections(), jSpaceAttributes.getMaxSAConnections())) {
                return false;
            }
            if (this.isSyncOnCommit() != jSpaceAttributes.isSyncOnCommit()) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getAdapterType(), jSpaceAttributes.getAdapterType())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getCacheLoaderClass(), jSpaceAttributes.getCacheLoaderClass())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getDbName(), jSpaceAttributes.getDbName())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getDbUserName(), jSpaceAttributes.getDbUserName())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getDbPassword(), jSpaceAttributes.getDbPassword())) {
                return false;
            }
            if (this.getNumberSyncObjects() != jSpaceAttributes.getNumberSyncObjects()) {
                return false;
            }
            if (this.getCheckPointPeriod() != jSpaceAttributes.getCheckPointPeriod()) {
                return false;
            }
            if (this.getPagePoolSize() != jSpaceAttributes.getPagePoolSize()) {
                return false;
            }
        }
        if (!JSpaceUtilities.isStringEquals(this.getCacheManagerSize(), jSpaceAttributes.getCacheManagerSize())) {
            return false;
        }
        if (this.isClustered() != jSpaceAttributes.isClustered()) {
            return false;
        }
        if (Boolean.valueOf(this.isClustered()).booleanValue()) {
            this.setClusterConfigURL(this.checkStringForNoneValue(this.getClusterConfigURL()));
            jSpaceAttributes.setClusterConfigURL(this.checkStringForNoneValue(jSpaceAttributes.getClusterConfigURL()));
            if (!JSpaceUtilities.isStringEquals(this.getClusterConfigURL(), jSpaceAttributes.getClusterConfigURL())) {
                return false;
            }
        }
        if (!JSpaceUtilities.isStringEquals(this.isSSLEnabled(), jSpaceAttributes.isSSLEnabled())) {
            return false;
        }
        if (Boolean.valueOf(this.isSSLEnabled()).booleanValue()) {
            if (!JSpaceUtilities.isStringEquals(this.getStubHandler(), jSpaceAttributes.getStubHandler())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getSSLKeyStore(), jSpaceAttributes.getSSLKeyStore())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getSSLTrustStore(), jSpaceAttributes.getSSLTrustStore())) {
                return false;
            }
            if (!JSpaceUtilities.isStringEquals(this.getSSLPassword(), jSpaceAttributes.getSSLPassword())) {
                return false;
            }
        }
        if (!JSpaceUtilities.isStringEquals(this.getLRMIProtocolName(), jSpaceAttributes.getLRMIProtocolName())) {
            return false;
        }
        if (!JSpaceUtilities.isStringEquals(this.getDCacheConfigName(), jSpaceAttributes.getDCacheConfigName())) {
            return false;
        }
        if (this.getDCacheProperties() != null && jSpaceAttributes.getDCacheProperties() == null || this.getDCacheProperties() == null && jSpaceAttributes.getDCacheProperties() != null) {
            return false;
        }
        if (this.getDCacheProperties() != null && jSpaceAttributes.getDCacheProperties() != null && !this.compareDCacheAttributes(this.getDCacheProperties(), jSpaceAttributes.getDCacheProperties())) {
            return false;
        }
        return this.isFilterInfoEqual(jSpaceAttributes);
    }

    private boolean isFloatValuesEqual(String string, String string2) {
        float f2;
        float f3;
        try {
            f3 = Float.parseFloat(string);
            f2 = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            _logger.log(Level.SEVERE, numberFormatException.toString(), numberFormatException);
            return false;
        }
        return f3 == f2;
    }

    private boolean compareDCacheAttributes(Properties properties, Properties properties2) {
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry<Object, Object> entry = iterator.next();
            Object object = entry.getKey();
            String string2 = (String)entry.getValue();
            if (JSpaceUtilities.isStringEquals(string2, string = (String)properties2.get(object))) continue;
            return false;
        }
        return true;
    }

    private boolean isFilterInfoEqual(JSpaceAttributes jSpaceAttributes) {
        Map map;
        int n2;
        if (this.getFiltersInfo() == null && jSpaceAttributes.getFiltersInfo() == null) {
            return true;
        }
        if (this.getFiltersInfo() == null && jSpaceAttributes.getFiltersInfo() != null || this.getFiltersInfo() != null && jSpaceAttributes.getFiltersInfo() == null) {
            return false;
        }
        int n3 = this.getFiltersInfo().length;
        if (n3 != (n2 = jSpaceAttributes.getFiltersInfo().length)) {
            return false;
        }
        Map map2 = this.getFiltersMap(this.getFiltersInfo());
        return this.isFilterMapsEqual(map2, map = this.getFiltersMap(jSpaceAttributes.getFiltersInfo()));
    }

    private Map getFiltersMap(FiltersInfo[] filtersInfoArray) {
        HashMap<String, FiltersInfo> hashMap = new HashMap<String, FiltersInfo>(filtersInfoArray.length);
        FiltersInfo[] filtersInfoArray2 = filtersInfoArray;
        int n2 = filtersInfoArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FiltersInfo filtersInfo = filtersInfoArray2[i2];
            String string = filtersInfo.filterName;
            hashMap.put(string, filtersInfo);
        }
        return hashMap;
    }

    private boolean isFilterMapsEqual(Map map, Map map2) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            FiltersInfo filtersInfo = (FiltersInfo)entry.getValue();
            FiltersInfo filtersInfo2 = (FiltersInfo)map2.get(entry.getKey());
            if (filtersInfo2 == null) {
                return false;
            }
            if (this.compareFilterInfo(filtersInfo, filtersInfo2)) continue;
            return false;
        }
        return true;
    }

    private boolean compareFilterInfo(FiltersInfo filtersInfo, FiltersInfo filtersInfo2) {
        try {
            MarshalledObject<FiltersInfo> marshalledObject = new MarshalledObject<FiltersInfo>(filtersInfo);
            MarshalledObject<FiltersInfo> marshalledObject2 = new MarshalledObject<FiltersInfo>(filtersInfo2);
            if (!marshalledObject.equals(marshalledObject2)) {
                return false;
            }
        }
        catch (IOException iOException) {
            _logger.log(Level.SEVERE, iOException.toString(), iOException);
        }
        return true;
    }

    private String checkStringForNoneValue(String string) {
        if (string != null && string.equalsIgnoreCase("none")) {
            string = null;
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\t --- JSpaceAttributes ---\n");
        stringBuffer.append("\n\t DCache properties -\t " + JProperties.getPropertiesXPathDescription(this.getDCacheProperties()) + "\n");
        stringBuffer.append("\n\t Cluster Policy -\t" + this.getClusterPolicy() + "\n");
        stringBuffer.append("\n\t Filters configuration -\t" + _Arrays.toString(this.getFiltersInfo()) + "\n");
        stringBuffer.append("\n\t Custom properties -\t " + JProperties.getPropertiesXPathDescription(this.getCustomProperties()) + "\n");
        stringBuffer.append("\n\t Properties\n\t " + JProperties.getPropertiesXPathDescription(this) + "\n");
        return stringBuffer.toString();
    }

    public int getCheckPointPeriod() {
        return Integer.parseInt(this.getProperty("space-config.persistent.Check_Point_Period", String.valueOf(-1)));
    }

    public void setCheckPointPeriod(int n2) {
        this.setProperty("space-config.persistent.Check_Point_Period", String.valueOf(n2));
    }

    public String getDbPassword() {
        return this.getProperty("space-config.persistent.password", "");
    }

    public void setDbPassword(String string) {
        String string2 = null;
        string2 = string != null ? string : "";
        this.setProperty("space-config.persistent.password", string2);
    }

    public String getDbUserName() {
        return this.getProperty("space-config.persistent.userName", "");
    }

    public void setDbUserName(String string) {
        String string2 = null;
        string2 = string != null ? string : "";
        this.setProperty("space-config.persistent.userName", string2);
    }

    public boolean isSyncOnCommit() {
        return Boolean.valueOf(this.getProperty("space-config.persistent.Sync_On_Commit", Constants.StorageAdapter.SYNC_ON_COMMIT_DEFAULT));
    }

    public void setSyncOnCommit(boolean bl2) {
        this.setProperty("space-config.persistent.Sync_On_Commit", String.valueOf(bl2));
    }

    public int getNumberSyncObjects() {
        return Integer.parseInt(this.getProperty("space-config.persistent.Number_Sync_Objects", String.valueOf(-1)));
    }

    public void setNumberSyncObjects(int n2) {
        this.setProperty("space-config.persistent.Number_Sync_Objects", String.valueOf(n2));
    }

    public int getPagePoolSize() {
        return Integer.parseInt(this.getProperty("space-config.persistent.Page_Pool_Size", String.valueOf(4096)));
    }

    public void setPagePoolSize(int n2) {
        this.setProperty("space-config.persistent.Page_Pool_Size", String.valueOf(n2));
    }

    public String getDbName() {
        return this.getProperty("space-config.persistent.DataBaseName", "");
    }

    public void setDbName(String string) {
        this.setProperty("space-config.persistent.DataBaseName", string);
    }

    public String getAdapterType() {
        return this.getProperty("space-config.persistent.AdapterType", "");
    }

    public void setAdapterType(String string) {
        this.setProperty("space-config.persistent.AdapterType", string);
    }

    public String getCacheLoaderClass() {
        return this.getProperty("space-config.persistent.CacheLoaderClass", "");
    }

    public void setCacheLoaderClass(String string) {
        this.setProperty("space-config.persistent.CacheLoaderClass", string);
    }

    public boolean isPersistent() {
        return Boolean.valueOf(this.getProperty("space-config.persistent.enabled", Constants.StorageAdapter.PERSISTENT_ENABLED_DEFAULT));
    }

    public void setPersistent(boolean bl2) {
        this.setProperty("space-config.persistent.enabled", String.valueOf(bl2));
    }

    public boolean isQPAutoCommit() {
        return Boolean.valueOf(this.getProperty("space-config.QueryProcessor.auto_commit", Constants.QueryProcessorInfo.QP_AUTO_COMMIT_DEFAULT));
    }

    public void setQPAutoCommit(boolean bl2) {
        this.setProperty("space-config.QueryProcessor.auto_commit", String.valueOf(bl2));
    }

    public boolean isQPInitJMX() {
        return Boolean.valueOf(this.getProperty("space-config.QueryProcessor.port", Constants.QueryProcessorInfo.QP_INIT_JMX_DEFAULT));
    }

    public void setQPInitJMX(boolean bl2) {
        this.setProperty("space-config.QueryProcessor.port", String.valueOf(bl2));
    }

    public boolean isQPParserCaseSensetivity() {
        return Boolean.valueOf(this.getProperty("space-config.QueryProcessor.parser_case_sensetivity", Constants.QueryProcessorInfo.QP_PARSER_CASE_SENSETIVITY_DEFAULT));
    }

    public void setQPParserCaseSensetivity(boolean bl2) {
        this.setProperty("space-config.QueryProcessor.parser_case_sensetivity", String.valueOf(bl2));
    }

    public boolean isQPTraceExecTime() {
        return Boolean.valueOf(this.getProperty("space-config.QueryProcessor.trace_exec_time", Constants.QueryProcessorInfo.QP_TRACE_EXEC_TIME_DEFAULT));
    }

    public void setQPTraceExecTime(boolean bl2) {
        this.setProperty("space-config.QueryProcessor.trace_exec_time", String.valueOf(bl2));
    }

    public int getQpMaxJDBCClientConnections() {
        return Integer.parseInt(this.getProperty("space-config.QueryProcessor.max_connections", Constants.QueryProcessorInfo.QP_MAX_CONNECTIONS_DEFAULT));
    }

    public void setQpMaxJDBCClientConnections(int n2) {
        this.setProperty("space-config.QueryProcessor.max_connections", String.valueOf(n2));
    }

    public int getQpMinJDBCClientConnections() {
        return Integer.parseInt(this.getProperty("space-config.QueryProcessor.min_connections", Constants.QueryProcessorInfo.QP_MIN_CONNECTIONS_DEFAULT));
    }

    public void setQpMinJDBCClientConnections(int n2) {
        this.setProperty("space-config.QueryProcessor.min_connections", String.valueOf(n2));
    }

    public int getQpPort() {
        return Integer.parseInt(this.getProperty("space-config.QueryProcessor.port", Constants.QueryProcessorInfo.QP_PORT_DEFAULT));
    }

    public int getQpPort(int n2) {
        return Integer.parseInt(this.getProperty("space-config.QueryProcessor.port", String.valueOf(n2)));
    }

    public void setQpPort(int n2) {
        this.setProperty("space-config.QueryProcessor.port", String.valueOf(n2));
    }

    public int getQpSpaceReadLeaseTime() {
        return Integer.parseInt(this.getProperty("space-config.QueryProcessor.space_read_lease_time", Constants.QueryProcessorInfo.QP_SPACE_READ_LEASE_TIME_DEFAULT));
    }

    public void setQpSpaceReadLeaseTime(int n2) {
        this.setProperty("space-config.QueryProcessor.space_read_lease_time", String.valueOf(n2));
    }

    public long getQpSpaceWriteLeaseTime() {
        return Long.parseLong(this.getProperty("space-config.QueryProcessor.space_write_lease", Constants.QueryProcessorInfo.QP_SPACE_WRITE_LEASE_DEFAULT));
    }

    public void setQpSpaceWriteLeaseTime(long l2) {
        this.setProperty("space-config.QueryProcessor.space_write_lease", String.valueOf(l2));
    }

    public int getQpTransactionTimeout() {
        return Integer.parseInt(this.getProperty("space-config.QueryProcessor.transaction_timeout", Constants.QueryProcessorInfo.QP_TRANSACTION_TIMEOUT_DEFAULT));
    }

    public void setQpTransactionTimeout(int n2) {
        this.setProperty("space-config.QueryProcessor.transaction_timeout", String.valueOf(n2));
    }

    public String getQpDateFormat() {
        return this.getProperty("space-config.QueryProcessor.date_format", "yyyy-MM-dd");
    }

    public void setQpDateFormat(String string) {
        this.setProperty("space-config.QueryProcessor.date_format", string);
    }

    public String getQpDateTimeFormat() {
        return this.getProperty("space-config.QueryProcessor.datetime_format", "yyyy-MM-dd hh:mm:ss");
    }

    public void setQpDateTimeFormat(String string) {
        this.setProperty("space-config.QueryProcessor.datetime_format", string);
    }

    public String getQpTimeFormat() {
        return this.getProperty("space-config.QueryProcessor.time_format", "hh:mm:ss");
    }

    public void setQpTimeFormat(String string) {
        this.setProperty("space-config.QueryProcessor.time_format", string);
    }

    public String getStorageAdapterClass() {
        return this.getProperty("space-config.persistent.StorageAdapterClass", "");
    }

    public void setStorageAdapterClass(String string) {
        this.setProperty("space-config.persistent.StorageAdapterClass", string);
    }

    public String getStorageAdapterURL() {
        return this.getProperty("space-config.persistent.StorageAdapterURL", "");
    }

    public void setStorageAdapterURL(String string) {
        this.setProperty("space-config.persistent.StorageAdapterURL", string);
    }

    public String isEngineMemoryUsageEnabled() {
        return this.getProperty("space-config.engine.memory_usage.enabled", "false");
    }

    public void setEngineMemoryUsageEnabled(String string) {
        this.setProperty("space-config.engine.memory_usage.enabled", string);
    }

    public void setEngineMemoryUsageHighPercentageRatio(String string) {
        this.setProperty("space-config.engine.memory_usage.high_watermark_percentage", string);
    }

    public String getEngineMemoryUsageHighPercentageRatio() {
        return this.getProperty("space-config.engine.memory_usage.high_watermark_percentage", "95");
    }

    public void setEngineMemoryUsageWriteOnlyBlockPercentageRatio(String string) {
        this.setProperty("space-config.engine.memory_usage.write_only_block_percentage", String.valueOf(string));
    }

    public String getEngineMemoryUsageWriteOnlyBlockPercentageRatio() {
        return this.getProperty("space-config.engine.memory_usage.write_only_block_percentage", "85");
    }

    public void setEngineMemoryWriteOnlyCheckPercentageRatio(String string) {
        this.setProperty("space-config.engine.memory_usage.write_only_check_percentage", String.valueOf(string));
    }

    public String getEngineMemoryWriteOnlyCheckPercentageRatio() {
        return this.getProperty("space-config.engine.memory_usage.write_only_check_percentage", "76");
    }

    public void setEngineMemoryUsageLowPercentageRatio(String string) {
        this.setProperty("space-config.engine.memory_usage.low_watermark_percentage", String.valueOf(string));
    }

    public String getEngineMemoryUsageLowPercentageRatio() {
        return this.getProperty("space-config.engine.memory_usage.low_watermark_percentage", "75");
    }

    public String isEngineMemoryExplicitGSEnabled() {
        return this.getProperty("space-config.engine.memory_usage.explicit-gc", "false");
    }

    public void setEngineMemoryExplicitGSEnabled(String string) {
        this.setProperty("space-config.engine.memory_usage.explicit-gc", string);
    }

    public void setEngineMemoryUsageRetryCount(String string) {
        this.setProperty("space-config.engine.memory_usage.retry_count", string);
    }

    public String getEngineMemoryUsageRetryCount() {
        return this.getProperty("space-config.engine.memory_usage.retry_count", "5");
    }

    public void setEngineMemoryUsageEvictionBatchSize(String string) {
        this.setProperty("space-config.engine.memory_usage.eviction_batch_size", string);
    }

    public String getEngineMemoryUsageEvictionBatchSize() {
        return this.getProperty("space-config.engine.memory_usage.eviction_batch_size", "500");
    }

    public void setEngineMaxThreads(String string) {
        this.setProperty("space-config.engine.max_threads", string);
    }

    public String getEngineMaxThreads() {
        return this.getProperty("space-config.engine.max_threads", "64");
    }

    public void setEngineMinThreads(String string) {
        this.setProperty("space-config.engine.min_threads", string);
    }

    public String getEngineMinThreads() {
        return this.getProperty("space-config.engine.min_threads", "4");
    }

    public void setEngineExtendedMatchClasses(String string) {
        this.setProperty("space-config.engine.extended-match.enabled-classes", string);
    }

    public String getEngineExtendedMatchClasses() {
        return this.getProperty("space-config.engine.extended-match.enabled-classes", "");
    }

    public void setSSLKeyStore(String string) {
        this.setProperty("space-config.ssl-stub-handler.keystore", string);
    }

    public String getSSLKeyStore() {
        return this.getProperty("space-config.ssl-stub-handler.keystore", "testkeys");
    }

    public void setSSLTrustStore(String string) {
        this.setProperty("space-config.ssl-stub-handler.truststore", string);
    }

    public String getSSLTrustStore() {
        return this.getProperty("space-config.ssl-stub-handler.truststore", "testkeys");
    }

    public void setSSLPassword(String string) {
        this.setProperty("space-config.ssl-stub-handler.password", string);
    }

    public String getSSLPassword() {
        return this.getProperty("space-config.ssl-stub-handler.password", "passphrase");
    }

    public void setStubHandler(String string) {
        this.setProperty("space-config.stub-handler", string);
    }

    public String getStubHandler() {
        return this.getProperty("space-config.stub-handler", Constants.SSLStubHandler.SSL_STUB_HANDLER_CLASS_DEFAULT);
    }

    public String isSSLEnabled() {
        return this.getProperty("is_ssl_enabled");
    }

    public void setSSLEnabled(String string) {
        this.setProperty("is_ssl_enabled", string);
    }

    public void setLRMIServerPort(String string) {
        this.setProperty("space-config.lrmi-stub-handler.server-port", string);
    }

    public String getLRMIServerPort() {
        return this.getProperty("space-config.lrmi-stub-handler.server-port", String.valueOf("0"));
    }

    public void setLRMIClientPort(String string) {
        this.setProperty("space-config.lrmi-stub-handler.client-port", string);
    }

    public String getLRMIClientPort() {
        return this.getProperty("space-config.lrmi-stub-handler.client-port", String.valueOf("0"));
    }

    public void setLRMIProtocolName(String string) {
        this.setProperty("space-config.lrmi-stub-handler.protocol-name", string);
    }

    public String getLRMIProtocolName() {
        return this.getProperty("space-config.lrmi-stub-handler.protocol-name", "NIO");
    }

    public boolean isLRMIMultiplexConnection() {
        return Boolean.valueOf(this.getProperty("space-config.lrmi-stub-handler.is-multiplex-connection", Constants.LRMIStubHandler.MULTIPLEX_DEFAULT_CONNECTION));
    }

    public void setLRMIMultiplexConnection(boolean bl2) {
        this.setProperty("space-config.lrmi-stub-handler.is-multiplex-connection", String.valueOf(bl2));
    }

    public void setDCacheConfigName(String string) {
        this.setProperty("space-config.dist-cache.config-name", string);
    }

    public String getDCacheConfigName() {
        return this.getProperty("space-config.dist-cache.config-name", "DefaultConfig");
    }

    public boolean isResetOnFailure() {
        return Boolean.valueOf(this.getProperty("space-config.sa_reset_on_failure", "false"));
    }

    public void setResetOnFailure(boolean bl2) {
        this.setProperty("space-config.sa_reset_on_failure", String.valueOf(bl2));
    }

    public void setMaxSAConnections(String string) {
        this.setProperty("space-config.max_sa_connections", string);
    }

    public String getMaxSAConnections() {
        return this.getProperty("space-config.max_sa_connections", String.valueOf(100));
    }

    public void setInitSAConnections(String string) {
        this.setProperty("space-config.init_sa_connections", string);
    }

    public String getInitSAConnections() {
        return this.getProperty("space-config.init_sa_connections", String.valueOf(10));
    }

    public void setNumberImplicitIndexes(String string) {
        this.setProperty("space-config.number-implicit-indexes", string);
    }

    public String getNumberImplicitIndexes() {
        return this.getProperty("space-config.number-implicit-indexes", String.valueOf(Constants.Client.NUMBER_OF_IMPLICIT_INDEXES_DEFAULT));
    }

    public void setNotifyRetries(String string) {
        this.setProperty("space-config.notifier-retries", string);
    }

    public String getNotifyRetries() {
        return this.getProperty("space-config.notifier-retries", String.valueOf("3"));
    }

    public void setConnectionRetries(String string) {
        this.setProperty("space-config.retries", string);
    }

    public String getConnectionRetries() {
        return this.getProperty("space-config.retries", String.valueOf("10"));
    }

    public void setSerializationType(int n2) {
        this.setProperty("space-config.serialization-type", String.valueOf(n2));
    }

    public int getSerializationType() {
        return Integer.parseInt(this.getProperty("space-config.serialization-type", String.valueOf(Constants.Engine.ENGINE_SERIALIZATION_TYPE_DEFAULT)));
    }

    public boolean isPrivate() {
        return Boolean.valueOf(this.getProperty("space-config.isPrivate", Constants.LookupManager.LOOKUP_IS_PRIVATE_DEFAULT));
    }

    public void setPrivate(boolean bl2) {
        this.setProperty("space-config.isPrivate", String.valueOf(bl2));
    }

    public void setExpirationTimeInterval(String string) {
        this.setProperty("space-config.lease_manager.expiration_time_interval", string);
    }

    public String getExpirationTimeInterval() {
        return this.getProperty("space-config.lease_manager.expiration_time_interval", String.valueOf(60000L));
    }

    public void setSpaceState(String string) {
        this.setProperty("space-config.space_state", string);
    }

    public String getSpaceState() {
        return this.getProperty("space-config.space_state");
    }

    public void setSchemaName(String string) {
        this.setProperty("space-config.schema", string);
    }

    public String getSchemaName() {
        return this.getProperty("space-config.schema", null);
    }

    public void setLoadOnStartup(boolean bl2) {
        this.setProperty("load-on-startup", String.valueOf(bl2));
    }

    public boolean isLoadOnStartup() {
        return Boolean.valueOf(this.getProperty("load-on-startup", Boolean.FALSE.toString()));
    }

    public void setCacheManagerSize(String string) {
        this.setProperty("space-config.engine.cache_size", string);
    }

    public String getCacheManagerSize() {
        return this.getProperty("space-config.engine.cache_size", "100000");
    }

    public void setCachePolicy(String string) {
        this.setProperty("space-config.engine.cache_policy", string);
    }

    public String getCachePolicy() {
        return this.getProperty("space-config.engine.cache_policy", String.valueOf(1));
    }

    public boolean isClustered() {
        return Boolean.valueOf(this.getProperty("space-config.cluster.enabled", Constants.Cluster.IS_CLUSTER_SPACE_DEFAULT));
    }

    public void setClustered(boolean bl2) {
        this.setProperty("space-config.cluster.enabled", String.valueOf(bl2));
        this.m_isClustered = bl2;
    }

    public void setClusterConfigURL(String string) {
        this.setProperty("space-config.cluster.config-url", string);
    }

    public String getClusterConfigURL() {
        return this.getProperty("space-config.cluster.config-url", "none");
    }

    public void setJMSRmiPort(String string) {
        this.setProperty("space-config.jms.connections.rmi-port", string);
    }

    public String getJMSRmiPort() {
        return this.getProperty("space-config.jms.connections.rmi-port", "10098");
    }

    public void setJMSTopicNames(String string) {
        this.setProperty("space-config.jms.administrated-destinations.topics.topic-names", string);
    }

    public String getJMSTopicNames() {
        return this.getProperty("space-config.jms.administrated-destinations.topics.topic-names", "MyTopic,TempTopic");
    }

    public void setJMSQueueNames(String string) {
        this.setProperty("space-config.jms.administrated-destinations.queues.queue-names", string);
    }

    public String getJMSQueueNames() {
        return this.getProperty("space-config.jms.administrated-destinations.queues.queue-names", "MyQueue,TempQueue");
    }

    public void setCustomProperties(Properties properties) {
        this._customProperties = properties;
    }

    public Properties getCustomProperties() {
        return this._customProperties;
    }

    public void setFiltersInfo(FiltersInfo[] filtersInfoArray) {
        this._filtersInfo = filtersInfoArray;
    }

    public void setFilterInfoAt(FiltersInfo filtersInfo, int n2) {
        this._filtersInfo[n2] = filtersInfo;
    }

    public FiltersInfo[] getFiltersInfo() {
        return this._filtersInfo;
    }

    public void setClusterPolicy(ClusterPolicy clusterPolicy) {
        this._clusterPolicy = clusterPolicy;
    }

    public ClusterPolicy getClusterPolicy() {
        return this._clusterPolicy;
    }

    public void setDCacheProperties(JSpaceAttributes jSpaceAttributes) {
        this._dCacheProperties = jSpaceAttributes;
    }

    public JSpaceAttributes getDCacheProperties() {
        return this._dCacheProperties;
    }

    public void setEntityClass(String string) {
        this.setProperty("space-config.persistent.entity-class", string);
    }

    public String getEntityClass() {
        return this.getProperty("space-config.persistent.entity-class", "");
    }

    public boolean isMirrorServiceEnabled() {
        return Boolean.valueOf(this.getProperty("space-config.mirror-service.enabled", "false"));
    }

    public void setMirrorServiceEnabled(boolean bl2) {
        this.setProperty("space-config.mirror-service.enabled", String.valueOf(bl2));
    }
}

