/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShutDownContainer
implements GS.OptionHandler,
Constants {
    private static Logger a = Logger.getLogger("com.gigaspaces.admin");
    private OptionHandler b;
    public static final String OPERATION_NAME = "shutdownContainer";

    public ShutDownContainer() {
        String[] stringArray = new String[]{"h", "help", "url"};
        this.b = new OptionHandler(Formatter.fromArray((String[])stringArray));
    }

    public String getUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n*****************************************************\n");
        stringBuffer.append("Usage: space shutdownContainer [options]\n");
        stringBuffer.append("options:\n");
        stringBuffer.append("\t-h/-help    prints help\n");
        stringBuffer.append("\t-url    space url, mandatory option\n");
        stringBuffer.append("\n*****************************************************\n\n");
        return stringBuffer.toString();
    }

    public String process(String string, BufferedReader bufferedReader) {
        try {
            Map map = this.b.getOptions(string);
            if (map.containsKey("h") || map.containsKey("help")) {
                return this.getUsage();
            }
            String string2 = (String)map.get("url");
            if (JSpaceUtilities.isEmpty(string2, true)) {
                CLIUtilities.printMissingParameterMessage("url");
                return this.getUsage();
            }
            SpaceURL spaceURL = SpaceURLParser.parseURL(string2);
            Object object = null;
            IJSpaceContainer iJSpaceContainer = null;
            try {
                object = CLIFinder.find(spaceURL, -1);
                iJSpaceContainer = (IJSpaceContainer)object;
            }
            catch (Exception exception) {
                CLIUtilities.printWrongContainerURLMessage(string2);
                return "";
            }
            if (iJSpaceContainer == null) {
                CLIUtilities.printWrongContainerURLMessage(string2);
                return "";
            }
            String string3 = iJSpaceContainer.getName();
            System.out.println("Started to shutdown <" + string3 + "> container...");
            iJSpaceContainer.shutdown();
            System.out.println("The <" + string3 + "> container has been shutdown successfully.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() != null) {
                System.out.println(illegalArgumentException.getMessage());
            } else {
                System.out.println(illegalArgumentException.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, exception.toString(), exception);
        }
        return "";
    }
}

