/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.DataContext;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.interpreter.VariableLocator;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAddExpression;
import com.google.clearsilver.jsilver.syntax.node.AAndExpression;
import com.google.clearsilver.jsilver.syntax.node.ADecimalExpression;
import com.google.clearsilver.jsilver.syntax.node.ADescendVariable;
import com.google.clearsilver.jsilver.syntax.node.ADivideExpression;
import com.google.clearsilver.jsilver.syntax.node.AEqExpression;
import com.google.clearsilver.jsilver.syntax.node.AExistsExpression;
import com.google.clearsilver.jsilver.syntax.node.AFunctionExpression;
import com.google.clearsilver.jsilver.syntax.node.AGtExpression;
import com.google.clearsilver.jsilver.syntax.node.AGteExpression;
import com.google.clearsilver.jsilver.syntax.node.AHexExpression;
import com.google.clearsilver.jsilver.syntax.node.ALtExpression;
import com.google.clearsilver.jsilver.syntax.node.ALteExpression;
import com.google.clearsilver.jsilver.syntax.node.AModuloExpression;
import com.google.clearsilver.jsilver.syntax.node.AMultiplyExpression;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.ANeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANegativeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANotExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericAddExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericEqExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericNeExpression;
import com.google.clearsilver.jsilver.syntax.node.AOrExpression;
import com.google.clearsilver.jsilver.syntax.node.AStringExpression;
import com.google.clearsilver.jsilver.syntax.node.ASubtractExpression;
import com.google.clearsilver.jsilver.syntax.node.AVariableExpression;
import com.google.clearsilver.jsilver.syntax.node.PExpression;
import com.google.clearsilver.jsilver.values.Value;
import java.util.LinkedList;

public class ExpressionEvaluator
extends DepthFirstAdapter {
    private Value currentValue;
    private final DataContext context;
    private final FunctionExecutor functionExecutor;

    public ExpressionEvaluator(DataContext context, FunctionExecutor functionExecutor) {
        this.context = context;
        this.functionExecutor = functionExecutor;
    }

    public Value evaluate(PExpression expression) {
        assert (this.currentValue == null);
        expression.apply(this);
        Value result = this.currentValue;
        this.currentValue = null;
        assert (result != null) : "No result set from " + expression.getClass();
        return result;
    }

    public void caseAVariableExpression(AVariableExpression node) {
        VariableLocator variableLocator = new VariableLocator(this);
        String variableName = variableLocator.getVariableName(node.getVariable());
        this.setResult(Value.variableValue(variableName, this.context));
    }

    public void caseAStringExpression(AStringExpression node) {
        String value = node.getValue().getText();
        value = value.substring(1, value.length() - 1);
        Value result = Value.literalValue(value, EscapeMode.ESCAPE_IS_CONSTANT, false);
        this.setResult(result);
    }

    public void caseADecimalExpression(ADecimalExpression node) {
        String value = node.getValue().getText();
        this.setResult(Value.literalValue(Integer.parseInt(value), EscapeMode.ESCAPE_IS_CONSTANT, false));
    }

    public void caseAHexExpression(AHexExpression node) {
        String value = node.getValue().getText();
        value = value.substring(2);
        this.setResult(Value.literalValue(Integer.parseInt(value, 16), EscapeMode.ESCAPE_IS_CONSTANT, false));
    }

    public void caseANumericExpression(ANumericExpression node) {
        this.executeFunction("#", node.getExpression());
    }

    public void caseANotExpression(ANotExpression node) {
        this.executeFunction("!", node.getExpression());
    }

    public void caseAExistsExpression(AExistsExpression node) {
        this.executeFunction("?", node.getExpression());
    }

    public void caseAEqExpression(AEqExpression node) {
        this.executeFunction("==", node.getLeft(), node.getRight());
    }

    public void caseANumericEqExpression(ANumericEqExpression node) {
        this.executeFunction("#==", node.getLeft(), node.getRight());
    }

    public void caseANeExpression(ANeExpression node) {
        this.executeFunction("!=", node.getLeft(), node.getRight());
    }

    public void caseANumericNeExpression(ANumericNeExpression node) {
        this.executeFunction("#!=", node.getLeft(), node.getRight());
    }

    public void caseALtExpression(ALtExpression node) {
        this.executeFunction("<", node.getLeft(), node.getRight());
    }

    public void caseAGtExpression(AGtExpression node) {
        this.executeFunction(">", node.getLeft(), node.getRight());
    }

    public void caseALteExpression(ALteExpression node) {
        this.executeFunction("<=", node.getLeft(), node.getRight());
    }

    public void caseAGteExpression(AGteExpression node) {
        this.executeFunction(">=", node.getLeft(), node.getRight());
    }

    public void caseAAndExpression(AAndExpression node) {
        this.executeFunction("&&", node.getLeft(), node.getRight());
    }

    public void caseAOrExpression(AOrExpression node) {
        this.executeFunction("||", node.getLeft(), node.getRight());
    }

    public void caseAAddExpression(AAddExpression node) {
        this.executeFunction("+", node.getLeft(), node.getRight());
    }

    public void caseANumericAddExpression(ANumericAddExpression node) {
        this.executeFunction("#+", node.getLeft(), node.getRight());
    }

    public void caseASubtractExpression(ASubtractExpression node) {
        this.executeFunction("-", node.getLeft(), node.getRight());
    }

    public void caseAMultiplyExpression(AMultiplyExpression node) {
        this.executeFunction("*", node.getLeft(), node.getRight());
    }

    public void caseADivideExpression(ADivideExpression node) {
        this.executeFunction("/", node.getLeft(), node.getRight());
    }

    public void caseAModuloExpression(AModuloExpression node) {
        this.executeFunction("%", node.getLeft(), node.getRight());
    }

    public void caseANegativeExpression(ANegativeExpression node) {
        this.executeFunction("-", node.getExpression());
    }

    public void caseAFunctionExpression(AFunctionExpression node) {
        LinkedList<PExpression> argsList = node.getArgs();
        PExpression[] args = argsList.toArray(new PExpression[argsList.size()]);
        this.executeFunction(this.getFullFunctionName(node), args);
    }

    private void executeFunction(String name, PExpression ... expressions) {
        Value[] args = new Value[expressions.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.evaluate(expressions[i]);
        }
        this.setResult(this.functionExecutor.executeFunction(name, args));
    }

    private void setResult(Value value) {
        assert (value != null);
        this.currentValue = value;
    }

    private String getFullFunctionName(AFunctionExpression node) {
        final StringBuilder result = new StringBuilder();
        node.getName().apply(new DepthFirstAdapter(){

            public void caseANameVariable(ANameVariable node) {
                result.append(node.getWord().getText());
            }

            public void caseADescendVariable(ADescendVariable node) {
                node.getParent().apply(this);
                result.append('.');
                node.getChild().apply(this);
            }
        });
        return result.toString();
    }
}

