/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueStack<T>
implements Iterable<T> {
    private T firstObject = null;
    private LinkedList<T> objectStack = null;
    private HashSet<T> objectsSet = null;

    public boolean push(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.objectStack == null) {
            if (this.firstObject == null) {
                this.firstObject = object;
                return true;
            }
            if (this.firstObject.equals(object)) {
                return false;
            }
            this.initStackAndSet();
        } else if (this.objectsSet.contains(object)) {
            return false;
        }
        this.objectStack.offerLast(object);
        this.objectsSet.add(object);
        return true;
    }

    private void initStackAndSet() {
        this.objectStack = new LinkedList();
        this.objectsSet = new HashSet();
        this.objectStack.offerLast(this.firstObject);
        this.objectsSet.add(this.firstObject);
        this.firstObject = null;
    }

    public T pop() {
        T returnedValue = null;
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        if (this.objectStack == null) {
            returnedValue = this.firstObject;
            this.firstObject = null;
        } else {
            returnedValue = this.objectStack.pollLast();
            this.objectsSet.remove(returnedValue);
        }
        return returnedValue;
    }

    public boolean isEmpty() {
        if (this.firstObject != null) {
            return false;
        }
        return this.objectStack == null || this.objectStack.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.objectStack == null) {
            this.initStackAndSet();
        }
        return new ImmutableIterator(this.objectStack.iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmutableIterator<T>
    implements Iterator<T> {
        private static final String MODIFICATION_ERROR_MESSAGE = "ResourceStack cannot be modyfied by Iterator.remove()";
        private final Iterator<T> iterator;

        private ImmutableIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(MODIFICATION_ERROR_MESSAGE);
        }
    }
}

