/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.autoescape;

import com.google.clearsilver.jsilver.exceptions.JSilverAutoEscapingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EscapeMode {
    ESCAPE_NONE("none", false),
    ESCAPE_HTML("html", false),
    ESCAPE_JS("js", false),
    ESCAPE_URL("url", false),
    ESCAPE_IS_CONSTANT("constant", false),
    ESCAPE_AUTO("auto", true),
    ESCAPE_AUTO_HTML("auto_html", true),
    ESCAPE_AUTO_JS("auto_js", true),
    ESCAPE_AUTO_JS_UNQUOTED("auto_js_unquoted", true),
    ESCAPE_AUTO_STYLE("auto_style", true),
    ESCAPE_AUTO_ATTR("auto_attr", true),
    ESCAPE_AUTO_UNQUOTED_ATTR("auto_attr_unquoted", true),
    ESCAPE_AUTO_ATTR_URI("auto_attr_uri", true),
    ESCAPE_AUTO_UNQUOTED_ATTR_URI("auto_attr_uri_unquoted", true),
    ESCAPE_AUTO_ATTR_URI_START("auto_attr_uri_start", true),
    ESCAPE_AUTO_UNQUOTED_ATTR_URI_START("auto_attr_uri_start_unquoted", true),
    ESCAPE_AUTO_ATTR_JS("auto_attr_js", true),
    ESCAPE_AUTO_ATTR_UNQUOTED_JS("auto_attr_unquoted_js", true),
    ESCAPE_AUTO_UNQUOTED_ATTR_JS("auto_attr_js_unquoted", true),
    ESCAPE_AUTO_UNQUOTED_ATTR_UNQUOTED_JS("auto_attr_js_unquoted_js", true),
    ESCAPE_AUTO_ATTR_CSS("auto_attr_style", true),
    ESCAPE_AUTO_UNQUOTED_ATTR_CSS("auto_attr_style_unquoted", true);

    private String escapeCmd;
    private boolean autoEscaper;

    private EscapeMode(String escapeCmd, boolean autoEscaper) {
        this.escapeCmd = escapeCmd;
        this.autoEscaper = autoEscaper;
    }

    public static EscapeMode computeEscapeMode(String escapeCmd, boolean doAutoEscape) {
        if (escapeCmd != null) {
            for (EscapeMode e : EscapeMode.values()) {
                if (!e.escapeCmd.equals(escapeCmd)) continue;
                return e;
            }
            throw new JSilverAutoEscapingException("Invalid escaping mode specified: " + escapeCmd);
        }
        EscapeMode escapeMode = doAutoEscape ? ESCAPE_AUTO : ESCAPE_NONE;
        return escapeMode;
    }

    public static EscapeMode computeEscapeMode(String escapeCmd) {
        return EscapeMode.computeEscapeMode(escapeCmd, false);
    }

    public static EscapeMode combineModes(EscapeMode left, EscapeMode right) {
        if (left.equals((Object)ESCAPE_NONE) || right.equals((Object)ESCAPE_NONE)) {
            return ESCAPE_NONE;
        }
        return ESCAPE_IS_CONSTANT;
    }

    public boolean isAutoEscapingMode() {
        return this.autoEscaper;
    }

    public String getEscapeCommand() {
        return this.escapeCmd;
    }
}

