/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    public static final int DIRECTION_FORWARD = 0;
    public static final int DIRECTION_BACKWARD = 1;
    private final String QUOTES = "'\"";
    public int currentPosition;
    public int maxPosition;
    public String str;
    public String delimiters;
    public boolean retTokens;
    public int lastQuoteIdx = -1;
    public char lastQuote = '\u0000';
    public boolean ignoreQuotes = true;
    public boolean ignoreDoubleTokens;
    public int minimumIndex = 0;
    public int tokenIndex = -1;
    public int parseDirection = 0;

    public StringTokenizer(String string, String string2, boolean bl2, boolean bl3) {
        this.str = string == null ? "" : string;
        this.delimiters = string2;
        this.retTokens = bl2;
        this.ignoreDoubleTokens = bl3;
        this.setTokenizeDirection(0);
    }

    public StringTokenizer(String string, String string2, boolean bl2) {
        this(string, string2, bl2, true);
    }

    public StringTokenizer(String string, String string2) {
        this(string, string2, false, true);
    }

    public StringTokenizer(String string) {
        this(string, " \t\n\r", false, true);
    }

    public synchronized void setReturnTokens(boolean bl2) {
        this.retTokens = bl2;
    }

    public String toString() {
        return this.str;
    }

    public synchronized void setTokenizeDirection(int n2) {
        this.parseDirection = n2;
        this.reset();
    }

    public int getTokenizeDirection() {
        return this.parseDirection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setString(String string) {
        if (string == null) {
            string = "";
        }
        StringTokenizer stringTokenizer = this;
        synchronized (stringTokenizer) {
            this.str = string;
            this.reset();
        }
    }

    public void setQuotesEnabled(boolean bl2) {
        this.ignoreQuotes = !bl2;
    }

    public boolean getQuotesEnabled() {
        return this.ignoreQuotes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void appendString(String string) {
        if (string == null) {
            return;
        }
        switch (this.parseDirection) {
            case 1: {
                StringTokenizer stringTokenizer = this;
                synchronized (stringTokenizer) {
                    this.str = this.str.concat(string);
                    break;
                }
            }
            default: {
                StringTokenizer stringTokenizer = this;
                synchronized (stringTokenizer) {
                    this.str = this.str.concat(string);
                    this.maxPosition = this.str.length();
                    break;
                }
            }
        }
    }

    public String nextToken() {
        String string = null;
        this.tokenIndex = this.currentPosition;
        switch (this.parseDirection) {
            case 1: {
                string = this.nextBackwardToken();
                break;
            }
            default: {
                string = this.nextForwardToken();
            }
        }
        return string;
    }

    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public boolean hasMoreTokens() {
        switch (this.parseDirection) {
            case 1: {
                return this.hasBackwardMoreTokens();
            }
        }
        return this.hasMoreForwardTokens();
    }

    public int countTokens() {
        switch (this.parseDirection) {
            case 1: {
                return this.countBackwardTokens();
            }
        }
        return this.countForwardTokens();
    }

    public String nextToken(String string) {
        this.delimiters = string;
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        StringTokenizer stringTokenizer = this;
        synchronized (stringTokenizer) {
            switch (this.parseDirection) {
                case 1: {
                    this.minimumIndex = this.str.length() - 1;
                    this.maxPosition = 0;
                    break;
                }
                default: {
                    this.minimumIndex = 0;
                    this.maxPosition = this.str.length();
                }
            }
            this.lastQuote = '\u0000';
            this.lastQuoteIdx = -1;
            this.tokenIndex = this.currentPosition = this.minimumIndex;
        }
    }

    public String[] toArray() {
        this.reset();
        String[] stringArray = new String[this.countTokens()];
        int n2 = 0;
        while (this.hasMoreTokens()) {
            stringArray[n2++] = this.nextToken();
        }
        return stringArray;
    }

    public char getLastDelimiter() {
        try {
            return this.str.charAt(this.getTokenIndex() - 1);
        }
        catch (Throwable throwable) {
            return '\u0000';
        }
    }

    public int countForwardTokens() {
        int n2 = 0;
        int n3 = this.currentPosition;
        while (n3 < this.maxPosition) {
            while (!this.retTokens && n3 < this.maxPosition && this.isDelimiterAtIndex(n3)) {
                if (!this.ignoreDoubleTokens && this.delimiters.indexOf(this.str.charAt(n3 - 1)) < 0) {
                    ++n3;
                    continue;
                }
                if (!this.ignoreDoubleTokens && this.delimiters.indexOf(this.str.charAt(n3 - 1)) >= 0) {
                    ++n2;
                    ++n3;
                    continue;
                }
                if (!this.ignoreDoubleTokens) continue;
                ++n3;
            }
            if (n3 >= this.maxPosition) break;
            int n4 = n3;
            while (n3 < this.maxPosition && this.delimiters.indexOf(this.str.charAt(n3)) < 0) {
                ++n3;
            }
            if (this.retTokens && n4 == n3 && this.isDelimiterAtIndex(n3)) {
                ++n3;
            }
            if (!this.isDelimiterAtIndex(n3)) continue;
            ++n2;
        }
        return n2;
    }

    public int countBackwardTokens() {
        int n2 = 0;
        int n3 = this.currentPosition;
        while (n3 > this.maxPosition) {
            while (!this.retTokens && n3 > this.maxPosition && this.isDelimiterAtIndex(n3)) {
                if (!this.ignoreDoubleTokens && this.delimiters.indexOf(this.str.charAt(n3 + 1)) < 0) {
                    --n3;
                    continue;
                }
                if (!this.ignoreDoubleTokens && this.delimiters.indexOf(this.str.charAt(n3 + 1)) >= 0) {
                    ++n2;
                    --n3;
                    continue;
                }
                if (!this.ignoreDoubleTokens) continue;
                --n3;
            }
            if (n3 <= this.maxPosition) break;
            int n4 = n3;
            while (n3 > this.maxPosition && this.delimiters.indexOf(this.str.charAt(n3)) < 0) {
                --n3;
            }
            if (this.retTokens && n4 == n3 && this.isDelimiterAtIndex(n3)) {
                --n3;
            }
            ++n2;
        }
        return n2;
    }

    public String nextForwardToken() {
        this.skipForwardDelimiters();
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int n2 = this.currentPosition;
        this.lastQuoteIdx = -1;
        while (this.currentPosition < this.maxPosition && !this.isDelimiterAtIndex(this.currentPosition)) {
            ++this.currentPosition;
        }
        if (this.retTokens && n2 == this.currentPosition) {
            ++this.currentPosition;
            return Character.toString(this.str.charAt(n2));
        }
        this.currentPosition = this.currentPosition < this.maxPosition ? ++this.currentPosition : this.maxPosition + 1;
        return this.str.substring(n2, this.currentPosition - 1);
    }

    public String nextBackwardToken() {
        this.skipBackwardDelimiters();
        if (this.currentPosition <= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int n2 = this.currentPosition;
        while (this.currentPosition > this.maxPosition && !this.isDelimiterAtIndex(this.currentPosition)) {
            --this.currentPosition;
        }
        if (!this.retTokens && n2 == this.currentPosition) {
            --this.currentPosition;
            return new String("");
        }
        --this.currentPosition;
        if (this.currentPosition > this.maxPosition) {
            return this.str.substring(this.currentPosition + 2, n2 + 1);
        }
        return this.str.substring(this.currentPosition + 1, n2 + 1);
    }

    public void skipForwardDelimiters() {
        while (!this.retTokens && this.currentPosition < this.maxPosition && this.isDelimiterAtIndex(this.currentPosition) && this.ignoreDoubleTokens) {
            ++this.currentPosition;
        }
    }

    public void skipBackwardDelimiters() {
        while (!this.retTokens && this.currentPosition < this.maxPosition && this.isDelimiterAtIndex(this.currentPosition) && this.ignoreDoubleTokens) {
            ++this.currentPosition;
        }
    }

    public boolean hasMoreForwardTokens() {
        this.skipForwardDelimiters();
        return this.currentPosition < this.maxPosition;
    }

    public boolean hasBackwardMoreTokens() {
        this.skipBackwardDelimiters();
        return this.currentPosition > this.maxPosition;
    }

    public boolean isDelimiterAtIndex(int n2) {
        if (n2 >= 0 && n2 < this.str.length()) {
            boolean bl2;
            boolean bl3 = this.isQuoteIdentiferAtIndex(n2);
            boolean bl4 = bl2 = this.delimiters.indexOf(this.str.charAt(n2)) >= 0;
            if (bl3) {
                return false;
            }
            return bl2;
        }
        return false;
    }

    public boolean isQuoteIdentiferAtIndex(int n2) {
        if (this.ignoreQuotes || n2 < 0 || n2 >= this.str.length()) {
            return false;
        }
        try {
            boolean bl2;
            boolean bl3 = bl2 = "'\"".indexOf(this.str.charAt(n2)) >= 0;
            if (n2 >= 1 && this.str.charAt(n2 - 1) == '\\') {
                bl2 = false;
            }
            if (bl2) {
                if (this.lastQuote == this.str.charAt(n2)) {
                    this.lastQuote = '\u0000';
                    this.lastQuoteIdx = -1;
                } else {
                    this.lastQuote = this.str.charAt(n2);
                    this.lastQuoteIdx = n2;
                }
            } else {
                switch (this.parseDirection) {
                    case 1: {
                        bl2 = n2 < this.lastQuoteIdx;
                        break;
                    }
                    default: {
                        bl2 = n2 > this.lastQuoteIdx && this.lastQuoteIdx >= 0;
                    }
                }
            }
            return bl2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

