/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class JDrawer
extends JWindow
implements SwingConstants {
    public ArrayList changeListeners = null;
    public Window parentWindow = null;
    public FrameListener eventHandler = new FrameListener(null);
    public ToggleAnimation animator = new ToggleAnimation(null);
    public boolean quickToggle = false;
    public JPanel contentPane = new JPanel(new BorderLayout());
    public int preferredLoc = 3;
    public DrawerHandle handleEast = new DrawerHandle(6, true);
    public DrawerHandle handleWest = new DrawerHandle(6, true);
    public DrawerHandle handleNorth = new DrawerHandle(6, false);
    public DrawerHandle handleSouth = new DrawerHandle(6, false);
    public JComponent userContent = new JPanel(new BorderLayout());
    public Border contentBdr = BorderFactory.createEtchedBorder(1);
    public DragHandler dndHandler = new DragHandler(null);
    public Dimension userSize = null;
    private ChangeEvent toggleEvent = new ChangeEvent(this);

    public JDrawer() {
        this(null, 3, false);
    }

    public JDrawer(Window window) {
        this(window, 3, false);
    }

    public JDrawer(Window window, int n2) {
        this(window, n2, false);
    }

    public JDrawer(Window window, int n2, boolean bl2) {
        super(window);
        this.contentPane.add((Component)this.handleWest, "West");
        this.contentPane.add((Component)this.handleEast, "East");
        this.contentPane.add((Component)this.handleSouth, "South");
        this.contentPane.add((Component)this.handleNorth, "North");
        this.contentPane.add((Component)this.userContent, "Center");
        Border border = BorderFactory.createLineBorder(this.getForeground(), 1);
        this.contentPane.setBorder(border);
        this.userContent.setBorder(this.contentBdr);
        this.setVisible(bl2);
        super.setContentPane(this.contentPane);
        this.setParentWindow(window);
        this.setPreferredLocation(n2);
        this.pack();
    }

    public synchronized void toggle() {
        if (!this.animator.isToggling()) {
            if (this.quickToggle) {
                this.setVisible(!this.isVisible());
                this.fireStateChanged(this.toggleEvent);
            } else {
                SwingUtilities.invokeLater(this.animator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        if (!this.changeListeners.contains(changeListener)) {
            ArrayList arrayList = this.changeListeners;
            synchronized (arrayList) {
                this.changeListeners.add(changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null || this.changeListeners == null) {
            return;
        }
        if (this.changeListeners.contains(changeListener)) {
            ArrayList arrayList = this.changeListeners;
            synchronized (arrayList) {
                this.changeListeners.remove(changeListener);
            }
        }
    }

    public boolean isToggled() {
        return this.isVisible();
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    public void setPreferredLocation(int n2) {
        this.clearHandleListeners(this.preferredLoc, n2);
        this.preferredLoc = n2;
        this.updateBounds();
    }

    public int getPreferredLocation() {
        return this.preferredLoc;
    }

    public void setParentWindow(Window window) {
        if (window == null) {
            throw new NullPointerException();
        }
        if (this.parentWindow != null) {
            this.parentWindow.removeComponentListener(this.eventHandler);
            this.parentWindow.removeWindowListener(this.eventHandler);
        }
        this.parentWindow = window;
        this.parentWindow.addComponentListener(this.eventHandler);
        this.parentWindow.addWindowListener(this.eventHandler);
        this.updateBounds();
    }

    public void setQuickToggleEnabled(boolean bl2) {
        this.quickToggle = bl2;
    }

    public Container getContentPane() {
        return this.userContent;
    }

    public boolean getFocusableWindowState() {
        return false;
    }

    public void setContentPane(Container container) {
        container.remove(this.userContent);
        this.userContent.setBorder(null);
        if (container != null) {
            container.add((Component)container, "Center");
            this.userContent = (JComponent)container;
            this.userContent.setBorder(this.contentBdr);
        }
    }

    public void clearHandleListeners(int n2, int n3) {
        switch (n2) {
            case 1: {
                this.handleNorth.removeMouseListener(this.dndHandler);
                this.handleNorth.removeMouseMotionListener(this.dndHandler);
                this.contentPane.add((Component)this.handleSouth, "South");
                break;
            }
            case 5: {
                this.handleSouth.removeMouseListener(this.dndHandler);
                this.handleSouth.removeMouseMotionListener(this.dndHandler);
                this.contentPane.add((Component)this.handleNorth, "North");
                break;
            }
            case 2: 
            case 7: {
                this.handleWest.removeMouseListener(this.dndHandler);
                this.handleWest.removeMouseMotionListener(this.dndHandler);
                this.contentPane.add((Component)this.handleEast, "East");
                break;
            }
            case 3: 
            case 4: {
                this.handleEast.removeMouseListener(this.dndHandler);
                this.handleEast.removeMouseMotionListener(this.dndHandler);
                this.contentPane.add((Component)this.handleWest, "West");
            }
        }
        switch (n3) {
            case 1: {
                this.handleNorth.addMouseListener(this.dndHandler);
                this.handleNorth.addMouseMotionListener(this.dndHandler);
                this.contentPane.remove(this.handleSouth);
                break;
            }
            case 5: {
                this.handleSouth.addMouseListener(this.dndHandler);
                this.handleSouth.addMouseMotionListener(this.dndHandler);
                this.contentPane.remove(this.handleNorth);
                break;
            }
            case 2: 
            case 7: {
                this.handleWest.addMouseListener(this.dndHandler);
                this.handleWest.addMouseMotionListener(this.dndHandler);
                this.contentPane.remove(this.handleEast);
                break;
            }
            case 3: 
            case 4: {
                this.handleEast.addMouseListener(this.dndHandler);
                this.handleEast.addMouseMotionListener(this.dndHandler);
                this.contentPane.remove(this.handleWest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStateChanged(ChangeEvent changeEvent) {
        if (this.changeListeners == null) {
            return;
        }
        ArrayList arrayList = this.changeListeners;
        synchronized (arrayList) {
            Iterator iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                ChangeListener changeListener = (ChangeListener)iterator.next();
                try {
                    changeListener.stateChanged(changeEvent);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void updateBounds() {
        if (!this.parentWindow.isShowing()) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Rectangle rectangle = this.parentWindow.getBounds();
        switch (this.preferredLoc) {
            case 1: {
                n2 = this.isVisible() ? (this.userSize == null ? this.getPreferredSize().height : this.userSize.height) : 0;
                n3 = rectangle.width;
                n4 = n3 / 20;
                this.setBounds(rectangle.x + n4, rectangle.y - n2, rectangle.width - 2 * n4, n2);
                break;
            }
            case 5: {
                n2 = this.isVisible() ? (this.userSize == null ? this.getPreferredSize().height : this.userSize.height) : 0;
                n3 = rectangle.width;
                n4 = n3 / 20;
                this.setBounds(rectangle.x + n4, rectangle.y + rectangle.height, rectangle.width - 2 * n4, n2);
                break;
            }
            case 2: 
            case 7: {
                n2 = rectangle.height;
                n3 = this.isVisible() ? (this.userSize == null ? this.getPreferredSize().width : this.userSize.width) : 0;
                n4 = n2 / 20;
                this.setBounds(rectangle.x - n3, rectangle.y + n4, n3, n2 - 2 * n4);
                break;
            }
            case 3: 
            case 4: {
                n2 = rectangle.height;
                n3 = this.isVisible() ? (this.userSize == null ? this.getPreferredSize().width : this.userSize.width) : 0;
                n4 = n2 / 20;
                this.setBounds(rectangle.x + rectangle.width, rectangle.y + n4, n3, n2 - 2 * n4);
                break;
            }
        }
        if (this.isVisible()) {
            this.validateTree();
        }
    }

    public boolean canExpand(int n2) {
        switch (n2) {
            case 1: {
                return this.canExpandNorth();
            }
            case 5: {
                return this.canExpandSouth();
            }
            case 2: 
            case 7: {
                return this.canExpandWest();
            }
            case 3: 
            case 4: {
                return this.canExpandWest();
            }
        }
        return false;
    }

    public Component getActiveHandle() {
        switch (this.preferredLoc) {
            case 1: {
                return this.handleNorth;
            }
            case 5: {
                return this.handleSouth;
            }
            case 2: 
            case 7: {
                return this.handleWest;
            }
            case 3: 
            case 4: {
                return this.handleEast;
            }
        }
        return null;
    }

    private boolean canExpandEast() {
        Rectangle rectangle = this.parentWindow.getBounds();
        int n2 = rectangle.x + rectangle.width + (this.userSize != null ? this.userSize.width : this.contentPane.getPreferredSize().width);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n3 = toolkit.getScreenSize().width;
        return n2 < n3;
    }

    private boolean canExpandSouth() {
        Rectangle rectangle = this.parentWindow.getBounds();
        int n2 = rectangle.y + rectangle.height + (this.userSize != null ? this.userSize.height : this.contentPane.getPreferredSize().height);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n3 = toolkit.getScreenSize().height;
        return n2 < n3;
    }

    private boolean canExpandNorth() {
        Rectangle rectangle = this.parentWindow.getBounds();
        int n2 = rectangle.y - (this.userSize != null ? this.userSize.height : this.contentPane.getPreferredSize().height);
        return n2 >= 0;
    }

    private boolean canExpandWest() {
        Rectangle rectangle = this.parentWindow.getBounds();
        int n2 = rectangle.x - (this.userSize != null ? this.userSize.width : this.contentPane.getPreferredSize().width);
        return n2 >= 0;
    }

    public static class 1 {
    }

    private class ToggleAnimation
    implements Runnable {
        private boolean isToggling = false;

        private ToggleAnimation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean isToggling() {
            ToggleAnimation toggleAnimation = this;
            synchronized (toggleAnimation) {
                return this.isToggling;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleSouth(boolean bl2) {
            if (!bl2 && !JDrawer.this.canExpandSouth() && JDrawer.this.canExpandNorth()) {
                JDrawer.this.setVisible(false);
                JDrawer.this.setPreferredLocation(1);
                JDrawer.this.setVisible(true);
                this.toggleNorth(bl2);
            }
            int n2 = JDrawer.this.getSize().height;
            int n3 = JDrawer.this.getSize().width;
            boolean bl3 = bl2 ? n2 > 0 : n2 < JDrawer.this.getPreferredSize().height;
            long l2 = JDrawer.this.getPreferredSize().height / 10;
            while (bl3) {
                n2 = bl2 ? (int)((long)n2 - l2) : (int)((long)n2 + l2);
                boolean bl4 = bl2 ? n2 != 0 : (bl3 = n2 < JDrawer.this.getPreferredSize().height);
                if (n2 < 0) {
                    bl3 = false;
                    n2 = 0;
                }
                JDrawer jDrawer = JDrawer.this;
                synchronized (jDrawer) {
                    JDrawer.this.setSize(n3, n2);
                }
                if (!bl3) continue;
                try {
                    Thread.sleep(2L);
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleNorth(boolean bl2) {
            if (!bl2 && !JDrawer.this.canExpandNorth() && JDrawer.this.canExpandSouth()) {
                JDrawer.this.setVisible(false);
                JDrawer.this.setPreferredLocation(5);
                JDrawer.this.setVisible(true);
                this.toggleSouth(bl2);
            }
            int n2 = JDrawer.this.getSize().height;
            int n3 = JDrawer.this.getSize().width;
            boolean bl3 = bl2 ? n2 > 0 : n2 < JDrawer.this.getPreferredSize().height;
            long l2 = JDrawer.this.getPreferredSize().height / 10;
            while (bl3) {
                n2 = bl2 ? (int)((long)n2 - l2) : (int)((long)n2 + l2);
                boolean bl4 = bl2 ? n2 != 0 : (bl3 = n2 < JDrawer.this.getPreferredSize().height);
                if (n2 < 0) {
                    bl3 = false;
                    n2 = 0;
                }
                Rectangle rectangle = JDrawer.this.getBounds();
                JDrawer jDrawer = JDrawer.this;
                synchronized (jDrawer) {
                    JDrawer.this.setBounds(rectangle.x, rectangle.y + 3 * (bl2 ? 1 : -1), n3, n2);
                }
                if (!bl3) continue;
                try {
                    Thread.sleep(2L);
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleWest(boolean bl2) {
            if (!bl2 && !JDrawer.this.canExpandWest() && JDrawer.this.canExpandEast()) {
                JDrawer.this.setVisible(false);
                JDrawer.this.setPreferredLocation(3);
                JDrawer.this.setVisible(true);
                this.toggleEast(bl2);
            }
            int n2 = JDrawer.this.getSize().height;
            int n3 = JDrawer.this.getSize().width;
            boolean bl3 = bl2 ? n3 > 0 : n3 < JDrawer.this.getPreferredSize().width;
            long l2 = JDrawer.this.getPreferredSize().width / 10;
            while (bl3) {
                n3 = bl2 ? (int)((long)n3 - l2) : (int)((long)n3 + l2);
                boolean bl4 = bl2 ? n3 != 0 : (bl3 = n3 < JDrawer.this.getPreferredSize().width);
                if (n3 < 0) {
                    bl3 = false;
                    n3 = 0;
                }
                Rectangle rectangle = JDrawer.this.getBounds();
                JDrawer jDrawer = JDrawer.this;
                synchronized (jDrawer) {
                    JDrawer.this.setBounds(rectangle.x + 3 * (bl2 ? 1 : -1), rectangle.y, n3, n2);
                }
                if (!bl3) continue;
                try {
                    Thread.sleep(2L);
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleEast(boolean bl2) {
            if (!bl2 && !JDrawer.this.canExpandEast() && JDrawer.this.canExpandWest()) {
                JDrawer.this.setVisible(false);
                JDrawer.this.setPreferredLocation(7);
                JDrawer.this.setVisible(true);
                this.toggleWest(bl2);
            }
            int n2 = JDrawer.this.getSize().height;
            int n3 = JDrawer.this.getSize().width;
            boolean bl3 = bl2 ? n3 > 0 : n3 < JDrawer.this.getPreferredSize().width;
            long l2 = JDrawer.this.getPreferredSize().height / 10;
            while (bl3) {
                n3 = bl2 ? (int)((long)n3 - l2) : (int)((long)n3 + l2);
                boolean bl4 = bl2 ? n3 != 0 : (bl3 = n3 < JDrawer.this.getPreferredSize().width);
                if (n3 < 0) {
                    bl3 = false;
                    n3 = 0;
                }
                JDrawer jDrawer = JDrawer.this;
                synchronized (jDrawer) {
                    JDrawer.this.setSize(n3, n2);
                }
                if (!bl3) continue;
                try {
                    Thread.sleep(2L);
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }

        public void run() {
            this.isToggling = true;
            boolean bl2 = JDrawer.this.isVisible();
            JDrawer.this.setVisible(true);
            switch (JDrawer.this.preferredLoc) {
                case 1: {
                    this.toggleNorth(bl2);
                    break;
                }
                case 5: {
                    this.toggleSouth(bl2);
                    break;
                }
                case 2: 
                case 7: {
                    this.toggleWest(bl2);
                    break;
                }
                case 3: 
                case 4: {
                    this.toggleEast(bl2);
                    break;
                }
            }
            if (bl2) {
                JDrawer.this.setVisible(false);
            }
            JDrawer.this.updateBounds();
            JDrawer.this.fireStateChanged(JDrawer.this.toggleEvent);
            this.isToggling = false;
        }

        public /* synthetic */ ToggleAnimation(1 var2_2) {
            this();
        }
    }

    private static class DrawerHandle
    extends JComponent {
        private Dimension reqMin;
        private Dimension reqPref;
        private Dimension reqMax;

        public DrawerHandle(int n2, boolean bl2) {
            this.reqMin = new Dimension(!bl2 ? 0 : n2, !bl2 ? n2 : 0);
            this.reqPref = new Dimension(!bl2 ? 0 : n2, !bl2 ? n2 : 0);
            this.reqMax = new Dimension(!bl2 ? Integer.MAX_VALUE : n2, !bl2 ? n2 : Integer.MAX_VALUE);
        }

        public void changeShape(Dimension dimension, Dimension dimension2, Dimension dimension3) {
            this.reqMin = dimension;
            this.reqPref = dimension2;
            this.reqMax = dimension3;
            this.invalidate();
        }

        public Dimension getMinimumSize() {
            return this.reqMin;
        }

        public Dimension getPreferredSize() {
            return this.reqPref;
        }

        public Dimension getMaximumSize() {
            return this.reqMax;
        }
    }

    private class DragHandler
    extends MouseInputAdapter {
        private boolean toggleOnRelease = false;
        private boolean isDragging = false;
        private Dimension originalSize = null;

        private DragHandler() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            switch (JDrawer.this.preferredLoc) {
                case 1: 
                case 5: {
                    JDrawer.this.setCursor(Cursor.getPredefinedCursor(9));
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    JDrawer.this.setCursor(Cursor.getPredefinedCursor(11));
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.isDragging) {
                JDrawer.this.setCursor(Cursor.getDefaultCursor());
            } else {
                this.mouseEntered(mouseEvent);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            Rectangle rectangle = JDrawer.this.getBounds();
            JDrawer.this.userContent.invalidate();
            JDrawer.this.validateTree();
            int n4 = JDrawer.super.getContentPane().getMinimumSize().height;
            int n5 = JDrawer.super.getContentPane().getMinimumSize().width;
            this.toggleOnRelease = false;
            this.isDragging = true;
            switch (JDrawer.this.preferredLoc) {
                case 1: {
                    int n6 = Math.abs(n3);
                    if (n3 == 0) {
                        return;
                    }
                    if (n3 < 0) {
                        JDrawer.this.setBounds(rectangle.x, rectangle.y - n6, rectangle.width, rectangle.height + n6);
                    } else {
                        JDrawer.this.setBounds(rectangle.x, rectangle.y + n6, rectangle.width, rectangle.height - n6);
                    }
                    if (JDrawer.this.getBounds().height > n4) {
                        if (JDrawer.this.userSize != null) {
                            JDrawer.this.userSize.setSize(rectangle.width, JDrawer.this.getBounds().height);
                            break;
                        }
                        JDrawer.this.userSize = new Dimension(rectangle.width, JDrawer.this.getBounds().height);
                        break;
                    }
                    if (JDrawer.this.getBounds().height >= n4) break;
                    this.toggleOnRelease = true;
                    break;
                }
                case 5: {
                    if (n3 == 0) {
                        return;
                    }
                    if (n3 < 0) {
                        int n7 = rectangle.height - Math.abs(n3);
                        if (n7 < 0) {
                            n7 = 0;
                        }
                        JDrawer.this.setBounds(rectangle.x, rectangle.y, rectangle.width, n7);
                    } else {
                        JDrawer.this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height + n3);
                    }
                    if (JDrawer.this.getBounds().height > n4) {
                        if (JDrawer.this.userSize != null) {
                            JDrawer.this.userSize.setSize(rectangle.width, JDrawer.this.getBounds().height);
                            break;
                        }
                        JDrawer.this.userSize = new Dimension(rectangle.width, JDrawer.this.getBounds().height);
                        break;
                    }
                    if (JDrawer.this.getBounds().height >= n4) break;
                    this.toggleOnRelease = true;
                    break;
                }
                case 3: 
                case 4: {
                    if (n2 == 0 || this.toggleOnRelease) {
                        return;
                    }
                    if (n2 < 0) {
                        int n8 = rectangle.width - Math.abs(n2);
                        if (n8 < 0) {
                            n8 = 0;
                        }
                        JDrawer.this.setBounds(rectangle.x, rectangle.y, n8, rectangle.height);
                    } else {
                        JDrawer.this.setBounds(rectangle.x, rectangle.y, rectangle.width + n2, rectangle.height);
                    }
                    if (JDrawer.this.getBounds().width > n5) {
                        if (JDrawer.this.userSize != null) {
                            JDrawer.this.userSize.setSize(JDrawer.this.getBounds().width, rectangle.height);
                            break;
                        }
                        JDrawer.this.userSize = new Dimension(JDrawer.this.getBounds().width, rectangle.height);
                        break;
                    }
                    if (JDrawer.this.getBounds().width >= n5) break;
                    this.toggleOnRelease = true;
                    break;
                }
                case 2: 
                case 7: {
                    int n9 = Math.abs(n2);
                    if (n2 == 0 || this.toggleOnRelease) {
                        return;
                    }
                    if (n2 < 0) {
                        JDrawer.this.setBounds(rectangle.x - n9, rectangle.y, rectangle.width + n9, rectangle.height);
                    } else {
                        JDrawer.this.setBounds(rectangle.x + n9, rectangle.y, rectangle.width - n9, rectangle.height);
                    }
                    if (JDrawer.this.getBounds().width > n5) {
                        if (JDrawer.this.userSize != null) {
                            JDrawer.this.userSize.setSize(JDrawer.this.getBounds().width, rectangle.height);
                            break;
                        }
                        JDrawer.this.userSize = new Dimension(JDrawer.this.getBounds().width, rectangle.height);
                        break;
                    }
                    if (JDrawer.this.getBounds().width >= n5) break;
                    this.toggleOnRelease = true;
                }
            }
            JDrawer.this.getContentPane().invalidate();
            JDrawer.this.validateTree();
            mouseEvent.consume();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.toggleOnRelease) {
                JDrawer.this.toggle();
                JDrawer.this.userSize = this.originalSize;
            }
            this.originalSize = null;
            this.isDragging = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.originalSize = new Dimension(JDrawer.this.getBounds().width, JDrawer.this.getBounds().height);
        }

        public /* synthetic */ DragHandler(1 var2_2) {
            this();
        }
    }

    private class FrameListener
    extends ComponentAdapter
    implements WindowListener {
        public boolean isToggled = false;

        private FrameListener() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (!JDrawer.this.isEnabled()) {
                JDrawer.this.setEnabled(true);
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            if (window != JDrawer.this) {
                JDrawer.this.dispatchEvent(new WindowEvent(JDrawer.this, windowEvent.getID()));
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            if (window != JDrawer.this) {
                JDrawer.this.dispatchEvent(new WindowEvent(JDrawer.this, windowEvent.getID()));
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            JDialog jDialog;
            Window window = windowEvent.getOppositeWindow();
            if (window instanceof JDialog && window != JDrawer.this.getParentWindow() && (jDialog = (JDialog)window).isModal()) {
                JDrawer.this.setEnabled(false);
            }
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            if (this.isToggled) {
                JDrawer.this.toggle();
            }
        }

        public void windowIconified(WindowEvent windowEvent) {
            this.isToggled = JDrawer.this.isToggled();
            if (this.isToggled) {
                JDrawer.this.setVisible(false);
            }
        }

        public void windowOpened(WindowEvent windowEvent) {
            JDrawer.this.updateBounds();
        }

        public void componentResized(ComponentEvent componentEvent) {
            JDrawer.this.updateBounds();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            JDrawer.this.updateBounds();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            JDrawer.this.setVisible(false);
        }

        public void componentShown(ComponentEvent componentEvent) {
            JDrawer.this.updateBounds();
        }

        public /* synthetic */ FrameListener(1 var2_2) {
            this();
        }
    }
}

