/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.isqlviewer.core.model.SuggestionListModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.text.SQLDocument;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class JDBCSuggestor
extends SuggestionListModel {
    private static final int METADATA_TYPE_TABLE = 0;
    private static final int METADATA_TYPE_COLUMN = 1;
    private ArrayList rootStore = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(DatabaseConnection databaseConnection) {
        PrintWriter printWriter;
        MetaDataItem metaDataItem;
        String string = null;
        String string2 = null;
        this.rootStore.clear();
        this.clear();
        if (databaseConnection == null || databaseConnection.isClosed()) {
            return;
        }
        DatabaseMetaData databaseMetaData = databaseConnection.getDatabaseInformation();
        string = databaseConnection.getSchema();
        string2 = databaseConnection.getCatalog();
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getTables(string2, null, "%", databaseConnection.getTableTypes());
            while (resultSet.next()) {
                metaDataItem = new MetaDataItem(null);
                metaDataItem.type = 0;
                metaDataItem.table = resultSet.getString("TABLE_NAME");
                metaDataItem.schema = resultSet.getString("TABLE_SCHEM");
                if (metaDataItem.schema != null && metaDataItem.schema.equals(string)) {
                    metaDataItem.value = metaDataItem.table;
                    metaDataItem.label = metaDataItem.value;
                    if (this.rootStore.size() >= 1) {
                        this.rootStore.add(0, metaDataItem);
                        continue;
                    }
                    this.rootStore.add(metaDataItem);
                    continue;
                }
                metaDataItem.value = metaDataItem.schema != null ? metaDataItem.schema.concat(".".concat(metaDataItem.table)) : metaDataItem.table;
                metaDataItem.label = metaDataItem.value;
                this.rootStore.add(metaDataItem);
            }
        }
        catch (SQLException sQLException) {
            printWriter = DriverManager.getLogWriter();
            if (printWriter != null) {
                BasicUtilities.HandleException((Throwable)sQLException, null, true, printWriter);
            }
        }
        catch (Throwable throwable) {
            if (databaseConnection.getVerboseOn()) {
                BasicUtilities.HandleException(throwable, null, databaseConnection.getDebugOn());
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
            resultSet = null;
        }
        try {
            resultSet = databaseMetaData.getColumns(string2, string, "%", "%");
            while (resultSet.next()) {
                metaDataItem = new MetaDataItem(null);
                metaDataItem.type = 1;
                metaDataItem.table = resultSet.getString("TABLE_NAME");
                metaDataItem.schema = resultSet.getString("TABLE_SCHEM");
                metaDataItem.value = resultSet.getString("COLUMN_NAME");
                metaDataItem.label = metaDataItem.table.concat(".").concat(metaDataItem.value);
                this.rootStore.add(metaDataItem);
            }
        }
        catch (SQLException sQLException) {
            printWriter = DriverManager.getLogWriter();
            if (printWriter != null) {
                BasicUtilities.HandleException((Throwable)sQLException, null, true, printWriter);
            }
        }
        catch (Throwable throwable) {
            if (databaseConnection.getVerboseOn()) {
                BasicUtilities.HandleException(throwable, null, databaseConnection.getDebugOn());
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
            resultSet = null;
        }
    }

    public void updateSuggestion(Document document, int n2) throws BadLocationException {
        String string = BasicUtilities.getCurrentWord(document, n2).toUpperCase();
        String string2 = null;
        SQLDocument sQLDocument = null;
        boolean bl2 = false;
        if (document instanceof SQLDocument) {
            sQLDocument = (SQLDocument)document;
        }
        if (string.indexOf(46) >= 0) {
            string2 = string.substring(0, string.indexOf(46));
            string = StringUtilities.stripCharacters(string.substring(string2.length()), ".");
            bl2 = sQLDocument != null && sQLDocument.isAliased(string2);
        }
        Iterator iterator = this.rootStore.iterator();
        this.clear();
        while (iterator.hasNext()) {
            MetaDataItem metaDataItem = (MetaDataItem)iterator.next();
            if (bl2) {
                String string3;
                if (metaDataItem.type != 1 || !sQLDocument.isAliased(metaDataItem.table) || !(string3 = sQLDocument.getTableForAlias(string2)).equalsIgnoreCase(metaDataItem.table) || metaDataItem.value.toUpperCase().indexOf(string) < 0) continue;
                this.addElement(metaDataItem);
                continue;
            }
            if (metaDataItem.label.toUpperCase().indexOf(string) < 0) continue;
            this.addElement(metaDataItem);
        }
    }

    public int applySuggestion(Object object, Document document, int n2, int n3) throws BadLocationException {
        String string = BasicUtilities.getCurrentWord(document, n3);
        String string2 = null;
        MetaDataItem metaDataItem = (MetaDataItem)object;
        if (string.indexOf(46) >= 0) {
            string2 = string.substring(0, string.indexOf(46));
            string = StringUtilities.stripCharacters(string.substring(string2.length()), ".");
        }
        this.clear();
        if (object == null) {
            return -1;
        }
        String string3 = metaDataItem.value;
        int n4 = string.length();
        document.remove(n3 -= n4, n4);
        document.insertString(n3, string3, null);
        return n3 + string3.length();
    }

    public static class 1 {
    }

    public static class SuggestionRenderer
    extends DefaultListCellRenderer {
        private SQLDocument document = null;

        public SuggestionRenderer(SQLDocument sQLDocument) {
            this.document = sQLDocument;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            MetaDataItem metaDataItem = (MetaDataItem)object;
            this.setText(metaDataItem.label);
            switch (metaDataItem.type) {
                case 1: {
                    this.setIcon(BasicUtilities.loadIconResource("TableInfo16"));
                    if (!this.document.isAliased(metaDataItem.table)) break;
                    this.setFont(jList.getFont().deriveFont(1));
                    break;
                }
                case 0: {
                    this.setIcon(BasicUtilities.loadIconResource("Table16"));
                    break;
                }
                default: {
                    this.setIcon(null);
                }
            }
            return this;
        }
    }

    private static class MetaDataItem {
        private int type = -1;
        private String table;
        private String schema;
        private String value;
        private String label;

        private MetaDataItem() {
        }

        public /* synthetic */ MetaDataItem(1 var1_1) {
            this();
        }
    }
}

