/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.filters.AbstractTableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.ByteArrayBlob;
import org.isqlviewer.sql.ByteArrayClob;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.Base64Decoder;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ExtensionFileFilter;
import org.isqlviewer.util.StringUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTableFilter
extends AbstractTableFilter {
    private static final String ROOT_TAG = "isql-resultset";
    private static final String COLUMN_TAG = "table-column";
    private static final String ROW_TAG = "table-row";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_ROWS = "rows";
    private static final String ATTR_ENCODING = "encoding";
    private static final String ATTR_COLUMNS = "columns";
    private static final String ATTR_WAS_NULL = "wasnull";
    private static final String ATTR_DATE_PATTERN = "pattern";
    private final String BASE64_ENCODING = "base64";

    public boolean canFilter(int n2, Object object) {
        switch (n2) {
            case 1: {
                return object instanceof EnhancedTableModel;
            }
        }
        return false;
    }

    public FileFilter[] getSupportedFileTypes(int n2) {
        return new FileFilter[]{new ExtensionFileFilter(this.getString("XML_Extension"), this.getString("XML_Desc"))};
    }

    public boolean isModeSupported(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public boolean isFileRequired(int n2) {
        return true;
    }

    public int filterIn(EnhancedTableModel enhancedTableModel, File file, InputStream inputStream) throws IOException, InterruptedException {
        Charset charset = this.getPreferredCharset(1);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        this.checkIfCancelled();
        this.readContent(inputStreamReader, enhancedTableModel);
        return 3;
    }

    public int filterOut(Object object, File file, OutputStream outputStream) throws InterruptedException {
        if (!(object instanceof TableModel)) {
            return 0;
        }
        TableModel tableModel = (TableModel)object;
        Charset charset = this.getPreferredCharset(1);
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, charset), true);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("");
        int n2 = 0;
        n2 = tableModel instanceof EnhancedTableModel ? ((EnhancedTableModel)tableModel).getTrueRowCount() : tableModel.getRowCount();
        this.checkIfCancelled();
        printWriter.print("<?xml version=\"1.0\" encoding=\"");
        printWriter.print(charset.name());
        printWriter.println("\" ?>");
        printWriter.print("<");
        printWriter.print(ROOT_TAG);
        printWriter.print(" ");
        printWriter.print(ATTR_ROWS);
        printWriter.print("=\"");
        printWriter.print(Integer.toString(n2));
        printWriter.print("\" ");
        printWriter.print(ATTR_COLUMNS);
        printWriter.print("=\"");
        printWriter.print(Integer.toString(tableModel.getColumnCount()));
        printWriter.println("\" >");
        for (int i2 = 0; i2 < n2; ++i2) {
            this.checkIfCancelled();
            printWriter.print("\t<");
            printWriter.print(ROW_TAG);
            printWriter.println(">");
            for (int i3 = 0; i3 < tableModel.getColumnCount(); ++i3) {
                Base64Encoder base64Encoder;
                ByteArrayOutputStream byteArrayOutputStream;
                Object object2;
                Object object3 = tableModel.getValueAt(i2, i3);
                String string = tableModel.getColumnName(i3);
                String string2 = "";
                if (string == null) {
                    string = "null";
                }
                printWriter.print("\t\t<");
                printWriter.print(COLUMN_TAG);
                printWriter.print(" ");
                printWriter.print(ATTR_TYPE);
                printWriter.print("=\"");
                String string3 = StringUtilities.getTypeStringForObject(object3);
                printWriter.print(StringUtilities.encodeXMLEntities(string3));
                printWriter.print("\" ");
                printWriter.print(" ");
                printWriter.print(ATTR_NAME);
                printWriter.print("=\"");
                printWriter.print(StringUtilities.encodeXMLEntities(string));
                printWriter.print("\" ");
                if (object3 == null) {
                    printWriter.print(ATTR_WAS_NULL);
                    printWriter.print("=\"");
                    printWriter.print(Boolean.TRUE);
                    printWriter.print("\"");
                } else if (object3 instanceof Timestamp) {
                    object2 = this.sysConfig.getFormatForSQLType(93);
                    printWriter.print(" ");
                    printWriter.print(ATTR_DATE_PATTERN);
                    printWriter.print("=\"");
                    printWriter.print(StringUtilities.encodeXMLEntities((String)object2));
                    printWriter.print("\"");
                    simpleDateFormat.applyPattern((String)object2);
                    string2 = simpleDateFormat.format((Timestamp)object3);
                } else if (object3 instanceof Time) {
                    object2 = this.sysConfig.getFormatForSQLType(92);
                    printWriter.print(" ");
                    printWriter.print(ATTR_DATE_PATTERN);
                    printWriter.print("=\"");
                    printWriter.print(StringUtilities.encodeXMLEntities((String)object2));
                    printWriter.print("\"");
                    simpleDateFormat.applyPattern((String)object2);
                    string2 = simpleDateFormat.format((Time)object3);
                } else if (object3 instanceof Date) {
                    object2 = this.sysConfig.getFormatForSQLType(91);
                    printWriter.print(" ");
                    printWriter.print(ATTR_DATE_PATTERN);
                    printWriter.print("=\"");
                    printWriter.print(StringUtilities.encodeXMLEntities((String)object2));
                    printWriter.print("\"");
                    simpleDateFormat.applyPattern((String)object2);
                    string2 = simpleDateFormat.format((Date)object3);
                } else if (object3 instanceof Blob) {
                    try {
                        object2 = (Blob)object3;
                        byteArrayOutputStream = new ByteArrayOutputStream((int)object2.length());
                        base64Encoder = new Base64Encoder(object2.getBinaryStream(), byteArrayOutputStream);
                        base64Encoder.process();
                        string2 = byteArrayOutputStream.toString();
                        printWriter.print(" ");
                        printWriter.print(ATTR_ENCODING);
                        printWriter.print("=\"");
                        printWriter.print(StringUtilities.encodeXMLEntities("base64"));
                        printWriter.print("\"");
                    }
                    catch (Throwable throwable) {
                        this.info(BasicUtilities.getString("Error_Encoding_Data", "base64"), throwable);
                        return 0;
                    }
                } else if (object3 instanceof Clob) {
                    try {
                        object2 = (Clob)object3;
                        byteArrayOutputStream = new ByteArrayOutputStream((int)object2.length());
                        base64Encoder = new Base64Encoder(object2.getAsciiStream(), byteArrayOutputStream);
                        string2 = base64Encoder.processString();
                        printWriter.print(" ");
                        printWriter.print(ATTR_ENCODING);
                        printWriter.print("=\"");
                        printWriter.print(StringUtilities.encodeXMLEntities("base64"));
                        printWriter.print("\"");
                    }
                    catch (Throwable throwable) {
                        this.debug(BasicUtilities.getString("Error_Encoding_Data", "base64"), throwable);
                        return 0;
                    }
                } else {
                    string2 = object3 == null ? "" : object3.toString();
                    string2 = StringUtilities.encodeXMLEntities(string2);
                }
                if (string2.indexOf(System.getProperty("line.seperator", "\n")) < 0) {
                    printWriter.print(">");
                    printWriter.print(string2);
                    printWriter.print("</");
                    printWriter.print(COLUMN_TAG);
                    printWriter.println(">");
                    continue;
                }
                printWriter.println(">");
                printWriter.println(string2);
                printWriter.print("\t\t</");
                printWriter.print(COLUMN_TAG);
                printWriter.println(">");
            }
            printWriter.print("\t</");
            printWriter.print(ROW_TAG);
            printWriter.println(">");
            this.fireProgressUpdated(i2);
        }
        printWriter.print("</");
        printWriter.print(ROOT_TAG);
        printWriter.println(">");
        this.info(this.getString("XML_TableData_Written"));
        try {
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public String getName() {
        return BasicUtilities.getString("XML_Handler_Name");
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Xml16");
    }

    public void loadProperties(int n2) {
    }

    private void readContent(Reader reader, EnhancedTableModel enhancedTableModel) throws IOException {
        try {
            XMLReader xMLReader = SystemConfig.getInstance().getXMLReader();
            xMLReader.setContentHandler(new XMLImporter(enhancedTableModel));
            xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xMLReader.setFeature("http://xml.org/sax/features/validation", false);
            xMLReader.parse(new InputSource(reader));
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    private class XMLImporter
    extends DefaultHandler {
        private EnhancedTableModel model = null;
        private SimpleDateFormat sdf = new SimpleDateFormat("");
        private ArrayList currentRow = null;
        private String currentType = null;
        private String currentEnc = null;
        private StringBuffer charBuffer = new StringBuffer("");
        static /* synthetic */ Class class$java$sql$Clob;
        static /* synthetic */ Class class$java$sql$Blob;

        public void characters(char[] cArray, int n2, int n3) {
            if (this.currentRow != null) {
                this.charBuffer.append(cArray, n2, n3);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string2.equalsIgnoreCase(XMLTableFilter.ROOT_TAG)) {
                XMLTableFilter.this.info(BasicUtilities.getString("XMLFilter_ImportFinished"));
                return;
            } else if (string2.equalsIgnoreCase(XMLTableFilter.COLUMN_TAG)) {
                int n2 = JDBCUtilities.getTypeforName(this.currentType);
                try {
                    String string4 = this.charBuffer.toString().trim();
                    switch (n2) {
                        case 2004: 
                        case 2005: {
                            this.currentRow.add(this.createLOB(n2));
                            return;
                        }
                        default: {
                            this.currentRow.add(JDBCUtilities.convertValue(string4, n2, this.sdf));
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    XMLTableFilter.this.info(BasicUtilities.getString("XMLFilter_ErrorConvertingValue", this.charBuffer.toString()), exception);
                    throw new SAXException(exception);
                }
                finally {
                    this.charBuffer.setLength(0);
                }
            } else {
                if (!string2.equalsIgnoreCase(XMLTableFilter.ROW_TAG)) return;
                this.model.addRow(this.currentRow);
                this.model.setColumnCount(this.currentRow.size());
                this.currentRow = null;
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string2.equalsIgnoreCase(XMLTableFilter.ROOT_TAG)) {
                XMLTableFilter.this.info(BasicUtilities.getString("XMLFilter_StartMessage", new String[]{attributes.getValue(XMLTableFilter.ATTR_ROWS), attributes.getValue(XMLTableFilter.ATTR_COLUMNS)}));
                this.model.clearAll();
                this.model.setColumnCount(Integer.parseInt(attributes.getValue(XMLTableFilter.ATTR_COLUMNS)));
            } else if (string2.equalsIgnoreCase(XMLTableFilter.COLUMN_TAG)) {
                this.currentType = attributes.getValue(XMLTableFilter.ATTR_TYPE);
                String string4 = attributes.getValue(XMLTableFilter.ATTR_NAME);
                String string5 = attributes.getValue(XMLTableFilter.ATTR_DATE_PATTERN);
                if (string5 != null) {
                    this.sdf.applyPattern(string5);
                }
                if (this.model.findColumn(string4) < 0) {
                    this.model.setColumnName(this.currentRow.size(), string4);
                }
            } else if (string2.equalsIgnoreCase(XMLTableFilter.ROW_TAG)) {
                XMLTableFilter.this.debug(BasicUtilities.getString("XMLFilter_ImportRowStart"));
                this.currentRow = new ArrayList();
            }
        }

        public XMLImporter(EnhancedTableModel enhancedTableModel) {
            this.model = enhancedTableModel;
        }

        private Object createLOB(int n2) throws Exception {
            if ("base64".equalsIgnoreCase(this.currentEnc)) {
                Base64Decoder base64Decoder = new Base64Decoder(this.charBuffer.toString());
                this.charBuffer.setLength(0);
                this.charBuffer.append(base64Decoder.processString());
            }
            switch (n2) {
                case 2004: {
                    int n3 = this.currentRow.size();
                    Class<?> clazz = class$java$sql$Blob;
                    if (clazz == null) {
                        clazz = class$java$sql$Blob = new Blob[0].getClass().getComponentType();
                    }
                    this.model.setClassforColumn(n3, clazz);
                    return new ByteArrayBlob(this.charBuffer.toString().getBytes());
                }
                case 2005: {
                    int n4 = this.currentRow.size();
                    Class<?> clazz = class$java$sql$Clob;
                    if (clazz == null) {
                        clazz = class$java$sql$Clob = new Clob[0].getClass().getComponentType();
                    }
                    this.model.setClassforColumn(n4, clazz);
                    return new ByteArrayClob(this.charBuffer.toString());
                }
            }
            return null;
        }
    }
}

