/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.TableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.event.ProgressListener;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.util.BasicUtilities;

public abstract class AbstractTableFilter
implements TableFilter {
    public static final String[] CHOICE_BOOLEAN = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
    public DatabaseConnection connection = null;
    public SystemConfig sysConfig = SystemConfig.getInstance();
    private ArrayList parameters;
    private Preferences preferences = null;
    private PrintWriter outWriter = new PrintWriter(System.out, true);
    private ResourceBundle bundle = null;
    private EventListenerList listenerList = new EventListenerList();
    private ProgressEvent evt = null;
    private boolean debugOn = false;
    static /* synthetic */ Class class$org$isqlviewer$event$ProgressListener;

    public final void addProgressListener(ProgressListener progressListener) {
        Class<?> clazz = class$org$isqlviewer$event$ProgressListener;
        if (clazz == null) {
            clazz = class$org$isqlviewer$event$ProgressListener = new ProgressListener[0].getClass().getComponentType();
        }
        this.listenerList.add(clazz, progressListener);
    }

    public final void removeProgressListener(ProgressListener progressListener) {
        Class<?> clazz = class$org$isqlviewer$event$ProgressListener;
        if (clazz == null) {
            clazz = class$org$isqlviewer$event$ProgressListener = new ProgressListener[0].getClass().getComponentType();
        }
        this.listenerList.remove(clazz, progressListener);
    }

    public final DriverPropertyInfo[] getParameters(int n2) {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{};
        return this.parameters.toArray(driverPropertyInfoArray);
    }

    public final int getType() {
        return 1;
    }

    public final void setLogStream(PrintWriter printWriter) {
        this.outWriter = null;
        this.outWriter = printWriter == null ? new PrintWriter(System.out, true) : printWriter;
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Import16");
    }

    public String getDescription() {
        return null;
    }

    public void initialize(int n2, Preferences preferences) {
        this.preferences = preferences;
        this.parameters = null;
        this.parameters = new ArrayList();
        String string = null;
        String string2 = null;
        this.loadProperties(n2);
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        String[] stringArray = sortedMap.keySet().toArray(new String[0]);
        if (this.supportsMutlipleCharsets(n2)) {
            String string3 = System.getProperty("file.encoding", "");
            if (!Charset.isSupported(string3)) {
                string3 = "UTF8";
            }
            string = this.getString("ASCII_Encoding_Name");
            string2 = this.getString("ASCII_Encoding_Desc");
            this.addProperty(string, stringArray, string3, false, string2);
        }
        string = this.getString("Import_Debug_Property");
        string2 = this.getString("Import_Debug_Desc");
        this.addProperty(string, CHOICE_BOOLEAN, "false", false, string2);
    }

    public boolean canFilter(int n2, Object object) {
        switch (n2) {
            case 1: {
                if (object == null || !(object instanceof EnhancedTableModel)) break;
                EnhancedTableModel enhancedTableModel = (EnhancedTableModel)object;
                return enhancedTableModel.getRowCount() >= 1 && enhancedTableModel.getColumnCount() >= 1;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList arrayList = this.parameters;
        synchronized (arrayList) {
            this.parameters.clear();
        }
    }

    public Preferences getConfiguration(int n2) {
        return this.preferences;
    }

    public boolean accept(int n2, File file) {
        if (file != null) {
            switch (n2) {
                case 1: {
                    return file.canWrite();
                }
                case 0: {
                    return file.canRead() && file.exists();
                }
            }
        }
        return false;
    }

    public void setDatabaseConnection(DatabaseConnection databaseConnection) {
        this.connection = databaseConnection;
    }

    public boolean isModeSupported(int n2) {
        return true;
    }

    public FileFilter[] getSupportedFileTypes(int n2) {
        return new FileFilter[0];
    }

    public final Charset getPreferredCharset(int n2) {
        String string = BasicUtilities.getString("ASCII_Encoding_Name");
        String string2 = this.getConfiguration(n2).get(string, System.getProperty("file.encoding", ""));
        if (Charset.isSupported(string2)) {
            this.debug(BasicUtilities.getString("Using_Ecoding_Format", string2));
            return Charset.forName(string2);
        }
        String string3 = BasicUtilities.getString("CharacterSet_Not_Supported", string2);
        this.info(string3);
        return Charset.forName("UTF8");
    }

    public final boolean isDebugEnabled() {
        if (this.preferences != null) {
            return this.preferences.getBoolean(this.getString("Import_Debug_Property"), false);
        }
        return false;
    }

    public final void info(Object object) {
        this.info(object, null);
    }

    public final void info(Object object, Throwable throwable) {
        BasicUtilities.HandleException(throwable, object.toString(), this.debugOn, this.outWriter);
    }

    public final void debug(Object object) {
        this.debug(object, null);
    }

    public final void debug(Object object, Throwable throwable) {
        if (this.isDebugEnabled()) {
            BasicUtilities.HandleException(throwable, object.toString(), this.debugOn, this.outWriter);
        }
    }

    public final void setResourceBunde(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public final String getString(String string) {
        if (this.bundle == null) {
            return BasicUtilities.getString(string);
        }
        return BasicUtilities.getString(this.bundle, string);
    }

    public final void setProgressMax(int n2) {
        this.evt = null;
        this.evt = new ProgressEvent(this, 0, n2);
    }

    public final void addProperty(String string, String[] stringArray, String string2, boolean bl2, String string3) {
        try {
            string2 = string2 == null ? "" : string2;
            DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string, string2);
            driverPropertyInfo.required = bl2;
            driverPropertyInfo.choices = stringArray;
            driverPropertyInfo.description = string3;
            driverPropertyInfo.value = this.preferences.get(string, string2);
            this.parameters.add(driverPropertyInfo);
        }
        catch (Throwable throwable) {
            this.info("AbstractTableFilter::addProperty()", throwable);
        }
    }

    public final void checkIfCancelled() throws InterruptedException {
        Thread.sleep(10L);
    }

    public void fireProgressUpdated(int n2) {
        this.fireProgressUpdated(n2, "");
    }

    public void fireProgressUpdated(int n2, String string) {
        if (this.evt == null) {
            return;
        }
        this.evt.setNote(string);
        this.evt.setProgress(n2);
        this.fireProgressUpdated(this.evt);
    }

    public void fireProgressUpdated(ProgressEvent progressEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            Object object = objectArray[i2];
            Class<?> clazz = class$org$isqlviewer$event$ProgressListener;
            if (clazz == null) {
                clazz = new ProgressListener[0].getClass().getComponentType();
            }
            if (object != clazz) continue;
            ((ProgressListener)objectArray[i2 + 1]).progressUpdated(progressEvent);
        }
    }

    public boolean supportsMutlipleCharsets(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public abstract void loadProperties(int var1);
}

