/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.garret.perst.IPersistent;
import org.garret.perst.PatriciaTrie;
import org.garret.perst.PatriciaTrieKey;
import org.garret.perst.Persistent;
import org.garret.perst.PersistentResource;
import org.garret.perst.impl.QueryImpl;

class PTrie
extends PersistentResource
implements PatriciaTrie {
    private PTrieNode rootZero;
    private PTrieNode rootOne;
    private int count;

    PTrie() {
    }

    public ArrayList elements() {
        ArrayList arrayList = new ArrayList(this.count);
        PTrie.fill(arrayList, this.rootZero);
        PTrie.fill(arrayList, this.rootOne);
        return arrayList;
    }

    public int size() {
        return this.count;
    }

    public IPersistent[] toArray() {
        return (IPersistent[])this.elements().toArray();
    }

    public IPersistent[] toArray(IPersistent[] iPersistentArray) {
        return this.elements().toArray(iPersistentArray);
    }

    public Iterator iterator() {
        return this.elements().iterator();
    }

    private static void fill(ArrayList arrayList, PTrieNode pTrieNode) {
        if (pTrieNode != null) {
            arrayList.add(pTrieNode.obj);
            PTrie.fill(arrayList, pTrieNode.childZero);
            PTrie.fill(arrayList, pTrieNode.childOne);
        }
    }

    private static int firstBit(long l2, int n2) {
        return (int)(l2 >>> n2 - 1) & 1;
    }

    private static int getCommonPartLength(long l2, int n2, long l3, int n3) {
        if (n2 > n3) {
            l2 >>>= n2 - n3;
            n2 = n3;
        } else {
            l3 >>>= n3 - n2;
            n3 = n2;
        }
        long l4 = l2 ^ l3;
        int n4 = 0;
        while (l4 != 0L) {
            l4 >>>= 1;
            ++n4;
        }
        return n2 - n4;
    }

    public IPersistent add(PatriciaTrieKey patriciaTrieKey, IPersistent iPersistent) {
        this.modify();
        ++this.count;
        if (PTrie.firstBit(patriciaTrieKey.mask, patriciaTrieKey.length) == 1) {
            if (this.rootOne != null) {
                return this.rootOne.add(patriciaTrieKey.mask, patriciaTrieKey.length, iPersistent);
            }
            this.rootOne = new PTrieNode(patriciaTrieKey.mask, patriciaTrieKey.length, iPersistent);
            return null;
        }
        if (this.rootZero != null) {
            return this.rootZero.add(patriciaTrieKey.mask, patriciaTrieKey.length, iPersistent);
        }
        this.rootZero = new PTrieNode(patriciaTrieKey.mask, patriciaTrieKey.length, iPersistent);
        return null;
    }

    public IPersistent findBestMatch(PatriciaTrieKey patriciaTrieKey) {
        if (PTrie.firstBit(patriciaTrieKey.mask, patriciaTrieKey.length) == 1) {
            if (this.rootOne != null) {
                return this.rootOne.findBestMatch(patriciaTrieKey.mask, patriciaTrieKey.length);
            }
        } else if (this.rootZero != null) {
            return this.rootZero.findBestMatch(patriciaTrieKey.mask, patriciaTrieKey.length);
        }
        return null;
    }

    public IPersistent findExactMatch(PatriciaTrieKey patriciaTrieKey) {
        if (PTrie.firstBit(patriciaTrieKey.mask, patriciaTrieKey.length) == 1) {
            if (this.rootOne != null) {
                return this.rootOne.findExactMatch(patriciaTrieKey.mask, patriciaTrieKey.length);
            }
        } else if (this.rootZero != null) {
            return this.rootZero.findExactMatch(patriciaTrieKey.mask, patriciaTrieKey.length);
        }
        return null;
    }

    public IPersistent remove(PatriciaTrieKey patriciaTrieKey) {
        IPersistent iPersistent;
        if (PTrie.firstBit(patriciaTrieKey.mask, patriciaTrieKey.length) == 1) {
            IPersistent iPersistent2;
            if (this.rootOne != null && (iPersistent2 = this.rootOne.remove(patriciaTrieKey.mask, patriciaTrieKey.length)) != null) {
                this.modify();
                --this.count;
                if (this.rootOne.isNotUsed()) {
                    this.rootOne.deallocate();
                    this.rootOne = null;
                }
                return iPersistent2;
            }
        } else if (this.rootZero != null && (iPersistent = this.rootZero.remove(patriciaTrieKey.mask, patriciaTrieKey.length)) != null) {
            this.modify();
            --this.count;
            if (this.rootZero.isNotUsed()) {
                this.rootZero.deallocate();
                this.rootZero = null;
            }
            return iPersistent;
        }
        return null;
    }

    public void clear() {
        if (this.rootOne != null) {
            this.rootOne.deallocate();
            this.rootOne = null;
        }
        if (this.rootZero != null) {
            this.rootZero.deallocate();
            this.rootZero = null;
        }
        this.count = 0;
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(clazz, this.iterator(), string);
    }

    static class PTrieNode
    extends Persistent {
        long key;
        int keyLength;
        IPersistent obj;
        PTrieNode childZero;
        PTrieNode childOne;

        PTrieNode(long l2, int n2, IPersistent iPersistent) {
            this.obj = iPersistent;
            this.key = l2;
            this.keyLength = n2;
        }

        PTrieNode() {
        }

        IPersistent add(long l2, int n2, IPersistent iPersistent) {
            IPersistent iPersistent2;
            if (l2 == this.key && n2 == this.keyLength) {
                this.modify();
                IPersistent iPersistent3 = this.obj;
                this.obj = iPersistent;
                return iPersistent3;
            }
            int n3 = PTrie.getCommonPartLength(l2, n2, this.key, this.keyLength);
            int n4 = this.keyLength - n3;
            long l3 = l2 >>> n2 - n3;
            long l4 = this.key - (l3 << n4);
            if (n4 > 0) {
                this.modify();
                iPersistent2 = new PTrieNode(l4, n4, this.obj);
                ((PTrieNode)iPersistent2).childZero = this.childZero;
                ((PTrieNode)iPersistent2).childOne = this.childOne;
                this.key = l3;
                this.keyLength = n3;
                this.obj = null;
                if (PTrie.firstBit(l4, n4) == 1) {
                    this.childZero = null;
                    this.childOne = iPersistent2;
                } else {
                    this.childZero = iPersistent2;
                    this.childOne = null;
                }
            }
            if (n2 > n3) {
                n4 = n2 - n3;
                l4 = l2 - (l3 << n4);
                if (PTrie.firstBit(l4, n4) == 1) {
                    if (this.childOne != null) {
                        return this.childOne.add(l4, n4, iPersistent);
                    }
                    this.modify();
                    this.childOne = new PTrieNode(l4, n4, iPersistent);
                    return null;
                }
                if (this.childZero != null) {
                    return this.childZero.add(l4, n4, iPersistent);
                }
                this.modify();
                this.childZero = new PTrieNode(l4, n4, iPersistent);
                return null;
            }
            iPersistent2 = this.obj;
            this.obj = iPersistent;
            return iPersistent2;
        }

        IPersistent findBestMatch(long l2, int n2) {
            if (n2 > this.keyLength) {
                int n3 = PTrie.getCommonPartLength(l2, n2, this.key, this.keyLength);
                int n4 = n2 - n3;
                long l3 = l2 >>> n4;
                long l4 = l2 - (l3 << n4);
                if (PTrie.firstBit(l4, n4) == 1) {
                    if (this.childOne != null) {
                        return this.childOne.findBestMatch(l4, n4);
                    }
                } else if (this.childZero != null) {
                    return this.childZero.findBestMatch(l4, n4);
                }
            }
            return this.obj;
        }

        IPersistent findExactMatch(long l2, int n2) {
            if (n2 >= this.keyLength) {
                if (l2 == this.key && n2 == this.keyLength) {
                    return this.obj;
                }
                int n3 = PTrie.getCommonPartLength(l2, n2, this.key, this.keyLength);
                if (n3 == this.keyLength) {
                    int n4 = n2 - n3;
                    long l3 = l2 >>> n4;
                    long l4 = l2 - (l3 << n4);
                    if (PTrie.firstBit(l4, n4) == 1) {
                        if (this.childOne != null) {
                            return this.childOne.findBestMatch(l4, n4);
                        }
                    } else if (this.childZero != null) {
                        return this.childZero.findBestMatch(l4, n4);
                    }
                }
            }
            return null;
        }

        boolean isNotUsed() {
            return this.obj == null && this.childOne == null && this.childZero == null;
        }

        IPersistent remove(long l2, int n2) {
            if (n2 >= this.keyLength) {
                IPersistent iPersistent;
                if (l2 == this.key && n2 == this.keyLength) {
                    IPersistent iPersistent2 = this.obj;
                    this.obj = null;
                    return iPersistent2;
                }
                int n3 = PTrie.getCommonPartLength(l2, n2, this.key, this.keyLength);
                int n4 = n2 - n3;
                long l3 = l2 >>> n4;
                long l4 = l2 - (l3 << n4);
                if (PTrie.firstBit(l4, n4) == 1) {
                    IPersistent iPersistent3;
                    if (this.childOne != null && (iPersistent3 = this.childOne.findBestMatch(l4, n4)) != null) {
                        if (this.childOne.isNotUsed()) {
                            this.modify();
                            this.childOne.deallocate();
                            this.childOne = null;
                        }
                        return iPersistent3;
                    }
                } else if (this.childZero != null && (iPersistent = this.childZero.findBestMatch(l4, n4)) != null) {
                    if (this.childZero.isNotUsed()) {
                        this.modify();
                        this.childZero.deallocate();
                        this.childZero = null;
                    }
                    return iPersistent;
                }
            }
            return null;
        }

        public void deallocate() {
            if (this.childOne != null) {
                this.childOne.deallocate();
            }
            if (this.childZero != null) {
                this.childZero.deallocate();
            }
            super.deallocate();
        }
    }
}

